/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.dialog.DialogAttachedDatasets_jBDown_actionAdapter;
import com.runqian.report4.ide.dialog.DialogAttachedDatasets_jBUp_actionAdapter;
import com.runqian.report4.ide.dialog.DialogAttachedDatasets_this_windowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogAttachedDatasets
extends JDialog
implements ActionListener {
    final byte COL_EXP = 1;
    final byte COL_INDEX = 0;
    JButton addButton;
    BorderLayout borderLayout1;
    String columnNames = Lang.getText("dialogattacheddatasets.colnames");
    JButton delButton;
    JTableEx expTable = new JTableEx(this.columnNames){

        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            GM.dialogEditTableText(DialogAttachedDatasets.this.expTable, row, col);
        }
    };
    JButton jBCancel;
    JButton jBDown;
    JButton jBOK;
    JButton jBUp;
    JLabel jLabel1;
    JScrollPane jScrollPane1;
    private int m_option = 2;
    JPanel panel;
    VerticalFlowLayout verticalFlowLayout1;

    public DialogAttachedDatasets() {
        super(GV.appFrame, "\u9644\u52a0\u6570\u636e\u96c6", true);
        this.addButton = new JButton("\u6dfb\u52a0(A)");
        this.delButton = new JButton("\u5220\u9664(D)");
        this.jBOK = new JButton("\u786e\u5b9a(O)");
        this.jBCancel = new JButton("\u53d6\u6d88(C)");
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.borderLayout1 = new BorderLayout();
        this.jLabel1 = new JLabel();
        this.panel = new JPanel(new BorderLayout());
        this.jScrollPane1 = new JScrollPane();
        this.jBUp = new JButton();
        this.jBDown = new JButton();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(450, 300);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBOK);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JComponent jc = (JComponent)e.getSource();
        if (jc.equals(this.jBOK)) {
            if (!this.expTable.verifyColumnData(1, Lang.getText("dialogattacheddatasets.exp"))) {
                return;
            }
            GM.setWindowDimension(this);
            this.m_option = 0;
            this.dispose();
        } else if (jc.equals(this.jBCancel)) {
            this.m_option = 2;
            GM.setWindowDimension(this);
            this.dispose();
        } else if (jc.equals(this.addButton)) {
            int r = this.expTable.addRow();
            this.expTable.clearSelection();
            this.expTable.selectRow(r);
        } else if (jc.equals(this.delButton)) {
            this.expTable.deleteSelectedRows();
        }
    }

    public String[] getExps() {
        if (this.expTable.getRowCount() == 0) {
            return null;
        }
        String[] exps = new String[this.expTable.getRowCount()];
        int i = 0;
        while (i < this.expTable.getRowCount()) {
            String exp = (String)this.expTable.getValueAt(i, 1);
            if (GM.isValidString(exp)) {
                exps[i] = exp;
            }
            ++i;
        }
        return exps;
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        this.expTable.setIndexCol(0);
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(70, 25));
        button.addActionListener(this);
    }

    void jBDown_actionPerformed(ActionEvent e) {
        int cr = this.expTable.getSelectedRow();
        if (cr < 0 || cr >= this.expTable.getRowCount() - 1) {
            return;
        }
        this.expTable.data.moveRow(cr, cr, cr + 1);
        this.expTable.selectRow(cr + 1);
        this.expTable.resetIndex();
    }

    void jBUp_actionPerformed(ActionEvent e) {
        int cr = this.expTable.getSelectedRow();
        if (cr <= 0) {
            return;
        }
        this.expTable.data.moveRow(cr, cr, cr - 1);
        this.expTable.selectRow(cr - 1);
        this.expTable.resetIndex();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jLabel1.setText(" ");
        this.jBUp.setMnemonic('U');
        this.jBUp.setText("\u4e0a\u79fb(U)");
        this.jBUp.addActionListener(new DialogAttachedDatasets_jBUp_actionAdapter(this));
        this.jBDown.setMnemonic('B');
        this.jBDown.setText("\u4e0b\u79fb(B)");
        this.jBDown.addActionListener(new DialogAttachedDatasets_jBDown_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogAttachedDatasets_this_windowAdapter(this));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.panel, "East");
        this.jScrollPane1.getViewport().add((Component)this.expTable, null);
        this.panel.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.panel.add((Component)this.jBOK, null);
        this.panel.add((Component)this.jBCancel, null);
        this.panel.add((Component)this.jLabel1, null);
        this.panel.add((Component)this.addButton, null);
        this.panel.add((Component)this.delButton, null);
        this.panel.add((Component)this.jBUp, null);
        this.panel.add((Component)this.jBDown, null);
        this.addButton.setMnemonic('A');
        this.initButton(this.addButton);
        this.delButton.setMnemonic('D');
        this.initButton(this.delButton);
        this.jBOK.setMnemonic('O');
        this.initButton(this.jBOK);
        this.jBCancel.setMnemonic('C');
        this.initButton(this.jBCancel);
        this.expTable.setClickCountToStart(1);
        GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogattacheddatasets.title"));
        this.addButton.setText(Lang.getText("button.add"));
        this.delButton.setText(Lang.getText("button.delete"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBUp.setText(Lang.getText("button.up"));
        this.jBDown.setText(Lang.getText("dialogattacheddatasets.down"));
    }

    public void setExps(String[] exps) {
        if (exps == null) {
            return;
        }
        int i = 0;
        while (i < exps.length) {
            Object[] row = new Object[4];
            row[1] = exps[i];
            this.expTable.addRow(row);
            ++i;
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

