/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBAdd_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBCopy_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBDel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBDown_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBPaste_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jBUp_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_jTP_changeAdapter;
import com.runqian.report4.ide.dialog.DialogBuiltinDataSet_this_windowAdapter;
import com.runqian.report4.ide.usermodel.IDataSetEditor;
import com.runqian.report4.usermodel.BuiltinDataSetConfig;
import com.runqian.report4.usermodel.DataSetConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumnModel;

public class DialogBuiltinDataSet
extends JDialog
implements IDataSetEditor {
    final byte COL_INDEX = 0;
    final byte COL_NAME = 1;
    final byte COL_TYPE = (byte)2;
    BorderLayout borderLayout1;
    int c = 0;
    int i = 0;
    JButton jBAdd;
    JButton jBCancel;
    JButton jBCopy;
    JButton jBDel;
    JButton jBDown;
    JButton jBOK;
    JButton jBPaste;
    JButton jBUp;
    JLabel jLabel1;
    JLabel jLabel2;
    JPanel jPanel1;
    JScrollPane jSPData;
    JScrollPane jSPField;
    JTabbedPane jTP;
    int m_option = -1;
    private DataSetConfig srcConfig = null;
    JTableEx tableData;
    JTableEx tableField = new JTableEx(Lang.getText("dialogbuiltindataset.colnames"));
    VFlowLayout vFlowLayout1;

    public DialogBuiltinDataSet() {
        super(GV.appFrame, "\u5185\u5efa\u6570\u636e\u96c6", true);
        this.tableData = new JTableEx();
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.vFlowLayout1 = new VFlowLayout();
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.jBAdd = new JButton();
        this.jBDel = new JButton();
        this.jLabel1 = new JLabel();
        this.jSPField = new JScrollPane();
        this.jTP = new JTabbedPane();
        this.jSPData = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.jBPaste = new JButton();
        this.jBCopy = new JButton();
        this.jBUp = new JButton();
        this.jBDown = new JButton();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(500, 400);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Throwable e) {
            GM.showException(e);
        }
    }

    public DataSetConfig getDataSetConfig() {
        this.tableField.acceptText();
        BuiltinDataSetConfig dsc = new BuiltinDataSetConfig();
        dsc.setSourceConfig(this.srcConfig);
        Section names = new Section(this.tableField.getColumnData(1));
        Vector types = this.tableField.getColumnData(2);
        dsc.setColNames(names.toStringArray());
        byte[] btype = new byte[types.size()];
        int i = 0;
        while (i < types.size()) {
            btype[i] = (Byte)types.get(i);
            ++i;
        }
        dsc.setColTypes(btype);
        String[][] data = new String[this.tableData.getRowCount()][this.tableData.getColumnCount()];
        int r = 0;
        while (r < this.tableData.getRowCount()) {
            int c = 0;
            while (c < this.tableData.getColumnCount()) {
                Object o = this.tableData.getValueAt(r, c);
                if (o == null) {
                    o = "";
                }
                data[r][c] = o.toString();
                ++c;
            }
            ++r;
        }
        dsc.setValues(data);
        return dsc;
    }

    public int getOption() {
        return this.m_option;
    }

    void init() {
        this.tableField.setSelectionMode(0);
        this.tableField.setColumnDropDown(2, TypesEx.listCodeTypes(false), TypesEx.listDispTypes(false));
        this.tableField.setRowHeight(20);
        this.tableField.setIndexCol(0);
        this.tableField.setColumnWidth(2, 120);
        this.tableData.setAutoResizeMode(0);
        this.tableData.getTableHeader().setReorderingAllowed(false);
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        if (this.jTP.getSelectedIndex() == 0) {
            int r = this.tableField.addRow();
            String sCol = "field" + ++this.c;
            GM.getTableUniqueName(this.tableField, 1, "field");
            this.tableField.data.setValueAt(sCol, r, 1);
            this.tableField.data.setValueAt(new Byte(11), r, 2);
            this.tableData.addColumn(sCol);
        } else {
            int c = this.tableData.getColumnCount();
            if (c < 1) {
                return;
            }
            this.tableData.addRow();
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBCopy_actionPerformed(ActionEvent e) {
        JTableEx table = this.jTP.getSelectedIndex() == 0 ? this.tableField : this.tableData;
        String blockData = table.getBlockData();
        GM.clipBoard(blockData);
    }

    void jBDel_actionPerformed(ActionEvent e) {
        if (this.jTP.getSelectedIndex() == 0) {
            int r = JOptionPane.showConfirmDialog(GV.appFrame, Lang.getText("dialogbuiltindataset.warning"), Lang.getText("public.note"), 2);
            if (r != 0) {
                return;
            }
            int row = this.tableField.getSelectedRow();
            TableColumnModel tcm = this.tableData.getColumnModel();
            this.tableData.deleteColumn(tcm.getColumn(row));
            this.tableField.deleteSelectedRow();
        } else {
            this.tableData.deleteSelectedRows();
        }
    }

    void jBDown_actionPerformed(ActionEvent e) {
        if (this.jTP.getSelectedIndex() == 0) {
            int row = this.tableField.getSelectedRow();
            if (row == this.tableField.getRowCount() - 1) {
                return;
            }
            this.tableField.shiftRowDown(-1);
            this.tableData.moveColumn(row, row + 1);
        } else {
            this.tableData.shiftRowDown(-1);
        }
    }

    void jBOK_actionPerformed(ActionEvent e) {
        int r = 0;
        while (r < this.tableField.getRowCount()) {
            Object name = this.tableField.data.getValueAt(r, 1);
            if (!GM.isValidString(name)) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogbuiltindataset.number") + r + Lang.getText("dialogbuiltindataset.notset"));
                return;
            }
            ++r;
        }
        this.m_option = 0;
        this.tableField.acceptText();
        this.tableData.acceptText();
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBPaste_actionPerformed(ActionEvent e) {
        String ls_data = GM.clipBoard();
        this.tableData.setBlockData(ls_data);
    }

    void jBUp_actionPerformed(ActionEvent e) {
        if (this.jTP.getSelectedIndex() == 0) {
            int row = this.tableField.getSelectedRow();
            if (row < 1) {
                return;
            }
            this.tableField.shiftRowUp(-1);
            this.tableData.moveColumn(row, row - 1);
        } else {
            this.tableData.shiftRowUp(-1);
        }
    }

    void jTP_stateChanged(ChangeEvent e) {
        if (this.jTP.getSelectedIndex() == 1) {
            this.refreshDataHeader();
        }
        this.jBPaste.setEnabled(this.jTP.getSelectedIndex() == 1);
    }

    private void jbInit() throws Throwable {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.vFlowLayout1);
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogBuiltinDataSet_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setMnemonic('E');
        this.jBCancel.setText("\u53d6\u6d88(E)");
        this.jBCancel.addActionListener(new DialogBuiltinDataSet_jBCancel_actionAdapter(this));
        this.jBAdd.setAlignmentX(0.0f);
        this.jBAdd.setAlignmentY(5.0f);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(new DialogBuiltinDataSet_jBAdd_actionAdapter(this));
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBDel.addActionListener(new DialogBuiltinDataSet_jBDel_actionAdapter(this));
        this.jLabel1.setIconTextGap(4);
        this.jLabel1.setText("  ");
        this.jLabel2.setText("  ");
        this.jTP.addChangeListener(new DialogBuiltinDataSet_jTP_changeAdapter(this));
        this.jBPaste.setMnemonic('P');
        this.jBPaste.setText("\u7c98\u8d34(P)");
        this.jBPaste.addActionListener(new DialogBuiltinDataSet_jBPaste_actionAdapter(this));
        this.jBCopy.setMnemonic('C');
        this.jBCopy.setText("\u590d\u5236(C)");
        this.jBCopy.addActionListener(new DialogBuiltinDataSet_jBCopy_actionAdapter(this));
        this.jSPData.setVerticalScrollBarPolicy(20);
        this.jBUp.setAlignmentY(0.5f);
        this.jBUp.setMnemonic('S');
        this.jBUp.setText("\u4e0a\u79fb(S)");
        this.jBUp.addActionListener(new DialogBuiltinDataSet_jBUp_actionAdapter(this));
        this.jBDown.setMnemonic('X');
        this.jBDown.setText("\u4e0b\u79fb(X)");
        this.jBDown.addActionListener(new DialogBuiltinDataSet_jBDown_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogBuiltinDataSet_this_windowAdapter(this));
        this.jPanel1.add((Component)this.jLabel2, null);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBOK, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jBAdd, null);
        this.jPanel1.add((Component)this.jBDel, null);
        this.jPanel1.add((Component)this.jBCopy, null);
        this.jPanel1.add((Component)this.jBPaste, null);
        this.jPanel1.add((Component)this.jBUp, null);
        this.jPanel1.add((Component)this.jBDown, null);
        this.getContentPane().add((Component)this.jTP, "Center");
        this.jTP.add((Component)this.jSPField, " \u5b57\u6bb5 ");
        this.jTP.add((Component)this.jSPData, "  \u6570\u636e ");
        this.jSPData.getViewport().add((Component)this.tableData, null);
        this.jSPField.getViewport().add((Component)this.tableField, null);
    }

    void refreshDataHeader() {
        this.tableField.acceptText();
        TableColumnModel tcm = this.tableData.getColumnModel();
        int c = this.tableField.getRowCount();
        int i = 0;
        while (i < c) {
            String sName = (String)this.tableField.data.getValueAt(i, 1);
            tcm.getColumn(i).setHeaderValue(sName);
            tcm.getColumn(i).setMinWidth(50);
            ++i;
        }
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogbuiltindataset.title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBAdd.setText(Lang.getText("button.add"));
        this.jBDel.setText(Lang.getText("button.delete"));
        this.jBPaste.setText(Lang.getText("button.paste"));
        this.jBCopy.setText(Lang.getText("button.copy"));
        this.jBUp.setText(Lang.getText("button.shiftup"));
        this.jBDown.setText(Lang.getText("button.shiftdown"));
        this.jTP.setTitleAt(0, Lang.getText("dialogbuiltindataset.field"));
        this.jTP.setTitleAt(1, Lang.getText("dialogbuiltindataset.data"));
    }

    public void setDataSetConfig(DataSetConfig dsConfig) {
        if (dsConfig == null) {
            return;
        }
        BuiltinDataSetConfig dsc = (BuiltinDataSetConfig)dsConfig;
        this.srcConfig = dsc.getSourceConfig();
        String[] names = dsc.getColNames();
        if (names == null) {
            return;
        }
        byte[] types = dsc.getColType();
        this.tableField.data.setRowCount(names.length);
        int r = 0;
        while (r < names.length) {
            String name = names[r];
            this.tableField.data.setValueAt(name, r, 1);
            byte type = types[r];
            this.tableField.data.setValueAt(new Byte(type), r, 2);
            ++r;
        }
        this.tableField.resetIndex();
        this.tableData.data.setDataVector(dsc.getValues(), dsc.getColNames());
        int c = 0;
        while (c < dsc.getColNames().length) {
            this.tableData.setColumnDefaultEditor(c);
            ++c;
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

