/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.dataset.IDataSetFactory;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.base.DataSetType;
import com.runqian.report4.ide.base.DataSetTypes;
import com.runqian.report4.ide.dialog.DialogDataSetColTitle;
import com.runqian.report4.ide.dialog.DialogDataSetData;
import com.runqian.report4.ide.dialog.DialogDataSetType;
import com.runqian.report4.ide.dialog.DialogDataSet_jBAdd_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBBrowse_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBColTitle_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBConvert2BuildIn_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBDel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBDown_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBUp_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_jBedit_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSet_this_windowAdapter;
import com.runqian.report4.ide.dialog.DialogEssDSType;
import com.runqian.report4.ide.dialog.DialogSQLDataSet;
import com.runqian.report4.ide.usermodel.IDataSetEditor;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.usermodel.BuiltinDataSetConfig;
import com.runqian.report4.usermodel.CSQLDataSetConfig;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.CustomDataSetConfig;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.EssDataSetConfig;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.ProcDataSetConfig;
import com.runqian.report4.usermodel.SQLDataSetConfig;
import com.runqian.report4.usermodel.Types;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogDataSet
extends JDialog {
    final byte COL_CACHE = 3;
    final byte COL_COLTITLE = 4;
    final byte COL_DATASET = 5;
    final byte COL_DATASOURCE = (byte)2;
    final byte COL_NAME = 0;
    final byte COL_TYPE = 1;
    final String TITLE_CACHE;
    final String TITLE_COLTITLE;
    final String TITLE_DATASET;
    final String TITLE_DATASOURCE;
    final String TITLE_NAME;
    final String TITLE_TYPE;
    BorderLayout borderLayout1;
    JTableEx datasetTable;
    JButton jBAdd;
    JButton jBBrowse;
    JButton jBCancel;
    JButton jBColTitle;
    JButton jBConvert2BuildIn;
    JButton jBDel;
    JButton jBDown;
    JButton jBOK;
    JButton jBUp;
    JButton jBedit;
    JLabel jLabel1;
    JPanel jPanel1;
    JScrollPane jScrollPane1;
    protected int m_option = -1;
    VFlowLayout vFlowLayout1;

    public DialogDataSet() {
        super(GV.appFrame, "\u6570\u636e\u96c6\u8bbe\u7f6e", true);
        this.COL_CACHE = (byte)3;
        this.COL_COLTITLE = (byte)4;
        this.COL_DATASET = (byte)5;
        this.TITLE_NAME = Lang.getText("dialogdataset.name");
        this.TITLE_TYPE = Lang.getText("dialogdataset.type");
        this.TITLE_DATASOURCE = Lang.getText("dialogdataset.datasource");
        this.TITLE_CACHE = Lang.getText("dialogdataset.cache");
        this.TITLE_COLTITLE = Lang.getText("dialogdataset.coltitle");
        this.TITLE_DATASET = Lang.getText("dialogdataset.dataset");
        this.datasetTable = new JTableEx(new String[]{this.TITLE_NAME, this.TITLE_TYPE, this.TITLE_DATASOURCE, this.TITLE_CACHE, this.TITLE_COLTITLE, this.TITLE_DATASET}){

            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                DialogDataSet.this.jBedit_actionPerformed(null);
            }

            public void rowfocusChanged(int oldRow, int newRow) {
                if (newRow < 0) {
                    DialogDataSet.this.jBConvert2BuildIn.setEnabled(false);
                    DialogDataSet.this.jBBrowse.setEnabled(false);
                    return;
                }
                DialogDataSet.this.jBConvert2BuildIn.setEnabled(true);
                DialogDataSet.this.jBBrowse.setEnabled(true);
                String type = (String)DialogDataSet.this.datasetTable.data.getValueAt(newRow, 1);
                if (type == null) {
                    return;
                }
                boolean isBuiltin = type.equals(DataSetType.TYPE_BUILTIN);
                DialogDataSet.this.setConvertBuiltin(isBuiltin);
            }
        };
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.vFlowLayout1 = new VFlowLayout();
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.jBAdd = new JButton();
        this.jBDel = new JButton();
        this.jBUp = new JButton();
        this.jBDown = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jBedit = new JButton();
        this.jBColTitle = new JButton();
        this.jBConvert2BuildIn = new JButton();
        this.jLabel1 = new JLabel();
        this.jBBrowse = new JButton();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(460, 370);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Throwable e) {
            GM.showException(e);
        }
    }

    private String bool2String(boolean lb) {
        return lb ? Lang.getText("dialogdataset.need") : Lang.getText("dialogdataset.noneed");
    }

    public BuiltinDataSetConfig calcBuildIn(DataSetConfig srcConfig) {
        BuiltinDataSetConfig bdc = new BuiltinDataSetConfig();
        String factory = srcConfig.getFactoryClass();
        try {
            String[] colNames;
            IDataSetFactory ids = (IDataSetFactory)Class.forName(factory).newInstance();
            IReport report = GVIde.reportEditor.getReportModel().getReport();
            Context context = null;
            context = GVIde.prepareContext(true, report);
            if (context == null) {
                return null;
            }
            DataSet ds = ids.createDataSet(context, srcConfig, false);
            if (ds == null) {
                throw new Exception(Lang.getText("dialogdataset.dsnull"));
            }
            int c = ds.getColCount();
            byte[] colTypes = new byte[c];
            int i = 0;
            while (i < c) {
                colTypes[i] = ds.getColInfo(i).getDataType();
                ++i;
            }
            ds = ids.createDataSet(context, srcConfig, true);
            String[] cols = colNames = ds.getTitles();
            String[][] values = this.getDataSetData(ds);
            bdc.setColNames(cols);
            bdc.setColTypes(colTypes);
            bdc.setValues(values);
        }
        catch (Exception x) {
            GM.showException(x);
            return null;
        }
        return bdc;
    }

    private boolean checkDataValid() {
        return this.datasetTable.verifyColumnData(0, Lang.getText("dialogdataset.dsname"));
    }

    public DataSetMetaData get() {
        if (this.datasetTable.data.getRowCount() == 0) {
            return null;
        }
        DataSetMetaData dataSets = new DataSetMetaData();
        int r = 0;
        while (r < this.datasetTable.data.getRowCount()) {
            DataSetConfig dsc = (DataSetConfig)this.datasetTable.data.getValueAt(r, 5);
            String tmp = (String)this.datasetTable.data.getValueAt(r, 0);
            dsc.setName(tmp);
            tmp = (String)this.datasetTable.data.getValueAt(r, 2);
            dsc.setDataSourceName(tmp);
            tmp = (String)this.datasetTable.data.getValueAt(r, 3);
            dsc.setCacheData(this.string2Bool(tmp));
            String[] titles = (String[])this.datasetTable.data.getValueAt(r, 4);
            dsc.setColTitles(titles);
            dataSets.addDataSetConfig(dsc);
            ++r;
        }
        return dataSets;
    }

    private String[][] getDataSetData(DataSet ds) {
        int cc = ds.getColCount();
        int rr = ds.getRowCount();
        String[][] data = new String[rr][cc];
        int r = 1;
        while (r <= rr) {
            Object[] rowData = ds.getRowData(r);
            String[] rowdata = new String[cc];
            int c = 0;
            while (c < cc) {
                String val;
                rowdata[c] = val = Types.toString(rowData[c]);
                ++c;
            }
            data[r - 1] = rowdata;
            ++r;
        }
        return data;
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        this.datasetTable.hideColumn(this.TITLE_COLTITLE);
        this.datasetTable.hideColumn(this.TITLE_DATASET);
        JComboBox comboBox = new JComboBox(DataSetTypes.listDispNames());
        comboBox.setEditable(false);
        DefaultCellEditor dataSetType = new DefaultCellEditor(comboBox);
        this.datasetTable.getColumn(this.TITLE_TYPE).setCellEditor(dataSetType);
        JComboBox<String> cache = new JComboBox<String>();
        cache.addItem(Lang.getText("dialogdataset.need"));
        cache.addItem(Lang.getText("dialogdataset.noneed"));
        DefaultCellEditor cacheEditor = new DefaultCellEditor(cache);
        this.datasetTable.getColumn(this.TITLE_CACHE).setCellEditor(cacheEditor);
        this.datasetTable.getColumn(this.TITLE_TYPE).setMaxWidth(90);
        this.datasetTable.getColumn(this.TITLE_CACHE).setMaxWidth(60);
        this.datasetTable.getColumn(this.TITLE_NAME).setPreferredWidth(200);
        comboBox = new JComboBox(GVIde.dsModel.listNames());
        comboBox.setEditable(true);
        dataSetType = new DefaultCellEditor(comboBox);
        this.datasetTable.getColumn(this.TITLE_DATASOURCE).setCellEditor(dataSetType);
        this.datasetTable.setColumnEnable(this.TITLE_TYPE, false);
        this.datasetTable.setColumnVisible(Lang.getText("dialogdataset.memory"), false);
    }

    void jBAdd_actionPerformed(ActionEvent e) throws Exception {
        DialogDataSetType ddst = new DialogDataSetType();
        ddst.show();
        if (ddst.getOption() != 0) {
            return;
        }
        String typeName = ddst.getType();
        String configClass = DataSetTypes.getDataSetType(typeName).getConfigClassName();
        DataSetConfig dsc = (DataSetConfig)Class.forName(configClass).newInstance();
        int r = 0;
        String tmpName = GM.getTableUniqueName(this.datasetTable, 0, "ds");
        r = this.datasetTable.addRow(new Object[]{tmpName, typeName, "", Lang.getText("dialogdataset.need"), null, dsc});
        this.datasetTable.clearSelection();
        this.datasetTable.selectRow(r);
        if (!this.jBedit_actionPerformed(null)) {
            this.datasetTable.removeRow(r);
        }
    }

    void jBBrowse_actionPerformed(ActionEvent e) {
        BuiltinDataSetConfig dcfg;
        int r = this.datasetTable.getSelectedRow();
        if (r == -1 || !GM.isValidString(this.datasetTable.getValueAt(r, 0))) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.selectconvertds"), Lang.getText("public.note"), 2);
            return;
        }
        if (!this.checkDataValid()) {
            return;
        }
        String[] colTitles = (String[])this.datasetTable.data.getValueAt(r, 4);
        DataSetConfig dsc = (DataSetConfig)this.datasetTable.data.getValueAt(r, 5);
        if (GM.isValidString(this.datasetTable.getValueAt(r, 2))) {
            String dsName = (String)this.datasetTable.getValueAt(r, 2);
            dsc.setDataSourceName(dsName);
        }
        if (dsc instanceof BuiltinDataSetConfig) {
            dcfg = (BuiltinDataSetConfig)dsc;
        } else {
            dsc.setColTitles(colTitles);
            dcfg = this.calcBuildIn(dsc);
            if (dcfg == null) {
                return;
            }
        }
        DialogDataSetData ddsd = new DialogDataSetData(dcfg);
        ddsd.show();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBColTitle_actionPerformed(ActionEvent e) {
        this.datasetTable.acceptText();
        if (0 == this.datasetTable.getRowCount()) {
            return;
        }
        int r = this.datasetTable.getSelectedRow();
        if (r == -1) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.selectcnds"), Lang.getText("public.note"), 2);
            return;
        }
        DataSetConfig dsc = (DataSetConfig)this.datasetTable.data.getValueAt(r, 5);
        String define = "";
        if (dsc instanceof SQLDataSetConfig) {
            define = ((SQLDataSetConfig)dsc).getSQL();
        } else if (dsc instanceof CSQLDataSetConfig) {
            define = ((CSQLDataSetConfig)dsc).getSQL();
        } else if (dsc instanceof ProcDataSetConfig) {
            define = ((ProcDataSetConfig)dsc).getSQL();
        } else if (dsc instanceof CustomDataSetConfig) {
            define = ((CustomDataSetConfig)dsc).getFactoryClass();
        }
        DialogDataSetColTitle ddsc = new DialogDataSetColTitle();
        ddsc.set(define, (String[])this.datasetTable.data.getValueAt(r, 4));
        ddsc.show();
        if (ddsc.getOption() == 0) {
            this.datasetTable.data.setValueAt(ddsc.get(), r, 4);
            return;
        }
    }

    void jBConvert2BuildIn_actionPerformed(ActionEvent e) {
        BuiltinDataSetConfig dcfg;
        int r = this.datasetTable.getSelectedRow();
        if (r == -1 || !GM.isValidString(this.datasetTable.getValueAt(r, 0))) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.selectconvertds"), Lang.getText("public.note"), 2);
            return;
        }
        if (!this.checkDataValid()) {
            return;
        }
        String[] colTitles = (String[])this.datasetTable.data.getValueAt(r, 4);
        DataSetConfig dsc = (DataSetConfig)this.datasetTable.data.getValueAt(r, 5);
        if (GM.isValidString(this.datasetTable.getValueAt(r, 2))) {
            String dsName = (String)this.datasetTable.getValueAt(r, 2);
            dsc.setDataSourceName(dsName);
        }
        if (dsc instanceof BuiltinDataSetConfig) {
            dcfg = (BuiltinDataSetConfig)dsc;
            if ((dsc = dcfg.getSourceConfig()) == null) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.cantrecover"), Lang.getText("public.note"), 1);
                return;
            }
            this.datasetTable.data.setValueAt(dsc, r, 5);
            String dsType = DataSetTypes.getDataSetType(dsc.getClass().getName()).getDispName();
            this.datasetTable.data.setValueAt(dsType, r, 1);
            this.setConvertBuiltin(false);
        } else {
            dsc.setColTitles(colTitles);
            dcfg = this.calcBuildIn(dsc);
            if (dcfg == null) {
                return;
            }
            dcfg.setSourceConfig(dsc);
            this.datasetTable.data.setValueAt(dcfg, r, 5);
            this.datasetTable.data.setValueAt(DataSetType.TYPE_BUILTIN, r, 1);
            this.setConvertBuiltin(true);
        }
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.datasetTable.acceptText();
        if (0 == this.datasetTable.getRowCount()) {
            return;
        }
        int r = this.datasetTable.getSelectedRow();
        if (r == -1) {
            return;
        }
        this.datasetTable.deleteSelectedRows();
    }

    void jBDown_actionPerformed(ActionEvent e) {
        this.datasetTable.shiftRowDown(-1);
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (!this.checkDataValid()) {
            return;
        }
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    void jBUp_actionPerformed(ActionEvent e) {
        this.datasetTable.shiftRowUp(-1);
    }

    boolean jBedit_actionPerformed(ActionEvent e) {
        this.datasetTable.acceptText();
        if (0 == this.datasetTable.getRowCount()) {
            return false;
        }
        int r = this.datasetTable.getSelectedRow();
        if (r == -1) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.selectds"), Lang.getText("public.note"), 2);
            return false;
        }
        try {
            String typeName = (String)this.datasetTable.data.getValueAt(r, 1);
            DataSetType dst = DataSetTypes.getDataSetType(typeName);
            if ((dst.getDispName().equals(DataSetType.TYPE_SQL) || dst.getDispName().equals(DataSetType.TYPE_CSQL) || dst.getDispName().equals(DataSetType.TYPE_PROC)) && GV.dsActive != null && GV.dsActive.isRemote() && !LogInfo.canUseDBObject()) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdataset.cantusedb"), Lang.getText("public.note"), 2);
                return false;
            }
            String editDialog = dst.getDialogClassName();
            DataSetConfig dsc = (DataSetConfig)this.datasetTable.data.getValueAt(r, 5);
            if (dsc instanceof EssDataSetConfig) {
                EssDataSetConfig edsc = (EssDataSetConfig)dsc;
                byte essType = edsc.getType();
                if (essType == 0) {
                    DialogEssDSType det = new DialogEssDSType(GV.appFrame);
                    det.show();
                    if (det.getOption() != 0) {
                        return false;
                    }
                    essType = det.getEssDSType();
                }
                switch (essType) {
                    case 1: {
                        editDialog = editDialog + "Cube";
                        break;
                    }
                    case 2: {
                        editDialog = editDialog + "Data";
                        break;
                    }
                    case 3: {
                        editDialog = editDialog + "Mdx";
                    }
                }
            }
            JDialog editor = (JDialog)Class.forName(editDialog).newInstance();
            IDataSetEditor iEditor = (IDataSetEditor)((Object)editor);
            iEditor.setDataSetConfig(dsc);
            if (iEditor instanceof DialogSQLDataSet) {
                DialogSQLDataSet dsd = (DialogSQLDataSet)iEditor;
                dsd.setSemanticsManager(GVIde.semantics.getSemanticManager());
            }
            editor.show();
            int i = iEditor.getOption();
            if (i == 0) {
                this.datasetTable.data.setValueAt(iEditor.getDataSetConfig(), r, 5);
                if (typeName.equals(DataSetType.TYPE_SEMANTICS)) {
                    dsc = iEditor.getDataSetConfig();
                    String srcDS = (String)this.datasetTable.data.getValueAt(r, 2);
                    if (!GM.isValidString(srcDS)) {
                        this.datasetTable.data.setValueAt(dsc.getDataSourceName(), r, 2);
                    }
                }
                return true;
            }
        }
        catch (Exception x) {
            GM.showException(x);
        }
        return false;
    }

    private void jbInit() throws Throwable {
        this.getContentPane().setLayout(this.borderLayout1);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.addWindowListener(new DialogDataSet_this_windowAdapter(this));
        this.jPanel1.setLayout(this.vFlowLayout1);
        this.jBOK.setToolTipText("");
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogDataSet_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogDataSet_jBCancel_actionAdapter(this));
        this.jBAdd.setAlignmentX(0.0f);
        this.jBAdd.setAlignmentY(5.0f);
        this.jBUp.setText("\u4e0a\u79fb(S)");
        this.jBUp.addActionListener(new DialogDataSet_jBUp_actionAdapter(this));
        this.jBUp.setMnemonic('S');
        this.jBDown.setText("\u4e0b\u79fb(X)");
        this.jBDown.addActionListener(new DialogDataSet_jBDown_actionAdapter(this));
        this.jBDown.setMnemonic('x');
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(new DialogDataSet_jBAdd_actionAdapter(this));
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBDel.addActionListener(new DialogDataSet_jBDel_actionAdapter(this));
        this.jBedit.setMnemonic('E');
        this.jBedit.setText("\u7f16\u8f91(E)");
        this.jBedit.addActionListener(new DialogDataSet_jBedit_actionAdapter(this));
        this.jBColTitle.setEnabled(false);
        this.jBColTitle.setText("\u4e2d\u6587\u540d");
        this.jBColTitle.addActionListener(new DialogDataSet_jBColTitle_actionAdapter(this));
        this.jBConvert2BuildIn.setMnemonic('B');
        this.jBConvert2BuildIn.setText("\u8f6c\u4e3a\u5185\u5efa");
        this.jBConvert2BuildIn.setEnabled(false);
        this.jBBrowse.setEnabled(false);
        this.jBConvert2BuildIn.addActionListener(new DialogDataSet_jBConvert2BuildIn_actionAdapter(this));
        this.jLabel1.setMaximumSize(new Dimension(4, 5));
        this.jLabel1.setMinimumSize(new Dimension(4, 5));
        this.jLabel1.setPreferredSize(new Dimension(4, 5));
        this.jLabel1.setIconTextGap(4);
        this.jLabel1.setText(" ");
        this.jBBrowse.setText("\u6d4f\u89c8\u6570\u636e");
        this.jBBrowse.addActionListener(new DialogDataSet_jBBrowse_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBOK, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jBAdd, null);
        this.jPanel1.add((Component)this.jBDel, null);
        this.jPanel1.add((Component)this.jBUp, null);
        this.jPanel1.add((Component)this.jBDown, null);
        this.jPanel1.add((Component)this.jBedit, null);
        this.jPanel1.add((Component)this.jBBrowse, null);
        this.jPanel1.add((Component)this.jBColTitle, null);
        this.jPanel1.add((Component)this.jBConvert2BuildIn, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.datasetTable.setSelectionMode(0);
        this.datasetTable.setRowHeight(20);
        this.jScrollPane1.getViewport().add((Component)this.datasetTable, null);
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogdataset.title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBAdd.setText(Lang.getText("button.add"));
        this.jBDel.setText(Lang.getText("button.delete"));
        this.jBedit.setText(Lang.getText("button.edit"));
        this.jBColTitle.setText(Lang.getText("dialogdataset.cnname"));
        this.jBConvert2BuildIn.setText(Lang.getText("dialogdataset.convert2buildin"));
        this.jBUp.setText(Lang.getText("button.shiftup"));
        this.jBDown.setText(Lang.getText("button.shiftdown"));
        this.jBBrowse.setText(Lang.getText("dialogdataset.browse"));
    }

    public void set(DataSetMetaData dataSets) {
        if (dataSets == null) {
            return;
        }
        this.datasetTable.data.setRowCount(dataSets.getDataSetConfigCount());
        int i = 0;
        while (i < dataSets.getDataSetConfigCount()) {
            DataSetConfig dsc = dataSets.getDataSetConfig(i);
            this.datasetTable.data.setValueAt(dsc.getName(), i, 0);
            String dscClassName = dsc.getClass().getName();
            DataSetType dst = DataSetTypes.getDataSetType(dscClassName);
            String typeName = dst.getDispName();
            this.datasetTable.data.setValueAt(typeName, i, 1);
            String tmp = dsc.getDataSourceName();
            if (tmp != null) {
                this.datasetTable.data.setValueAt(tmp, i, 2);
            }
            this.datasetTable.data.setValueAt(this.bool2String(dsc.getCacheData()), i, 3);
            this.datasetTable.data.setValueAt(dsc.getColTitles(), i, 4);
            this.datasetTable.data.setValueAt(dsc, i, 5);
            ++i;
        }
        if (this.datasetTable.data.getRowCount() > 0) {
            this.datasetTable.setRowSelectionInterval(0, 0);
        }
    }

    private void setConvertBuiltin(boolean isBuiltin) {
        this.jBColTitle.setEnabled(!isBuiltin);
        if (isBuiltin) {
            this.jBConvert2BuildIn.setText(Lang.getText("dialogdataset.recover"));
        } else {
            this.jBConvert2BuildIn.setText(Lang.getText("dialogdataset.convert2buildin"));
        }
    }

    private boolean string2Bool(String str) {
        return str.equals(Lang.getText("dialogdataset.need"));
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

