/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.ide.base.DataSourceList;
import com.runqian.report4.ide.base.DataSourceListModel;
import com.runqian.report4.ide.dialog.DialogDataSourceOLAP;
import com.runqian.report4.ide.dialog.DialogDataSourcePara;
import com.runqian.report4.ide.dialog.DialogDataSourceType;
import com.runqian.report4.ide.dialog.DialogDataSource_jBClose_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_jBConnect_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_jBDelete_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_jBDisconnect_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_jBEdit_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_jBNew_actionAdapter;
import com.runqian.report4.ide.dialog.DialogDataSource_this_windowAdapter;
import com.runqian.report4.ide.dialog.DialogODBCDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogDataSource
extends JDialog {
    BorderLayout borderLayout1;
    static DataSourceListModel dsModel;
    JButton jBClose;
    JButton jBConnect;
    JButton jBDelete;
    JButton jBDisconnect;
    JButton jBEdit;
    JButton jBNew;
    JLabel jLabel1;
    DataSourceList jListDS;
    JPanel jPanel1;
    JScrollPane jScrollPane1;
    JPanel panel1 = new JPanel();
    VerticalFlowLayout verticalFlowLayout1;

    public DialogDataSource(DataSourceListModel dslm) {
        super(GV.appFrame, "\u6570\u636e\u6e90", true);
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jBNew = new JButton();
        this.jBDelete = new JButton();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jBConnect = new JButton();
        this.jBDisconnect = new JButton();
        this.jLabel1 = new JLabel();
        this.jBClose = new JButton();
        this.jBEdit = new JButton();
        try {
            dsModel = dslm;
            this.jListDS = new DataSourceList(dslm);
            this.jbInit();
            this.resetLangText();
            this.setSize(400, 300);
            GM.setDialogDefaultButton(this, this.jBConnect, this.jBClose);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    public static boolean isExistDataSource(DataSource ds) {
        if (dsModel == null) {
            return false;
        }
        if (dsModel.existDSName(ds.getName())) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.existdsname") + ds.getName(), Lang.getText("public.note"), 0);
            return true;
        }
        return false;
    }

    public static boolean isLocalDataSource(DataSource ds, boolean showMessage) {
        if (ds.isSystem()) {
            if (showMessage) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.canteditds") + ds.getName() + " ] \u3002", Lang.getText("public.note"), 2);
            }
            return false;
        }
        if (ds.isRemote()) {
            if (showMessage) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.editremote") + "[ " + ds.getName() + " ] \u3002", Lang.getText("public.note"), 2);
            }
            return false;
        }
        return true;
    }

    void jBClose_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        try {
            GV.dsModel.save();
        }
        catch (Throwable ex) {
            GM.showException(ex);
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void jBConnect_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = dsModel.getSize();
        if (index <= -1) return;
        if (index >= size) return;
        DataSource ds = (DataSource)dsModel.getElementAt(index);
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (GV.dsActive != null) {
                    GV.dsActive.close();
                }
                ds.connect();
            }
            catch (Exception x) {
                GM.showException(x);
                Object var7_6 = null;
                this.repaint();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.repaint();
            this.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = dsModel.getSize();
        if (index > -1 && index < size) {
            DataSource ds = (DataSource)dsModel.get(index);
            if (ds.isSystem()) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.notdelds") + ds.getName() + " ] \u3002", Lang.getText("public.note"), 2);
                return;
            }
            if (ds.isRemote()) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.delremote") + "[ " + ds.getName() + " ] \u3002", Lang.getText("public.note"), 2);
                return;
            }
            Object[] options = new Object[]{Lang.getText("public.delete"), Lang.getText("public.cancel")};
            int i = JOptionPane.showOptionDialog(GV.appFrame, Lang.getText("dialogdatasource.mustdelds") + ds.getName() + " ] \uff1f", Lang.getText("public.note"), 2, 3, null, options, options[1]);
            if (0 == i) {
                dsModel.removeElementAt(index);
            }
            if (index > -1 && index < size) {
                this.jListDS.setSelectedIndex(index);
            }
        }
    }

    void jBDisconnect_actionPerformed(ActionEvent e) {
        try {
            int index = this.jListDS.getSelectedIndex();
            int size = dsModel.getSize();
            if (index > -1 && index < size) {
                DataSource ds = (DataSource)dsModel.getElementAt(index);
                if (ds != GVIde.dsActive) {
                    return;
                }
            } else {
                return;
            }
            GVIde.dsActive.close();
            this.repaint();
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }

    void jBEdit_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = dsModel.getSize();
        if (index > -1 && index < size) {
            int option;
            DataSource ds = (DataSource)dsModel.getElementAt(index);
            if (!DialogDataSource.isLocalDataSource(ds, true)) {
                return;
            }
            byte dsType = ds.getDSType();
            if (dsType == 2) {
                DialogDataSourceOLAP dolap = new DialogDataSourceOLAP();
                dolap.set(ds);
                dolap.show();
                option = dolap.getOption();
                ds = dolap.get();
            } else if (dsType == 0) {
                DialogDataSourcePara ddp = new DialogDataSourcePara();
                ddp.set(ds);
                ddp.show();
                option = ddp.getOption();
                ds = ddp.get();
            } else {
                DialogODBCDataSource dods = new DialogODBCDataSource();
                dods.set(ds);
                dods.show();
                option = dods.getOption();
                ds = dods.get();
            }
            if (option != 0) {
                return;
            }
            dsModel.setElementAt(ds, index);
        }
    }

    void jBNew_actionPerformed(ActionEvent e) {
        DataSource ds;
        DialogDataSourceType dct = new DialogDataSourceType();
        dct.show();
        if (dct.getOption() != 0) {
            return;
        }
        byte dsType = dct.getDataSourceType();
        if (dsType == 0) {
            DialogDataSourcePara ddp = new DialogDataSourcePara();
            ddp.show();
            if (ddp.getOption() != 0) {
                return;
            }
            ds = ddp.get();
        } else if (dsType == 1) {
            DialogODBCDataSource dods = new DialogODBCDataSource();
            dods.show();
            if (dods.getOption() != 0) {
                return;
            }
            ds = dods.get();
        } else {
            DialogDataSourceOLAP ddo = new DialogDataSourceOLAP();
            ddo.show();
            if (ddo.getOption() != 0) {
                return;
            }
            ds = ddo.get();
        }
        int index = this.jListDS.getSelectedIndex();
        int size = dsModel.getSize();
        if (dsModel.existDSName(ds.getName())) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogdatasource.existdsname") + ds.getName(), Lang.getText("public.closenote"), 0);
            return;
        }
        if (index == -1 || index == size || index == 0) {
            dsModel.addElement(ds);
            this.jListDS.setSelectedIndex(size);
        } else {
            dsModel.insertElementAt(ds, index + 1);
            this.jListDS.setSelectedIndex(index + 1);
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jBNew.setMnemonic('N');
        this.jBNew.setText("\u65b0\u5efa(N)");
        this.jBNew.addActionListener(new DialogDataSource_jBNew_actionAdapter(this));
        this.jBDelete.setActionCommand("jButton2");
        this.jBDelete.setMnemonic('D');
        this.jBDelete.setText("\u5220\u9664(D)");
        this.jBDelete.addActionListener(new DialogDataSource_jBDelete_actionAdapter(this));
        this.jPanel1.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBConnect.setMnemonic('O');
        this.jBConnect.setText("\u8fde\u63a5(O)");
        this.jBConnect.addActionListener(new DialogDataSource_jBConnect_actionAdapter(this));
        this.jBDisconnect.setMnemonic('K');
        this.jBDisconnect.setText("\u65ad\u5f00(K)");
        this.jBDisconnect.addActionListener(new DialogDataSource_jBDisconnect_actionAdapter(this));
        this.jLabel1.setText(" ");
        this.jBClose.setMnemonic('C');
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogDataSource_jBClose_actionAdapter(this));
        this.jBEdit.setVerifyInputWhenFocusTarget(true);
        this.jBEdit.setMnemonic('E');
        this.jBEdit.setText("\u7f16\u8f91(E)");
        this.jBEdit.addActionListener(new DialogDataSource_jBEdit_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogDataSource_this_windowAdapter(this));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jScrollPane1, "Center");
        this.panel1.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBNew, null);
        this.jPanel1.add((Component)this.jBDelete, null);
        this.jPanel1.add((Component)this.jBEdit, null);
        this.jScrollPane1.getViewport().add((Component)this.jListDS, null);
        this.jPanel1.add((Component)this.jBConnect, null);
        this.jPanel1.add((Component)this.jBDisconnect, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jBClose, null);
        this.jListDS.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogDataSource.this.jBEdit.doClick();
                }
            }
        });
        this.jListDS.setSelectedIndex(0);
        this.jListDS.setSelectionMode(0);
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogdatasource.title"));
        this.jBNew.setText(Lang.getText("button.new"));
        this.jBDelete.setText(Lang.getText("button.delete"));
        this.jBConnect.setText(Lang.getText("button.connect"));
        this.jBDisconnect.setText(Lang.getText("button.disconnect"));
        this.jBClose.setText(Lang.getText("button.close"));
        this.jBEdit.setText(Lang.getText("button.edit"));
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        try {
            GV.dsModel.save();
        }
        catch (Throwable ex) {
            GM.showException(ex);
            return;
        }
        this.dispose();
    }
}

