/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.DateChooser;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogInputArgument_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogInputArgument_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogInputArgument_this_windowAdapter;
import com.runqian.report4.ide.dialog.EachParamEditor;
import com.runqian.report4.ide.dialog.EachParamRenderer;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.usermodel.Macro;
import com.runqian.report4.usermodel.MacroMetaData;
import com.runqian.report4.usermodel.Param;
import com.runqian.report4.usermodel.ParamMetaData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class DialogInputArgument
extends JDialog {
    static final int COL_DESC = 1;
    static final int COL_EDITSTYLE = 4;
    static final int COL_NAME = 0;
    static final int COL_TYPE = 2;
    static final int COL_VALUE = 3;
    static final String TITLE_DESC;
    static final String TITLE_EDITSTYLE = "EditStyle";
    static final String TITLE_NAME;
    static final String TITLE_TYPE;
    static final String TITLE_VALUE;
    static final String TYPE_MACRO;
    JButton jBCancel;
    JButton jBOK;
    JScrollPane jScrollPane1;
    JTableEx jTbParam;
    private int m_option = -1;
    JPanel panel1 = new JPanel();
    private SemanticsManager sManager = null;

    static {
        TITLE_NAME = Lang.getText("dialoginputargument.name");
        TITLE_DESC = Lang.getText("dialoginputargument.desc");
        TITLE_TYPE = Lang.getText("dialoginputargument.type");
        TITLE_VALUE = Lang.getText("dialoginputargument.value");
        TYPE_MACRO = Lang.getText("dialoginputargument.macro");
    }

    public DialogInputArgument(SemanticsManager sManager) {
        super(GV.appFrame, "\u8bbe\u7f6e\u62a5\u8868\u53c2\u6570\u503c\u3014\u53cc\u51fb\u6570\u503c\u5217\u5f39\u51fa\u7f16\u8f91\u7a97\u53e3\u3015", true);
        this.jScrollPane1 = new JScrollPane();
        this.jTbParam = new JTableEx(new String[]{TITLE_NAME, TITLE_DESC, TITLE_TYPE, TITLE_VALUE, TITLE_EDITSTYLE}){

            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                if (col < 3) {
                    return;
                }
                String type = this.data.getValueAt(row, 2).toString();
                if (type.equalsIgnoreCase(Lang.getText("dialoginputargument.date"))) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String val = null;
                    DateChooser dc = new DateChooser((Frame)GV.appFrame, true);
                    dc.setLocation(xpos, ypos);
                    Calendar cal = Calendar.getInstance();
                    try {
                        val = this.data.getValueAt(row, 3).toString();
                        cal.setTime(formatter.parse(val));
                        dc.initDate(cal);
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    dc.setVisible(true);
                    cal = dc.getSelectedDate();
                    if (cal != null) {
                        this.acceptText();
                        val = formatter.format(cal.getTime());
                        this.setValueAt(val, row, col);
                    }
                } else {
                    GM.dialogEditTableText(DialogInputArgument.this.jTbParam, row, col);
                }
            }
        };
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        try {
            this.sManager = sManager;
            this.jbInit();
            this.resetLangText();
            this.pack();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Throwable t) {
            GM.showException(t);
        }
    }

    public HashMap getMacroValue() {
        return this.getValue(false);
    }

    public int getOption() {
        return this.m_option;
    }

    public HashMap getParamValue() {
        return this.getValue(true);
    }

    private HashMap getValue(boolean getParam) {
        HashMap<String, String> newValues = new HashMap<String, String>();
        String name = "";
        this.jTbParam.acceptText();
        int i = 0;
        while (i < this.jTbParam.getRowCount()) {
            Object o = this.jTbParam.getValueAt(i, 2);
            if (!(!getParam ? !((String)o).equalsIgnoreCase(TYPE_MACRO) : ((String)o).equalsIgnoreCase(TYPE_MACRO)) && (o = this.jTbParam.getValueAt(i, 0)) != null) {
                name = o.toString();
                String value = (String)this.jTbParam.getValueAt(i, 3);
                newValues.put(name, value);
            }
            ++i;
        }
        return newValues;
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.panel1.setLayout(new VFlowLayout());
        this.panel1.setForeground(Color.black);
        this.jTbParam.setCellSelectionEnabled(false);
        this.jBOK.setDefaultCapable(true);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogInputArgument_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setDefaultCapable(false);
        this.jBCancel.addActionListener(new DialogInputArgument_jBCancel_actionAdapter(this));
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addWindowListener(new DialogInputArgument_this_windowAdapter(this));
        this.jScrollPane1.getViewport().add((Component)this.jTbParam, null);
        this.panel1.add(this.jBOK);
        this.panel1.add(this.jBCancel);
        this.jTbParam.setColumnEnable(TITLE_NAME, false);
        this.jTbParam.setColumnEnable(TITLE_DESC, false);
        this.jTbParam.setColumnEnable(TITLE_TYPE, false);
        this.jTbParam.setColumnWidth(TITLE_NAME, 75);
        this.jTbParam.setColumnWidth(TITLE_DESC, 100);
        this.jTbParam.setColumnWidth(TITLE_TYPE, 45);
        this.jTbParam.hideColumn(TITLE_EDITSTYLE);
        TableColumn tc = this.jTbParam.getColumn(3);
        tc.setCellEditor(new EachParamEditor(this.sManager, this.jTbParam));
        tc.setCellRenderer(new EachParamRenderer(this.sManager, this.jTbParam));
        this.getContentPane().add((Component)this.panel1, "East");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialoginputargument.title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.jTbParam.setColumnEditable(3, false);
        }
    }

    public void setMacro(MacroMetaData macros) {
        int count = macros.getMacroCount();
        Object[] rowData = new Object[5];
        int i = 0;
        while (i < count) {
            Macro m = macros.getMacro(i);
            rowData[0] = m.getMacroName();
            rowData[1] = m.getDescription();
            rowData[2] = TYPE_MACRO;
            rowData[3] = m.getMacroValue();
            this.jTbParam.addRow(rowData);
            ++i;
        }
    }

    public void setParam(ParamMetaData paras) {
        try {
            Object[] rowData = new Object[5];
            int i = 0;
            while (i < paras.getParamCount()) {
                Param p = paras.getParam(i);
                rowData[0] = p.getParamName();
                rowData[1] = p.getDescription() == null ? p.getParamName() : p.getDescription();
                byte type = p.getDataType();
                rowData[2] = TypesEx.getDataTypeName(type);
                rowData[3] = p.getValue();
                rowData[4] = p.getStyleName();
                this.jTbParam.addRow(rowData);
                ++i;
            }
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

