/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.ArgList;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Escape;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.base.TableButtonCellEditor;
import com.runqian.report4.ide.base.TableButtonRenderer;
import com.runqian.report4.ide.dialog.DialogLinkEditor_jBAdd_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_jBDel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_jBPath_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_tab_changeAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_textPath_actionAdapter;
import com.runqian.report4.ide.dialog.DialogLinkEditor_this_windowAdapter;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.Param;
import com.runqian.report4.usermodel.ParamMetaData;
import com.runqian.report4.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;

public class DialogLinkEditor
extends JDialog {
    final int COL_ACTION = 4;
    final int COL_INDEX = 0;
    final int COL_NAME = 1;
    final int COL_TITLE = 2;
    final int COL_VALUE = 3;
    private final String LIST_ARGS = Lang.getText("editservletconfig.listparam");
    private final String STR_LINK = "link2(";
    private final String STR_LIST = "list(";
    private final String STR_NULL = "null";
    private final int TAB_DEFINE = 0;
    private final int TAB_EXP = 1;
    private final byte TYPE_DESCRIPTION = 1;
    private final byte TYPE_INITLIST = 0;
    private final byte TYPE_JSPPATH = 3;
    private final byte TYPE_LISTARGS = (byte)2;
    private ArgList argList;
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridBagLayout gridBagLayout3;
    JButton jBAdd;
    JButton jBCancel;
    JButton jBDel;
    JButton jBOK;
    JButton jBPath;
    JLabel jLabel1;
    JLabel jLabel2;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel5;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    private int m_option = 2;
    JPanel panelDefine;
    JPanel panelExp;
    JTabbedPane tab;
    JTableEx tableParam;
    JTextArea textExp;
    JTextField textPath;
    boolean verify;
    VerticalFlowLayout verticalFlowLayout1;

    public DialogLinkEditor() {
        super(GV.appFrame, "\u8d85\u94fe\u63a5\u7f16\u8f91", true);
        this.TYPE_JSPPATH = (byte)3;
        this.jPanel1 = new JPanel();
        this.panelDefine = new JPanel();
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.borderLayout2 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.tab = new JTabbedPane();
        this.panelExp = new JPanel();
        this.borderLayout3 = new BorderLayout();
        this.textExp = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.gridBagLayout2 = new GridBagLayout();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jBAdd = new JButton();
        this.jBDel = new JButton();
        this.gridBagLayout3 = new GridBagLayout();
        this.textPath = new JTextField();
        this.jBPath = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.tableParam = new JTableEx(Lang.getText("DialogLinkEditor.tableparam")){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                String value;
                if (col == 4) {
                    return;
                }
                this.acceptText();
                String name = this.getValueAt(row, 1) == null ? "" : (String)this.getValueAt(row, 1);
                byte type = DialogLinkEditor.this.argList.getType(name);
                String string = value = this.getValueAt(row, col) == null ? "" : (String)this.getValueAt(row, col);
                if (col == 3 && DialogLinkEditor.this.argList != null && (type == 1 || type == 2) && GM.isValidString(name)) {
                    File f = null;
                    String newPath = null;
                    try {
                        if (value.startsWith(String.valueOf(File.separatorChar))) {
                            value = value.substring(String.valueOf(File.separatorChar).length());
                        }
                        if (type == 1) {
                            f = GM.dialogSelectFile("raq", ConfigOptions.sReportDirectory, Lang.getText("public.open"), value);
                            if (f == null) {
                                return;
                            }
                            newPath = f.getAbsolutePath();
                            if (!newPath.startsWith(ConfigOptions.sReportDirectory)) {
                                JOptionPane.showMessageDialog(null, Lang.getText("dialoglinkeditor.falseraqdir", ConfigOptions.sReportDirectory));
                                return;
                            }
                            newPath = newPath.substring(ConfigOptions.sReportDirectory.length());
                        } else if (type == 2) {
                            f = GM.dialogSelectFile("jsp", ConfigOptions.sJSPDirectory, Lang.getText("public.open"), value);
                            if (f == null) {
                                return;
                            }
                            newPath = f.getAbsolutePath();
                            if (!newPath.startsWith(ConfigOptions.sJSPDirectory)) {
                                JOptionPane.showMessageDialog(null, Lang.getText("dialoglinkeditor.falsejspdir", ConfigOptions.sJSPDirectory));
                                return;
                            }
                            newPath = newPath.substring(ConfigOptions.sJSPDirectory.length());
                        }
                        if (newPath != null) {
                            if (newPath.startsWith(String.valueOf(File.separatorChar))) {
                                newPath = newPath.substring(String.valueOf(File.separatorChar).length());
                            }
                            this.setValueAt(newPath, row, col);
                        }
                        return;
                    }
                    catch (Exception ex) {
                        GM.showException(ex);
                        return;
                    }
                }
                DialogInputText dit = new DialogInputText();
                dit.setText(value);
                dit.show();
                if (dit.getOption() == 0) {
                    this.setValueAt(dit.getText(), row, col);
                }
            }

            public void setValueAt(Object value, int row, int col) {
                if (!this.isItemDataChanged(row, col, value)) {
                    return;
                }
                Object oldValue = this.getValueAt(row, col);
                super.setValueAt(value, row, col);
                if (col == 1) {
                    DialogLinkEditor.this.verify = this.verifyColumnData(col, this.getColumnName(col));
                    if (!DialogLinkEditor.this.verify) {
                        super.setValueAt(oldValue, row, col);
                        return;
                    }
                    if (DialogLinkEditor.this.argList == null) {
                        return;
                    }
                    if (GM.isValidString(value)) {
                        byte type = DialogLinkEditor.this.argList.getType((String)value);
                        this.setValueAt(type == 1 || type == 2 ? DialogLinkEditor.this.LIST_ARGS : null, row, 4);
                    }
                }
                DialogLinkEditor.this.setTextExpression();
            }
        };
        try {
            this.jbInit();
            this.init();
            this.setSize(500, 380);
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void close() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private int existName(String name) {
        int i = 0;
        while (i < this.tableParam.getRowCount()) {
            Object o = this.tableParam.getValueAt(i, 1);
            if (GM.isValidString(o) && o.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getExpression() {
        this.tableParam.acceptText();
        return this.textExp.getText();
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        this.initButton(this.jBAdd);
        this.initButton(this.jBDel);
        this.textExp.setLineWrap(true);
        this.tableParam.setRowHeight(20);
        this.tableParam.setIndexCol(0);
        JButton button = new JButton();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name;
                DialogLinkEditor.this.tableParam.acceptText();
                if (DialogLinkEditor.this.argList == null) {
                    return;
                }
                String string = name = DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 1) == null ? "" : (String)DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 1);
                if (!GM.isValidString(name)) {
                    return;
                }
                byte type = DialogLinkEditor.this.argList.getType(name);
                if (type == 1) {
                    String raqName = DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 3) == null ? "" : (String)DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 3);
                    DialogLinkEditor.this.loadReportArgs(raqName, (byte)2);
                } else if (type == 2) {
                    String jspName = DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 3) == null ? "" : (String)DialogLinkEditor.this.tableParam.getValueAt(DialogLinkEditor.this.tableParam.getSelectedRow(), 3);
                    DialogLinkEditor.this.loadJspArgs(jspName, (byte)2);
                }
            }
        });
        TableButtonCellEditor cellEditor = new TableButtonCellEditor(button);
        TableButtonRenderer cellRenderer = new TableButtonRenderer();
        TableColumn col = this.tableParam.getColumn(4);
        col.setCellEditor(cellEditor);
        col.setCellRenderer(cellRenderer);
        col.setMaxWidth(90);
        this.tableParam.setColumnWidth(4, 90);
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(30, 22));
    }

    private boolean isList(String list) {
        return GM.isValidString(list) && list.startsWith("list(") && list.endsWith(")");
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        String name = GM.getTableUniqueName(this.tableParam, 1, "arg");
        int r = this.tableParam.addRow();
        this.tableParam.clearSelection();
        this.tableParam.selectRow(r);
        this.tableParam.setValueAt(name, r, 1);
        this.setTextExpression();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.close();
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.tableParam.deleteSelectedRows();
        this.setTextExpression();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (this.tab.getSelectedIndex() == 0) {
            this.tableParam.acceptText();
            if (!this.verify) {
                this.verify = true;
                return;
            }
            if (!this.tableParam.verifyColumnData(1, this.tableParam.getColumnName(1))) {
                return;
            }
        }
        this.m_option = 0;
        this.close();
    }

    void jBPath_actionPerformed(ActionEvent e) {
        File f = GM.dialogSelectFile("jsp", ConfigOptions.sJSPDirectory, Lang.getText("public.open"), this.textPath.getText());
        if (f == null) {
            return;
        }
        String newPath = f.getAbsolutePath();
        if (!newPath.startsWith(ConfigOptions.sJSPDirectory)) {
            JOptionPane.showMessageDialog(null, Lang.getText("dialoglinkeditor.falsejspdir", ConfigOptions.sJSPDirectory));
            return;
        }
        newPath = newPath.substring(ConfigOptions.sJSPDirectory.length());
        if (newPath.startsWith(String.valueOf(File.separatorChar))) {
            newPath = newPath.substring(String.valueOf(File.separatorChar).length());
        }
        this.textPath.setText(newPath);
        this.loadJspArgs(newPath, (byte)3);
    }

    private void jbInit() throws Exception {
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogLinkEditor_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogLinkEditor_jBCancel_actionAdapter(this));
        this.jPanel1.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.panelDefine.setLayout(this.gridBagLayout2);
        this.jLabel1.setText("JSP\u8def\u5f84");
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.panelExp.setLayout(this.borderLayout3);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogLinkEditor_this_windowAdapter(this));
        this.tab.addChangeListener(new DialogLinkEditor_tab_changeAdapter(this));
        this.jLabel2.setText("\u53c2\u6570");
        this.jBAdd.setText("+");
        this.jBAdd.addActionListener(new DialogLinkEditor_jBAdd_actionAdapter(this));
        this.jBDel.setText("-");
        this.jBDel.addActionListener(new DialogLinkEditor_jBDel_actionAdapter(this));
        this.jPanel5.setLayout(this.gridBagLayout3);
        this.jBPath.setText("...");
        this.jBPath.addActionListener(new DialogLinkEditor_jBPath_actionAdapter(this));
        this.textPath.addActionListener(new DialogLinkEditor_textPath_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBOK, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.jPanel2.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jPanel2.add((Component)this.textPath, GM.getGBC(1, 2, true));
        this.jPanel2.add((Component)this.jBPath, GM.getGBC(1, 3));
        this.panelDefine.add((Component)this.jPanel3, GM.getGBC(2, 1, true, true));
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.jLabel2, GM.getGBC(1, 1, true));
        this.jPanel5.add((Component)this.jBAdd, GM.getGBC(1, 2));
        this.jPanel5.add((Component)this.jBDel, GM.getGBC(1, 3));
        this.jScrollPane1.getViewport().add((Component)this.tableParam, null);
        this.panelDefine.add((Component)this.jPanel2, GM.getGBC(1, 1, true));
        this.getContentPane().add((Component)this.tab, "Center");
        this.tab.add((Component)this.panelDefine, "\u5b9a\u4e49");
        this.tab.add((Component)this.panelExp, "\u8868\u8fbe\u5f0f");
        this.panelExp.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.textExp, null);
    }

    private void loadJspArgs(String jspName, byte type) {
        ArgList aList = new ArgList();
        aList.setJsp(jspName);
        if (type == 0 || type == 3) {
            this.argList = aList;
        }
        boolean hasExist = false;
        StringBuffer sb = new StringBuffer();
        sb.append(Lang.getText("public.param"));
        int i = 0;
        while (i < aList.size()) {
            Param p = aList.get(i);
            int r = this.existName(p.getParamName());
            switch (type) {
                case 1: {
                    if (r == -1) break;
                    this.tableParam.setValueAt(p.getDescription(), r, 2);
                    break;
                }
                case 2: 
                case 3: {
                    if (r == -1) {
                        r = this.tableParam.addRow();
                        this.tableParam.setValueAt(p.getParamName(), r, 1);
                        this.tableParam.setValueAt(p.getDescription(), r, 2);
                        this.tableParam.setValueAt(p.getValue(), r, 3);
                        break;
                    }
                    if (hasExist) {
                        sb.append(",");
                    } else {
                        hasExist = true;
                    }
                    sb.append(p.getParamName());
                }
            }
            ++i;
        }
        sb.append(Lang.getText("dialoglinkeditor.exist"));
        if (aList.size() > 0) {
            this.setTextExpression();
        }
        if (hasExist && (type == 2 || type == 3)) {
            JOptionPane.showMessageDialog(null, sb.toString());
        }
        this.tableParam.acceptText();
    }

    private void loadReportArgs(String raqName, byte type) {
        if (GM.isValidString(raqName)) {
            String raqFile = ConfigOptions.sReportDirectory;
            if (!ConfigOptions.sReportDirectory.endsWith(String.valueOf(File.separatorChar))) {
                raqFile = raqFile + File.separatorChar;
            }
            raqFile = raqFile + raqName;
            try {
                FileInputStream in = new FileInputStream(raqFile);
                IReport report = ReportUtils.read(in);
                ParamMetaData pmd = report.getParamMetaData();
                if (pmd == null) {
                    return;
                }
                this.tableParam.acceptText();
                StringBuffer sb = new StringBuffer();
                sb.append(Lang.getText("public.param"));
                boolean hasExist = false;
                int i = 0;
                while (i < pmd.getParamCount()) {
                    Param param = pmd.getParam(i);
                    if (param.getParamType() != 1) {
                        String name = param.getParamName();
                        String desc = param.getDescription();
                        String value = param.getValue();
                        int r = this.existName(name);
                        switch (type) {
                            case 1: {
                                if (r == -1) break;
                                this.tableParam.setValueAt(desc, r, 2);
                                break;
                            }
                            case 2: {
                                if (r == -1) {
                                    r = this.tableParam.addRow();
                                    this.tableParam.setValueAt(name, r, 1);
                                    this.tableParam.setValueAt(desc, r, 2);
                                    this.tableParam.setValueAt(value, r, 3);
                                    break;
                                }
                                if (hasExist) {
                                    sb.append(",");
                                } else {
                                    hasExist = true;
                                }
                                sb.append(name);
                            }
                        }
                    }
                    ++i;
                }
                sb.append(Lang.getText("dialoglinkeditor.exist"));
                if (pmd.getParamCount() > 0) {
                    this.setTextExpression();
                }
                if (hasExist && type == 2) {
                    JOptionPane.showMessageDialog(null, sb.toString());
                }
                this.tableParam.acceptText();
            }
            catch (Exception e) {
            }
        }
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("DialogLinkEditor.title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.tab.setTitleAt(0, Lang.getText("DialogLinkEditor.tab1"));
        this.tab.setTitleAt(1, Lang.getText("DialogLinkEditor.tab2"));
        this.jLabel1.setText(Lang.getText("DialogLinkEditor.label1"));
        this.jLabel2.setText(Lang.getText("DialogLinkEditor.label2"));
    }

    public void setExpression(String exp) {
        this.textExp.setText(exp);
        this.setParams(exp);
        if (this.argList == null) {
            return;
        }
        int i = 0;
        while (i < this.argList.size()) {
            Param p = this.argList.get(i);
            int r = this.existName(p.getParamName());
            if (GM.isValidString(this.tableParam.getValueAt(r, 3))) {
                String value = (String)this.tableParam.getValueAt(r, 3);
                switch (p.getParamType()) {
                    case 1: {
                        this.loadReportArgs(value, (byte)1);
                        break;
                    }
                    case 2: {
                        this.loadJspArgs(value, (byte)1);
                    }
                }
            }
            ++i;
        }
    }

    private boolean setParams(String exp) {
        if (!GM.isValidString(exp)) {
            return false;
        }
        if (exp.startsWith("link2(") && exp.endsWith(")")) {
            ArgumentTokenizer at = new ArgumentTokenizer(exp.substring("link2(".length(), exp.length() - 1));
            int i = 0;
            String[] s = new String[3];
            while (at.hasNext()) {
                s[i] = at.next();
                ++i;
            }
            if (!(GM.isValidString(s[0]) && this.isList(s[1]) && this.isList(s[2]))) {
                return false;
            }
            this.textPath.setText(Escape.removeEscAndQuote(s[0]));
            this.loadJspArgs(this.textPath.getText(), (byte)0);
            ArgumentTokenizer at1 = new ArgumentTokenizer(s[1].substring("list(".length(), s[1].length() - 1));
            Vector<String> names = new Vector<String>();
            while (at1.hasNext()) {
                names.add(at1.next());
            }
            ArgumentTokenizer at2 = new ArgumentTokenizer(s[2].substring("list(".length(), s[2].length() - 1));
            Vector<String> values = new Vector<String>();
            while (at2.hasNext()) {
                values.add(at2.next());
            }
            if (names.size() != values.size()) {
                return false;
            }
            i = 0;
            while (i < names.size()) {
                String value;
                String name = Escape.removeEscAndQuote((String)names.get(i));
                int r = this.existName(name);
                if (r == -1) {
                    r = this.tableParam.addRow();
                }
                this.tableParam.setValueAt(name, r, 1);
                if (GM.isValidString(values.get(i)) && !(value = (String)values.get(i)).equals("null")) {
                    value = value.startsWith("\"") && value.endsWith("\"") ? Escape.removeEscAndQuote(value) : "=" + value;
                    this.tableParam.setValueAt(value, r, 3);
                }
                ++i;
            }
        }
        return true;
    }

    private void setTextExpression() {
        StringBuffer exp = new StringBuffer("link2(");
        exp.append(Escape.addEscAndQuote(this.textPath.getText()));
        exp.append(",");
        StringBuffer val = new StringBuffer();
        exp.append("list(");
        val.append("list(");
        int rc = this.tableParam.getRowCount();
        int i = 0;
        while (i < rc) {
            Object temp;
            if (i != 0) {
                exp.append(",");
                val.append(",");
            }
            if (GM.isValidString(temp = this.tableParam.getValueAt(i, 1))) {
                String value;
                String name = Escape.addEscAndQuote((String)temp);
                exp.append(name);
                temp = this.tableParam.getValueAt(i, 3);
                value = temp != null ? ((value = (String)temp).startsWith("=") ? value.substring(1) : Escape.addEscAndQuote(value)) : "null";
                val.append(value);
            }
            ++i;
        }
        exp.append("),");
        exp.append(val);
        exp.append("))");
        this.textExp.setText(exp.toString());
    }

    void tab_stateChanged(ChangeEvent e) {
        if (this.tab.getSelectedIndex() == 1) {
            this.tableParam.acceptText();
            this.textExp.requestFocusInWindow();
        }
    }

    void textPath_actionPerformed(ActionEvent e) {
        if (GM.isValidString(this.textPath.getText())) {
            this.loadJspArgs(this.textPath.getText(), (byte)3);
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.close();
    }
}

