/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.base.Maps;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogCellFormat;
import com.runqian.report4.ide.dialog.DialogExpEditor;
import com.runqian.report4.ide.dialog.DialogParameter_jBAdd_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBCancel_focusAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBDel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBDown_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_jBUp_actionAdapter;
import com.runqian.report4.ide.dialog.DialogParameter_this_windowAdapter;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.usermodel.Param;
import com.runqian.report4.usermodel.ParamMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogParameter
extends JDialog {
    final byte COL_AUTOCREATE = 10;
    final byte COL_DATATYPE = (byte)2;
    final byte COL_DESC = 1;
    final byte COL_EDITSTYLE = 9;
    final byte COL_FORMAT = 6;
    final byte COL_NAME = 0;
    final byte COL_NULLABLE = 5;
    public final byte COL_PARATYPE = 8;
    final byte COL_PRECISION = (byte)3;
    final byte COL_SCALE = (byte)4;
    final byte COL_VALUE = 7;
    String TITLE_AUTOCREATE;
    BorderLayout borderLayout1;
    String colNames;
    JButton jBAdd;
    JButton jBCancel;
    JButton jBDel;
    JButton jBDown;
    JButton jBOK;
    JButton jBUp;
    JLabel jLabel1;
    JPanel jPanel1;
    JScrollPane jScrollPane1;
    private int m_option = -1;
    public JTableEx paraTable;

    public DialogParameter() {
        super(GV.appFrame, Lang.getText("dialogparameter.title"), true);
        this.COL_NULLABLE = (byte)5;
        this.COL_FORMAT = (byte)6;
        this.COL_VALUE = (byte)7;
        this.COL_PARATYPE = (byte)8;
        this.COL_EDITSTYLE = (byte)9;
        this.COL_AUTOCREATE = (byte)10;
        this.TITLE_AUTOCREATE = Lang.getText("dialogparameter.autocreate");
        this.colNames = Lang.getText("dialogparameter.colnames") + this.TITLE_AUTOCREATE;
        this.paraTable = new JTableEx(this.colNames){

            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                if (col == 6) {
                    DialogCellFormat dcf = new DialogCellFormat();
                    String fmt = (String)this.data.getValueAt(row, col);
                    dcf.setFormat(fmt);
                    dcf.show();
                    if (dcf.getOption() == 0) {
                        this.acceptText();
                        this.setValueAt(dcf.getFormat(), row, col);
                        this.acceptText();
                    }
                } else if (col == 7) {
                    byte b;
                    String exp = (String)this.data.getValueAt(row, col);
                    DialogExpEditor dee = new DialogExpEditor();
                    this.acceptText();
                    dee.setEditingType(3);
                    if (exp == null) {
                        exp = "";
                    }
                    if ((b = ((Byte)this.data.getValueAt(row, 8)).byteValue()) == 1) {
                        exp = "=" + exp;
                    }
                    dee.setExpression(exp);
                    dee.init();
                    dee.show();
                    if (dee.getOption() != 0) {
                        return;
                    }
                    exp = dee.getExpression();
                    if (exp.startsWith("=")) {
                        this.data.setValueAt(exp.substring(1), row, col);
                        this.data.setValueAt(new Byte(1), row, 8);
                    } else {
                        this.data.setValueAt(exp, row, col);
                        this.data.setValueAt(new Byte(0), row, 8);
                    }
                    this.acceptText();
                } else {
                    GM.dialogEditTableText(DialogParameter.this.paraTable, row, col);
                }
            }

            public void setValueAt(Object aValue, int row, int column) {
                if (!this.isItemDataChanged(row, column, aValue)) {
                    return;
                }
                this.data.setValueAt(aValue, row, column);
                this.data.setValueAt(Boolean.FALSE, row, 10);
            }
        };
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.jBAdd = new JButton();
        this.jBDel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jBUp = new JButton();
        this.jBDown = new JButton();
        this.jLabel1 = new JLabel();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(600, 400);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    public static void clearLocalCookies() {
        try {
            String xmlNodeName;
            ConfigFile cf = ConfigFile.getConfigFile();
            String oldConfigNode = cf.getConfigNode();
            cf.setConfigNode(ConfigFile.LOCAL_PARAM);
            String fileName = "";
            if (GVIde.reportSheet != null) {
                fileName = GVIde.reportSheet.getFileName();
            }
            if (GM.isValidString(xmlNodeName = GM.getLegalXMLName(fileName))) {
                cf.setAttrValue(xmlNodeName, "");
            }
            cf.setConfigNode(oldConfigNode);
        }
        catch (Throwable t) {
            GM.showException(t);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public ParamMetaData getParameter() {
        if (this.paraTable.getRowCount() < 1) {
            return null;
        }
        ParamMetaData pmd = new ParamMetaData();
        int i = 0;
        while (i < this.paraTable.getRowCount()) {
            String name = (String)this.paraTable.getValueAt(i, 0);
            if (GM.isValidString(name)) {
                Param p = new Param();
                p.setParamName(name);
                Object o = this.paraTable.data.getValueAt(i, 1);
                if (GM.isValidString(o)) {
                    p.setDescription((String)o);
                }
                if ((o = this.paraTable.data.getValueAt(i, 2)) != null) {
                    p.setDataType((Byte)o);
                }
                if ((o = this.paraTable.data.getValueAt(i, 3)) != null) {
                    p.setPrecision(((Number)o).shortValue());
                }
                if ((o = this.paraTable.getValueAt(i, 4)) != null) {
                    p.setScale(((Number)o).shortValue());
                }
                if ((o = this.paraTable.getValueAt(i, 5)) != null) {
                    p.setNullable((Boolean)o);
                }
                p.setFormat((String)this.paraTable.data.getValueAt(i, 6));
                String tmpval = (String)this.paraTable.data.getValueAt(i, 7);
                if (!GM.isValidString(tmpval)) {
                    tmpval = null;
                }
                p.setValue(tmpval);
                p.setParamType((Byte)this.paraTable.data.getValueAt(i, 8));
                p.setStyleName((String)this.paraTable.data.getValueAt(i, 9));
                p.setAutoCreated((Boolean)this.paraTable.data.getValueAt(i, 10));
                pmd.addParam(p);
            }
            ++i;
        }
        DialogParameter.clearLocalCookies();
        return pmd;
    }

    private void init() {
        EditStyleList esl;
        this.paraTable.setSelectionMode(0);
        this.paraTable.setRowHeight(20);
        this.paraTable.setColumnWidth(0, 180);
        this.paraTable.setColumnDropDown(2, TypesEx.listCodeTypes(false), TypesEx.listDispTypes(false));
        this.paraTable.setColumnDropDown(8, Maps.paraTypeCode(), Maps.paraTypeDisp());
        this.paraTable.setColumnCheckBox(5);
        this.paraTable.setColumnSpinner(3);
        this.paraTable.setColumnWidth(3, 40);
        this.paraTable.setColumnSpinner(4);
        this.paraTable.setColumnWidth(4, 40);
        this.paraTable.setClickCountToStart(1);
        this.paraTable.hideColumn(this.TITLE_AUTOCREATE);
        SemanticsManager sm = GVIde.semantics.getSemanticManager();
        if (sm != null && (esl = sm.getEditStyleList()) != null) {
            int count = esl.size();
            Vector<String> vList = null;
            int i = 0;
            while (i < count) {
                EditStyle style = esl.get(i);
                if (style != null && this.isIDEUsable(style.getEditMode())) {
                    if (vList == null) {
                        vList = new Vector<String>();
                        vList.add("");
                    }
                    vList.add(style.getName());
                }
                ++i;
            }
            if (vList != null) {
                this.paraTable.setColumnDropDown(9, vList, vList);
            }
        }
    }

    private boolean isIDEUsable(byte style) {
        switch (style) {
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        String name = GM.getTableUniqueName(this.paraTable, 0, "arg");
        int r = this.paraTable.addRow();
        this.paraTable.clearSelection();
        this.paraTable.selectRow(r);
        this.paraTable.data.setValueAt(name, r, 0);
        this.paraTable.data.setValueAt(name, r, 1);
        this.paraTable.data.setValueAt(new Byte(11), r, 2);
        this.paraTable.data.setValueAt(new Byte(0), r, 8);
        this.paraTable.data.setValueAt(Boolean.FALSE, r, 10);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBCancel_focusGained(FocusEvent e) {
        this.jBCancel.requestFocus();
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.paraTable.deleteSelectedRows();
    }

    void jBDown_actionPerformed(ActionEvent e) {
        this.paraTable.shiftRowDown(-1);
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (!this.paraTable.verifyColumnData(0, Lang.getText("dialogparameter.paramname"))) {
            return;
        }
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    void jBUp_actionPerformed(ActionEvent e) {
        this.paraTable.shiftRowUp(-1);
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new DialogParameter_this_windowAdapter(this));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(new VFlowLayout());
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogParameter_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addFocusListener(new DialogParameter_jBCancel_focusAdapter(this));
        this.jBCancel.addActionListener(new DialogParameter_jBCancel_actionAdapter(this));
        this.jBAdd.setAlignmentX(0.0f);
        this.jBAdd.setAlignmentY(5.0f);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(new DialogParameter_jBAdd_actionAdapter(this));
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBDel.addActionListener(new DialogParameter_jBDel_actionAdapter(this));
        this.jBUp.setActionCommand("");
        this.jBUp.setMnemonic('S');
        this.jBUp.setText("\u4e0a\u79fb(S)");
        this.jBUp.addActionListener(new DialogParameter_jBUp_actionAdapter(this));
        this.jBDown.setToolTipText("");
        this.jBDown.setMnemonic('X');
        this.jBDown.setText("\u4e0b\u79fb(X)");
        this.jBDown.addActionListener(new DialogParameter_jBDown_actionAdapter(this));
        this.jLabel1.setText(" ");
        this.jPanel1.add((Component)this.jBOK, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jBAdd, null);
        this.jPanel1.add((Component)this.jBDel, null);
        this.jPanel1.add((Component)this.jBUp, null);
        this.jPanel1.add((Component)this.jBDown, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jScrollPane1.getViewport().add((Component)this.paraTable, null);
    }

    private void resetLangText() {
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBAdd.setText(Lang.getText("button.add"));
        this.jBDel.setText(Lang.getText("button.delete"));
        this.jBUp.setText(Lang.getText("button.shiftup"));
        this.jBDown.setText(Lang.getText("button.shiftdown"));
    }

    public void setParameter(ParamMetaData para) {
        if (para == null) {
            return;
        }
        int i = 0;
        while (i < para.getParamCount()) {
            Param pm = para.getParam(i);
            if (pm == null) {
                return;
            }
            Object[] row = new Object[]{pm.getParamName(), pm.getDescription(), new Byte(pm.getDataType()), new Integer(pm.getPrecision()), new Integer(pm.getScale()), new Boolean(pm.isNullable()), pm.getFormat(), pm.getValue(), new Byte(pm.getParamType()), pm.getStyleName(), new Boolean(pm.isAutoCreated())};
            this.paraTable.data.addRow(row);
            ++i;
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.jBCancel_actionPerformed(null);
    }
}

