/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.base.JLayeredPaneParameter;
import com.runqian.report4.ide.usermodel.IDataSetEditor;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.ProcDataSetConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DialogProcDataSet
extends JDialog
implements IDataSetEditor {
    private JButton jBCancel;
    private JButton jBOK;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    JTabbedPane jTabbedPaneEditor;
    protected JTextArea jTextAreaSQL = new JTextArea();
    private int m_option;
    protected JLayeredPaneParameter paras;

    public DialogProcDataSet(String title) {
        super(GV.appFrame, title, true);
        this.jTabbedPaneEditor = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jBCancel = new JButton(Lang.getText("button.cancel"));
        this.jBOK = new JButton(Lang.getText("button.ok"));
        this.initComponents();
        this.setSize(500, 400);
        GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
    }

    public DialogProcDataSet() {
        this(Lang.getText("dialogprocdataset.title"));
        this.paras = new JLayeredPaneParameter(true);
        this.jTabbedPaneEditor.addTab(Lang.getText("dialogprocdataset.param"), this.paras);
    }

    private void closeDialog(WindowEvent evt) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    public DataSetConfig getDataSetConfig() {
        this.paras.paramTable.acceptText();
        ProcDataSetConfig dsc = new ProcDataSetConfig();
        dsc.setListenerClass(this.paras.jTFClassListener.getText());
        dsc.setBeginRow(this.paras.jTFBeginRow.getText());
        dsc.setEndRow(this.paras.jTFEndRow.getText());
        int r = 0;
        while (r < this.paras.paramTable.getRowCount()) {
            String para = (String)this.paras.paramTable.getValueAt(r, this.paras.COL_PARAM);
            if (GM.isValidString(para)) {
                byte type = (Byte)this.paras.paramTable.getValueAt(r, this.paras.COL_TYPE);
                byte mode = (Byte)this.paras.paramTable.getValueAt(r, this.paras.COL_MODE);
                String outName = (String)this.paras.paramTable.getValueAt(r, this.paras.COL_OUTNAME);
                dsc.addParam(para, type, mode, outName);
            }
            ++r;
        }
        dsc.setSQL(this.jTextAreaSQL.getText());
        return dsc;
    }

    public int getOption() {
        return this.m_option;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.jTextAreaSQL.setLineWrap(true);
        this.jScrollPane1.setViewportView(this.jTextAreaSQL);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTabbedPaneEditor.addTab(Lang.getText("dialogprocdataset.define"), this.jScrollPane1);
        this.getContentPane().add((Component)this.jTabbedPaneEditor, "Center");
        this.jPanel1.setLayout(new VFlowLayout());
        this.jBOK.setMnemonic('O');
        this.jPanel1.add(this.jBOK);
        this.jBCancel.setMnemonic('C');
        this.jPanel1.add(this.jBCancel);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DialogProcDataSet.this.closeDialog(evt);
            }
        });
        this.jBOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogProcDataSet.this.jBOKActionPerformed(evt);
            }
        });
        this.jBCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogProcDataSet.this.jBCancelActionPerformed(evt);
            }
        });
    }

    private void jBCancelActionPerformed(ActionEvent evt) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    private void jBOKActionPerformed(ActionEvent evt) {
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    public static void main(String[] args) {
    }

    public void setDataSetConfig(DataSetConfig dsConfig) {
        if (dsConfig == null) {
            return;
        }
        ProcDataSetConfig dsc = (ProcDataSetConfig)dsConfig;
        this.jTextAreaSQL.setText(dsc.getSQL());
        this.paras.jTFClassListener.setText(dsc.getListenerClass());
        this.paras.jTFBeginRow.setText(dsc.getBeginRow());
        this.paras.jTFEndRow.setText(dsc.getEndRow());
        int i = 0;
        while (i < dsc.getParamCount()) {
            this.paras.paramTable.addRow(new Object[]{new Integer(i + 1), dsc.getParamExp(i), new Byte(dsc.getParamType(i)), new Byte(dsc.getParamMode(i)), dsc.getParamOutName(i)});
            ++i;
        }
    }
}

