/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_jBClose_actionAdapter;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_jBFile_actionAdapter;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_jBRemove_actionAdapter;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_jBTransfer_actionAdapter;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_jTabbedPane1_changeAdapter;
import com.runqian.report4.ide.dialog.DialogRaqTransfer_this_windowAdapter;
import com.runqian.report4.transfer.ReportTransfer;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class DialogRaqTransfer
extends JDialog {
    private final int DIR = 1;
    private final int FILE = 0;
    private final String MIGRATEDIRECTORY = "migrateDirectory";
    BorderLayout borderLayout1;
    BorderLayout borderLayout3;
    BorderLayout borderLayout4;
    ButtonGroup buttonGroup1;
    FlowLayout flowLayout1;
    FlowLayout flowLayout2;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridBagLayout gridBagLayout3;
    JButton jBClose;
    JButton jBDirectory;
    JButton jBFile;
    JButton jBRemove;
    JButton jBTargetDir;
    JButton jBTransfer;
    JCheckBox jCBSub;
    JCheckBox jCBUseDefault;
    JLabel jLabel2;
    JLabel jLabel3;
    JListEx jListFiles;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel6;
    JPanel jPanel7;
    JPanel jPanel8;
    JPanel jPanel9;
    JScrollPane jScrollPane1;
    JTextField jTFDirectory;
    JTextField jTFTargetDir;
    JTabbedPane jTabbedPane1;
    private int m_option = 0;
    private int maxFileNameLen = 0;
    JPanel panel1 = new JPanel();
    JPanel panelDirectory;
    JPanel panelFile;
    JPanel panelmain;
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    VerticalFlowLayout verticalFlowLayout1;

    public DialogRaqTransfer() {
        super(GV.appFrame, Lang.getText("dialograqtransfer.title"), true);
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.jListFiles = new JListEx();
        this.jPanel1 = new JPanel();
        this.jBTransfer = new JButton();
        this.jBFile = new JButton();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jBClose = new JButton();
        this.jBRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTFTargetDir = new JTextField();
        this.jBTargetDir = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.panelmain = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTFDirectory = new JTextField();
        this.jBDirectory = new JButton();
        this.jPanel7 = new JPanel();
        this.jCBSub = new JCheckBox();
        this.jCBUseDefault = new JCheckBox();
        this.buttonGroup1 = new ButtonGroup();
        this.panelFile = new JPanel();
        this.jPanel8 = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.borderLayout3 = new BorderLayout();
        this.panelDirectory = new JPanel();
        this.jPanel9 = new JPanel();
        this.flowLayout2 = new FlowLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.gridBagLayout3 = new GridBagLayout();
        this.jTabbedPane1 = new JTabbedPane();
        this.borderLayout4 = new BorderLayout();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(500, 400);
            GM.setDialogDefaultButton(this, this.jBTransfer, this.jBClose);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void init() {
        try {
            ConfigFile cf = ConfigFile.getConfigFile();
            String directory = cf.getAttrValue("migrateDirectory");
            this.jTFTargetDir.setText(directory);
        }
        catch (Throwable t) {
            GM.showException(t);
        }
    }

    void jBClose_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBDirectory_actionPerformed(ActionEvent e) {
        String newDir = GM.dialogSelectDirectory(GV.lastDirectory);
        if (GM.isValidString(newDir)) {
            this.jTFDirectory.setText(newDir);
        }
    }

    void jBFile_actionPerformed(ActionEvent e) {
        File[] files = GM.dialogSelectFiles("raq");
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (!this.jListFiles.data.contains(f)) {
                    if (f.getAbsolutePath().length() > this.maxFileNameLen) {
                        this.maxFileNameLen = f.getAbsolutePath().length();
                    }
                    this.jListFiles.data.addElement(f);
                }
                ++i;
            }
            this.maxFileNameLen += 5;
        }
        this.jListFiles.setSelectionInterval(0, 0);
    }

    void jBRemove_actionPerformed(ActionEvent e) {
        this.jListFiles.removeSelectedItems();
    }

    void jBTargetDir_actionPerformed(ActionEvent e) {
        String newDir;
        String dir = this.jTFTargetDir.getText();
        if (dir == null || dir.trim().equals("")) {
            dir = GV.lastDirectory;
        }
        if (GM.isValidString(newDir = GM.dialogSelectDirectory(dir))) {
            this.jTFTargetDir.setText(newDir);
            try {
                ConfigFile cf = ConfigFile.getConfigFile();
                cf.setAttrValue("migrateDirectory", newDir);
            }
            catch (Throwable t) {
                GM.showException(t);
            }
        }
    }

    void jBTransfer_actionPerformed(ActionEvent e) {
        if (this.m_option == 0) {
            this.transferFile();
        } else if (this.m_option == 1) {
            this.transferDirectory();
        }
    }

    void jTabbedPane1_stateChanged(ChangeEvent e) {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.m_option = 0;
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.m_option = 1;
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.panel1.setLayout(this.borderLayout1);
        this.jBTransfer.setActionCommand("\u5f00\u59cb\u8fc1\u79fb(O)");
        this.jBTransfer.setMnemonic('O');
        this.jBTransfer.setText("\u5f00\u59cb\u8fc1\u79fb(O)");
        this.jBTransfer.addActionListener(new DialogRaqTransfer_jBTransfer_actionAdapter(this));
        this.jBFile.setMnemonic('F');
        this.jBFile.setText("\u9009\u62e9\u6587\u4ef6(F)");
        this.jBFile.addActionListener(new DialogRaqTransfer_jBFile_actionAdapter(this));
        this.jPanel1.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBClose.setMnemonic('C');
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogRaqTransfer_jBClose_actionAdapter(this));
        this.jBRemove.setMnemonic('R');
        this.jBRemove.setText("\u4e0d\u9009\u6587\u4ef6(R)");
        this.jBRemove.addActionListener(new DialogRaqTransfer_jBRemove_actionAdapter(this));
        this.jLabel2.setRequestFocusEnabled(true);
        this.jLabel2.setText("\u8fc1\u79fb\u5230\u76ee\u5f55\uff1a");
        this.jBTargetDir.setHorizontalAlignment(0);
        this.jBTargetDir.setText("...");
        this.jBTargetDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogRaqTransfer.this.jBTargetDir_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jTFTargetDir.setText("");
        this.panelmain.setLayout(this.borderLayout4);
        this.jLabel3.setText("\u8fc1\u79fb\u76ee\u5f55");
        this.jBDirectory.setText("...");
        this.jBDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogRaqTransfer.this.jBDirectory_actionPerformed(e);
            }
        });
        this.jTFDirectory.setText("");
        this.jCBSub.setText("\u5305\u542b\u5b50\u76ee\u5f55");
        this.jCBUseDefault.setText("Default Arg");
        this.jPanel8.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.panelFile.setLayout(this.borderLayout3);
        this.panelDirectory.setLayout(this.gridBagLayout2);
        this.jPanel7.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.panelmain.setBorder(this.titledBorder2);
        this.panelmain.setDebugGraphicsOptions(0);
        this.panelFile.setBorder(null);
        this.jPanel6.setLayout(this.gridBagLayout3);
        this.addWindowListener(new DialogRaqTransfer_this_windowAdapter(this));
        this.jPanel6.add((Component)this.jLabel3, GM.getGBC(1, 1));
        this.jPanel6.add((Component)this.jTFDirectory, GM.getGBC(1, 2, true));
        this.jPanel6.add((Component)this.jBDirectory, GM.getGBC(1, 3));
        this.panelDirectory.add((Component)this.jPanel6, GM.getGBC(1, 1, true));
        this.jPanel7.add((Component)this.jCBSub, null);
        this.panelDirectory.add((Component)this.jPanel7, GM.getGBC(2, 1, true));
        this.panelDirectory.add((Component)this.jPanel9, GM.getGBC(3, 1, true, true));
        this.jPanel1.add((Component)this.jBTransfer, null);
        this.jPanel1.add((Component)this.jBClose, null);
        GridBagConstraints gbc = GM.getGBC(1, 1);
        gbc.gridwidth = 3;
        this.jPanel2.add((Component)this.jCBUseDefault, gbc);
        this.jPanel2.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.jPanel2.add((Component)this.jTFTargetDir, GM.getGBC(2, 2, true));
        this.jPanel2.add((Component)this.jBTargetDir, GM.getGBC(2, 3));
        this.panelmain.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.panelFile, "\u6587\u4ef6\u8fc1\u79fb");
        this.jTabbedPane1.add((Component)this.panelDirectory, "\u76ee\u5f55\u8fc1\u79fb");
        this.jTabbedPane1.addChangeListener(new DialogRaqTransfer_jTabbedPane1_changeAdapter(this));
        this.panelmain.add((Component)this.jPanel2, "South");
        this.panel1.add((Component)this.jPanel1, "East");
        this.panel1.add((Component)this.panelmain, "Center");
        this.getContentPane().add(this.panel1);
        this.jListFiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogRaqTransfer.this.jBRemove.doClick();
                }
            }
        });
        this.jListFiles.setSelectedIndex(0);
        this.jPanel8.add((Component)this.jBFile, null);
        this.jPanel8.add((Component)this.jBRemove, null);
        this.panelFile.add((Component)this.jScrollPane1, "Center");
        this.panelFile.add((Component)this.jPanel8, "North");
        this.jScrollPane1.getViewport().add((Component)this.jListFiles, null);
        this.jTabbedPane1.setSelectedComponent(this.panelFile);
        this.setDefaultCloseOperation(0);
    }

    String newSplitString(int num) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < num) {
            sb.append('-');
            ++i;
        }
        return "     " + sb.toString();
    }

    private void resetLangText() {
        this.jBTransfer.setActionCommand(Lang.getText("dialograqtransfer.transfer"));
        this.jBTransfer.setText(Lang.getText("dialograqtransfer.transfer"));
        this.jBFile.setText(Lang.getText("dialograqtransfer.file"));
        this.jBClose.setText(Lang.getText("button.close"));
        this.jBRemove.setText(Lang.getText("dialograqtransfer.remove"));
        this.jLabel2.setText(Lang.getText("dialograqtransfer.targetdir"));
        this.jLabel3.setText(Lang.getText("dialograqtransfer.transferdir"));
        this.jCBSub.setText(Lang.getText("dialograqtransfer.containsub"));
        this.jCBUseDefault.setText(Lang.getText("dialograqtransfer.usedefault"));
        this.jTabbedPane1.add((Component)this.panelFile, Lang.getText("dialograqtransfer.selectfile"));
        this.jTabbedPane1.add((Component)this.panelDirectory, Lang.getText("dialograqtransfer.selectdirectory"));
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private void transfer(File f, String dir, StringBuffer error) {
        String oldFile = f.getAbsolutePath();
        String url = this.jTFDirectory.getText();
        try {
            if (f.isFile()) {
                if (!f.toString().endsWith(".raq")) {
                    return;
                }
                FileInputStream is = new FileInputStream(f);
                Object[] buffer = new Object[1];
                IReport report = ReportTransfer.transfer1(is, buffer);
                Context context = GVIde.prepareContext(this.jCBUseDefault.isSelected(), report, null);
                report = ReportTransfer.transfer2(buffer, report, context);
                String newFile = dir + f.getAbsolutePath().substring(url.length());
                f = new File(newFile);
                FileOutputStream out = new FileOutputStream(f);
                ReportUtils.write(out, report);
                ((OutputStream)out).close();
            } else if (f.isDirectory()) {
                File d = new File(dir + f.getAbsolutePath().substring(url.length()));
                d.mkdir();
                File[] child = f.listFiles();
                int i = 0;
                while (i < child.length) {
                    this.transfer(child[i], dir, error);
                    ++i;
                }
            }
        }
        catch (Exception x) {
            error.append(oldFile);
            error.append("\r\n");
            error.append(x.getMessage());
            error.append("\r\n");
            error.append("\r\n");
            x.printStackTrace();
        }
    }

    private void transferDirectory() {
        String sDir;
        boolean containSub = this.jCBSub.isSelected();
        String tDir = this.jTFTargetDir.getText();
        int c = -1;
        if (!GM.isValidString(tDir)) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialograqtransfer.targetmsg"));
            return;
        }
        String sep = System.getProperty("file.separator");
        if (!tDir.endsWith(sep)) {
            tDir = tDir + sep;
        }
        if (!GM.isValidString(sDir = this.jTFDirectory.getText())) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialograqtransfer.directorymsg"));
            return;
        }
        File f = new File(sDir);
        StringBuffer error = new StringBuffer();
        if (f.isFile()) {
            this.transfer(f, tDir, error);
        } else if (f.isDirectory()) {
            File[] child = f.listFiles();
            int i = 0;
            while (i < child.length) {
                if (containSub || !child[i].isDirectory()) {
                    this.transfer(child[i], tDir, error);
                }
                ++i;
            }
        }
        String msg = error.toString();
        if (!GM.isValidString(msg)) {
            msg = Lang.getText("dialograqtransfer.success");
        }
        DialogInputText dit = new DialogInputText(GV.appFrame);
        dit.setText(msg);
        dit.show();
    }

    private void transferFile() {
        int c = this.jListFiles.data.size();
        if (c < 1) {
            return;
        }
        String dir = this.jTFTargetDir.getText();
        if (!GM.isValidString(dir)) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialograqtransfer.targetmsg"));
            return;
        }
        String sep = System.getProperty("file.separator");
        if (!dir.endsWith(sep)) {
            dir = dir + sep;
        }
        StringBuffer error = new StringBuffer();
        int i = 0;
        while (i < c) {
            Object o = this.jListFiles.data.getElementAt(i);
            if (o instanceof File) {
                File f = (File)o;
                String oldFile = f.getAbsolutePath();
                try {
                    FileInputStream is = new FileInputStream(f);
                    Object[] buffer = new Object[1];
                    IReport report = ReportTransfer.transfer1(is, buffer);
                    Context context = GVIde.prepareContext(this.jCBUseDefault.isSelected(), report, null);
                    report = ReportTransfer.transfer2(buffer, report, context);
                    String newFile = dir + f.getName();
                    f = new File(newFile);
                    FileOutputStream out = new FileOutputStream(f);
                    ReportUtils.write(out, report);
                    ((OutputStream)out).close();
                    this.jListFiles.data.setElementAt(oldFile + this.newSplitString(this.maxFileNameLen - oldFile.length()) + ">     " + newFile, i);
                }
                catch (Exception x) {
                    error.append(oldFile);
                    error.append("\r\n");
                    error.append(x.getMessage());
                    error.append("\r\n");
                    error.append("\r\n");
                    x.printStackTrace();
                }
            }
            ++i;
        }
        String msg = error.toString();
        if (!GM.isValidString(msg)) {
            msg = Lang.getText("dialograqtransfer.success");
        }
        DialogInputText dit = new DialogInputText(GV.appFrame);
        dit.setText(msg);
        dit.show();
    }
}

