/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.base4.util.SegmentSet;
import com.runqian.base4.util.Sentence;
import com.runqian.report4.control.CellPosition;
import com.runqian.report4.control.EditControl;
import com.runqian.report4.ide.AtomicCell;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.dialog.DialogSearch_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogSearch_jBReplaceAll_actionAdapter;
import com.runqian.report4.ide.dialog.DialogSearch_jBReplace_actionAdapter;
import com.runqian.report4.ide.dialog.DialogSearch_jBSearch_actionAdapter;
import com.runqian.report4.ide.dialog.DialogSearch_this_windowAdapter;
import com.runqian.report4.ide.usermodel.ReportEditor;
import com.runqian.report4.ide.usermodel.ReportModel;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.util.ReportParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DialogSearch
extends JDialog {
    ButtonGroup bg1;
    ButtonGroup bg2;
    Border border1;
    BorderLayout borderLayout1;
    EditControl editControl = null;
    private int expKeyIndex = 0;
    GridBagLayout gridBagLayout1;
    boolean isSearchClicked = false;
    JButton jBCancel;
    JButton jBReplace;
    JButton jBReplaceAll;
    JButton jBSearch;
    JComboBox jCBReplace;
    JComboBox jCBSearch;
    JCheckBox jCBSensitive;
    JCheckBox jCBWordOnly;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLbStatus;
    JPanel jPanel1;
    JPanel jPanel2;
    JRadioButton jRBAllExp;
    JRadioButton jRBValueOnly;
    JPanel panel1 = new JPanel();
    private short replaceAllStartCol = 1;
    private int replaceAllStartRow = 1;
    static Section replaceKeys;
    private String replaceString = "";
    ReportEditor reportEditor = null;
    ReportModel reportModel = null;
    public final byte[] searchExpKeys;
    private int searchFlag;
    private boolean searchInExp;
    static Section searchKeys;
    private boolean searchSelectedCells;
    private String searchString = "";
    public final byte[] searchValueKeys;
    private short searchedCol;
    private int searchedRow = -1;
    static SegmentSet status;
    private int stringIndex = -1;
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    private int valueKeyIndex = 0;
    VerticalFlowLayout verticalFlowLayout1;

    static {
        searchKeys = new Section();
        replaceKeys = new Section();
        status = new SegmentSet("");
    }

    public DialogSearch() {
        super(GV.appFrame, Lang.getText("dialogsearch.title"), false);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCBSearch = new JComboBox();
        this.jCBReplace = new JComboBox();
        this.jBSearch = new JButton();
        this.jBReplace = new JButton();
        this.jBReplaceAll = new JButton();
        this.jBCancel = new JButton();
        this.jCBSensitive = new JCheckBox();
        this.jCBWordOnly = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRBValueOnly = new JRadioButton();
        this.jRBAllExp = new JRadioButton();
        this.bg1 = new ButtonGroup();
        this.bg2 = new ButtonGroup();
        this.jLbStatus = new JLabel();
        this.searchedCol = (short)-1;
        this.searchValueKeys = new byte[]{40, 41};
        this.searchExpKeys = new byte[]{40, 49, 41, 48, 50, 51, 27, 35, 22, 23, 42, 52, 43, 44, 45, 46, 47, 53, 28, 30, 31, 32, 54, 55, 56, 37, 33, 34, 80, 57};
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.gridBagLayout1 = new GridBagLayout();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.pack();
            GM.setDialogDefaultButton(this, this.jBSearch, this.jBCancel);
            this.jCBSearch.requestFocus();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    void init() {
        String sTmp = status.get("case");
        if (GM.isValidString(sTmp)) {
            this.jCBSensitive.setSelected(new Boolean(sTmp));
        }
        if (GM.isValidString(sTmp = status.get("wordonly"))) {
            this.jCBWordOnly.setSelected(new Boolean(sTmp));
        }
        if (GM.isValidString(sTmp = status.get("range"))) {
            boolean b = sTmp == "value";
            this.jRBValueOnly.setSelected(b);
            this.jRBAllExp.setSelected(!b);
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.rememberStatus();
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBReplaceAll_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace, this.jCBSensitive.isSelected(), this.jCBWordOnly.isSelected(), this.jRBAllExp.isSelected());
        int i = this.replaceAll();
        this.jLbStatus.setText(Lang.getText("dialogsearch.totalreplace") + i + Lang.getText("dialogsearch.replacestr"));
    }

    void jBReplace_actionPerformed(ActionEvent e) {
        if (this.isSearchClicked) {
            this.stringIndex = -1;
        }
        this.isSearchClicked = false;
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace, this.jCBSensitive.isSelected(), this.jCBWordOnly.isSelected(), this.jRBAllExp.isSelected());
        if (this.replace()) {
            this.jLbStatus.setText(" ");
        } else {
            this.jLbStatus.setText(Lang.getText("dialogsearch.notexist") + (String)this.jCBSearch.getSelectedItem() + " ]\u3002");
        }
    }

    void jBSearch_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        this.isSearchClicked = true;
        this.setSearchConfig((String)this.jCBSearch.getSelectedItem(), "", this.jCBSensitive.isSelected(), this.jCBWordOnly.isSelected(), this.jRBAllExp.isSelected());
        if (this.search()) {
            this.jLbStatus.setText(" ");
        } else {
            this.jLbStatus.setText(Lang.getText("dialogsearch.notexist") + (String)this.jCBSearch.getSelectedItem() + " ]");
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u683c\u5b50\u8303\u56f4");
        this.border1 = BorderFactory.createEmptyBorder();
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u5c5e\u6027\u8303\u56f4");
        this.panel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u67e5\u627e\u5185\u5bb9");
        this.jLabel2.setText("\u66ff\u6362\u4e3a");
        this.jBSearch.setText("\u67e5\u627e(F)");
        this.jBSearch.setMnemonic('F');
        this.jBSearch.addActionListener(new DialogSearch_jBSearch_actionAdapter(this));
        this.jBReplace.setText("\u66ff\u6362(R)");
        this.jBReplace.setMnemonic('R');
        this.jBReplace.addActionListener(new DialogSearch_jBReplace_actionAdapter(this));
        this.jBReplaceAll.setText("\u5168\u90e8\u66ff\u6362(A)");
        this.jBReplaceAll.setMnemonic('A');
        this.jBReplaceAll.addActionListener(new DialogSearch_jBReplaceAll_actionAdapter(this));
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.setMnemonic('C');
        this.jBCancel.addActionListener(new DialogSearch_jBCancel_actionAdapter(this));
        this.jCBSensitive.setMaximumSize(new Dimension(95, 27));
        this.jCBSensitive.setSelected(true);
        this.jCBSensitive.setText("\u533a\u5206\u5927\u5c0f\u5199");
        this.jCBWordOnly.setText("\u4ec5\u641c\u7d22\u72ec\u7acb\u5355\u8bcd");
        this.jPanel2.setBorder(this.titledBorder2);
        this.jRBValueOnly.setText("\u5355\u5143\u683c\u7684\u503c");
        this.jRBValueOnly.setSelected(true);
        this.jRBAllExp.setText("\u8868\u8fbe\u5f0f");
        this.jRBAllExp.setActionCommand("\u8868\u8fbe\u5f0f");
        this.jCBSearch.setEditable(true);
        this.jCBReplace.setEditable(true);
        this.jLbStatus.setText(" ");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new DialogSearch_this_windowAdapter(this));
        this.jPanel1.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.jPanel2.add((Component)this.jRBValueOnly, null);
        this.jPanel2.add((Component)this.jRBAllExp, null);
        this.panel1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.panel1.add((Component)this.jCBSearch, GM.getGBC(1, 2, true));
        this.panel1.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.panel1.add((Component)this.jCBReplace, GM.getGBC(2, 2, true));
        JPanel tmp = new JPanel(new FlowLayout(0));
        tmp.add(this.jCBSensitive);
        tmp.add(this.jCBWordOnly);
        GridBagConstraints gbc = GM.getGBC(3, 1);
        gbc.gridwidth = 2;
        this.panel1.add((Component)tmp, gbc);
        gbc = GM.getGBC(4, 1);
        gbc.gridwidth = 2;
        this.panel1.add((Component)this.jPanel2, gbc);
        gbc = GM.getGBC(5, 1, true, true);
        gbc.gridwidth = 2;
        this.panel1.add((Component)this.jLbStatus, gbc);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBSearch, null);
        this.jPanel1.add((Component)this.jBReplace, null);
        this.jPanel1.add((Component)this.jBReplaceAll, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.bg2.add(this.jRBValueOnly);
        this.bg2.add(this.jRBAllExp);
    }

    void rememberStatus() {
        status.put("case", new Boolean(this.jCBSensitive.isSelected()).toString());
        status.put("wordonly", new Boolean(this.jCBWordOnly.isSelected()).toString());
        String sTmp = this.jRBValueOnly.isSelected() ? "value" : "exp";
        status.put("range", sTmp);
    }

    private boolean replace(boolean replaceAll, Vector cmds) {
        if (this.search(replaceAll)) {
            INormalCell nc = this.reportModel.getCell(this.searchedRow, this.searchedCol);
            AtomicCell ac = new AtomicCell(nc);
            if (this.searchInExp) {
                byte propId = this.searchExpKeys[this.expKeyIndex];
                ac.setProperty(propId);
                IByteMap expMap = nc.getExpMap(true);
                String exp = (String)expMap.get(propId);
                exp = Sentence.replace(exp, this.stringIndex, this.searchString, this.replaceString, this.searchFlag + 4);
                ac.setExp(exp);
            } else {
                byte propId = this.searchValueKeys[this.valueKeyIndex];
                ac.setProperty(propId);
                IByteMap valMap = this.reportModel.getCell(this.searchedRow, this.searchedCol).getPropertyMap();
                String value = (String)valMap.get(propId);
                value = Sentence.replace(value, this.stringIndex, this.searchString, this.replaceString, this.searchFlag + 4);
                ac.setValue(value);
            }
            cmds.add(ac);
            this.stringIndex += this.replaceString.length() - 1;
            return true;
        }
        return false;
    }

    private boolean replace() {
        Vector cmds = new Vector();
        boolean lb = this.replace(false, cmds);
        if (lb) {
            GVIde.reportEditor.executeCmd(cmds);
        }
        return lb;
    }

    private int replaceAll() {
        int count = 0;
        Vector cmds = new Vector();
        while (this.replace(true, cmds)) {
            ++count;
        }
        if (count > 0) {
            GVIde.reportEditor.executeCmd(cmds);
        }
        this.replaceAllStartRow = 1;
        this.replaceAllStartCol = 1;
        return count;
    }

    void resetDropItems() {
        String sTmp = (String)this.jCBSearch.getSelectedItem();
        this.jCBSearch.removeAllItems();
        searchKeys.unionSection(sTmp);
        int i = searchKeys.size() - 1;
        while (i >= 0) {
            this.jCBSearch.addItem(searchKeys.getSection(i));
            --i;
        }
        this.jCBSearch.setSelectedItem(sTmp);
        sTmp = (String)this.jCBReplace.getSelectedItem();
        this.jCBReplace.removeAllItems();
        replaceKeys.unionSection(sTmp);
        int i2 = replaceKeys.size() - 1;
        while (i2 >= 0) {
            this.jCBReplace.addItem(replaceKeys.getSection(i2));
            --i2;
        }
        this.jCBReplace.setSelectedItem(sTmp);
    }

    private void resetLangText() {
        this.titledBorder1.setTitle(Lang.getText("dialogsearch.searchcell"));
        this.titledBorder2.setTitle(Lang.getText("dialogsearch.searchproperty"));
        this.jLabel1.setText(Lang.getText("dialogsearch.searchitem"));
        this.jLabel2.setText(Lang.getText("dialogsearch.replace"));
        this.jBSearch.setText(Lang.getText("button.search"));
        this.jBReplace.setText(Lang.getText("button.replace"));
        this.jBReplaceAll.setText(Lang.getText("button.replaceall"));
        this.jBCancel.setText(Lang.getText("button.close"));
        this.jCBSensitive.setText(Lang.getText("dialogsearch.sensitive"));
        this.jCBWordOnly.setText(Lang.getText("dialogsearch.wordonly"));
        this.jRBValueOnly.setText(Lang.getText("dialogsearch.valueonly"));
        this.jRBAllExp.setText(Lang.getText("dialogsearch.exp"));
        this.jRBAllExp.setActionCommand(Lang.getText("dialogsearch.exp"));
    }

    private boolean search(int startRow, short startCol, int endRow, short endCol, boolean replaceAll) {
        ReportParser parser = new ReportParser(this.reportModel.getReport());
        boolean found = false;
        int row = startRow;
        while (row <= endRow) {
            short col = startCol;
            while (col <= endCol) {
                INormalCell nc = this.reportModel.getCell(row, col);
                if (!nc.isMerged() || parser.isMergedFirstCell(row, col, false)) {
                    byte propId;
                    int i;
                    if (this.searchInExp) {
                        IByteMap expMap = nc.getExpMap(true);
                        i = this.expKeyIndex;
                        while (i < this.searchExpKeys.length) {
                            propId = this.searchExpKeys[i];
                            String exp = (String)expMap.get(propId);
                            if (exp == null) {
                                this.stringIndex = -1;
                            } else {
                                this.stringIndex = Sentence.indexOf(exp, this.searchString, this.stringIndex + 1, this.searchFlag);
                                if (this.stringIndex >= 0) {
                                    found = true;
                                    this.expKeyIndex = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    } else {
                        IByteMap valMap = nc.getPropertyMap();
                        i = this.valueKeyIndex;
                        while (i < this.searchValueKeys.length) {
                            propId = this.searchValueKeys[i];
                            String value = (String)valMap.get(propId);
                            if (value == null) {
                                this.stringIndex = -1;
                            } else {
                                this.stringIndex = Sentence.indexOf(value, this.searchString, this.stringIndex + 1, this.searchFlag);
                                if (this.stringIndex >= 0) {
                                    found = true;
                                    this.valueKeyIndex = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (found) {
                        this.searchedRow = row;
                        this.searchedCol = col;
                        this.replaceAllStartRow = row;
                        this.replaceAllStartCol = col;
                        if (!replaceAll) {
                            this.editControl.setSearchedCell(row, col, this.searchSelectedCells);
                        }
                        return true;
                    }
                    this.expKeyIndex = 0;
                    this.valueKeyIndex = 0;
                }
                col = (short)(col + 1);
            }
            ++row;
        }
        return false;
    }

    private boolean search(boolean replaceAll) {
        int startRow = 1;
        int endRow = this.reportModel.getRowCount();
        short startCol = 1;
        short endCol = this.reportModel.getColCount();
        if (!(this.reportEditor.selectedRects.isEmpty() || this.reportEditor.getSelectedRect().getColCount() <= 1 && this.reportEditor.getSelectedRect().getRowCount() <= 1)) {
            startRow = this.reportEditor.getSelectedRect().getBeginRow();
            startCol = this.reportEditor.getSelectedRect().getBeginCol();
            endRow = this.reportEditor.getSelectedRect().getEndRow();
            endCol = this.reportEditor.getSelectedRect().getEndCol();
            this.searchSelectedCells = true;
        }
        int activeRow = startRow;
        short activeCol = startCol;
        CellPosition cp = this.editControl.getActiveCell();
        if (cp != null) {
            activeRow = cp.getRow();
            activeCol = cp.getCol();
        }
        boolean found = false;
        if (!replaceAll) {
            found = this.search(activeRow, activeCol, activeRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow + 1, startCol, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(startRow, startCol, activeRow - 1, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow, startCol, activeRow, (short)(activeCol - 1), replaceAll);
            if (found) {
                return true;
            }
        } else {
            found = this.search(this.replaceAllStartRow, this.replaceAllStartCol, this.replaceAllStartRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(this.replaceAllStartRow + 1, (short)1, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
        }
        return false;
    }

    private boolean search() {
        return this.search(false);
    }

    public void setControl(ReportEditor editor, boolean replace) {
        this.reportEditor = editor;
        this.editControl = (EditControl)editor.getComponent();
        this.reportModel = new ReportModel(this.editControl);
        this.resetDropItems();
        if (!replace) {
            this.jCBReplace.setEnabled(false);
            this.jBReplace.setEnabled(false);
            this.jBReplaceAll.setEnabled(false);
        }
    }

    void setSearchConfig(String searchString, String replaceString, boolean caseSensitive, boolean onlyWorld, boolean searchInExp) {
        this.searchString = searchString;
        if (replaceString == null) {
            replaceString = "";
        }
        this.replaceString = replaceString;
        this.searchInExp = searchInExp;
        this.searchFlag = 18;
        if (!caseSensitive) {
            ++this.searchFlag;
        }
        if (onlyWorld) {
            this.searchFlag += 8;
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

