/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.swing.JComboBoxExEditor;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.swing.JTextAreaEditor;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.datamanager.datawindow.DDDW;
import com.runqian.datamanager.datawindow.DWCheckBox;
import com.runqian.report4.ide.dialog.DWCheckBoxEditor;
import com.runqian.report4.ide.dialog.DWPasswordEditor;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.SemanticsManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

class EachParamEditor
implements TableCellEditor {
    private TableCellEditor defaultEditor;
    private TableCellEditor editor;
    private HashMap editorMap = new HashMap();
    private SemanticsManager sManager;
    private JTableEx table;

    public EachParamEditor(SemanticsManager sManager, JTableEx table) {
        this.sManager = sManager;
        this.table = table;
        this.defaultEditor = new JTextAreaEditor(table);
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    protected void selectEditor(MouseEvent e) {
        this.editor = this.defaultEditor;
        if (this.sManager == null) {
            return;
        }
        EditStyleList esl = this.sManager.getEditStyleList();
        if (esl == null || esl.size() <= 0) {
            return;
        }
        int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        String style = (String)this.table.data.getValueAt(row, 4);
        if (!GM.isValidString(style)) {
            return;
        }
        EditStyle es = esl.get(style);
        if (es == null) {
            return;
        }
        try {
            Object oStyle = GV.SemanticEditStyle2DWObject(es.getEditConfig(), this.sManager);
            if (oStyle != null) {
                if (oStyle instanceof DDDW) {
                    this.editor = (DefaultCellEditor)this.editorMap.get(oStyle);
                    if (this.editor == null) {
                        Vector code = new Vector(((DDDW)oStyle).codes);
                        Vector disp = new Vector(((DDDW)oStyle).disps);
                        JComboBoxEx combo = new JComboBoxEx();
                        combo.x_setData(code, disp);
                        this.editor = new JComboBoxExEditor(combo);
                        this.editorMap.put(oStyle, this.editor);
                    }
                } else if (oStyle instanceof DWCheckBox) {
                    this.editor = (DefaultCellEditor)this.editorMap.get(oStyle);
                    if (this.editor == null) {
                        this.editor = new DWCheckBoxEditor((DWCheckBox)oStyle);
                        this.editorMap.put(oStyle, this.editor);
                    }
                }
            } else if (es.getEditMode() == 9) {
                this.editor = (DefaultCellEditor)this.editorMap.get(new Byte(es.getEditMode()));
                if (this.editor == null) {
                    this.editor = new DWPasswordEditor();
                    this.editorMap.put(new Byte(es.getEditMode()), this.editor);
                }
            }
        }
        catch (Exception ex) {
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }
}

