/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.usermodel;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.Segment;
import com.runqian.base4.util.PwdUtils;
import com.runqian.report4.ide.GroupEngine;
import com.runqian.report4.ide.dialog.DialogExportToTextOption;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.ReportGroup;
import com.runqian.report4.view.excel.ExcelReport;
import com.runqian.report4.view.html.HtmlReport;
import com.runqian.report4.view.pdf.PdfReport;
import com.runqian.report4.view.text.TextFile;
import com.runqian.report4.view.text.TextReport;
import com.runqian.report4.view.word.WordReport;
import com.runqian.report4.view.xml.XMLReport;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ReportExporter {
    public static final byte EXPORT_EXCEL = 1;
    public static final byte EXPORT_EXCEL_PAGE = 2;
    public static final byte EXPORT_EXCEL_FORMULA = 3;
    public static final byte EXPORT_PDF = 4;
    public static final byte EXPORT_PDF_PAGE = 5;
    public static final byte EXPORT_WORD = 6;
    public static final byte EXPORT_WORD_PAGE = 7;
    public static final byte EXPORT_TEXT = 8;
    public static final byte EXPORT_XML = 9;
    public static final byte EXPORT_HTML = 10;
    public static final byte EXPORT_PDF_ANAMORPHIC = 11;
    public static final byte EXPORT_PDF_PAGE_ANAMORPHIC = 12;
    private String _$1;
    private byte _$2;

    public ReportExporter(String string, byte by) {
        this._$1 = string;
        this._$2 = by;
    }

    private Object _$1(Object object, IReport iReport, OutputStream outputStream, boolean bl, String string) throws Throwable {
        switch (this._$2) {
            case 1: 
            case 2: 
            case 3: {
                if (object == null) {
                    object = new ExcelReport();
                }
                ExcelReport excelReport = (ExcelReport)object;
                if (this._$2 == 2) {
                    PageBuilder pageBuilder = new PageBuilder(iReport);
                    excelReport.setDispRatio(iReport.getDispRatio());
                    excelReport.resetExport();
                    ExportConfig exportConfig = iReport.getExportConfig();
                    if (exportConfig != null) {
                        excelReport.setFilePassword(PwdUtils.decrypt(exportConfig.getExcelFilePassword()));
                        excelReport.setHiddenRowExported(exportConfig.getExcelHiddenRowExported());
                        excelReport.setHiddenColExported(exportConfig.getExcelHiddenColExported());
                    }
                    excelReport.export(string, pageBuilder);
                } else {
                    excelReport.export(string, iReport);
                    if (this._$2 == 3) {
                        excelReport.setFomulaExported(true);
                    }
                }
                if (!bl) break;
                excelReport.saveTo(outputStream);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                if (object == null) {
                    object = new PdfReport(outputStream);
                }
                PdfReport pdfReport = (PdfReport)object;
                pdfReport.setAnamorphic(this._$2 == 11 || this._$2 == 12);
                if (this._$2 == 5 || this._$2 == 12) {
                    PageBuilder pageBuilder = new PageBuilder(iReport);
                    pdfReport.resetExport();
                    ExportConfig exportConfig = iReport.getExportConfig();
                    if (exportConfig != null) {
                        pdfReport.setOwnerPassword(PwdUtils.decrypt(exportConfig.getPDFOwnerPassword()));
                        pdfReport.setUserPassword(exportConfig.getPDFUserPassword());
                        pdfReport.setPrivilege(exportConfig.getPDFPrivilege());
                    }
                    pdfReport.export(pageBuilder);
                } else {
                    pdfReport.export(iReport);
                }
                if (!bl) break;
                pdfReport.save();
                break;
            }
            case 6: 
            case 7: {
                if (object == null) {
                    object = new WordReport();
                }
                WordReport wordReport = (WordReport)object;
                if (this._$2 == 7) {
                    PageBuilder pageBuilder = new PageBuilder(iReport);
                    wordReport.export(pageBuilder);
                } else {
                    wordReport.export(iReport);
                }
                if (!bl) break;
                wordReport.saveTo(outputStream);
                break;
            }
            case 9: {
                if (object == null) {
                    object = new XMLReport();
                }
                XMLReport xMLReport = (XMLReport)object;
                xMLReport.export(string, iReport);
                if (!bl) break;
                xMLReport.saveTo((FileOutputStream)outputStream);
                break;
            }
            case 10: {
                HtmlReport htmlReport = new HtmlReport(iReport, this._$1);
                String string2 = htmlReport.generateHtml();
                outputStream.write(string2.getBytes());
                break;
            }
            default: {
                String string3;
                DialogExportToTextOption dialogExportToTextOption = new DialogExportToTextOption();
                dialogExportToTextOption.show();
                if (dialogExportToTextOption.getOption() != 0) {
                    return null;
                }
                Segment segment = new Segment(dialogExportToTextOption.get());
                String string4 = segment.get(DialogExportToTextOption.EXPORTLINE);
                boolean bl2 = new Boolean(string4);
                if (bl2) {
                    TextReport textReport = new TextReport(iReport);
                    string3 = textReport.toString();
                } else {
                    string4 = segment.get(DialogExportToTextOption.DISPVALUE);
                    bl2 = new Boolean(string4);
                    string4 = segment.get(DialogExportToTextOption.SEPERATOR);
                    if (string4.equalsIgnoreCase("tab")) {
                        string4 = "\t";
                    }
                    TextFile textFile = new TextFile(iReport, string4);
                    textFile.setSaveDispValue(bl2);
                    string3 = textFile.toString();
                }
                outputStream.write(string3.getBytes());
            }
        }
        return object;
    }

    public void export(IReport iReport) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this._$1);
            this._$1(null, iReport, fileOutputStream, true, "report");
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            GM.showException(throwable);
            return;
        }
    }

    public void export(ReportGroup reportGroup, Context context) {
        GroupEngine groupEngine = new GroupEngine(reportGroup, context);
        Object object = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._$1);
            int n = 0;
            while (n < groupEngine.count()) {
                IReport iReport = groupEngine.get(n);
                String string = groupEngine.getTitle(n);
                if (!GM.isValidString(string)) {
                    string = "report" + n;
                }
                object = this._$1(object, iReport, fileOutputStream, n == groupEngine.count() - 1, string);
                ++n;
            }
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            GM.showException(throwable);
            return;
        }
    }
}

