/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.dataset.IDataSetFactory;
import com.runqian.report4.model.IDESession;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.Macro;
import com.runqian.report4.usermodel.MacroMetaData;
import com.runqian.report4.usermodel.Param;
import com.runqian.report4.usermodel.ParamMetaData;
import com.runqian.report4.usermodel.Types;
import com.runqian.report4.util.MacroResolver2;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class CalcReport {
    public static final byte REPORT_LINEAR = 0;
    public static final byte REPORT_NONE_DATASET = 1;
    public static final byte REPORT_MORE_DATASET = 2;
    public static final byte REPORT_LAYER_CO = 3;
    public static final byte REPORT_LINE_CO = 4;
    public static final byte REPORT_PLANE_CO = 5;
    public static final byte REPORT_MORE_UPDATE = 6;
    public static final byte REPORT_DELAY_FUN = 7;
    public static final byte REPORT_SPECIAL_GROUP = 8;
    public static final byte REPORT_SEMANTICS = 9;
    public static final byte REPORT_ADDED_DS = 10;
    public static final byte SIGNED = 0;
    public static final byte NOT_SIGNED = 1;
    public static final byte SIGNED_MODIFIED = 2;
    private static MessageManager _$1 = EngineMessage.get();

    public static void calcAttribute(IReport iReport, Context context) throws Exception {
        ParamMetaData paramMetaData = iReport.getParamMetaData();
        CalcReport.calcAttribute(paramMetaData, context);
    }

    public static void calcAttribute(ParamMetaData paramMetaData, Context context) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        HttpSession httpSession = context.getHttpSession();
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 2) {
                String string = param.getParamName();
                Map map = context.getParamMap(true);
                if (httpSession != null) {
                    map.put(string, httpSession.getAttribute(string));
                } else {
                    IDESession iDESession = IDESession.getInstance();
                    if (iDESession != null) {
                        map.put(string, iDESession.getAttribute(string));
                    } else {
                        map.put(string, null);
                    }
                }
            }
            ++n2;
        }
    }

    public static void calcAttribute(ParamMetaData paramMetaData, Context context, boolean bl) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        HttpSession httpSession = context.getHttpSession();
        Map map = context.getParamMap(true);
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 2 && (bl || context.getParamValue(param.getParamName()) == null)) {
                String string = param.getParamName();
                if (httpSession != null) {
                    map.put(string, httpSession.getAttribute(string));
                } else {
                    IDESession iDESession = IDESession.getInstance();
                    if (iDESession != null) {
                        map.put(string, iDESession.getAttribute(string));
                    } else {
                        map.put(string, null);
                    }
                }
            }
            ++n2;
        }
    }

    public static void calcDataSet(IReport iReport, Context context, boolean bl) {
        int n;
        DataSetMetaData dataSetMetaData = iReport.getDataSetMetaData();
        if (dataSetMetaData != null && (n = dataSetMetaData.getDataSetConfigCount()) > 0) {
            Map map = context.getDataSetMap(true);
            int n2 = 0;
            while (n2 < n) {
                String string;
                DataSetConfig dataSetConfig = dataSetMetaData.getDataSetConfig(n2);
                if (dataSetConfig != null && !map.containsKey(string = dataSetConfig.getName())) {
                    Object object;
                    String string2 = dataSetConfig.getFactoryClass();
                    try {
                        IDataSetFactory iDataSetFactory = (IDataSetFactory)Class.forName(string2).newInstance();
                        object = iDataSetFactory.createDataSet(context, dataSetConfig, bl);
                        map.put(string, object);
                    }
                    catch (Exception exception) {
                        object = EngineMessage.get();
                        Logger.error(String.valueOf(((MessageManager)object).getMessage("Engine.createDataFactory")) + string2 + ((MessageManager)object).getMessage("Engine.failure"), exception);
                        throw new ReportError(String.valueOf(((MessageManager)object).getMessage("Engine.createDataFactory")) + string2 + ((MessageManager)object).getMessage("Engine.failure"), exception);
                    }
                }
                ++n2;
            }
        }
    }

    public static void calcDynamicMacro(IReport iReport, Context context) {
        MacroMetaData macroMetaData = iReport.getMacroMetaData();
        CalcReport.calcDynamicMacro(macroMetaData, context);
    }

    public static void calcDynamicMacro(MacroMetaData macroMetaData, Context context) {
        int n;
        if (macroMetaData != null && (n = macroMetaData.getMacroCount()) > 0) {
            Map map = context.getMacroMap(true);
            int n2 = 0;
            while (n2 < n) {
                Macro macro = macroMetaData.getMacro(n2);
                if (macro.getType() == 1) {
                    String string = MacroResolver2.replaceMacros(macro.getMacroValue(), context);
                    String string2 = macro.getMacroName();
                    Object object = new Expression(context, string).calculate(context, false);
                    if (object == null) {
                        map.remove(string2);
                    } else {
                        object = Variant2.getValue(object, false, false);
                        map.put(string2, Variant2.toString(object));
                    }
                }
                ++n2;
            }
        }
    }

    public static void calcDynamicMacro(MacroMetaData macroMetaData, Context context, boolean bl) {
        int n;
        if (macroMetaData != null && (n = macroMetaData.getMacroCount()) > 0) {
            Map map = context.getMacroMap(true);
            int n2 = 0;
            while (n2 < n) {
                Macro macro = macroMetaData.getMacro(n2);
                if (macro.getType() == 1 && (bl || context.getMacroValue(macro.getMacroName()) == null)) {
                    String string = MacroResolver2.replaceMacros(macro.getMacroValue(), context);
                    String string2 = macro.getMacroName();
                    Object object = new Expression(context, string).calculate(context, false);
                    if (object == null) {
                        map.remove(string2);
                    } else {
                        object = Variant2.getValue(object, false, false);
                        map.put(string2, Variant2.toString(object));
                    }
                }
                ++n2;
            }
        }
    }

    public static void calcDynamicParam(IReport iReport, Context context) throws Exception {
        ParamMetaData paramMetaData = iReport.getParamMetaData();
        CalcReport.calcDynamicParam(paramMetaData, context);
    }

    public static void calcDynamicParam(ParamMetaData paramMetaData, Context context) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 1) {
                Map map = context.getParamMap(true);
                String string = MacroResolver2.replaceMacros(param.getValue(), context);
                String string2 = param.getParamName();
                Object object = new Expression(context, string).calculate(context, false);
                if ((object = Variant2.getValue(object, false, false)) == null) {
                    map.put(string2, null);
                } else {
                    map.put(string2, Types.getProperData(param.getDataType(), Variant2.toString(object)));
                }
            }
            ++n2;
        }
    }

    public static void calcDynamicParam(ParamMetaData paramMetaData, Context context, boolean bl) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        Map map = context.getParamMap(true);
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 1 && (bl || context.getParamValue(param.getParamName()) == null)) {
                String string = MacroResolver2.replaceMacros(param.getValue(), context);
                String string2 = param.getParamName();
                Object object = new Expression(context, string).calculate(context, false);
                if ((object = Variant2.getValue(object, false, false)) == null) {
                    map.put(string2, null);
                } else {
                    map.put(string2, Types.getProperData(param.getDataType(), Variant2.toString(object)));
                }
            }
            ++n2;
        }
    }

    public static void calcStaticMacro(IReport iReport, Context context) {
        MacroMetaData macroMetaData = iReport.getMacroMetaData();
        CalcReport.calcStaticMacro(macroMetaData, context);
    }

    public static void calcStaticMacro(MacroMetaData macroMetaData, Context context) {
        if (macroMetaData == null) {
            return;
        }
        int n = macroMetaData.getMacroCount();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Macro macro = macroMetaData.getMacro(n2);
            if (macro.getType() == 0) {
                Map map = context.getMacroMap(true);
                map.put(macro.getMacroName(), macro.getMacroValue());
            }
            ++n2;
        }
    }

    public static void calcStaticMacro(MacroMetaData macroMetaData, Context context, boolean bl) {
        if (macroMetaData == null) {
            return;
        }
        int n = macroMetaData.getMacroCount();
        if (n <= 0) {
            return;
        }
        Map map = context.getMacroMap(true);
        int n2 = 0;
        while (n2 < n) {
            Macro macro = macroMetaData.getMacro(n2);
            if (macro.getType() == 0 && (bl || context.getMacroValue(macro.getMacroName()) == null)) {
                map.put(macro.getMacroName(), macro.getMacroValue());
            }
            ++n2;
        }
    }

    public static void calcStaticParam(IReport iReport, Context context) throws Exception {
        ParamMetaData paramMetaData = iReport.getParamMetaData();
        CalcReport.calcStaticParam(paramMetaData, context);
    }

    public static void calcStaticParam(ParamMetaData paramMetaData, Context context) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 0) {
                Map map = context.getParamMap(true);
                map.put(param.getParamName(), Types.getProperData(param.getDataType(), param.getValue()));
            }
            ++n2;
        }
    }

    public static void calcStaticParam(ParamMetaData paramMetaData, Context context, boolean bl) throws Exception {
        if (paramMetaData == null) {
            return;
        }
        int n = paramMetaData.getParamCount();
        if (n <= 0) {
            return;
        }
        Map map = context.getParamMap(true);
        int n2 = 0;
        while (n2 < n) {
            Param param = paramMetaData.getParam(n2);
            if (param.getParamType() == 0 && (bl || context.getParamValue(param.getParamName()) == null)) {
                map.put(param.getParamName(), Types.getProperData(param.getDataType(), param.getValue()));
            }
            ++n2;
        }
    }

    public static boolean checkNonlinear(byte by) {
        return by > 1;
    }

    public static byte getNonlinear(IReport iReport, Context context) throws Exception {
        CalcReport.calcStaticParam(iReport, context);
        CalcReport.calcStaticMacro(iReport, context);
        CalcReport.calcDynamicParam(iReport, context);
        CalcReport.calcDynamicMacro(iReport, context);
        CalcReport.calcAttribute(iReport, context);
        CalcReport.calcDataSet(iReport, context, false);
        byte by = iReport.getReportType();
        if (by == 0) {
            ExtCellSet extCellSet = new ExtCellSet(iReport);
            extCellSet.prepareCalculate(context, false);
            return extCellSet.getNonlinear();
        }
        if (by == 1) {
            RowReport rowReport = new RowReport(iReport);
            rowReport.prepareCalculate(context, false);
            return rowReport.getNonlinear();
        }
        return 0;
    }

    public static String getNonlinearCause(byte by) {
        EngineMessage.get();
        if (by == 2) {
            return _$1.getMessage("Nonlinear.moreDataSet");
        }
        if (by == 3) {
            return _$1.getMessage("Nonlinear.layerCo");
        }
        if (by == 4) {
            return _$1.getMessage("Nonlinear.lineCo");
        }
        if (by == 5) {
            return _$1.getMessage("Nonlinear.planeCo");
        }
        if (by == 6) {
            return _$1.getMessage("Nonlinear.moreUpdate");
        }
        if (by == 7) {
            return _$1.getMessage("Nonlinear.isDelayFun");
        }
        if (by == 8) {
            return _$1.getMessage("Nonlinear.specialGroup");
        }
        if (by == 9) {
            return _$1.getMessage("Nonlinear.semantics");
        }
        if (by == 10) {
            return _$1.getMessage("Nonlinear.addedDS");
        }
        return _$1.getMessage("Nonlinear.linear");
    }

    public static byte getSigned(IReport iReport) throws Exception {
        byte[] byArray = iReport.getCipherHash();
        if (byArray == null) {
            return 1;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != 0) {
                if (iReport.isSigned()) {
                    return 0;
                }
                return 2;
            }
            ++n2;
        }
        return 1;
    }

    public static String getSignedMessage(byte by) {
        EngineMessage.get();
        if (by == 1) {
            return _$1.getMessage("Signed.NotSigned");
        }
        if (by == 2) {
            return _$1.getMessage("Signed.ModifiedSigned");
        }
        return _$1.getMessage("Signed.Signed");
    }

    public static void prepareCalculate(IReport iReport, Context context) {
        try {
            CalcReport.calcAttribute(iReport, context);
            CalcReport.calcStaticParam(iReport.getParamMetaData(), context, false);
            CalcReport.calcStaticMacro(iReport.getMacroMetaData(), context, false);
            CalcReport.calcDynamicParam(iReport, context);
            CalcReport.calcDynamicMacro(iReport, context);
            return;
        }
        catch (Exception exception) {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError(String.valueOf(messageManager.getMessage("Engine.calcParam")) + exception);
        }
    }
}

