/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model;

import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.StringUtils;
import com.runqian.report4.model.Sheet;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.IColCell;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IRowCell;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;

public abstract class Pager {
    protected IReport report;
    protected Sheet pages;
    protected int pageWidth;
    protected int pageHeight;

    public Pager(IReport iReport) {
        this.report = iReport;
        this.pages = new Sheet();
    }

    public void clear() {
        this.pages.clear();
    }

    public abstract void createPages() throws Exception;

    public int getColumns() {
        return 1;
    }

    protected static Font getFont(INormalCell iNormalCell) {
        int n = 0;
        if (iNormalCell.isBold()) {
            ++n;
        }
        if (iNormalCell.isItalic()) {
            n += 2;
        }
        return new Font(iNormalCell.getFontName(), n, iNormalCell.getFontSize());
    }

    public static int getMergedHeight(IReport iReport, INormalCell iNormalCell, boolean bl, float f, byte by) {
        float f2 = 0.0f;
        Area area = iNormalCell.getMergedArea();
        int n = area.getBeginRow();
        int n2 = area.getEndRow();
        if (!iNormalCell.isMerged()) {
            IRowCell iRowCell = iReport.getRowCell(n);
            f2 = iRowCell.getRowHeight();
            if (iRowCell.getRowVisible()) {
                return (int)Math.ceil(Pager.unitTransfer(f2, by) * f);
            }
            return 0;
        }
        int n3 = n;
        while (n3 <= n2) {
            IRowCell iRowCell = iReport.getRowCell(n3);
            float f3 = iRowCell.getRowHeight();
            if (bl) {
                f2 += f3;
            } else if (iRowCell.getRowVisible()) {
                f2 += f3;
            }
            ++n3;
        }
        return (int)Math.ceil(Pager.unitTransfer(f2, by) * f);
    }

    public static int getMergedWidth(IReport iReport, INormalCell iNormalCell, boolean bl, float f, byte by) {
        float f2 = 0.0f;
        Area area = iNormalCell.getMergedArea();
        int n = area.getBeginCol();
        short s = area.getEndCol();
        if (!iNormalCell.isMerged()) {
            IColCell iColCell = iReport.getColCell((short)n);
            f2 = iColCell.getColWidth();
            if (iColCell.getColVisible()) {
                return (int)Math.ceil(Pager.unitTransfer(f2, by) * f);
            }
            return 0;
        }
        int n2 = n;
        while (n2 <= s) {
            IColCell iColCell = iReport.getColCell((short)n2);
            float f3 = iColCell.getColWidth();
            if (bl) {
                f2 += f3;
            } else if (iColCell.getColVisible()) {
                f2 += f3;
            }
            ++n2;
        }
        return (int)Math.ceil(Pager.unitTransfer(f2, by) * f);
    }

    public abstract IReport getPage(int var1, int var2, int var3, int var4) throws Exception;

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public Sheet getPagesSheet() {
        return this.pages;
    }

    public static int getReportHeight(IReport iReport, byte by, float f) {
        int n = 0;
        int n2 = iReport.getRowCount();
        int n3 = 1;
        while (n3 <= n2) {
            IRowCell iRowCell = iReport.getRowCell(n3);
            if (iRowCell.getRowVisible()) {
                n += (int)Pager.unitTransfer((float)((int)Math.ceil(iRowCell.getRowHeight())) * f, by);
            }
            ++n3;
        }
        return n;
    }

    public static int getReportWidth(IReport iReport, byte by, float f) {
        int n = 0;
        int n2 = iReport.getColCount();
        int n3 = 1;
        while (n3 <= n2) {
            IColCell iColCell = iReport.getColCell((short)n3);
            if (iColCell.getColVisible()) {
                n += (int)Math.ceil(Pager.unitTransfer(iColCell.getColWidth(), by) * f);
            }
            ++n3;
        }
        return n;
    }

    public int getXPageCount() {
        return this.pages.getColSize();
    }

    public int getYPageCount() {
        return this.pages.getRowSize();
    }

    public void interrupt() {
    }

    public void setColumns(int n) {
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public static float unUnitTransfer(float f, byte by) {
        if (by == 2) {
            f /= 72.0f;
        } else if (by == 1) {
            f = f * 25.4f / 72.0f;
        }
        return f;
    }

    public static float unitTransfer(float f, byte by) {
        if (by == 2) {
            f *= 72.0f;
        } else if (by == 1) {
            f = f * 72.0f / 25.4f;
        }
        return f;
    }

    public static ArrayList wrapString(String string, FontMetrics fontMetrics, int n) {
        n -= 5;
        ArrayList<String> arrayList = new ArrayList<String>();
        string = StringUtils.replace(string, "\\n", "\n");
        ArgumentTokenizer argumentTokenizer = new ArgumentTokenizer(string, '\n', true, true, true);
        while (argumentTokenizer.hasNext()) {
            String string2 = argumentTokenizer.next();
            if (argumentTokenizer.hasNext()) {
                string2 = String.valueOf(string2) + "\n";
            }
            int n2 = string2.length();
            String string3 = "";
            int n3 = 0;
            while (n3 < n2) {
                char c = string2.charAt(n3);
                if (fontMetrics.stringWidth(string3 = String.valueOf(string3) + String.valueOf(c)) > n) {
                    arrayList.add(string3.substring(0, string3.length() - 1));
                    string3 = String.valueOf(c);
                }
                ++n3;
            }
            arrayList.add(string3);
        }
        return arrayList;
    }
}

