/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.SemanticExpression;
import com.runqian.report4.semantics.Association;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.ParamList;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.input.DDListBox;
import com.runqian.report4.usermodel.input.DDViewDataWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class SemanticCell {
    private static final int MASK_DESC = 3;
    private static final int MASK_EXTEND = 24579;
    private static final int MASK_FIELD = 895;
    private static final int MASK_HAVEVIEW = Short.MAX_VALUE;
    private static final int MASK_NULLGROUP = 24576;
    private static final int MASK_TERM = 8187;
    private static final int OPT_AVG = 16;
    private static final int OPT_COUNT = 128;
    private static final int OPT_DISPLAY = 32768;
    private static final int OPT_DISTINCT = 256;
    private static final int OPT_ENUMGROUP = 8192;
    private static final int OPT_FILTER = 2048;
    private static final int OPT_FILTERCROSS = 4096;
    private static final int OPT_FILTERONE = 1024;
    private static final int OPT_GROUP = 1;
    private static final int OPT_MAX = 32;
    private static final int OPT_MIN = 64;
    private static final int OPT_OVERLAPGROUP = 16384;
    private static final int OPT_SELECT = 2;
    private static final int OPT_SELECTONE = 512;
    private static final int OPT_SUM = 8;
    private static final int OPT_VALUE = 4;
    private INormalCell leftHead;
    private Map relation = null;
    private byte seExtend = 0;
    private Object seFieldInfo = null;
    private int seOperate = 0;
    private View seView = null;
    private static Object testInfo;
    private INormalCell topHead;

    SemanticCell() {
    }

    void addDataSetExp(INormalCell cell, View v, String relExp, byte filter1) {
        if (this.relation != null && this.relation.containsKey(v)) {
            return;
        }
        if (this.relation == null) {
            this.relation = new HashMap();
        }
        this.relation.put(v, null);
        String opt = Association.getFilterOP(filter1);
        String[] addDs = cell.getAdditionalDataSetExps();
        int len = 0;
        if (addDs == null) {
            addDs = new String[1];
        } else {
            len = addDs.length;
            String[] add = new String[len + 1];
            int i = 0;
            while (i < len) {
                add[i] = addDs[i];
                ++i;
            }
            addDs = add;
        }
        addDs[len] = "=" + opt + ";" + v.getViewName() + ";" + relExp;
        cell.setAdditionalDataSetExps(addDs);
    }

    static void analysisExp(String exp, ViewList vl, ParamList pl, EditStyleList styleList, Map dsMap, Map paramMap) {
        ArgumentTokenizer at = new ArgumentTokenizer(exp, ';');
        if (!at.hasNext()) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingOption"));
        }
        String operate = at.next().trim();
        int opt = SemanticCell.getType(operate);
        if ((Short.MAX_VALUE & opt) != 0) {
            View ds = null;
            if (at.hasNext()) {
                ds = vl.getView(at.next().trim());
            }
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("Expression.missingDataSet") + opt);
            }
            if (dsMap != null && !dsMap.containsKey(ds)) {
                dsMap.put(ds, new HashMap());
            }
            String param = null;
            if ((opt & 0x37F) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingField") + opt);
                }
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                if ((opt & 3) != 0 && at.hasNext()) {
                    param = at.next().trim();
                    SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                }
            } else if ((opt & 0x6000) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingNullGroup"));
                }
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                if (at.hasNext()) {
                    param = at.next().trim();
                    SemanticExpression.setParameter(param, ds, vl, pl, dsMap, paramMap);
                }
            }
            if ((opt & 0x1FFB) != 0 && at.hasNext()) {
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
            }
        } else if (opt == 32768) {
            boolean transfer = false;
            if (at.hasNext()) {
                String styleName = at.next();
                EditStyle style = null;
                if (styleName != null && styleName.length() > 0) {
                    style = styleList.get(styleName);
                }
                if (style != null) {
                    String name;
                    View ds;
                    Object config = style.getEditConfig();
                    if (config instanceof DDListBox) {
                        transfer = true;
                    } else if (config instanceof DDViewDataWindow && (ds = vl.getView(name = ((DDViewDataWindow)config).getViewName())) != null) {
                        String desc;
                        int i;
                        int isize;
                        if (dsMap != null && !dsMap.containsKey(ds)) {
                            dsMap.put(ds, new HashMap());
                        }
                        SemanticCell.parseExp(((DDViewDataWindow)config).getCodeColName(), ds, vl, pl, dsMap, paramMap);
                        SemanticCell.parseExp(((DDViewDataWindow)config).getDispColName(), ds, vl, pl, dsMap, paramMap);
                        SemanticCell.parseExp(((DDViewDataWindow)config).getDsFilter(), ds, vl, pl, dsMap, paramMap);
                        ArrayList l = ((DDViewDataWindow)config).getSortDescList();
                        if (l != null && l.size() > 0) {
                            isize = l.size();
                            i = 0;
                            while (i < isize) {
                                desc = (String)l.get(i);
                                SemanticCell.parseExp(desc, ds, vl, pl, dsMap, paramMap);
                                ++i;
                            }
                        }
                        if ((l = ((DDViewDataWindow)config).getSortExpList()) != null && l.size() > 0) {
                            isize = l.size();
                            i = 0;
                            while (i < isize) {
                                desc = (String)l.get(i);
                                SemanticCell.parseExp(desc, ds, vl, pl, dsMap, paramMap);
                                ++i;
                            }
                        }
                        transfer = true;
                    }
                }
                if (!transfer) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.exp") + exp);
                }
            }
        }
    }

    boolean analysisValueExp(String exp, ViewList vl, ParamList pl, EditStyleList styleList, Map dsMap, Map paramMap) {
        int opt;
        ArgumentTokenizer at = new ArgumentTokenizer(exp, ';');
        if (!at.hasNext()) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingOption"));
        }
        String operate = at.next().trim();
        this.seOperate = opt = SemanticCell.getType(operate);
        if ((Short.MAX_VALUE & opt) != 0) {
            View ds = null;
            if (at.hasNext()) {
                ds = vl.getView(at.next().trim());
            }
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("Expression.missingDataSet") + opt);
            }
            if (dsMap != null && !dsMap.containsKey(ds)) {
                dsMap.put(ds, new HashMap());
            }
            this.seView = ds;
            String param = null;
            if ((opt & 0x37F) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingField") + opt);
                }
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                this.seFieldInfo = this.seView.getColInfo(param);
                if (this.seFieldInfo == null) {
                    this.seFieldInfo = this.seView.getColInfoByColName(param);
                }
                if (this.seFieldInfo == null) {
                    this.seFieldInfo = this.seView.getComputedColInfo(param);
                }
                if ((opt & 3) != 0 && at.hasNext()) {
                    param = at.next().trim();
                    SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                }
            } else if ((opt & 0x6000) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingNullGroup"));
                }
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
                testInfo = null;
                if (at.hasNext()) {
                    param = at.next().trim();
                    SemanticExpression.setParameter(param, ds, vl, pl, dsMap, paramMap, true);
                    testInfo = SemanticExpression.getTempInfo();
                }
                if (testInfo != null) {
                    this.seFieldInfo = testInfo;
                }
            }
            if ((opt & 0x1FFB) != 0 && at.hasNext()) {
                param = at.next().trim();
                SemanticCell.parseExp(param, ds, vl, pl, dsMap, paramMap);
            }
        } else if (opt == 32768) {
            boolean transfer = false;
            if (at.hasNext()) {
                String styleName = at.next();
                EditStyle style = null;
                if (styleName != null && styleName.length() > 0) {
                    style = styleList.get(styleName);
                }
                if (style != null) {
                    String name;
                    View ds;
                    Object config = style.getEditConfig();
                    if (config instanceof DDListBox) {
                        transfer = true;
                    } else if (config instanceof DDViewDataWindow && (ds = vl.getView(name = ((DDViewDataWindow)config).getViewName())) != null) {
                        String desc;
                        int i;
                        int isize;
                        if (dsMap != null && !dsMap.containsKey(ds)) {
                            dsMap.put(ds, new HashMap());
                        }
                        SemanticCell.parseExp(((DDViewDataWindow)config).getCodeColName(), ds, vl, pl, dsMap, paramMap);
                        SemanticCell.parseExp(((DDViewDataWindow)config).getDispColName(), ds, vl, pl, dsMap, paramMap);
                        SemanticCell.parseExp(((DDViewDataWindow)config).getDsFilter(), ds, vl, pl, dsMap, paramMap);
                        ArrayList l = ((DDViewDataWindow)config).getSortDescList();
                        if (l != null && l.size() > 0) {
                            isize = l.size();
                            i = 0;
                            while (i < isize) {
                                desc = (String)l.get(i);
                                SemanticCell.parseExp(desc, ds, vl, pl, dsMap, paramMap);
                                ++i;
                            }
                        }
                        if ((l = ((DDViewDataWindow)config).getSortExpList()) != null && l.size() > 0) {
                            isize = l.size();
                            i = 0;
                            while (i < isize) {
                                desc = (String)l.get(i);
                                SemanticCell.parseExp(desc, ds, vl, pl, dsMap, paramMap);
                                ++i;
                            }
                        }
                        transfer = true;
                    }
                }
                if (!transfer) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.exp") + exp);
                }
            }
        }
        if ((this.seOperate & 0x6003) != 0) {
            if (16 == this.seExtend) {
                this.seExtend = this.leftHead == null && this.topHead != null ? (byte)19 : (this.leftHead != null && this.topHead != null ? (byte)17 : (byte)18);
            }
        } else if (16 == this.seExtend) {
            this.seExtend = (byte)17;
        }
        return true;
    }

    byte getExtend() {
        return this.seExtend;
    }

    Object getFieldInfo() {
        return this.seFieldInfo;
    }

    INormalCell getLeftHead() {
        return this.leftHead;
    }

    Map getRelation() {
        return this.relation;
    }

    INormalCell getTopHead() {
        return this.topHead;
    }

    static int getType(String str) {
        if ("\u5206\u7ec4".equals(str) || "Group".equals(str)) {
            return 1;
        }
        if ("\u5217\u8868".equals(str) || "Select".equals(str)) {
            return 2;
        }
        if ("\u53d6\u503c".equals(str) || "Value".equals(str)) {
            return 4;
        }
        if ("\u8ba1\u6570".equals(str) || "Count".equals(str)) {
            return 128;
        }
        if ("\u6c42\u548c".equals(str) || "Sum".equals(str)) {
            return 8;
        }
        if ("\u5e73\u5747".equals(str) || "Avg".equals(str)) {
            return 16;
        }
        if ("\u6700\u5927".equals(str) || "Max".equals(str)) {
            return 32;
        }
        if ("\u6700\u5c0f".equals(str) || "Min".equals(str)) {
            return 64;
        }
        if ("\u5355\u9009".equals(str) || "SelectOne".equals(str)) {
            return 512;
        }
        if ("\u4e00\u5bf9\u4e00".equals(str) || "FilterOne".equals(str)) {
            return 1024;
        }
        if ("\u4e00\u5bf9\u591a".equals(str) || "Filter".equals(str)) {
            return 2048;
        }
        if ("\u591a\u5bf9\u591a".equals(str) || "FilterCross".equals(str)) {
            return 4096;
        }
        if ("\u679a\u4e3e".equals(str) || "EnumGroup".equals(str)) {
            return 8192;
        }
        if ("\u663e\u793a".equals(str) || "Display".equals(str)) {
            return 32768;
        }
        if ("\u5355\u8ba1".equals(str) || "CountDistinct".equals(str)) {
            return 256;
        }
        if ("\u53e0\u4e3e".equals(str) || "EnumGroupOverlap".equals(str)) {
            return 16384;
        }
        MessageManager mm = EngineMessage.get();
        throw new ReportError(mm.getMessage("Expression.unknownOption") + str);
    }

    View getView() {
        return this.seView;
    }

    static void parseExp(String exp, View v, ViewList vl, ParamList pl, Map dsMap, Map paramMap) {
        new SemanticExpression(exp, v, vl, pl, dsMap, paramMap);
    }

    static int scanId(String exp, int start) {
        int len = exp.length();
        int end = start;
        while (end < len) {
            char c = exp.charAt(end);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == ',' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') {
                return end;
            }
            ++end;
        }
        return len;
    }

    void setExtend(byte mode) {
        this.seExtend = mode;
    }

    void setLeftHead(INormalCell cell) {
        this.leftHead = cell;
    }

    void setTopHead(INormalCell cell) {
        this.topHead = cell;
    }
}

