/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.ReportError;
import com.runqian.base4.util.Sentence;
import com.runqian.report4.semantics.ColInfo;
import com.runqian.report4.semantics.ComputedColInfo;
import com.runqian.report4.semantics.ParamList;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import java.util.HashMap;
import java.util.Map;

class SemanticExpression {
    private static final byte NONE = 0;
    private static final byte OPT_DSMEMBER = 3;
    private static final byte OPT_NONE = 1;
    private static final byte OPT_OPERATOR = 2;
    private static Object colInfo;
    private Map dsMap;
    private String expStr;
    private int location;
    private Map paramMap;
    private ParamList pl;
    private byte preNode = 0;
    private ViewList vl;

    public SemanticExpression(String exp, View dsName, ViewList vl, ParamList pl, Map dsMap, Map paramMap, Object ci) {
        this.vl = vl;
        this.pl = pl;
        this.dsMap = dsMap;
        this.paramMap = paramMap;
        this.expStr = exp;
        this.location = 0;
        colInfo = ci;
        if (exp != null) {
            this.create(dsName);
        }
    }

    public SemanticExpression(String exp, View dsName, ViewList vl, ParamList pl, Map dsMap, Map paramMap) {
        this.vl = vl;
        this.pl = pl;
        this.dsMap = dsMap;
        this.paramMap = paramMap;
        this.expStr = exp;
        this.location = 0;
        if (exp != null) {
            this.create(dsName);
        }
    }

    private void create(View ds) {
        int len = this.expStr.length();
        int inBrackets = 0;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                continue;
            }
            switch (c) {
                case '(': {
                    ++inBrackets;
                    ++this.location;
                    break;
                }
                case ')': {
                    if (--inBrackets < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
                    }
                    ++this.location;
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': {
                    this.preNode = (byte)2;
                    ++this.location;
                    break;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        ++this.location;
                    }
                    this.preNode = (byte)2;
                    break;
                }
                case '&': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '&') {
                        ++this.location;
                    }
                    this.preNode = (byte)2;
                    break;
                }
                case '|': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '|') {
                        ++this.location;
                    }
                    this.preNode = (byte)2;
                    break;
                }
                case '.': {
                    if (this.preNode == 1 || (this.preNode & 2) == 2) {
                        this.preNode = this.createNode(ds);
                        break;
                    }
                    this.preNode = (byte)3;
                    ++this.location;
                    break;
                }
                default: {
                    this.preNode = this.createNode(ds);
                }
            }
        }
        if (inBrackets > 0) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
        }
    }

    private byte createDSNode(String id, View ds) {
        String name = ds.getViewName();
        if (this.isNextBracket()) {
            SemanticExpression.setParameter(this.scanParameter(), ds, this.vl, this.pl, this.dsMap, this.paramMap);
            return 1;
        }
        if (ds != null) {
            ComputedColInfo info1 = ds.getComputedColInfo(id);
            if (info1 != null) {
                Map map;
                colInfo = info1;
                if (this.dsMap != null && (map = (Map)this.dsMap.get(ds)) != null) {
                    map.put(info1, null);
                    new SemanticExpression(info1.getColExp(), ds, this.vl, this.pl, this.dsMap, this.paramMap);
                }
                return 1;
            }
            ColInfo info2 = ds.getColInfo(id);
            if (info2 == null) {
                info2 = ds.getColInfoByColName(id);
            }
            if (info2 != null) {
                Map map;
                colInfo = info2;
                if (this.dsMap != null && (map = (Map)this.dsMap.get(ds)) != null) {
                    map.put(info2, null);
                }
                return 1;
            }
        }
        return 0;
    }

    private byte createNode(View ds) {
        byte node;
        String dsTmp;
        View v;
        char c = this.expStr.charAt(this.location);
        int match = -1;
        if (c == '\"' || c == '\'') {
            match = Sentence.scanQuotation(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("\",'Expression.illmacthed"));
            }
            this.location = match + 1;
            return 1;
        }
        if (c == '{') {
            match = Sentence.scanBrace(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("{,}Expression.illmacthed"));
            }
            SemanticExpression.setParameter(this.expStr.substring(this.location + 1, match), ds, this.vl, this.pl, this.dsMap, this.paramMap);
            this.location = match + 1;
            return 1;
        }
        if (c == '[') {
            match = Sentence.scanBracket(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("[,]Expression.illmacthed"));
            }
            SemanticExpression.setParameter(this.expStr.substring(this.location + 1, match), ds, this.vl, this.pl, this.dsMap, this.paramMap);
            this.location = match + 1;
            return 1;
        }
        String id = this.scanId();
        int index = id.indexOf(46);
        if (index > 0 && !Character.isDigit(id.charAt(0)) && (v = this.vl.getView(dsTmp = id.substring(0, index))) != null) {
            byte node2;
            id = id.substring(index + 1);
            if (this.dsMap != null && !this.dsMap.containsKey(v)) {
                this.dsMap.put(v, new HashMap());
            }
            if ((node2 = this.createDSNode(id, v)) != 0) {
                return node2;
            }
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.unknownDataSet") + id);
        }
        if (ds != null && (node = this.createDSNode(id, ds)) != 0) {
            return 1;
        }
        if (this.preNode == 3 && (node = this.createDSNode(id, null)) != 0) {
            return 1;
        }
        if (this.isNextBracket()) {
            SemanticExpression.setParameter(this.scanParameter(), ds, this.vl, this.pl, this.dsMap, this.paramMap);
            return 1;
        }
        if (c == '@') {
            id = id.substring(1);
        }
        if (id.length() > 0 && id.charAt(0) == '@') {
            id = id.substring(1);
        }
        if (this.pl.isParamName(id) && this.paramMap != null && !this.paramMap.containsKey(id)) {
            this.paramMap.put(id, null);
        }
        return 1;
    }

    public static Object getTempInfo() {
        return colInfo;
    }

    private boolean isNextBracket() {
        int i = this.location;
        int len = this.expStr.length();
        while (i < len && Character.isWhitespace(this.expStr.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        return this.expStr.charAt(i) == '(';
    }

    private String scanId() {
        int len = this.expStr.length();
        int begin = this.location;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == ',' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') break;
            ++this.location;
        }
        return this.expStr.substring(begin, this.location);
    }

    private String scanParameter() {
        char c;
        int len = this.expStr.length();
        while (this.location < len) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == len) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingParam"));
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingParam"));
        }
        int match = Sentence.scanParenthesis(this.expStr, this.location);
        if (match == -1) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
        }
        String param = this.expStr.substring(this.location + 1, match);
        this.location = match + 1;
        return param;
    }

    public static String setParameter(String paramStr, View ds, ViewList vl, ParamList pl, Map dsMap, Map paramMap, boolean b) {
        String newStr = "";
        boolean first = true;
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr == null ? null : paramStr.trim(), ',');
        Object cInfo = null;
        while (arg.hasMoreElements()) {
            if (!first) {
                newStr = newStr + ",";
            }
            String token = arg.nextToken().trim();
            if (token.length() > 0) {
                if (first) {
                    new SemanticExpression(token, ds, vl, pl, dsMap, paramMap, null);
                    cInfo = colInfo;
                    first = false;
                    continue;
                }
                new SemanticExpression(token, ds, vl, pl, dsMap, paramMap, cInfo);
                Object ci = colInfo;
                if (cInfo != null && ci == cInfo) continue;
                cInfo = null;
                continue;
            }
            first = false;
        }
        return newStr;
    }

    public static String setParameter(String paramStr, View ds, ViewList vl, ParamList pl, Map dsMap, Map paramMap) {
        String newStr = "";
        boolean first = true;
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr == null ? null : paramStr.trim(), ',');
        while (arg.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                newStr = newStr + ",";
            }
            String token = arg.nextToken().trim();
            if (token.length() <= 0) continue;
            new SemanticExpression(token, ds, vl, pl, dsMap, paramMap);
        }
        return newStr;
    }
}

