/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.base4.util.Queue;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.CellLocation;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.RowCellEngine;
import com.runqian.report4.model.engine.lIIIllIIIIlIIlII;
import com.runqian.report4.model.engine.lllllllIllIIIlII;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IRowCell;
import com.runqian.report4.util.ByteArrayInputRecord;
import com.runqian.report4.util.ByteArrayOutputRecord;
import com.runqian.report4.util.MacroResolver2;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExtRowCell
extends ExtCell
implements IRowCell {
    private static final long serialVersionUID = 4841144127094697334L;
    protected byte rowType;
    protected byte rowVisible;
    protected byte breakPage;
    protected byte reserve = 0;
    protected int row;
    protected float rowHeight;
    protected RowCellEngine engine;

    public ExtRowCell() {
    }

    public ExtRowCell(ExtCellSet extCellSet, int n, IRowCell iRowCell) {
        this.engine = new RowCellEngine();
        this.engine.cs = extCellSet;
        this.row = n;
        this.engine.srcPrepare = iRowCell;
        this.engine.srcCurrent = this;
        this.engine.sourceRow = n;
        this.rowType = iRowCell.getRowType();
        this.setRowVisible(iRowCell.getRowVisible());
        this.setBreakPage(iRowCell.getBreakPage());
        this.rowHeight = iRowCell.getRowHeight();
        IByteMap iByteMap = iRowCell.getExpMap();
        if (iByteMap != null) {
            int n2 = iByteMap.size();
            int n3 = 0;
            while (n3 < n2) {
                byte by = iByteMap.getKey(n3);
                switch (by) {
                    case 2: {
                        this.engine.rowVisibleExp = iByteMap.getValue(n3);
                        break;
                    }
                    case 1: {
                        this.engine.rowHeightExp = iByteMap.getValue(n3);
                        break;
                    }
                    case 13: {
                        this.engine.breakPageExp = iByteMap.getValue(n3);
                        break;
                    }
                }
                ++n3;
            }
        }
    }

    public void addRow(int n) {
        this.row += n;
    }

    public void calcProperties(Context context, lIIIllIIIIlIIlII lIIIllIIIIlIIlII2, Queue queue, boolean bl) {
        byte by = 0;
        try {
            Object object;
            short s = 1;
            while (s <= this.engine.cs.getColCount()) {
                INormalCell iNormalCell = this.engine.cs.getCell(this.row, s);
                if (iNormalCell != null) {
                    this.engine.cs.setCurrent((ExtCell)((Object)iNormalCell));
                    break;
                }
                s = (short)(s + 1);
            }
            if (this.engine.rowVisibleExp != null) {
                by = 2;
                byte by2 = ((Expression)this.engine.rowVisibleExp).getState();
                if (by2 > this.engine.cs.getState() && by2 == 8) {
                    if (!bl && this.getSource() == this) {
                        lIIIllIIIIlIIlII2.push(this, by);
                    }
                } else {
                    object = Variant2.getValue(((Expression)this.engine.rowVisibleExp).calculate(context, false), false, false);
                    this.setRowVisible((Boolean)object);
                }
            }
            if (this.engine.rowHeightExp != null) {
                by = 1;
                byte by3 = ((Expression)this.engine.rowHeightExp).getState();
                if (by3 > this.engine.cs.getState() && by3 == 8) {
                    if (!bl && this.getSource() == this) {
                        lIIIllIIIIlIIlII2.push(this, by);
                    }
                } else {
                    object = Variant2.getValue(((Expression)this.engine.rowHeightExp).calculate(context, false), false, false);
                    this.setRowHeight(((Number)object).floatValue());
                }
            }
            if (this.engine.breakPageExp != null) {
                by = 3;
                byte by4 = ((Expression)this.engine.breakPageExp).getState();
                if (by4 > this.engine.cs.getState() && by4 == 8) {
                    if (!bl && this.getSource() == this) {
                        lIIIllIIIIlIIlII2.push(this, by);
                        return;
                    }
                } else {
                    object = Variant2.getValue(((Expression)this.engine.breakPageExp).calculate(context, false), false, false);
                    this.setBreakPage((Boolean)object);
                }
                return;
            }
        }
        catch (lllllllIllIIIlII lllllllIllIIIlII2) {
            if (!bl && queue.indexOf(lllllllIllIIIlII2.getCell()) >= 0) {
                if (this.getSource() == this) {
                    lIIIllIIIIlIIlII2.push(this, by);
                    return;
                }
            }
            throw lllllllIllIIIlII2;
        }
    }

    public void clearProperties(lIIIllIIIIlIIlII lIIIllIIIIlIIlII2) {
        if (this.engine.rowVisibleExp != null && lIIIllIIIIlIIlII2.search(this, (byte)2) < 0) {
            this.engine.rowVisibleExp = null;
        }
        if (this.engine.rowHeightExp != null && lIIIllIIIIlIIlII2.search(this, (byte)1) < 0) {
            this.engine.rowHeightExp = null;
        }
        if (this.engine.breakPageExp != null && lIIIllIIIIlIIlII2.search(this, (byte)3) < 0) {
            this.engine.breakPageExp = null;
        }
    }

    public Object clone() {
        return super.clone();
    }

    public Object deepClone() {
        return super.clone();
    }

    public void fillRecord(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord byteArrayInputRecord = new ByteArrayInputRecord(byArray);
        this.rowType = byteArrayInputRecord.readByte();
        this.rowVisible = byteArrayInputRecord.readByte();
        this.breakPage = byteArrayInputRecord.readByte();
        this.row = byteArrayInputRecord.readInt();
        this.rowHeight = byteArrayInputRecord.readFloat();
    }

    public boolean getBreakPage() {
        return this.breakPage == 1;
    }

    public String getBreakPageExp() {
        return this.engine.srcPrepare.getBreakPageExp();
    }

    public ExtCell getCellLeftHead() {
        return this.engine.cs.getCell00();
    }

    public ExtCellSet getCellSet() {
        return this.engine.cs;
    }

    public ExtCell getCellTopHead() {
        return this.engine.cs.getCell00();
    }

    public IByteMap getExpMap() {
        return null;
    }

    public IByteMap getExpMap(boolean bl) {
        return new ByteMap(1);
    }

    public byte getGroupHeaderLevel() {
        return this.engine.srcPrepare.getGroupHeaderLevel();
    }

    public String getId() {
        return CellLocation.getCellId(this.row, 0);
    }

    public String getNotes() {
        return this.engine.srcPrepare.getNotes();
    }

    public IByteMap getPropertyMap() {
        ByteMap byteMap = new ByteMap(4);
        byteMap.put((byte)0, new Byte(this.rowType));
        byteMap.put((byte)1, new Float(this.rowHeight));
        byteMap.put((byte)2, new Boolean(this.getRowVisible()));
        byteMap.put((byte)3, new Boolean(this.getBreakPage()));
        return byteMap;
    }

    public int getRow() {
        return this.row;
    }

    public float getRowHeight() {
        return this.rowHeight;
    }

    public String getRowHeightExp() {
        return this.engine.srcPrepare.getRowHeightExp();
    }

    public byte getRowType() {
        return this.rowType;
    }

    public boolean getRowVisible() {
        return this.rowVisible == 1;
    }

    public String getRowVisibleExp() {
        return this.engine.srcPrepare.getRowVisibleExp();
    }

    public ExtCell getSource() {
        return this.engine.srcCurrent;
    }

    public String getSourceId() {
        return CellLocation.getCellId(this.engine.sourceRow, 0);
    }

    public int getSourceRow() {
        return this.engine.sourceRow;
    }

    public void prepProperties(Context context) {
        try {
            if (this.engine.rowVisibleExp != null) {
                this.engine.rowVisibleExp = MacroResolver2.replaceMacros((String)this.engine.rowVisibleExp, context);
                this.engine.rowVisibleExp = new Expression(this.engine.cs, context, (String)this.engine.rowVisibleExp);
            }
            if (this.engine.rowHeightExp != null) {
                this.engine.rowHeightExp = MacroResolver2.replaceMacros((String)this.engine.rowHeightExp, context);
                this.engine.rowHeightExp = new Expression(this.engine.cs, context, (String)this.engine.rowHeightExp);
            }
            if (this.engine.breakPageExp != null) {
                this.engine.breakPageExp = MacroResolver2.replaceMacros((String)this.engine.breakPageExp, context);
                this.engine.breakPageExp = new Expression(this.engine.cs, context, (String)this.engine.breakPageExp);
                return;
            }
        }
        catch (ReportError reportError) {
            ReportError reportError2 = reportError;
            reportError.setCellId(this.getSourceId());
            throw reportError2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        this.rowType = objectInput.readByte();
        this.rowVisible = objectInput.readByte();
        this.breakPage = objectInput.readByte();
        this.row = objectInput.readInt();
        this.rowHeight = objectInput.readFloat();
        this.engine = (RowCellEngine)objectInput.readObject();
    }

    public void revertProperties() {
        if (this.engine.rowVisibleExp instanceof Expression) {
            this.engine.rowVisibleExp = this.engine.rowVisibleExp.toString();
        }
        if (this.engine.rowHeightExp instanceof Expression) {
            this.engine.rowHeightExp = this.engine.rowHeightExp.toString();
        }
        if (this.engine.breakPageExp instanceof Expression) {
            this.engine.breakPageExp = this.engine.breakPageExp.toString();
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord byteArrayOutputRecord = new ByteArrayOutputRecord();
        byteArrayOutputRecord.writeByte(this.rowType);
        byteArrayOutputRecord.writeByte(this.rowVisible);
        byteArrayOutputRecord.writeByte(this.breakPage);
        byteArrayOutputRecord.writeInt(this.row);
        byteArrayOutputRecord.writeFloat(this.rowHeight);
        return byteArrayOutputRecord.toByteArray();
    }

    public void setBreakPage(boolean bl) {
        this.breakPage = bl ? (byte)1 : 0;
    }

    public void setBreakPageExp(String string) {
    }

    public void setCellLeftHead(ExtCell extCell) {
        if (extCell != null) {
            extCell.addCellLeftHead(this);
        }
    }

    public void setCellTopHead(ExtCell extCell) {
        if (extCell != null) {
            extCell.addCellTopHead(this);
        }
    }

    public void setExpMap(IByteMap iByteMap) {
    }

    public void setGroupHeaderLevel(byte by) {
    }

    public void setNotes(String string) {
    }

    public void setPropertyMap(IByteMap iByteMap) {
        Object object = iByteMap.get((byte)0);
        if (object != null) {
            this.rowType = ((Number)object).byteValue();
        }
        if ((object = iByteMap.get((byte)1)) != null) {
            this.rowHeight = ((Number)object).floatValue();
        }
        if ((object = iByteMap.get((byte)2)) != null) {
            this.setRowVisible((Boolean)object);
        }
        if ((object = iByteMap.get((byte)3)) != null) {
            this.setBreakPage((Boolean)object);
        }
    }

    public void setRow(int n) {
        this.row = n;
    }

    public void setRowHeight(float f) {
        this.rowHeight = f;
    }

    public void setRowHeightExp(String string) {
    }

    public void setRowType(byte by) {
        this.rowType = by;
    }

    public void setRowVisible(boolean bl) {
        this.rowVisible = bl ? (byte)1 : 0;
    }

    public void setRowVisibleExp(String string) {
    }

    public void updateCell(ExtCellSet extCellSet, ExtCell extCell) {
        this.engine = ((ExtRowCell)extCellSet._$5.get((int)((ExtRowCell)extCell).engine.srcCurrent.getRow(), (int)((ExtRowCell)extCell).engine.srcCurrent.getCol())).engine;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeByte(this.rowType);
        objectOutput.writeByte(this.rowVisible);
        objectOutput.writeByte(this.breakPage);
        objectOutput.writeInt(this.row);
        objectOutput.writeFloat(this.rowHeight);
        objectOutput.writeObject(this.engine);
    }
}

