/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.InputExpression;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NormalCellEngine
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 7415358161299951956L;
    protected ExtCellSet cs;
    protected INormalCell srcPrepare;
    protected ExtCell srcCurrent;
    protected IByteMap propEngMap;
    protected Object expression;
    protected Object[] addExpression;
    protected InputExpression propInput;
    protected int sourceRow;
    protected short sourceCol;
    protected boolean isDSFunction;
    protected boolean isAddDsFun;
    protected byte extensible;
    protected byte state;

    public Object clone() {
        try {
            NormalCellEngine normalCellEngine = (NormalCellEngine)super.clone();
            if (this.propEngMap != null) {
                normalCellEngine.propEngMap = new ByteMap();
                normalCellEngine.propEngMap.addAll(this.propEngMap);
            }
            return normalCellEngine;
        }
        catch (Exception exception) {
            throw new ReportError(exception.getMessage(), exception);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        this.cs = (ExtCellSet)objectInput.readObject();
        this.srcPrepare = (INormalCell)objectInput.readObject();
        this.srcCurrent = (ExtCell)objectInput.readObject();
        short s = objectInput.readShort();
        if (s > 0) {
            this.propEngMap = new ByteMap(s);
            short s2 = 0;
            while (s2 < s) {
                this.propEngMap.add(objectInput.readByte(), objectInput.readObject());
                s2 = (short)(s2 + 1);
            }
        }
        this.expression = objectInput.readObject();
        this.sourceRow = objectInput.readInt();
        this.sourceCol = objectInput.readShort();
        this.extensible = objectInput.readByte();
        this.state = objectInput.readByte();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeObject(this.cs);
        objectOutput.writeObject(this.srcPrepare);
        objectOutput.writeObject(this.srcCurrent);
        if (this.propEngMap != null) {
            short s = this.propEngMap.size();
            objectOutput.writeShort(s);
            short s2 = 0;
            while (s2 < s) {
                objectOutput.writeByte(this.propEngMap.getKey(s2));
                Object object = this.propEngMap.getValue(s2);
                if (object instanceof Expression) {
                    objectOutput.writeObject(((Expression)object).toString());
                } else {
                    objectOutput.writeObject(object);
                }
                s2 = (short)(s2 + 1);
            }
        } else {
            objectOutput.writeShort(0);
        }
        if (this.expression instanceof Expression) {
            if (this.state == 8) {
                objectOutput.writeObject(((Expression)this.expression).toString());
            } else {
                objectOutput.writeObject(null);
            }
        } else {
            objectOutput.writeObject(this.expression);
        }
        objectOutput.writeInt(this.sourceRow);
        objectOutput.writeShort(this.sourceCol);
        objectOutput.writeByte(this.extensible);
        objectOutput.writeByte(this.state);
    }
}

