/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.StringUtils;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.ExtNormalCell;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.IColCell;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IRowCell;
import com.runqian.report4.usermodel.graph.ImageValue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;

class Perfected {
    Perfected() {
    }

    private static void adjustCellSize(IReport r, INormalCell cell, float toWidth, float toHeight, byte unit) {
        int i;
        int i2;
        float w = Perfected.getMergedWidth(r, cell, false, 1.0f, unit);
        float h = Perfected.getMergedHeight(r, cell, false, 1.0f, unit);
        Area ar = cell.getMergedArea();
        int startCol = ar.getBeginCol();
        short endCol = ar.getEndCol();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        if (toWidth > w) {
            if (cell.isMerged()) {
                int colspan = endCol - startCol + 1;
                i2 = startCol;
                while (i2 <= endCol) {
                    IColCell cc = r.getColCell((short)i2);
                    if (!cc.getColVisible()) {
                        --colspan;
                    }
                    ++i2;
                }
                int dw = (int)Math.ceil((double)(toWidth - w) * 1.0 / (double)colspan);
                i = startCol;
                while (i <= endCol) {
                    IColCell cc = r.getColCell((short)i);
                    if (cc.getColVisible()) {
                        cc.setColWidth(Perfected.unUnitTransfer(dw + (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * 1.0f), unit));
                    }
                    ++i;
                }
            } else {
                IColCell cc = r.getColCell((short)startCol);
                cc.setColWidth(Perfected.unUnitTransfer(toWidth, unit));
            }
        }
        if (toHeight > h) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    }
                    ++i2;
                }
                int dh = (int)Math.ceil((double)(toHeight - h) * 1.0 / (double)rowspan);
                i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (rc.getRowVisible()) {
                        rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                    }
                    ++i;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(toHeight, unit));
            }
        }
    }

    private static void adjustRowHeight(IReport r, INormalCell cell, String text, byte unit) {
        int totalH = Perfected.getTotalHeight(r, cell, text, unit);
        if (totalH == 0) {
            return;
        }
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        int oldH = (int)Math.floor(Perfected.getMergedHeight(r, cell, false, 1.0f, unit));
        if (oldH < totalH) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                int i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    }
                    ++i;
                }
                int dh = (int)Math.ceil((double)(totalH - oldH) * 1.0 / (double)rowspan);
                int i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (rc.getRowVisible()) {
                        rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                    }
                    ++i2;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(totalH, unit));
            }
        }
    }

    private static boolean canBeFoot(char c) {
        String cannotFoot = "([{\u00b7\u2018\u201c\u3008\u300a\u300c\u300e\u3010\u3014\u3016\uff08\uff0e\uff3b\uff5b\uffe1\uffe5";
        return cannotFoot.indexOf(c) < 0;
    }

    private static boolean canBeHead(char c) {
        String cannotHead = "!),.:;?]}\u00a8\u00b7\u02c7\u02c9\u2015\u2016\u2019\u201d\u2026\u2236\u3001\u3002\u3003\u3005\u3009\u300b\u300d\u300f\u3011\u3015\u3017\uff01\uff02\uff07\uff09\uff0c\uff0e\uff1a\uff1b\uff1f\uff3d\uff40\uff5c\uff5d\uff5e\uffe0";
        return cannotHead.indexOf(c) < 0;
    }

    private static int cutLine(String s, char c) {
        int len = s.length() - 1;
        if (c == '\u0000') {
            c = s.charAt(len);
        }
        if (!Perfected.canBeHead(c)) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!hasHead) {
                    if (Perfected.canBeHead(seekChar)) {
                        hasHead = true;
                    }
                    --seek;
                    continue;
                }
                if (Perfected.canBeFoot(seekChar)) {
                    loc = seek + 1;
                    continue;
                }
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        if (Perfected.isEnglishChar(c)) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!Perfected.isEnglishChar(seekChar)) {
                    if (Perfected.canBeFoot(seekChar)) {
                        loc = seek + 1;
                        continue;
                    }
                    hasHead = true;
                    --seek;
                    continue;
                }
                if (hasHead) {
                    loc = seek + 1;
                    continue;
                }
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        return Perfected.seekCanBeFoot(s.substring(0, len), len);
    }

    private static void flexCell(IReport r, int row, int colTotal, int dataStartCol, int dataEndCol) {
        int align;
        INormalCell cell;
        int j = 0;
        int right = dataStartCol;
        j = colTotal;
        while (j >= dataStartCol) {
            cell = r.getCell(row, (short)j);
            if (cell != null) {
                right = j;
                break;
            }
            --j;
        }
        j = align = right - (colTotal - dataEndCol);
        while (j >= dataStartCol) {
            cell = r.getCell(row, (short)j);
            if (cell != null && cell.isStretchWhenPaged()) {
                align = j;
                break;
            }
            --j;
        }
        if (align > 0) {
            INormalCell cell2;
            int k = 0;
            j = right;
            while (j > align) {
                cell2 = r.getCell(row, (short)j);
                if (cell2 != null && ((ExtCell)((Object)cell2)).getRow() == row && ((ExtCell)((Object)cell2)).getCol() == j) {
                    ((ExtCell)((Object)cell2)).setCol((short)(colTotal - k));
                    r.setCell(row, (short)(colTotal - k), cell2);
                }
                --j;
                ++k;
            }
            cell2 = r.getCell(row, (short)align);
            if (((ExtCell)((Object)cell2)).getRow() == row) {
                ((ExtNormalCell)cell2).addColMerge((short)(colTotal - right));
            }
        }
    }

    public static void flexTilteHeaderFooter(IReport r, int rowTotal, short colTotal) {
        IColCell cc;
        int end = 1;
        int dataStartCol = 1;
        while (dataStartCol <= colTotal) {
            cc = r.getColCell((short)dataStartCol);
            if (cc.getColType() == -79) break;
            dataStartCol = (short)(dataStartCol + 1);
        }
        int dataEndCol = colTotal;
        while (dataEndCol >= dataStartCol) {
            cc = r.getColCell((short)dataEndCol);
            if (cc.getColType() == -79) break;
            dataEndCol = (short)(dataEndCol - 1);
        }
        int i = 1;
        while (i <= rowTotal) {
            IRowCell rc = r.getRowCell(i);
            byte type = rc.getRowType();
            if (type != -93 && type != -96) break;
            Perfected.flexCell(r, i, colTotal, dataStartCol, dataEndCol);
            end = i++;
        }
        int i2 = 1;
        while (i2 <= end) {
            int j = 1;
            while (j <= colTotal) {
                INormalCell cell = r.getCell(i2, (short)j);
                if (cell != null && cell.isMerged() && ((ExtCell)((Object)cell)).getRow() == i2 && ((ExtCell)((Object)cell)).getCol() == j) {
                    Area ar = cell.getMergedArea();
                    int endRow = ar.getEndRow();
                    short endCol = ar.getEndCol();
                    int m = ar.getBeginRow();
                    while (m <= endRow) {
                        short n = ar.getBeginCol();
                        while (n <= endCol) {
                            r.setCell(m, n, cell);
                            n = (short)(n + 1);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i2;
        }
        int i3 = rowTotal;
        while (i3 >= 1) {
            IRowCell rc = r.getRowCell(i3);
            byte type = rc.getRowType();
            if (type != -92 && type != -89) break;
            Perfected.flexCell(r, i3, colTotal, dataStartCol, dataEndCol);
            end = i3--;
        }
        int i4 = end;
        while (i4 <= rowTotal) {
            int j = 1;
            while (j <= colTotal) {
                INormalCell cell = r.getCell(i4, (short)j);
                if (cell != null && cell.isMerged() && ((ExtCell)((Object)cell)).getRow() == i4 && ((ExtCell)((Object)cell)).getCol() == j) {
                    Area ar = cell.getMergedArea();
                    int endRow = ar.getEndRow();
                    short endCol = ar.getEndCol();
                    int m = ar.getBeginRow();
                    while (m <= endRow) {
                        short n = ar.getBeginCol();
                        while (n <= endCol) {
                            r.setCell(m, n, cell);
                            n = (short)(n + 1);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i4;
        }
    }

    protected static Font getFont(INormalCell cell) {
        int fontStyle = 0;
        if (cell.isBold()) {
            ++fontStyle;
        }
        if (cell.isItalic()) {
            fontStyle += 2;
        }
        return new Font(cell.getFontName(), fontStyle, cell.getFontSize());
    }

    protected static float getMergedHeight(IReport r, INormalCell cell, boolean includeHideRow, float scale, byte unit) {
        float height = 0.0f;
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        if (!cell.isMerged()) {
            IRowCell rc = r.getRowCell(startRow);
            height = rc.getRowHeight();
            if (rc.getRowVisible()) {
                return Perfected.unitTransfer(height, unit) * scale;
            }
            return 0.0f;
        }
        int i = startRow;
        while (i <= endRow) {
            IRowCell rc = r.getRowCell(i);
            float h = rc.getRowHeight();
            if (includeHideRow) {
                height += h;
            } else if (rc.getRowVisible()) {
                height += h;
            }
            ++i;
        }
        return Perfected.unitTransfer(height, unit) * scale;
    }

    protected static float getMergedWidth(IReport r, INormalCell cell, boolean includeHideCol, float scale, byte unit) {
        float width = 0.0f;
        Area ar = cell.getMergedArea();
        int startCol = ar.getBeginCol();
        short endCol = ar.getEndCol();
        if (!cell.isMerged()) {
            IColCell cc = r.getColCell((short)startCol);
            width = cc.getColWidth();
            if (cc.getColVisible()) {
                return Perfected.unitTransfer(width, unit) * scale;
            }
            return 0.0f;
        }
        int i = startCol;
        while (i <= endCol) {
            IColCell cc = r.getColCell((short)i);
            float w = cc.getColWidth();
            if (includeHideCol) {
                width += w;
            } else if (cc.getColVisible()) {
                width += w;
            }
            ++i;
        }
        return Perfected.unitTransfer(width, unit) * scale;
    }

    protected static int getReportHeight(IReport r, byte unit, float scale) {
        int height = 0;
        int totalRow = r.getRowCount();
        int row = 1;
        while (row <= totalRow) {
            IRowCell rc = r.getRowCell(row);
            if (rc.getRowVisible()) {
                height += (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * scale);
            }
            ++row;
        }
        return height;
    }

    protected static int getReportWidth(IReport r, byte unit, float scale) {
        int width = 0;
        int totalCol = r.getColCount();
        int col = 1;
        while (col <= totalCol) {
            IColCell cc = r.getColCell((short)col);
            if (cc.getColVisible()) {
                width += (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * scale);
            }
            ++col;
        }
        return width;
    }

    public static int getTotalHeight(IReport r, INormalCell cell, String text, byte unit) {
        if (text.trim().length() == 0) {
            return 0;
        }
        float w = Perfected.getMergedWidth(r, cell, false, 1.0f, unit);
        int indent = (int)Perfected.unitTransfer(cell.getIndent() * 1.0f, unit);
        if (cell.getHAlign() == -47) {
            indent *= 2;
        }
        if ((w = w - (float)indent - 4.0f) <= 0.0f) {
            return 0;
        }
        FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(Perfected.getFont(cell));
        ArrayList al = Perfected.wrapString(text, fm, w);
        if (al.size() < 2) {
            return 0;
        }
        int lineH = (int)Math.ceil((double)fm.getFont().getSize() * 1.255);
        int totalH = lineH * al.size() + 2;
        return totalH;
    }

    private static boolean isEnglishChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static void perfect(ExtCellSet report) {
        byte align;
        byte unit = report.getUnit();
        boolean shrinkFont = false;
        int rows = report.getRowCount();
        int cols = report.getColCount();
        Perfected.flexTilteHeaderFooter(report, rows, (short)cols);
        int row = 1;
        while (row <= rows) {
            int col = 1;
            while (col <= cols) {
                ExtNormalCell cell = (ExtNormalCell)report.getCell(row, (short)col);
                if (cell != null && cell.getRow() == row && cell.getCol() == col) {
                    Area ar;
                    byte dataType = cell.getCellType();
                    Object subValue = cell.getValue();
                    if (dataType == -60 && subValue instanceof ExtCellSet) {
                        Perfected.perfect((ExtCellSet)subValue);
                        cell.setValue(subValue);
                    }
                    if (cell.getRowHidden()) {
                        IRowCell rc = report.getRowCell(row);
                        rc.setRowVisible(false);
                    }
                    if (cell.getColHidden()) {
                        IColCell cc = report.getColCell((short)col);
                        cc.setColVisible(false);
                    }
                    int adjust = cell.getAdjustSizeMode();
                    if (cell.getTextWrap() && adjust != 51 && dataType == -64) {
                        if (adjust == 48) {
                            cell.setAdjustSizeMode((byte)49);
                            adjust = 49;
                        }
                        String text = "";
                        String data = cell.getDispValue();
                        if (data != null) {
                            text = data;
                        }
                        if (text.length() == 0 && subValue != null) {
                            text = subValue.toString();
                        }
                        if (text.length() > 0) {
                            Perfected.adjustRowHeight(report, cell, text, unit);
                        }
                    }
                    if (cell.getBreakPageAfterRow()) {
                        ar = cell.getMergedArea();
                        IRowCell rc = report.getRowCell(ar.getEndRow());
                        rc.setBreakPage(true);
                    }
                    if (cell.getBreakPageAfterCol()) {
                        ar = cell.getMergedArea();
                        IColCell cc = report.getColCell(ar.getEndCol());
                        cc.setBreakPage(true);
                    }
                    if (dataType == -63 || dataType == -62 || dataType == -57) {
                        Object vl = subValue;
                        if (vl instanceof ImageValue) {
                            vl = ((ImageValue)vl).getValue();
                        }
                        if (vl instanceof byte[]) {
                            float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            Image image = new ImageIcon((byte[])vl).getImage();
                            int iw = image.getWidth(null);
                            int ih = image.getHeight(null);
                            if (((float)iw > w || (float)ih > h) && (adjust == 48 || dataType == -57)) {
                                Perfected.adjustCellSize(report, cell, iw, ih + 1, unit);
                            }
                        }
                    } else if (dataType == -60) {
                        if (subValue instanceof IReport) {
                            IReport sub = (IReport)subValue;
                            float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            int subw = Perfected.getReportWidth(sub, unit, 1.0f);
                            int subh = Perfected.getReportHeight(sub, unit, 1.0f);
                            if ((float)subw > w || (float)subh > h) {
                                if (adjust == 48) {
                                    Perfected.adjustCellSize(report, cell, subw, subh + 2, unit);
                                } else if (adjust == 49) {
                                    int i;
                                    if ((float)subh > h) {
                                        int subRows = sub.getRowCount();
                                        i = 1;
                                        while (i <= subRows) {
                                            IRowCell rc = sub.getRowCell(i);
                                            if (rc.getRowVisible()) {
                                                int hh = (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f);
                                                int newH = (int)((float)hh * h / (float)subh);
                                                rc.setRowHeight(Perfected.unUnitTransfer(newH, unit));
                                            }
                                            ++i;
                                        }
                                    }
                                    if ((float)subw > w) {
                                        short subCols = sub.getColCount();
                                        i = 1;
                                        while (i <= subCols) {
                                            IColCell cc = sub.getColCell((short)i);
                                            if (cc.getColVisible()) {
                                                int ww = (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * 1.0f);
                                                int newW = (int)((float)ww * w / (float)subw);
                                                cc.setColWidth(Perfected.unUnitTransfer(newW, unit));
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (dataType == -64) {
                        boolean bl = shrinkFont = adjust == 51 || shrinkFont;
                        if (adjust == 48) {
                            FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(Perfected.getFont(cell));
                            String text = "";
                            String obj = cell.getDispValue();
                            if (obj != null) {
                                text = obj;
                            }
                            if (text.length() == 0 && subValue != null) {
                                text = subValue.toString();
                            }
                            int w = fm.stringWidth(text);
                            int indent = (int)Math.floor(Perfected.unitTransfer(cell.getIndent() * 1.0f, unit));
                            align = cell.getHAlign();
                            if (align == -47) {
                                indent *= 2;
                            }
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            Perfected.adjustCellSize(report, cell, w + indent + 4, h, unit);
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        if (shrinkFont) {
            int row2 = 1;
            while (row2 <= rows) {
                int col = 1;
                while (col <= cols) {
                    INormalCell cell = report.getCell(row2, (short)col);
                    if (cell != null && ((ExtCell)((Object)cell)).getRow() == row2 && ((ExtCell)((Object)cell)).getCol() == col) {
                        byte adjust;
                        byte dataType = cell.getCellType();
                        Object value = cell.getValue();
                        if (dataType == -64 && (adjust = cell.getAdjustSizeMode()) == 51) {
                            String text = "";
                            Object obj = cell.getDispValue();
                            if (obj != null) {
                                text = obj.toString();
                            }
                            if (text.length() == 0 && (obj = cell.getValue()) != null) {
                                text = obj.toString();
                            }
                            float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                            float indent = Perfected.unitTransfer(cell.getIndent() * 1.0f, unit);
                            align = cell.getHAlign();
                            if (align == -47) {
                                indent *= 2.0f;
                            }
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            boolean wrap = cell.getTextWrap();
                            Graphics g = new BufferedImage(10, 10, 2).getGraphics();
                            float fontSize = Perfected.shrinkFontSize(text, w -= indent, h, wrap, Perfected.getFont(cell), g, unit);
                            cell.setFontSize((short)fontSize);
                        }
                    }
                    ++col;
                }
                ++row2;
            }
        }
    }

    private static int seekCanBeFoot(String s, int len) {
        if (len == -1) {
            len = s.length();
        }
        if (len <= 1) {
            return len;
        }
        int seek = len - 1;
        int loc = 0;
        while (seek >= 0 && loc == 0) {
            char seekChar = s.charAt(seek);
            if (Perfected.canBeFoot(seekChar)) {
                loc = seek + 1;
                continue;
            }
            --seek;
        }
        if (loc > 0) {
            return loc;
        }
        return len;
    }

    private static int shrinkFontSize(String text, float w, float h, boolean wrap, Font font, Graphics g, byte unit) {
        if (text == null || text.trim().length() == 0) {
            return font.getSize();
        }
        int fontSize = font.getSize();
        if (fontSize < 2) {
            return 1;
        }
        if (wrap) {
            while (true) {
                FontMetrics fm = g.getFontMetrics(font);
                ArrayList al = Perfected.wrapString(text, fm, w);
                int lineH = (int)Math.ceil((double)fontSize * 1.28);
                int totalH = lineH * al.size() + 5;
                if ((float)totalH <= h) {
                    return fontSize;
                }
                font = new Font(font.getFontName(), font.getStyle(), --fontSize);
            }
        }
        FontMetrics fm = g.getFontMetrics(font);
        int sw = fm.stringWidth(text);
        if ((float)sw > w) {
            if ((fontSize = (int)((double)fontSize * 1.0 * (double)w / (double)sw)) < 2) {
                return 1;
            }
            while (true) {
                if ((float)(sw = (fm = g.getFontMetrics(font = new Font(font.getFontName(), font.getStyle(), fontSize))).stringWidth(text)) > w) {
                    return fontSize - 1;
                }
                ++fontSize;
            }
        }
        return fontSize;
    }

    public static float unUnitTransfer(float f, byte unit) {
        if (unit == 2) {
            f /= 72.0f;
        } else if (unit == 1) {
            f = f * 25.4f / 72.0f;
        }
        return f;
    }

    public static float unitTransfer(float f, byte unit) {
        if (unit == 2) {
            f *= 72.0f;
        } else if (unit == 1) {
            f = f * 72.0f / 25.4f;
        }
        return f;
    }

    protected static ArrayList wrapString(String text, FontMetrics fm, float w) {
        w = (float)Math.ceil(w) - 1.01f;
        ArrayList<String> al = new ArrayList<String>();
        text = StringUtils.replace(text, "\\n", "\n");
        ArgumentTokenizer at = new ArgumentTokenizer(text, '\n', true, true, true);
        while (at.hasNext()) {
            String line = at.next();
            if (at.hasNext()) {
                line = line + "\n";
            }
            int len = line.length();
            String tmp = "";
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                if ((float)fm.stringWidth(tmp = tmp + String.valueOf(c)) > w) {
                    int cut = Perfected.cutLine(tmp, c);
                    al.add(tmp.substring(0, cut));
                    tmp = tmp.substring(cut);
                }
                ++i;
            }
            al.add(tmp);
        }
        return al;
    }
}

