/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.report4.model.engine.ExtCell;

class PropQueue {
    private int BLOCKSIZE;
    int count;
    private DataBlock head;
    int index1;
    int index2;

    public PropQueue(int size) {
        this.BLOCKSIZE = size;
        this.head = new DataBlock(size);
        this.head.prev = this.head;
        this.head.next = this.head;
        this.index1 = 0;
        this.index2 = 0;
        this.count = 0;
    }

    public PropQueue() {
        this(256);
    }

    public boolean empty() {
        return this.count == 0;
    }

    public void push(ExtCell cell, byte key) {
        DataBlock tail = this.head.prev;
        ((DataBlock)tail).cell[this.index2] = cell;
        ((DataBlock)tail).key[this.index2] = key;
        ++this.index2;
        ++this.count;
        if (this.index2 >= this.BLOCKSIZE) {
            DataBlock oldTail = this.head.prev;
            DataBlock newTail = null;
            newTail = new DataBlock(this.BLOCKSIZE);
            this.head.prev = newTail;
            oldTail.next = newTail;
            newTail.prev = oldTail;
            newTail.next = this.head;
            this.index2 = 0;
        }
    }

    public void reset() {
        this.head.prev = this.head;
        this.head.next = this.head;
        this.index1 = 0;
        this.index2 = 0;
        this.count = 0;
    }

    public int search(ExtCell cell, byte key) {
        if (this.count <= 0) {
            return -1;
        }
        int cnt = this.count;
        int index = this.index1;
        DataBlock tmp = this.head;
        while (cnt > 0) {
            ExtCell obj = tmp.cell[index];
            byte ky = tmp.key[index];
            ++index;
            if (cell == obj && ky == key) {
                return this.count - cnt;
            }
            --cnt;
            if (index < this.BLOCKSIZE) continue;
            tmp = tmp.next;
            index = 0;
        }
        return -1;
    }

    public int size() {
        return this.count;
    }

    private static class DataBlock {
        private ExtCell[] cell;
        private byte[] key;
        private DataBlock next;
        private DataBlock prev;

        private DataBlock(int size) {
            this.cell = new ExtCell[size];
            this.key = new byte[size];
        }
    }
}

