/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.expression;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GV;
import com.runqian.base4.util.Logger;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.expression.DSFunction;
import com.runqian.report4.model.expression.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

class FunctionLib {
    static /* synthetic */ Class class$com$runqian$report4$model$expression$FunctionLib;
    private static HashMap dsFunMap;
    private static HashMap funMap;
    static HashMap tDSFunMap;
    static HashMap tFunMap;

    static {
        funMap = new HashMap(250);
        dsFunMap = new HashMap(30);
        tFunMap = new HashMap(250);
        tDSFunMap = new HashMap(30);
        FunctionLib.loadSystemFunctions();
        try {
            InputStream is = null;
            ExtCellSet lc = ExtCellSet.get();
            if (lc.getType() == 0) {
                Class<?> gvClass = null;
                try {
                    gvClass = Class.forName("com.runqian.base4.tool.GV");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (gvClass != null) {
                    String relativePath = GC.PATH_WEB_CONFIG + "/customFunctions.properties";
                    File file = new File(GV.getAbsolutePath(relativePath));
                    if (file.exists()) {
                        System.out.println("Try to load from: " + file.getAbsolutePath());
                        is = new FileInputStream(file);
                    } else {
                        System.out.println("Try to load from: " + relativePath);
                        is = (class$com$runqian$report4$model$expression$FunctionLib == null ? (class$com$runqian$report4$model$expression$FunctionLib = FunctionLib.class$("com.runqian.report4.model.expression.FunctionLib")) : class$com$runqian$report4$model$expression$FunctionLib).getResourceAsStream(relativePath);
                    }
                } else {
                    System.out.println("com.runqian.base4.tool.GV not exist.");
                }
            } else {
                System.out.println("Try to load from: /config/customFunctions.properties");
                is = (class$com$runqian$report4$model$expression$FunctionLib == null ? (class$com$runqian$report4$model$expression$FunctionLib = FunctionLib.class$("com.runqian.report4.model.expression.FunctionLib")) : class$com$runqian$report4$model$expression$FunctionLib).getResourceAsStream("/config/customFunctions.properties");
            }
            if (is != null) {
                FunctionLib.loadCustomFuctions(is);
            }
        }
        catch (Exception x) {
        }
    }

    public static void addDSFunction(String dsName, String className) {
        try {
            dsName = dsName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (dsFunMap.containsKey(dsName)) {
                MessageManager mm = EngineMessage.get();
                throw new RuntimeException(mm.getMessage("FunctionLib.repeatedDataSet") + dsName);
            }
            dsFunMap.put(dsName, funClass);
            tDSFunMap.put(funClass, dsName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void addFunction(String funName, Class funClass) {
        if (funMap.containsKey(funName = funName.toLowerCase())) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + funName);
        }
        funMap.put(funName, funClass);
        tFunMap.put(funClass, funName);
    }

    public static void addFunction(String funName, String className) {
        try {
            funName = funName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (funMap.containsKey(funName)) {
                MessageManager mm = EngineMessage.get();
                throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + funName);
            }
            funMap.put(funName, funClass);
            tFunMap.put(funClass, funName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static boolean isDSFunName(String id) {
        return dsFunMap.containsKey(id.toLowerCase());
    }

    public static boolean isFunName(String id) {
        return funMap.containsKey(id.toLowerCase());
    }

    public static void loadCustomFuctions(InputStream is) {
        try {
            Properties pt = new Properties();
            pt.load(is);
            int c = 0;
            Enumeration<?> e = pt.propertyNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String value = (String)pt.get(key);
                int pos = value.indexOf(44);
                String type = value.substring(0, pos).trim();
                String cls = value.substring(pos + 1, value.length()).trim();
                try {
                    if (type.equals("1")) {
                        FunctionLib.addDSFunction((String)key, cls);
                    } else if (type.equals("0")) {
                        FunctionLib.addFunction((String)key, cls);
                    }
                    ++c;
                    System.out.println("Custom function: " + key + " loaded.");
                }
                catch (Exception x) {
                    System.out.println("Custom function: " + key + " load failed.");
                }
            }
            System.out.println("Total " + c + " custom functions loaded.");
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
    }

    public static void loadSystemFunction() {
        FunctionLib.loadSystemFunctions();
    }

    public static void loadSystemFunctions() {
        FunctionLib.addDSFunction("select", "com.runqian.report4.model.expression.function.dsfunction.DSSelect");
        FunctionLib.addDSFunction("bselect1", "com.runqian.report4.model.expression.function.dsfunction.DSBinarySelectOne");
        FunctionLib.addDSFunction("select1", "com.runqian.report4.model.expression.function.dsfunction.DSSelectOne");
        FunctionLib.addDSFunction("group", "com.runqian.report4.model.expression.function.dsfunction.DSGroup");
        FunctionLib.addDSFunction("sum", "com.runqian.report4.model.expression.function.dsfunction.DSSum");
        FunctionLib.addDSFunction("count", "com.runqian.report4.model.expression.function.dsfunction.DSCount");
        FunctionLib.addDSFunction("avg", "com.runqian.report4.model.expression.function.dsfunction.DSAverage");
        FunctionLib.addDSFunction("max", "com.runqian.report4.model.expression.function.dsfunction.DSMax");
        FunctionLib.addDSFunction("min", "com.runqian.report4.model.expression.function.dsfunction.DSMin");
        FunctionLib.addDSFunction("last", "com.runqian.report4.model.expression.function.dsfunction.DSLast");
        FunctionLib.addDSFunction("first", "com.runqian.report4.model.expression.function.dsfunction.DSFirst");
        FunctionLib.addDSFunction("colCount", "com.runqian.report4.model.expression.function.dsfunction.DSColCount");
        FunctionLib.addDSFunction("field", "com.runqian.report4.model.expression.function.dsfunction.DSField");
        FunctionLib.addDSFunction("isField", "com.runqian.report4.model.expression.function.dsfunction.DSIsFieldName");
        FunctionLib.addDSFunction("fieldName", "com.runqian.report4.model.expression.function.dsfunction.DSFieldName");
        FunctionLib.addDSFunction("plot", "com.runqian.report4.model.expression.function.dsfunction.DSPlot");
        FunctionLib.addDSFunction("top", "com.runqian.report4.model.expression.function.dsfunction.DSTop");
        FunctionLib.addDSFunction("filter", "com.runqian.report4.model.expression.function.dsfunction.DSFilter");
        FunctionLib.addDSFunction("filter1", "com.runqian.report4.model.expression.function.dsfunction.DSFilterOne");
        FunctionLib.addDSFunction("filterCross", "com.runqian.report4.model.expression.function.dsfunction.DSFilterCross");
        FunctionLib.addDSFunction("dcount", "com.runqian.report4.model.expression.function.dsfunction.DSDistinctCount");
        FunctionLib.addDSFunction("dselect", "com.runqian.report4.model.expression.function.dsfunction.DSDistinctSelect");
        FunctionLib.addDSFunction("selectEx", "com.runqian.report4.model.expression.function.dsfunction.DSExtSelect");
        FunctionLib.addDSFunction("groupEx", "com.runqian.report4.model.expression.function.dsfunction.DSExtGroup");
        FunctionLib.addDSFunction("enumGroup", "com.runqian.report4.model.expression.function.dsfunction.DSEnumGroup");
        FunctionLib.addDSFunction("overlap", "com.runqian.report4.model.expression.function.dsfunction.DSOverlapGroup");
        FunctionLib.addDSFunction("dselectEx", "com.runqian.report4.model.expression.function.dsfunction.DSDistinctSelectExt");
        FunctionLib.addFunction("select", "com.runqian.report4.model.expression.function.special.Select");
        FunctionLib.addFunction("move", "com.runqian.report4.model.expression.function.special.Move");
        FunctionLib.addFunction("move2", "com.runqian.report4.model.expression.function.special.Move2");
        FunctionLib.addFunction("offset", "com.runqian.report4.model.expression.function.special.Offset");
        FunctionLib.addFunction("leftHead", "com.runqian.report4.model.expression.function.LeftHead");
        FunctionLib.addFunction("topHead", "com.runqian.report4.model.expression.function.TopHead");
        FunctionLib.addFunction("value", "com.runqian.report4.model.expression.function.CSCurrent");
        FunctionLib.addFunction("sum", "com.runqian.report4.model.expression.function.Sum");
        FunctionLib.addFunction("count", "com.runqian.report4.model.expression.function.Count");
        FunctionLib.addFunction("avg", "com.runqian.report4.model.expression.function.Average");
        FunctionLib.addFunction("avg2", "com.runqian.report4.model.expression.function.Average2");
        FunctionLib.addFunction("max", "com.runqian.report4.model.expression.function.Max");
        FunctionLib.addFunction("min", "com.runqian.report4.model.expression.function.Min");
        FunctionLib.addFunction("maxc", "com.runqian.report4.model.expression.function.MaxCell");
        FunctionLib.addFunction("minc", "com.runqian.report4.model.expression.function.MinCell");
        FunctionLib.addFunction("list", "com.runqian.report4.model.expression.function.ValueList");
        FunctionLib.addFunction("map", "com.runqian.report4.model.expression.function.ValueMap");
        FunctionLib.addFunction("if", "com.runqian.report4.model.expression.function.IfFun");
        FunctionLib.addFunction("nvl", "com.runqian.report4.model.expression.function.Nvl");
        FunctionLib.addFunction("case", "com.runqian.report4.model.expression.function.Case");
        FunctionLib.addFunction("ds", "com.runqian.report4.model.expression.function.GetDataSet");
        FunctionLib.addFunction("query", "com.runqian.report4.model.expression.function.Query");
        FunctionLib.addFunction("query2", "com.runqian.report4.model.expression.function.Query2");
        FunctionLib.addFunction("call", "com.runqian.report4.model.expression.function.Call");
        FunctionLib.addFunction("call2", "com.runqian.report4.model.expression.function.Call2");
        FunctionLib.addFunction("graph", "com.runqian.report4.model.expression.function.CalcGraph");
        FunctionLib.addFunction("barcode", "com.runqian.report4.model.expression.function.CalcBarcode");
        FunctionLib.addFunction("subReport", "com.runqian.report4.model.expression.function.CalcSubRpt");
        FunctionLib.addFunction("row", "com.runqian.report4.model.expression.function.CellRowNo");
        FunctionLib.addFunction("col", "com.runqian.report4.model.expression.function.CellColNo");
        FunctionLib.addFunction("esc", "com.runqian.report4.model.expression.function.Esc");
        FunctionLib.addFunction("disp", "com.runqian.report4.model.expression.function.DispValue");
        FunctionLib.addFunction("eval", "com.runqian.report4.model.expression.function.Evaluator");
        FunctionLib.addFunction("isEmpty", "com.runqian.report4.model.expression.function.IsEmpty");
        FunctionLib.addFunction("plot", "com.runqian.report4.model.expression.function.Plot");
        FunctionLib.addFunction("sort", "com.runqian.report4.model.expression.function.Sort");
        FunctionLib.addFunction("maxWidth", "com.runqian.report4.model.expression.function.MaxWidth");
        FunctionLib.addFunction("valueAt", "com.runqian.report4.model.expression.function.ValueAt");
        FunctionLib.addFunction("cell", "com.runqian.report4.model.expression.function.GetCell");
        FunctionLib.addFunction("to", "com.runqian.report4.model.expression.function.To");
        FunctionLib.addFunction("inputValue", "com.runqian.report4.model.expression.function.InputValue");
        FunctionLib.addFunction("seq", "com.runqian.report4.model.expression.function.Sequence");
        FunctionLib.addFunction("list2", "com.runqian.report4.model.expression.function.ValueList2");
        FunctionLib.addFunction("datetime", "com.runqian.report4.model.expression.function.datetime.DateTime");
        FunctionLib.addFunction("datetime2", "com.runqian.report4.model.expression.function.datetime.DateTime2");
        FunctionLib.addFunction("day", "com.runqian.report4.model.expression.function.datetime.Day");
        FunctionLib.addFunction("dayName", "com.runqian.report4.model.expression.function.datetime.DayName");
        FunctionLib.addFunction("dayNo", "com.runqian.report4.model.expression.function.datetime.DayNumber");
        FunctionLib.addFunction("daysAfter", "com.runqian.report4.model.expression.function.datetime.DaysAfter");
        FunctionLib.addFunction("hour", "com.runqian.report4.model.expression.function.datetime.Hour");
        FunctionLib.addFunction("minute", "com.runqian.report4.model.expression.function.datetime.Minute");
        FunctionLib.addFunction("month", "com.runqian.report4.model.expression.function.datetime.Month");
        FunctionLib.addFunction("monthEnd", "com.runqian.report4.model.expression.function.datetime.MonthEnd");
        FunctionLib.addFunction("monthBegin", "com.runqian.report4.model.expression.function.datetime.MonthBegin");
        FunctionLib.addFunction("quaterBegin", "com.runqian.report4.model.expression.function.datetime.QuaterBegin");
        FunctionLib.addFunction("quaterEnd", "com.runqian.report4.model.expression.function.datetime.QuaterEnd");
        FunctionLib.addFunction("lastMonth", "com.runqian.report4.model.expression.function.datetime.LastMonth");
        FunctionLib.addFunction("lastYear", "com.runqian.report4.model.expression.function.datetime.LastYear");
        FunctionLib.addFunction("relDate", "com.runqian.report4.model.expression.function.datetime.RelativeDate");
        FunctionLib.addFunction("relTime", "com.runqian.report4.model.expression.function.datetime.RelativeTime");
        FunctionLib.addFunction("second", "com.runqian.report4.model.expression.function.datetime.Second");
        FunctionLib.addFunction("secondsAfter", "com.runqian.report4.model.expression.function.datetime.SecondsAfter");
        FunctionLib.addFunction("date", "com.runqian.report4.model.expression.function.datetime.ToDate");
        FunctionLib.addFunction("time", "com.runqian.report4.model.expression.function.datetime.ToTime");
        FunctionLib.addFunction("year", "com.runqian.report4.model.expression.function.datetime.Year");
        FunctionLib.addFunction("now", "com.runqian.report4.model.expression.function.datetime.Now");
        FunctionLib.addFunction("daysInMonth", "com.runqian.report4.model.expression.function.datetime.DaysInMonth");
        FunctionLib.addFunction("daysInYear", "com.runqian.report4.model.expression.function.datetime.DaysInYear");
        FunctionLib.addFunction("weekBegin", "com.runqian.report4.model.expression.function.datetime.WeekBegin");
        FunctionLib.addFunction("weekEnd", "com.runqian.report4.model.expression.function.datetime.WeekEnd");
        FunctionLib.addFunction("lastDay", "com.runqian.report4.model.expression.function.datetime.LastDay");
        FunctionLib.addFunction("age", "com.runqian.report4.model.expression.function.datetime.Age");
        FunctionLib.addFunction("abs", "com.runqian.report4.model.expression.function.math.Abs");
        FunctionLib.addFunction("ceil", "com.runqian.report4.model.expression.function.math.Ceiling");
        FunctionLib.addFunction("cos", "com.runqian.report4.model.expression.function.math.Cos");
        FunctionLib.addFunction("exp", "com.runqian.report4.model.expression.function.math.Exp");
        FunctionLib.addFunction("fact", "com.runqian.report4.model.expression.function.math.Fact");
        FunctionLib.addFunction("log", "com.runqian.report4.model.expression.function.math.Log");
        FunctionLib.addFunction("log10", "com.runqian.report4.model.expression.function.math.LogTen");
        FunctionLib.addFunction("pi", "com.runqian.report4.model.expression.function.math.Pi");
        FunctionLib.addFunction("pow", "com.runqian.report4.model.expression.function.math.Pow");
        FunctionLib.addFunction("rand", "com.runqian.report4.model.expression.function.math.Rand");
        FunctionLib.addFunction("round", "com.runqian.report4.model.expression.function.math.Round");
        FunctionLib.addFunction("sign", "com.runqian.report4.model.expression.function.math.Sign");
        FunctionLib.addFunction("sin", "com.runqian.report4.model.expression.function.math.Sin");
        FunctionLib.addFunction("sqrt", "com.runqian.report4.model.expression.function.math.Sqrt");
        FunctionLib.addFunction("tan", "com.runqian.report4.model.expression.function.math.Tan");
        FunctionLib.addFunction("floor", "com.runqian.report4.model.expression.function.math.Floor");
        FunctionLib.addFunction("fill", "com.runqian.report4.model.expression.function.string.Fill");
        FunctionLib.addFunction("left", "com.runqian.report4.model.expression.function.string.Left");
        FunctionLib.addFunction("ltrim", "com.runqian.report4.model.expression.function.string.LeftTrim");
        FunctionLib.addFunction("len", "com.runqian.report4.model.expression.function.string.Len");
        FunctionLib.addFunction("lower", "com.runqian.report4.model.expression.function.string.Lower");
        FunctionLib.addFunction("mid", "com.runqian.report4.model.expression.function.string.Mid");
        FunctionLib.addFunction("pos", "com.runqian.report4.model.expression.function.string.Pos");
        FunctionLib.addFunction("rmQuote", "com.runqian.report4.model.expression.function.string.QuoteRemover");
        FunctionLib.addFunction("right", "com.runqian.report4.model.expression.function.string.Right");
        FunctionLib.addFunction("rtrim", "com.runqian.report4.model.expression.function.string.RightTrim");
        FunctionLib.addFunction("space", "com.runqian.report4.model.expression.function.string.Space");
        FunctionLib.addFunction("trim", "com.runqian.report4.model.expression.function.string.Trim");
        FunctionLib.addFunction("upper", "com.runqian.report4.model.expression.function.string.Upper");
        FunctionLib.addFunction("wordCap", "com.runqian.report4.model.expression.function.string.WordCap");
        FunctionLib.addFunction("like", "com.runqian.report4.model.expression.function.string.Like");
        FunctionLib.addFunction("rplc", "com.runqian.report4.model.expression.function.string.ReplaceString");
        FunctionLib.addFunction("split", "com.runqian.report4.model.expression.function.string.SplitString");
        FunctionLib.addFunction("link", "com.runqian.report4.model.expression.function.string.HttpLink");
        FunctionLib.addFunction("throwe", "com.runqian.report4.model.expression.function.ThrowException");
        FunctionLib.addFunction("subList", "com.runqian.report4.model.expression.function.SubList");
        FunctionLib.addFunction("int", "com.runqian.report4.model.expression.function.convert.ToInteger");
        FunctionLib.addFunction("long", "com.runqian.report4.model.expression.function.convert.ToLong");
        FunctionLib.addFunction("double", "com.runqian.report4.model.expression.function.convert.ToDouble");
        FunctionLib.addFunction("number", "com.runqian.report4.model.expression.function.convert.ToNumber");
        FunctionLib.addFunction("asc", "com.runqian.report4.model.expression.function.convert.Asc");
        FunctionLib.addFunction("char", "com.runqian.report4.model.expression.function.convert.Char");
        FunctionLib.addFunction("isDate", "com.runqian.report4.model.expression.function.convert.IsDate");
        FunctionLib.addFunction("isNumber", "com.runqian.report4.model.expression.function.convert.IsNumber");
        FunctionLib.addFunction("isTime", "com.runqian.report4.model.expression.function.convert.IsTime");
        FunctionLib.addFunction("rmb", "com.runqian.report4.model.expression.function.convert.ToRMB");
        FunctionLib.addFunction("chn", "com.runqian.report4.model.expression.function.convert.ToChinese");
        FunctionLib.addFunction("str", "com.runqian.report4.model.expression.function.convert.ToString");
        FunctionLib.addFunction("float", "com.runqian.report4.model.expression.function.convert.ToFloat");
        FunctionLib.addFunction("rgb", "com.runqian.report4.model.expression.function.convert.RGB");
        FunctionLib.addFunction("bigint", "com.runqian.report4.model.expression.function.convert.ToBigInteger");
        FunctionLib.addFunction("decimal", "com.runqian.report4.model.expression.function.convert.ToBigDecimal");
        FunctionLib.addFunction("hexString", "com.runqian.report4.model.expression.function.convert.ToHexString");
        FunctionLib.addFunction("pno", "com.runqian.report4.model.expression.function.PageNumber");
        FunctionLib.addFunction("pcount", "com.runqian.report4.model.expression.function.PageCount");
        FunctionLib.addFunction("pccount", "com.runqian.report4.model.expression.function.CellCount");
        FunctionLib.addFunction("pcsum", "com.runqian.report4.model.expression.function.CellSum");
    }

    public static Function newDSFunction(String funName, DataSet ds) {
        try {
            Class funClass = (Class)dsFunMap.get(funName.toLowerCase());
            DSFunction fun = (DSFunction)funClass.newInstance();
            fun.ds = ds;
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Function newFunction(String funName) {
        try {
            Class funClass = (Class)funMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

