/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.expression.graph;

import com.runqian.base4.tool.GM;
import com.runqian.base4.util.ImageUtils;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.expression.graph.DrawBase;
import com.runqian.report4.model.expression.graph.ExtGraphProperty;
import com.runqian.report4.model.expression.graph.ICustomGraph;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.graph.ImageValue;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class StatisticGraph {
    ExtGraphProperty _$1;
    int _$2 = 0;
    int _$3 = 0;

    public StatisticGraph(ExtGraphProperty extGraphProperty, int n, int n2) {
        this._$1 = extGraphProperty;
        this._$2 = n;
        this._$3 = n2;
    }

    private void _$1(Graphics2D graphics2D, int n, int n2) {
        BackGraphConfig backGraphConfig = this._$1.getBackGraphConfig();
        if (backGraphConfig == null) {
            return;
        }
        byte[] byArray = backGraphConfig.getImageBytes();
        if (byArray == null) {
            return;
        }
        Image image = new ImageIcon(byArray).getImage();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        graphics2D.drawImage(image, 1, 1, n3, n4, null);
    }

    public ImageValue calc() throws Exception {
        ImageValue imageValue = new ImageValue();
        if (this._$2 == 0 || this._$3 == 0) {
            return imageValue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this._$1.getImageFormat();
        BufferedImage bufferedImage = null;
        Graphics graphics = null;
        try {
            bufferedImage = by == 2 || by == 3 ? new BufferedImage(this._$2, this._$3, 2) : new BufferedImage(this._$2, this._$3, 1);
            graphics = (Graphics2D)bufferedImage.getGraphics();
            this._$1((Graphics2D)graphics, this._$2, this._$3);
            int n = this._$1.getCanvasColor();
            if (n != 0xFFFFFF) {
                ((Graphics2D)graphics).setBackground(new Color(n));
                graphics.clearRect(0, 0, this._$2, this._$3);
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 1, 1, 0.1f));
            if (by != 2) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (!GM.isValidString(this._$1.getLinkTarget())) {
                this._$1.setLinkTarget("_blank");
            }
            this._$1.recalcProperty();
            Object object = DrawBase.getInstance(this._$1);
            if (object instanceof DrawBase) {
                DrawBase drawBase = (DrawBase)object;
                drawBase.setGraphics2D((Graphics2D)graphics);
                drawBase.setGraphWH(this._$2, this._$3);
                drawBase.draw(stringBuffer);
            } else if (object instanceof ICustomGraph) {
                ICustomGraph iCustomGraph = (ICustomGraph)object;
                bufferedImage = iCustomGraph.draw(this._$1, stringBuffer, this._$2, this._$3);
            } else {
                throw new ReportError("Not supportted class:" + object.getClass().getName());
            }
            Object var7_10 = null;
            if (graphics != null) {
                graphics.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (graphics != null) {
                graphics.dispose();
            }
            throw throwable;
        }
        imageValue.setValue(StatisticGraph.getImageBytes(bufferedImage, by));
        if (ExtCellSet.get().getSpecialChartEnabled()) {
            imageValue.setHtml(stringBuffer.toString());
        }
        imageValue.setImageType(by);
        return imageValue;
    }

    public static byte[] getImageBytes(BufferedImage bufferedImage, byte by) throws Exception {
        byte[] byArray = null;
        switch (by) {
            case 2: {
                byArray = ImageUtils.writeGIF(bufferedImage);
                break;
            }
            case 1: {
                byArray = ImageUtils.writeJPEG(bufferedImage);
                break;
            }
            case 3: {
                byArray = ImageUtils.writePNG(bufferedImage);
                break;
            }
        }
        return byArray;
    }
}

