/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.remote;

import com.runqian.base4.tool.GV;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.OpenRequest;
import com.runqian.report4.remote.OpenResponse;
import com.runqian.report4.remote.SaveRequest;
import com.runqian.report4.remote.SaveResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class LogInfo {
    public static String currentFile;
    public static int currentFileType;
    public static int privilege;
    public static String servUrl;
    public static Map sessionVariables;
    public static String userId;
    public static String userName;

    public static boolean canChangeSessionVar() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x100) != 0;
    }

    public static boolean canOpenRaq() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 1) != 0;
    }

    public static boolean canOpenSemantic() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x80) != 0;
    }

    public static boolean canSaveAsRaq() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 4) != 0;
    }

    public static boolean canSaveAsSemantic() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x20) != 0;
    }

    public static boolean canSaveLocalRaq() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 8) != 0;
    }

    public static boolean canSaveLocalSemantic() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x40) != 0;
    }

    public static boolean canSaveRaq() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 2) != 0;
    }

    public static boolean canSaveSemantic() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x10) != 0;
    }

    public static boolean canUseDBObject() {
        if (!GV.lc.getRemotePrivilegeEnabled()) {
            return true;
        }
        return (privilege & 0x200) != 0;
    }

    public static InputStream getRemoteFileStream(String filePath, int fileType) {
        try {
            URL url = new URL(servUrl);
            URLConnection uc = url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            OpenRequest or = new OpenRequest();
            or.userId = userId;
            or.fileName = filePath;
            or.fileType = fileType;
            OutputStream os = uc.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(or);
            InputStream is = uc.getInputStream();
            OpenResponse oro = (OpenResponse)new ObjectInputStream(is).readObject();
            is = new ByteArrayInputStream(oro.data);
            currentFile = filePath;
            currentFileType = fileType;
            return is;
        }
        catch (Exception x) {
            currentFile = "";
            currentFileType = 0;
            return null;
        }
    }

    public static boolean putRemoteFileStream(String filePath, int fileType, byte[] data) {
        try {
            URL url = new URL(servUrl);
            URLConnection uc = url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            SaveRequest sr = new SaveRequest();
            sr.userId = userId;
            sr.fileName = filePath;
            sr.fileType = fileType;
            sr.data = data;
            OutputStream os = uc.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(sr);
            InputStream is = uc.getInputStream();
            SaveResponse sro = (SaveResponse)new ObjectInputStream(is).readObject();
            if (sro.state == Const.OK) {
                currentFile = filePath;
                currentFileType = fileType;
                return true;
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        currentFile = "";
        currentFileType = 0;
        return false;
    }

    public static void reset() {
        servUrl = "";
        userId = "";
        userName = "";
        privilege = 0;
        currentFile = "";
        currentFileType = 0;
    }
}

