/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.remote.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.base4.util.MD5;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.DataSourceDefine;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.remote.LoginRequest;
import com.runqian.report4.remote.LoginResponse;
import com.runqian.report4.remote.RemoteReportDefineLoader;
import com.runqian.report4.remote.dialog.DialogLogin_jBCancel_actionAdapter;
import com.runqian.report4.remote.dialog.DialogLogin_jBLogin_actionAdapter;
import com.runqian.report4.remote.dialog.DialogLogin_this_windowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class DialogLogin
extends JDialog {
    public static final String N_AUTO = "auto";
    public static final String N_PASSWORD = "password";
    public static final String N_URL = "url";
    public static final String N_USER = "user";
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    private ConfigFile cf = null;
    FlowLayout flowLayout1;
    GridBagLayout gridBagLayout1;
    JButton jBCancel;
    JButton jBLogin;
    JCheckBox jCBAuto;
    JComboBoxEx jCBUrl;
    JComboBoxEx jCBUser;
    JLabel jLabelId;
    JLabel jLabelLogo;
    JLabel jLabelPassWord;
    JLabel jLabelUrl;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3;
    JPanel jPanel5;
    JPanel jPanelLogo;
    JPasswordField jPasswordField;
    private int m_option = 2;
    private String oldConfigNode;
    VerticalFlowLayout verticalFlowLayout1;

    public DialogLogin() {
        super(GV.appFrame, "\u767b\u5f55", true);
        this.jBLogin = new JButton();
        this.jBCancel = new JButton();
        this.flowLayout1 = new FlowLayout();
        this.jPanelLogo = new JPanel();
        this.jLabelLogo = new JLabel();
        this.jLabelUrl = new JLabel();
        this.jCBUser = new JComboBoxEx();
        this.jLabelId = new JLabel();
        this.jCBUrl = new JComboBoxEx();
        this.jLabelPassWord = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.borderLayout1 = new BorderLayout();
        this.jPanel5 = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.gridBagLayout1 = new GridBagLayout();
        this.jCBAuto = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.borderLayout3 = new BorderLayout();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBLogin, this.jBCancel);
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    private String getInitValue(String attr) {
        try {
            if (this.cf == null) {
                this.cf = ConfigFile.getConfigFile();
                this.oldConfigNode = this.cf.getConfigNode();
                this.cf.setConfigNode("REMOTE");
            }
            return this.cf.getAttrValue(attr);
        }
        catch (Throwable x) {
            return null;
        }
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        String auto;
        this.jCBUrl.setEditable(true);
        this.jCBUser.setEditable(true);
        String urls = this.getInitValue(N_URL);
        String users = this.getInitValue(N_USER);
        Section s = new Section(urls);
        Vector vUrl = s.toVector();
        this.jCBUrl.setListData(vUrl);
        if (vUrl.size() > 0) {
            this.jCBUrl.setSelectedIndex(0);
        }
        s = new Section(users);
        Vector vUser = s.toVector();
        this.jCBUser.setListData(vUser);
        if (vUser.size() > 0) {
            this.jCBUser.setSelectedIndex(0);
        }
        if ((auto = this.getInitValue(N_AUTO)).equals("true")) {
            this.jCBAuto.setSelected(true);
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.whenClose();
    }

    void jBLogin_actionPerformed(ActionEvent e) {
        String surl = null;
        String userId = "";
        String password = "";
        if (!GM.isValidString(this.jCBUrl.getSelectedItem())) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialoglogin.emptyurl"));
            return;
        }
        surl = (String)this.jCBUrl.getSelectedItem();
        if (!GM.isValidString(this.jCBUser.getSelectedItem())) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialoglogin.emptyuser"));
            return;
        }
        userId = (String)this.jCBUser.getSelectedItem();
        if (this.jPasswordField.getPassword() == null) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialoglogin.emptypw"));
            return;
        }
        password = new String(this.jPasswordField.getPassword());
        if (!DialogLogin.login(surl, userId, password)) {
            return;
        }
        if (GM.isValidString(surl)) {
            this.setInitValue(N_URL, this.sort(surl, this.jCBUrl.totalItems()));
        }
        if (GM.isValidString(userId)) {
            this.setInitValue(N_USER, this.sort(userId, this.jCBUser.totalItems()));
        }
        if (GM.isValidString(password)) {
            this.setInitValue(N_PASSWORD, password);
        }
        this.m_option = 0;
        this.whenClose();
    }

    private void jbInit() throws Exception {
        this.jBLogin.setMnemonic('L');
        this.jBLogin.setText("\u767b\u5f55(L)");
        this.jBLogin.addActionListener(new DialogLogin_jBLogin_actionAdapter(this));
        this.jPanel1.setLayout(this.flowLayout1);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogLogin_jBCancel_actionAdapter(this));
        this.flowLayout1.setAlignment(2);
        this.jPanel2.setLayout(this.borderLayout1);
        this.jLabelUrl.setRequestFocusEnabled(true);
        this.jLabelUrl.setText("URL");
        this.jLabelId.setText("\u7528\u6237");
        this.jLabelPassWord.setText("\u5bc6\u7801");
        this.jPasswordField.setText("");
        this.jPanel5.setLayout(this.gridBagLayout1);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogLogin_this_windowAdapter(this));
        this.jCBAuto.setText("\u81ea\u52a8\u767b\u5f55");
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel2.setBorder(null);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setDebugGraphicsOptions(0);
        this.jPanelLogo.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jBLogin, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.jLabelUrl, GM.getGBC(1, 1));
        this.jPanel5.add((Component)this.jCBUrl, GM.getGBC(2, 1, true));
        this.jPanel5.add((Component)this.jLabelId, GM.getGBC(3, 1));
        this.jPanel5.add((Component)this.jCBUser, GM.getGBC(4, 1, true));
        this.jPanel5.add((Component)this.jLabelPassWord, GM.getGBC(5, 1));
        this.jPanel5.add((Component)this.jPasswordField, GM.getGBC(6, 1, true));
        this.jPanel5.add((Component)this.jCBAuto, GM.getGBC(7, 1, true));
        this.jPanel3.add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        ImageIcon icon = GV.getLogoImage();
        boolean isLongLogo = false;
        if (icon != null) {
            int h;
            Image image = icon.getImage();
            int w = icon.getIconWidth();
            boolean bl = isLongLogo = (double)w * 1.0 / (double)(h = icon.getIconHeight()) > 2.0;
            image = isLongLogo ? image.getScaledInstance(430, (int)(430.0 * (double)h / (double)w), 4) : (w > h ? image.getScaledInstance(150, (int)(150.0 * ((double)h * 1.0 / (double)w)), 4) : image.getScaledInstance((int)(150.0 * ((double)w * 1.0 / (double)h)), 150, 4));
            this.jLabelLogo = new JLabel(new ImageIcon(image));
        } else {
            this.jLabelLogo = new JLabel();
        }
        this.jPanelLogo.add((Component)this.jLabelLogo, null);
        if (isLongLogo) {
            this.placeLongLogo();
            this.setSize(450, 320);
        } else {
            this.placeLogo();
            this.setSize(500, 280);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean login(String surl, String userId, String password, String defaultSemantic) {
        RemoteReportDefineLoader.clearLoaders();
        LoginRequest lr = new LoginRequest();
        lr.userId = userId;
        lr.password = new MD5().getMD5ofStr(password);
        OutputStream os = null;
        ObjectOutputStream oos = null;
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            URL url = new URL(surl);
            URLConnection uc = url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            os = uc.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(lr);
            is = uc.getInputStream();
            ois = new ObjectInputStream(is);
            LoginResponse lrp = (LoginResponse)ois.readObject();
            if (lrp.state == Const.INVALID_USER) {
                JOptionPane.showMessageDialog(null, Lang.getText("dialoglogin.usererror"), Lang.getText("dialoglogin.loginfaild"), 2);
                boolean bl = false;
                return bl;
            }
            if (lrp.state == Const.ERROR_PWD) {
                JOptionPane.showMessageDialog(null, Lang.getText("dialoglogin.pwerror"), Lang.getText("dialoglogin.loginfaild"), 2);
                boolean bl = false;
                return bl;
            }
            if (lrp.state == Const.OK) {
                RemoteReportDefineLoader.addLoader(new RemoteReportDefineLoader());
                LogInfo.servUrl = surl;
                LogInfo.userId = userId;
                String userName = lrp.userName;
                if (!GM.isValidString(userName)) {
                    userName = userId;
                }
                LogInfo.userName = userName;
                LogInfo.privilege = lrp.privilege;
                LogInfo.sessionVariables = lrp.sessionVariables;
                GV.resetFrameTitle(GV.dsActive != null ? GV.dsActive.getName() : "", userName);
                Map dsMap = lrp.dataSources;
                if (dsMap != null) {
                    Iterator it = dsMap.values().iterator();
                    while (it.hasNext()) {
                        DataSourceDefine dsd = (DataSourceDefine)it.next();
                        if (dsd.getName() == null) {
                            System.out.println("Remote datasource name is null, ignore it");
                            continue;
                        }
                        DataSource ds = new DataSource(dsd);
                        GV.dsModel.addRemoteDataSource(ds);
                    }
                }
                String fileName = !ConfigOptions.bAutoOpenSemantic.booleanValue() && GM.isValidString(defaultSemantic) ? defaultSemantic : lrp.semanticsFileName;
                GV.appFrame.openSemantic(fileName, true);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex1) {
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex2) {
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex3) {
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex4) {
                }
            }
        }
        return false;
    }

    public static boolean login(String surl, String userId, String password) {
        return DialogLogin.login(surl, userId, password, "");
    }

    private void placeLogo() {
        this.jPanel3.add((Component)this.jPanelLogo, "West");
    }

    private void placeLongLogo() {
        this.jPanel3.add((Component)this.jPanelLogo, "North");
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialoglogin.title"));
        this.jBLogin.setText(Lang.getText("button.login"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jLabelId.setText(Lang.getText("dialoglogin.user"));
        this.jLabelPassWord.setText(Lang.getText("dialoglogin.password"));
        this.jCBAuto.setText(Lang.getText("dialoglogin.autologin"));
    }

    private void setInitValue(String attr, String value) {
        try {
            if (this.cf == null) {
                this.cf = ConfigFile.getConfigFile();
                this.oldConfigNode = this.cf.getConfigNode();
                this.cf.setConfigNode("REMOTE");
            }
            this.cf.setAttrValue(attr, value);
        }
        catch (Throwable t) {
        }
    }

    private String sort(String selectedItem, String totalItems) {
        String sortString = selectedItem;
        Section s = new Section(totalItems);
        Vector v = s.toVector();
        int i = 0;
        while (i < v.size()) {
            if (!v.get(i).equals(selectedItem)) {
                sortString = sortString + "," + v.get(i);
            }
            ++i;
        }
        return sortString;
    }

    void this_windowClosing(WindowEvent e) {
        this.whenClose();
    }

    private void whenClose() {
        if (this.jCBAuto.isSelected()) {
            this.setInitValue(N_AUTO, "true");
        } else {
            this.setInitValue(N_AUTO, "false");
        }
        if (this.cf != null) {
            this.cf.setConfigNode(this.oldConfigNode);
        }
        GM.setWindowDimension(this);
        this.dispose();
    }
}

