/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.remote.example;

import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.LoginRequest;
import com.runqian.report4.remote.LoginResponse;
import com.runqian.report4.remote.LogoutRequest;
import com.runqian.report4.remote.LogoutResponse;
import com.runqian.report4.remote.OpenRequest;
import com.runqian.report4.remote.OpenResponse;
import com.runqian.report4.remote.SaveRequest;
import com.runqian.report4.remote.SaveResponse;
import com.runqian.report4.remote.example.UserInfo;
import com.runqian.report4.remote.example.UserManager;
import com.runqian.report4.semantics.SemanticsManager;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;

public class RemoteManager {
    public Map dataSources;
    public long overtime = 3600000L;
    private static RemoteManager rm = new RemoteManager();
    private String semanticsFile;
    private UserManager um = new UserManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginResponse doLogin(LoginRequest req) {
        LoginResponse res = new LoginResponse();
        UserInfo info = this.um.getInfo(req.userId);
        if (info == null) {
            res.state = Const.INVALID_USER;
            return res;
        }
        UserInfo userInfo = info;
        synchronized (userInfo) {
            if (info.checkPassword(req.password)) {
                System.out.println("\u5bc6\u7801\u6821\u9a8c\u6210\u529f\uff0c\u5f00\u59cb\u51c6\u5907response");
                res.state = Const.OK;
                res.sessionVariables = info.sessionVariables;
                res.userName = info.userName;
                res.dataSources = this.dataSources;
                res.privilege = info.privilege;
                res.semanticsFileName = this.semanticsFile;
                res.alarmRowNum = info.alarmRowNum;
                info.state = Const.OK;
                info.accessTime = System.currentTimeMillis();
            } else {
                res.state = Const.ERROR_PWD;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogoutResponse doLogout(LogoutRequest req) {
        LogoutResponse res = new LogoutResponse();
        UserInfo info = this.um.getInfo(req.userId);
        if (info == null) {
            res.state = Const.INVALID_USER;
            return res;
        }
        UserInfo userInfo = info;
        synchronized (userInfo) {
            res.state = Const.OK;
            info.state = Const.NOT_LOGIN;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenResponse doOpen(OpenRequest req) {
        OpenResponse res = new OpenResponse();
        UserInfo info = this.um.getInfo(req.userId);
        if (info == null) {
            res.state = Const.INVALID_USER;
            return res;
        }
        UserInfo userInfo = info;
        synchronized (userInfo) {
            info.checkOvertime(this.overtime);
            if (info.state == Const.OK) {
                try {
                    if (req.fileType == Const.FILE_SEMANTICS) {
                        SemanticsManager sm = new SemanticsManager();
                        sm.readXML(req.fileName);
                        if (info.semanticsPrivilege != null) {
                            Iterator set = info.semanticsPrivilege.keySet().iterator();
                            while (set.hasNext()) {
                                Object viewName = set.next();
                                if (viewName == null || viewName.equals("")) continue;
                                Object value = info.semanticsPrivilege.get(viewName);
                                System.out.println("viewName=" + viewName + "';value=" + value);
                                if (value == null || value.equals("")) {
                                    System.out.println("\u5220\u9664\u65e0\u6743\u9650\u7684\u89c6\u56fe\uff0cviewName=" + viewName);
                                    sm.getViewList().removeView((String)viewName);
                                    continue;
                                }
                                ArgumentTokenizer cols = new ArgumentTokenizer((String)value, ':');
                                while (cols.hasNext()) {
                                    String col = cols.next();
                                    if (col == null || col.equals("")) continue;
                                    System.out.println("\u5f00\u59cb\u5220\u9664\u65e0\u6743\u9650\u7684\u5b57\u6bb5\uff0cviewName=" + viewName + ";col=" + col);
                                    sm.getView((String)viewName).removeCol(col);
                                }
                            }
                        }
                        System.out.println("\u8fd4\u56de\u8bed\u4e49\u6587\u4ef6\u5b57\u8282\u6d41");
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        StreamResult sr = new StreamResult(bos);
                        sm.writeXMLStream(sr);
                        res.data = bos.toByteArray();
                    } else {
                        res.data = this.readFile(req.fileName);
                    }
                    res.state = Const.OK;
                }
                catch (Exception e) {
                    res.state = Const.FAILED;
                    res.clause = e.getMessage();
                    e.printStackTrace();
                }
                info.refreshAccessTime();
            } else {
                res.state = info.state;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveResponse doSave(SaveRequest req) {
        SaveResponse res = new SaveResponse();
        UserInfo info = this.um.getInfo(req.userId);
        if (info == null) {
            res.state = Const.INVALID_USER;
            return res;
        }
        UserInfo userInfo = info;
        synchronized (userInfo) {
            info.checkOvertime(this.overtime);
            if (info.state == Const.OK) {
                try {
                    this.writeFile(req.fileName, req.data);
                    res.state = Const.OK;
                }
                catch (Exception e) {
                    res.state = Const.FAILED;
                    res.clause = e.getMessage();
                    e.printStackTrace();
                }
                info.refreshAccessTime();
            } else {
                res.state = info.state;
            }
        }
        return res;
    }

    public static RemoteManager getInstance() {
        return rm;
    }

    public UserManager getUserManager() {
        return this.um;
    }

    private byte[] readFile(InputStream is) throws IOException {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String fileName) throws IOException {
        byte[] byArray;
        block2: {
            FileInputStream is = null;
            try {
                is = new FileInputStream(fileName);
                byArray = this.readFile(is);
                Object var5_4 = null;
                if (is == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (is == null) break block3;
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        return byArray;
    }

    public void setSemanticsFile(String fileName) {
        this.semanticsFile = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(String fileName, byte[] data) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(fileName);
            os.write(data);
            os.flush();
            Object var5_4 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (os == null) throw throwable;
            os.close();
            throw throwable;
        }
        os.close();
    }
}

