/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.remote.example;

import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.DBTypes;
import com.runqian.base4.util.MD5;
import com.runqian.base4.util.SegmentSet;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.DataSourceDefine;
import com.runqian.report4.remote.LoginRequest;
import com.runqian.report4.remote.LogoutRequest;
import com.runqian.report4.remote.OpenRequest;
import com.runqian.report4.remote.Request;
import com.runqian.report4.remote.Response;
import com.runqian.report4.remote.SaveRequest;
import com.runqian.report4.remote.example.RemoteManager;
import com.runqian.report4.remote.example.UserInfo;
import com.runqian.report4.remote.example.UserManager;
import com.runqian.report4.usermodel.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoteServer
extends HttpServlet {
    private String getNodeAttr(Node node, String attrName) {
        NamedNodeMap map = node.getAttributes();
        Node attr = map.getNamedItem(attrName);
        if (attr == null) {
            return "";
        }
        return attr.getNodeValue();
    }

    public void init() throws ServletException {
        ServletContext application = this.getServletContext();
        ServletConfig config = this.getServletConfig();
        RemoteManager rm = RemoteManager.getInstance();
        UserManager um = rm.getUserManager();
        String usersConfig = config.getInitParameter("usersConfig");
        Properties p = new Properties();
        try {
            InputStream is = application.getResourceAsStream(usersConfig);
            p.load(is);
            is.close();
            Enumeration<?> em = p.propertyNames();
            while (em.hasMoreElements()) {
                String userId = (String)em.nextElement();
                UserInfo info = new UserInfo();
                String tmp = p.getProperty(userId);
                ArgumentTokenizer at = new ArgumentTokenizer(tmp, ',');
                String name = at.nextToken();
                try {
                    name = new String(name.getBytes("iso8859-1"), "GBK");
                }
                catch (Exception e) {
                    // empty catch block
                }
                info.userName = name;
                info.password = new MD5().getMD5ofStr(at.nextToken());
                info.privilege = Integer.parseInt(at.nextToken(), 2);
                info.alarmRowNum = Integer.parseInt(at.nextToken());
                System.out.println("\u7cfb\u7edf\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u8bfb\u53d6\u4f1a\u8bdd\u53d8\u91cf");
                tmp = at.nextToken();
                SegmentSet set = null;
                if (tmp != null && tmp.trim().length() > 0) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    System.out.println("tmp=" + tmp);
                    set = new SegmentSet(tmp, ';');
                    info.sessionVariables = set.toMap();
                }
                System.out.println("\u7cfb\u7edf\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u8bfb\u53d6\u8bed\u4e49\u6743\u9650");
                tmp = at.nextToken();
                if (tmp != null && tmp.trim().length() > 0) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    set = new SegmentSet(tmp, ';');
                    info.semanticsPrivilege = set.toMap();
                }
                um.addUser(userId, info);
            }
            String semanticsFile = config.getInitParameter("semanticsFile");
            if (semanticsFile != null && semanticsFile.trim().length() > 0) {
                rm.setSemanticsFile(semanticsFile);
            }
            String dsConfig = config.getInitParameter("dsConfig");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream iis = application.getResourceAsStream(dsConfig);
            Document doc = docBuilder.parse(iis);
            iis.close();
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            HashMap<String, DataSourceDefine> dsMap = new HashMap<String, DataSourceDefine>();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeName().equals("ds")) {
                    String dbCharset;
                    DataSourceDefine dsd = new DataSourceDefine();
                    String name = this.getNodeAttr(node, "name");
                    dsd.setName(name);
                    String caseSense = this.getNodeAttr(node, "CaseSensitive");
                    dsd.setCaseSentence("1".equals(caseSense));
                    String ideCharset = this.getNodeAttr(node, "ideCharset");
                    if (ideCharset.length() > 0) {
                        dsd.setClientCharset(ideCharset);
                    }
                    if ((dbCharset = this.getNodeAttr(node, "dbCharset")).length() > 0) {
                        dsd.setDBCharset(dbCharset);
                    }
                    String dbtype = this.getNodeAttr(node, "dbType");
                    dsd.setDBType(DBTypes.getDBType(dbtype));
                    String driver = this.getNodeAttr(node, "driverClass");
                    dsd.setDriver(driver);
                    dsd.setDSType((byte)0);
                    String transCharset = this.getNodeAttr(node, "transCharset");
                    dsd.setNeedTranContent("1".equals(transCharset));
                    String transSQLCharset = this.getNodeAttr(node, "transSQLCharset");
                    dsd.setNeedTranSentence("1".equals(transSQLCharset));
                    String pwd = this.getNodeAttr(node, "password");
                    dsd.setPassword(pwd);
                    dsd.setUrl(this.getNodeAttr(node, "url"));
                    dsd.setUser(this.getNodeAttr(node, "user"));
                    String useSchema = this.getNodeAttr(node, "useSchema");
                    dsd.setUseSchema("1".equals(useSchema));
                    dsMap.put(name, dsd);
                }
                ++i;
            }
            rm.dataSources = dsMap;
            System.out.println("\u8fdc\u7a0b\u8bbe\u8ba1\u670d\u52a1\u5668\u5df2\u542f\u52a8......");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream is = null;
        OutputStream os = null;
        try {
            ServletContext application = this.getServletContext();
            is = request.getInputStream();
            ObjectInputStream ois = new ObjectInputStream((InputStream)is);
            Request req = (Request)ois.readObject();
            RemoteManager rm = RemoteManager.getInstance();
            Response res = null;
            if (req instanceof LoginRequest) {
                System.out.println("\u63a5\u6536\u5230\u767b\u9646\u8bf7\u6c42");
                res = rm.doLogin((LoginRequest)req);
                System.out.println("\u767b\u9646\u5904\u7406\u5b8c\u6bd5");
            } else if (req instanceof LogoutRequest) {
                res = rm.doLogout((LogoutRequest)req);
            } else if (req instanceof OpenRequest) {
                OpenRequest openReq = (OpenRequest)req;
                if (openReq.fileType == Const.FILE_SEMANTICS) {
                    String fileName = openReq.fileName;
                    if (!fileName.startsWith("/WEB-INF")) {
                        fileName = "/WEB-INF/" + fileName;
                    }
                    openReq.fileName = fileName = application.getRealPath(fileName);
                } else {
                    String fileName;
                    openReq.fileName = fileName = application.getRealPath(Context.getMainDir() + "/" + openReq.fileName);
                }
                res = rm.doOpen(openReq);
            } else if (req instanceof SaveRequest) {
                String fileName;
                SaveRequest saveReq = (SaveRequest)req;
                saveReq.fileName = saveReq.fileType == Const.FILE_SEMANTICS ? (fileName = application.getRealPath("/WEB-INF/" + saveReq.fileName)) : (fileName = application.getRealPath(Context.getMainDir() + "/" + saveReq.fileName));
                res = rm.doSave(saveReq);
            }
            os = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            System.out.println("\u8f93\u51faresponse");
            oos.writeObject(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }
}

