/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GV;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.base4.util.Sentence;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

class ExpParse {
    private static final byte FLAG_LIKE = 2;
    private static final byte FLAG_NONE = 0;
    private static final byte FLAG_TO = 1;
    private static final byte NONE = 0;
    private static final byte OPT_CSVARIABLE = 4;
    private static final byte OPT_DSMEMBER = 3;
    private static final byte OPT_NONE = 1;
    private static final byte OPT_OPERATOR = 2;
    private static final char SPLIT_LIKE = '\u0002';
    private static final char SPLIT_TO = '\u0001';
    static /* synthetic */ Class class$com$runqian$report4$transfer$ExpressionTransfer;
    private static Map dsfunMap;
    private String expStr;
    private static Map funMap;
    private int location;
    private String newStr = "";
    private byte preNode = 0;
    private byte toLikeFlag = 0;

    static {
        funMap = new HashMap(256);
        dsfunMap = new HashMap(64);
        ExpParse.loadFunction();
        ExpParse.loadDSFunction();
        ExpParse.loadCustomFunctions();
    }

    public ExpParse(CellSet cs, Context ctx, DataSet ds, String expStr) {
        this.expStr = expStr;
        this.location = 0;
        try {
            this.create(cs, ctx, ds);
            if (this.toLikeFlag != 0) {
                this.tansferToOrLike(0, ctx);
            }
        }
        catch (ReportError re) {
            MessageManager mm = EngineMessage.get();
            re.setErrorMsg(mm.getMessage("Expression.inExp", expStr) + re.getErrorMsg());
            throw re;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void create(CellSet cs, Context ctx, DataSet ds) {
        int len = this.expStr.length();
        int inBrackets = 0;
        int bracketPos = -1;
        block10: while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                this.newStr = this.newStr + c;
                continue;
            }
            switch (c) {
                case '(': {
                    ++inBrackets;
                    bracketPos = this.newStr.length();
                    ++this.location;
                    this.newStr = this.newStr + c;
                    break;
                }
                case ')': {
                    if (--inBrackets < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
                    }
                    ++this.location;
                    this.newStr = this.newStr + c;
                    if (this.toLikeFlag == 0 || inBrackets != 0) continue block10;
                    this.tansferToOrLike(bracketPos, ctx);
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': {
                    ++this.location;
                    this.newStr = this.newStr + c;
                    this.preNode = (byte)2;
                    break;
                }
                case '=': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        ++this.location;
                    }
                    this.newStr = this.newStr + c;
                    this.newStr = this.newStr + c;
                    this.preNode = (byte)2;
                    break;
                }
                case '!': 
                case '<': 
                case '>': {
                    ++this.location;
                    this.newStr = this.newStr + c;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        ++this.location;
                        this.newStr = this.newStr + '=';
                    }
                    this.preNode = (byte)2;
                    break;
                }
                case '&': {
                    ++this.location;
                    this.newStr = this.newStr + c;
                    if (this.location < len && this.expStr.charAt(this.location) == '&') {
                        ++this.location;
                        this.newStr = this.newStr + c;
                    }
                    this.preNode = (byte)2;
                    break;
                }
                case '|': {
                    ++this.location;
                    this.newStr = this.newStr + c;
                    if (this.location < len && this.expStr.charAt(this.location) == '|') {
                        ++this.location;
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new ReportError(mm.getMessage("Expression.unknownSymbol") + "|");
                    }
                    this.newStr = this.newStr + c;
                    this.preNode = (byte)2;
                    break;
                }
                case '.': {
                    if (this.preNode == 1 || (this.preNode & 2) == 2) {
                        this.preNode = this.createNode(cs, ctx, ds);
                        break;
                    }
                    this.preNode = (byte)3;
                    ++this.location;
                    this.newStr = this.newStr + c;
                    break;
                }
                default: {
                    this.preNode = this.createNode(cs, ctx, ds);
                }
            }
        }
        if (inBrackets > 0) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
        }
    }

    private byte createDSNode(CellSet cs, Context ctx, DataSet ds, String id) {
        if (this.isNextBracket()) {
            String dsfun = ExpParse.getDSFunction(id);
            if (dsfun != null) {
                this.newStr = this.newStr + dsfun + "(" + ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds) + ")";
                return 1;
            }
            String exp = this.transferRoot(cs, ctx, ds, id);
            if (exp != null) {
                this.newStr = this.newStr + exp;
                return 1;
            }
            if (this.preNode == 3) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("Expression.unknownDataSet") + id);
            }
        } else if (ds != null && ExpParse.isDSColNo(ds, id)) {
            this.newStr = this.newStr + id;
            return 1;
        }
        return 0;
    }

    private byte createNode(CellSet cs, Context ctx, DataSet ds) {
        byte node;
        String dsName;
        char c = this.expStr.charAt(this.location);
        int match = -1;
        if (c == '\"' || c == '\'') {
            match = Sentence.scanQuotation(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("\",'Expression.illmacthed"));
            }
            this.newStr = this.newStr + c + this.expStr.substring(this.location + 1, match) + c;
            this.location = match + 1;
            return 1;
        }
        if (c == '{') {
            match = Sentence.scanBrace(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("{,}Expression.illmacthed"));
            }
            this.newStr = this.newStr + "{" + ExpParse.setParameter(this.expStr.substring(this.location + 1, match), cs, ctx, ds) + "}";
            this.location = match + 1;
            return 1;
        }
        if (c == '[') {
            match = Sentence.scanBracket(this.expStr, this.location);
            if (match == -1) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("[,]Expression.illmacthed"));
            }
            this.newStr = this.preNode == 0 || this.preNode == 2 ? this.newStr + "list(" + ExpParse.setParameter(this.expStr.substring(this.location + 1, match), cs, ctx, ds) + ")" : (this.preNode == 4 ? this.newStr + "[" + ExpParse.setMoveParameter(this.expStr.substring(this.location + 1, match), cs, ctx, ds) + "]" : this.newStr + "[" + ExpParse.setParameter(this.expStr.substring(this.location + 1, match), cs, ctx, ds) + "]");
            this.location = match + 1;
            return 1;
        }
        String id = this.scanId();
        if (id.equalsIgnoreCase("and")) {
            this.newStr = this.newStr + "&&";
            return 2;
        }
        if (id.equalsIgnoreCase("or")) {
            this.newStr = this.newStr + "||";
            return 2;
        }
        if (id.equalsIgnoreCase("not")) {
            this.newStr = this.newStr + "!";
            return 2;
        }
        if (id.equalsIgnoreCase("in")) {
            this.newStr = this.newStr + "in";
            return 2;
        }
        if (id.equalsIgnoreCase("to")) {
            this.toLikeFlag = 1;
            this.newStr = this.newStr + '\u0001';
            return 1;
        }
        if (id.equalsIgnoreCase("like")) {
            this.toLikeFlag = (byte)2;
            this.newStr = this.newStr + '\u0002';
            return 1;
        }
        DataSet tempDS = ds;
        int index = id.indexOf(46);
        if (index > 0 && !Character.isDigit(id.charAt(0)) && (tempDS = ExpParse.getDataSet(ctx, dsName = id.substring(0, index))) != null) {
            id = id.substring(index + 1);
            this.newStr = this.newStr + tempDS.getDataSetName() + ".";
            byte node2 = this.createDSNode(cs, ctx, tempDS, id);
            if (node2 != 0) {
                return node2;
            }
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.unknownDataSet") + id);
        }
        if (id.equalsIgnoreCase("ds") && this.isNextBracket()) {
            String para = this.scanParameter(ctx);
            String dsName2 = para.substring(1, para.length() - 1);
            tempDS = ExpParse.getDataSet(ctx, dsName2);
            if (tempDS != null) {
                this.newStr = this.newStr + id + "(" + ExpParse.setParameter(para, cs, ctx, tempDS) + ")";
                id = this.scanId();
                if (id.charAt(0) == '.') {
                    id = id.substring(1);
                    this.newStr = this.newStr + ".";
                    byte node3 = this.createDSNode(cs, ctx, tempDS, id);
                    if (node3 != 0) {
                        return node3;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.unknownDataSet") + id);
                }
            }
            boolean hello = true;
        }
        if (ds != null && (node = this.createDSNode(cs, ctx, ds, id)) != 0) {
            return node;
        }
        if (this.preNode == 3 && (node = this.createDSNode(cs, ctx, ds, id)) != 0) {
            return node;
        }
        boolean isSaved = false;
        boolean indicator = false;
        if (id.charAt(0) == '@') {
            id = id.substring(1);
            indicator = true;
        } else if (id.charAt(0) == '$') {
            id = id.substring(1);
            this.newStr = this.newStr + '$';
            isSaved = true;
        }
        if (id.equalsIgnoreCase("value")) {
            this.newStr = this.newStr + "value()";
            return 1;
        }
        if (!indicator && ExpParse.isSource(cs, id)) {
            this.newStr = this.newStr + id.toUpperCase();
            if (isSaved) {
                return 1;
            }
            return 4;
        }
        if (this.isNextBracket()) {
            String fun = ExpParse.getFunction(id);
            if (fun != null) {
                this.newStr = this.newStr + fun + "(" + ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds) + ")";
                return 1;
            }
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.unknownFunction") + id);
        }
        if (ctx.isParamName(id)) {
            this.newStr = this.newStr + id;
            return 1;
        }
        Iterator keyIterator = ctx.getParamMap(true).keySet().iterator();
        while (keyIterator.hasNext()) {
            String pName = (String)keyIterator.next();
            if (pName == null || !pName.equalsIgnoreCase(id)) continue;
            this.newStr = this.newStr + pName;
            return 1;
        }
        Object value = Variant2.parse(id);
        if (value instanceof String) {
            this.newStr = this.newStr + "\"" + (String)value + "\"";
            return 1;
        }
        this.newStr = this.newStr + Variant2.toString(value);
        return 1;
    }

    private static String getDSFunction(String dsfun) {
        return (String)dsfunMap.get(dsfun.toLowerCase());
    }

    private static DataSet getDataSet(Context ctx, String dsName) {
        Map map = ctx.getDataSetMap(false);
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                if (!dsName.equalsIgnoreCase(name)) continue;
                return (DataSet)entry.getValue();
            }
            Context parent = ctx.getParent();
            if (parent != null) {
                return ExpParse.getDataSet(parent, dsName);
            }
        }
        return null;
    }

    private static String getFunction(String fun) {
        return (String)funMap.get(fun.toLowerCase());
    }

    String getNewExp() {
        return this.newStr;
    }

    static boolean isDSColNo(DataSet ds, String col) {
        String str;
        Object obj;
        int no = -1;
        if (col != null && col.charAt(0) == '#' && (obj = Variant2.parse(str = col.substring(1))) instanceof Number && (no = ((Number)obj).intValue()) >= 0 && no <= ds.getColCount()) {
            return true;
        }
        if (ds.isColName(col)) {
            return true;
        }
        return ds.isColTitle(col);
    }

    private boolean isNextBracket() {
        int i = this.location;
        int len = this.expStr.length();
        while (i < len && Character.isWhitespace(this.expStr.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        return this.expStr.charAt(i) == '(';
    }

    private static boolean isSource(CellSet cs, String id) {
        int i = 0;
        long row = 0L;
        int col = 0;
        char c = '\u0000';
        boolean flag = false;
        if (id == null) {
            return false;
        }
        int length = id.length();
        if (length < 2) {
            return false;
        }
        int rowSize = cs.getRow();
        int colSize = cs.getColumn();
        i = 0;
        while (i < length) {
            c = id.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                col = col * 26 + (c - 65) + 1;
                flag = true;
            } else {
                if (c < 'a' || c > 'z') break;
                col = col * 26 + (c - 97) + 1;
                flag = true;
            }
            if (col > colSize) {
                return false;
            }
            ++i;
        }
        if (!flag && c == '`' && i == 0) {
            flag = true;
            ++i;
        }
        if (!flag) {
            return false;
        }
        flag = false;
        while (i < length) {
            c = id.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            if ((row = row * 10L + (long)(c - 48)) > (long)rowSize) {
                return false;
            }
            flag = true;
            ++i;
        }
        return flag;
    }

    private static void loadCustomFuctions(InputStream is) {
        try {
            Properties pt = new Properties();
            pt.load(is);
            int c = 0;
            Enumeration<?> e = pt.propertyNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String value = (String)pt.get(key);
                int pos = value.indexOf(44);
                String type = value.substring(0, pos).trim();
                ++c;
                if (type.equals("1")) {
                    dsfunMap.put(((String)key).toLowerCase(), (String)key);
                } else if (type.equals("0")) {
                    funMap.put(((String)key).toLowerCase(), (String)key);
                }
                System.out.println("Custom function: " + key + " loaded.");
            }
            System.out.println("Total " + c + " custom functions loaded.");
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
    }

    private static void loadCustomFunctions() {
        try {
            InputStream is = null;
            ExtCellSet lc = ExtCellSet.get();
            if (lc.getType() == 0) {
                Class<?> gvClass = null;
                try {
                    gvClass = Class.forName("com.runqian.base4.tool.GV");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (gvClass != null) {
                    String relativePath = GC.PATH_WEB_CONFIG + "/customFunctions.properties";
                    File file = new File(GV.getAbsolutePath(relativePath));
                    is = file.exists() ? new FileInputStream(file) : (class$com$runqian$report4$transfer$ExpressionTransfer == null ? (class$com$runqian$report4$transfer$ExpressionTransfer = ExpParse.class$("com.runqian.report4.transfer.ExpressionTransfer")) : class$com$runqian$report4$transfer$ExpressionTransfer).getResourceAsStream(relativePath);
                }
            } else {
                is = (class$com$runqian$report4$transfer$ExpressionTransfer == null ? (class$com$runqian$report4$transfer$ExpressionTransfer = ExpParse.class$("com.runqian.report4.transfer.ExpressionTransfer")) : class$com$runqian$report4$transfer$ExpressionTransfer).getResourceAsStream("/config/customFunctions.properties");
            }
            if (is != null) {
                ExpParse.loadCustomFuctions(is);
            }
        }
        catch (Exception x) {
        }
    }

    private static void loadDSFunction() {
        dsfunMap.put("select", "select");
        dsfunMap.put("bselect1", "bselect1");
        dsfunMap.put("bselect_one", "bselect1");
        dsfunMap.put("select1", "select1");
        dsfunMap.put("select_one", "select1");
        dsfunMap.put("get", "select1");
        dsfunMap.put("group", "group");
        dsfunMap.put("sum", "sum");
        dsfunMap.put("count", "count");
        dsfunMap.put("avg", "avg");
        dsfunMap.put("average", "avg");
        dsfunMap.put("max", "max");
        dsfunMap.put("min", "min");
        dsfunMap.put("last", "last");
        dsfunMap.put("first", "first");
        dsfunMap.put("colcount", "colCount");
        dsfunMap.put("field", "field");
        dsfunMap.put("fieldname", "fieldname");
        dsfunMap.put("isfield", "isfield");
        dsfunMap.put("plot", "plot");
        dsfunMap.put("top", "top");
    }

    private static void loadFunction() {
        funMap.put("sum", "sum");
        funMap.put("count", "count");
        funMap.put("avg", "avg");
        funMap.put("average", "avg");
        funMap.put("max", "max");
        funMap.put("min", "min");
        funMap.put("list", "list");
        funMap.put("map", "map");
        funMap.put("string", "str");
        funMap.put("str", "str");
        funMap.put("float", "float");
        funMap.put("if", "if");
        funMap.put("nvl", "nvl");
        funMap.put("case", "if");
        funMap.put("ds", "ds");
        funMap.put("query", "query");
        funMap.put("query2", "query2");
        funMap.put("sql", "query");
        funMap.put("call", "call");
        funMap.put("call2", "call2");
        funMap.put("row", "row");
        funMap.put("col", "col");
        funMap.put("disp", "disp");
        funMap.put("eval", "eval");
        funMap.put("plot", "plot");
        funMap.put("sort", "sort");
        funMap.put("maxwidth", "maxWidth");
        funMap.put("hexstring", "hexString");
        funMap.put("date_time", "datetime");
        funMap.put("datetime", "datetime");
        funMap.put("datetime2", "datetime2");
        funMap.put("day", "day");
        funMap.put("day_name", "dayName");
        funMap.put("dayname", "dayName");
        funMap.put("day_number", "dayNo");
        funMap.put("daynum", "dayNo");
        funMap.put("days_after", "daysAfter");
        funMap.put("daysafter", "daysAfter");
        funMap.put("hour", "hour");
        funMap.put("minute", "minute");
        funMap.put("month", "month");
        funMap.put("monthend", "monthEnd");
        funMap.put("monthbegin", "monthBegin");
        funMap.put("quaterbegin", "quaterBegin");
        funMap.put("quaterend", "quaterEnd");
        funMap.put("lastmonth", "lastMonth");
        funMap.put("lastyear", "lastYear");
        funMap.put("relative_date", "relDate");
        funMap.put("reldate", "relDate");
        funMap.put("relative_time", "relTime");
        funMap.put("reltime", "relTime");
        funMap.put("second", "second");
        funMap.put("seconds_after", "secondsAfter");
        funMap.put("secondsafter", "secondsAfter");
        funMap.put("date", "date");
        funMap.put("time", "time");
        funMap.put("year", "year");
        funMap.put("now", "now");
        funMap.put("daysinmonth", "daysInMonth");
        funMap.put("daysinyear", "daysInYear");
        funMap.put("weekbegin", "weekBegin");
        funMap.put("weekend", "weekEnd");
        funMap.put("lastday", "lastDay");
        funMap.put("abs", "abs");
        funMap.put("ceil", "ceil");
        funMap.put("cos", "cos");
        funMap.put("exp", "exp");
        funMap.put("fact", "fact");
        funMap.put("log", "log");
        funMap.put("log10", "log10");
        funMap.put("pi", "pi");
        funMap.put("pow", "pow");
        funMap.put("rand", "rand");
        funMap.put("round", "round");
        funMap.put("sign", "sign");
        funMap.put("sin", "sin");
        funMap.put("sqrt", "sqrt");
        funMap.put("tan", "tan");
        funMap.put("floor", "floor");
        funMap.put("fill", "fill");
        funMap.put("left", "left");
        funMap.put("left_trim", "ltrim");
        funMap.put("ltrim", "ltrim");
        funMap.put("len", "len");
        funMap.put("lower", "lower");
        funMap.put("mid", "mid");
        funMap.put("pos", "pos");
        funMap.put("right", "right");
        funMap.put("rtrim", "rtrim");
        funMap.put("right_trim", "rtrim");
        funMap.put("space", "space");
        funMap.put("trim", "trim");
        funMap.put("upper", "upper");
        funMap.put("word_cap", "wordCap");
        funMap.put("like2", "like");
        funMap.put("rmvquote", "rmQuote");
        funMap.put("rplcstring", "rplc");
        funMap.put("split", "split");
        funMap.put("integer", "int");
        funMap.put("int", "int");
        funMap.put("toint", "int");
        funMap.put("long", "long");
        funMap.put("double", "double");
        funMap.put("number", "number");
        funMap.put("asc", "asc");
        funMap.put("char", "char");
        funMap.put("isdate", "isDate");
        funMap.put("isnumber", "isNumber");
        funMap.put("istime", "isTime");
        funMap.put("rmb", "rmb");
        funMap.put("chn", "chn");
        funMap.put("rgb", "rgb");
        funMap.put("bigint", "bigint");
        funMap.put("decimal", "decimal");
        funMap.put("valueat", "valueAt");
    }

    private String scanId() {
        int len = this.expStr.length();
        int begin = this.location;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') break;
            ++this.location;
        }
        return this.expStr.substring(begin, this.location);
    }

    protected String scanParameter(Context ctx) {
        char c;
        int len = this.expStr.length();
        while (this.location < len) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == len) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingParam"));
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingParam"));
        }
        int match = Sentence.scanParenthesis(this.expStr, this.location);
        if (match == -1) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
        }
        String param = this.expStr.substring(this.location + 1, match);
        this.location = match + 1;
        return param;
    }

    private static String setMoveParameter(String param, CellSet cs, Context ctx, DataSet ds) {
        String paramStr = "";
        ArgumentTokenizer arg = new ArgumentTokenizer(param == null ? null : param.trim(), ';');
        String left = null;
        String top = null;
        String moveStr = null;
        if (arg.hasNext()) {
            left = arg.next();
        }
        if (arg.hasNext()) {
            top = arg.next();
        }
        if (left != null && left.length() > 0) {
            arg = new ArgumentTokenizer(left, ',');
            if (arg.hasNext() && (moveStr = arg.next()).length() > 0 && left != null) {
                paramStr = paramStr + ExpParse.setScopeMove(moveStr, cs, ctx);
            }
            while (arg.hasNext()) {
                moveStr = arg.next();
                if (moveStr.length() <= 0) continue;
                paramStr = paramStr + ',' + ExpParse.setScopeMove(moveStr, cs, ctx);
            }
        }
        if (top != null && top.length() > 0) {
            paramStr = paramStr + ';';
            arg = new ArgumentTokenizer(top, ',');
            if (arg.hasNext() && (moveStr = arg.next()).length() > 0) {
                paramStr = paramStr + ExpParse.setScopeMove(moveStr, cs, ctx);
            }
            while (arg.hasNext()) {
                moveStr = arg.next();
                if (moveStr.length() <= 0) continue;
                paramStr = paramStr + ',' + ExpParse.setScopeMove(moveStr, cs, ctx);
            }
        }
        return paramStr;
    }

    private static String setParameter(String param, CellSet cs, Context ctx, DataSet ds) {
        ExpParse exp;
        String token;
        String paramStr = "";
        ArgumentTokenizer arg = new ArgumentTokenizer(param == null ? null : param.trim(), ',');
        if (arg.hasNext()) {
            token = arg.next().trim();
            exp = null;
            if (token.length() > 0) {
                exp = new ExpParse(cs, ctx, ds, token);
                paramStr = paramStr + exp.newStr;
            }
        }
        while (arg.hasNext()) {
            token = arg.next().trim();
            exp = null;
            paramStr = paramStr + ',';
            if (token.length() <= 0) continue;
            exp = new ExpParse(cs, ctx, ds, token);
            paramStr = paramStr + exp.newStr;
        }
        return paramStr;
    }

    private static String setScopeMove(String moveStr, CellSet cs, Context ctx) {
        ArgumentTokenizer arg = new ArgumentTokenizer(moveStr, ':');
        String source = null;
        String position = "";
        if (arg.hasNext() && (source = arg.next()) != null) {
            source = source.trim();
        }
        if (arg.hasNext()) {
            position = arg.next();
        }
        if (!ExpParse.isSource(cs, source)) {
            position = source;
            source = null;
        }
        if (source != null) {
            if (!ExpParse.isSource(cs, source)) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("Move.unknownCell") + source);
            }
            if (position.length() > 0) {
                return source.toUpperCase() + ':' + position;
            }
            return source.toUpperCase();
        }
        return position;
    }

    private void tansferToOrLike(int bracketPos, Context ctx) {
        int len = this.newStr.length();
        if (bracketPos < len) {
            int pos;
            String param = "";
            if (this.newStr.charAt(bracketPos) == '(') {
                int match = Sentence.scanParenthesis(this.newStr, bracketPos);
                if (match == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError("(,)" + mm.getMessage("Expression.illmacthed"));
                }
                param = this.newStr.substring(bracketPos + 1, match);
            } else {
                param = this.newStr.substring(bracketPos, len);
            }
            if (this.toLikeFlag == 1) {
                pos = param.indexOf(1);
                if (pos > 0) {
                    param = "to(" + param.substring(0, pos) + "," + param.substring(pos + 1) + ")";
                    this.newStr = this.newStr.substring(0, bracketPos) + param;
                    this.toLikeFlag = 0;
                }
            } else if (this.toLikeFlag == 2 && (pos = param.indexOf(2)) > 0) {
                param = "like(" + param.substring(0, pos) + "," + param.substring(pos + 1) + ")";
                this.newStr = this.newStr.substring(0, bracketPos) + param;
                this.toLikeFlag = 0;
            }
        }
    }

    private String transferRoot(CellSet cs, Context ctx, DataSet ds, String id) {
        String fun = id.toLowerCase();
        if (fun.equals("rgroup")) {
            String param = ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds);
            ArgumentTokenizer arg = new ArgumentTokenizer(param, ',');
            int count = arg.countTokens() - 1;
            return "group(" + param + ",,,,,,true".substring(count) + ")";
        }
        if (fun.equals("rselect")) {
            String param = ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds);
            ArgumentTokenizer arg = new ArgumentTokenizer(param, ',');
            int count = arg.countTokens() - 1;
            return "select(" + param + ",,,,true".substring(count) + ")";
        }
        if (fun.equals("rselect1") || fun.equals("rselect_one")) {
            String param = ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds);
            ArgumentTokenizer arg = new ArgumentTokenizer(param, ',');
            int count = arg.countTokens() - 1;
            return "select1(" + param + ",,true".substring(count) + ")";
        }
        if (fun.equals("rbselect1") || fun.equals("rbselect_one")) {
            String param = ExpParse.setParameter(this.scanParameter(ctx), cs, ctx, ds);
            return "rbselect1(" + param + ")";
        }
        return null;
    }
}

