/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.Segment;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.SegmentSet;
import com.runqian.base.util.Sentence;
import com.runqian.base.util.ShortMap;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.transfer.ReportInfoTransfer;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.SQLDataSetConfig;
import com.runqian.report4.usermodel.input.CheckBox;
import com.runqian.report4.usermodel.input.DDCalendar;
import com.runqian.report4.usermodel.input.DDDataWindow;
import com.runqian.report4.usermodel.input.DDListBox;
import com.runqian.report4.usermodel.input.DDTree;
import com.runqian.report4.usermodel.input.DDTreeNode;
import com.runqian.report4.usermodel.input.InputProperty;
import com.runqian.report4.usermodel.input.RelationParams;
import com.runqian.report4.usermodel.input.TableRelation;
import com.runqian.report4.usermodel.input.TableRelations;
import com.runqian.report4.usermodel.input.UpdateProperty;
import com.runqian.report4.usermodel.input.UploadFile;
import com.runqian.report4.usermodel.input.Validity;
import java.util.ArrayList;
import java.util.HashMap;

class InputTransfer {
    InputTransfer() {
    }

    private static boolean findDsName(IReport report, String dsName) {
        DataSetMetaData dsmd = report.getDataSetMetaData();
        if (dsmd == null) {
            return false;
        }
        int count = dsmd.getDataSetConfigCount();
        int i = 0;
        while (i < count) {
            DataSetConfig dsc = dsmd.getDataSetConfig(i);
            if (dsName.equalsIgnoreCase(dsc.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Object getEditConfig(String config, byte type, IReport report, CellSet cs, Context ctx) {
        switch (type) {
            case 6: {
                return InputTransfer.toDDCalendar(config);
            }
            case 4: {
                return InputTransfer.toCheckBox(config);
            }
            case 3: {
                return InputTransfer.toDDDW(config, report, cs, ctx);
            }
            case 2: {
                return InputTransfer.toListBox(config);
            }
            case 8: {
                return InputTransfer.toDDTree(config, report);
            }
            case 7: {
                return InputTransfer.toUploadFile(config);
            }
        }
        return null;
    }

    private static byte getEditStyle(Integer style) {
        if (CellPropertyDefine.CES_EDITBOX.equals(style)) {
            return 1;
        }
        if (CellPropertyDefine.CES_LISTBOX.equals(style)) {
            return 2;
        }
        if (CellPropertyDefine.CES_DATAWIN.equals(style)) {
            return 3;
        }
        if (CellPropertyDefine.CES_CHECKBOX.equals(style)) {
            return 4;
        }
        if (CellPropertyDefine.CES_CALENDAR.equals(style)) {
            return 6;
        }
        if (CellPropertyDefine.CES_UPLOAD.equals(style)) {
            return 7;
        }
        if (CellPropertyDefine.CES_TREE.equals(style)) {
            return 8;
        }
        if (CellPropertyDefine.CES_PWD.equals(style)) {
            return 9;
        }
        return 1;
    }

    private static byte getInputDataType(Integer type) {
        if (CellPropertyDefine.CIDT_TEXT.equals(type)) {
            return 1;
        }
        if (CellPropertyDefine.CIDT_NUMERIC.equals(type)) {
            return 2;
        }
        if (CellPropertyDefine.CIDT_DATE.equals(type)) {
            return 8;
        }
        if (CellPropertyDefine.CIDT_DIGITAL.equals(type)) {
            return 4;
        }
        if (CellPropertyDefine.CIDT_EMAIL.equals(type)) {
            return 5;
        }
        if (CellPropertyDefine.CIDT_INT.equals(type)) {
            return 6;
        }
        return 1;
    }

    private static int[] getIntArray(String[] sa) {
        int[] ia = new int[sa.length];
        int i = 0;
        while (i < sa.length) {
            ia[i] = Integer.parseInt(sa[i]);
            ++i;
        }
        return ia;
    }

    private static ArrayList getUpdateList(String update, CellSet cs, Context ctx) {
        ArrayList<UpdateProperty> list = new ArrayList<UpdateProperty>();
        ArgumentTokenizer at = new ArgumentTokenizer(update, '\u0000');
        while (at.hasNext()) {
            RelationParams params;
            TableRelation tr;
            String value;
            String key;
            String one = at.next();
            if (one == null || one.trim().length() <= 0) continue;
            UpdateProperty up = new UpdateProperty();
            up.setMode((byte)1);
            TableRelations trs = (TableRelations)up.getRelation();
            SegmentSet segs = new SegmentSet(one, true, ';', true);
            up.setName(segs.get("name"));
            trs.setTableName(segs.get("tbl"));
            trs.setDataSourceName(segs.get("ds"));
            String keyCol = segs.get("keyCol");
            String KeyValue = segs.get("keyValue");
            String updateCol = segs.get("updateCol");
            String updateValue = segs.get("updateValue");
            ArgumentTokenizer at1 = new ArgumentTokenizer(keyCol, ',');
            ArgumentTokenizer at2 = new ArgumentTokenizer(KeyValue, ',');
            while (at1.hasNext()) {
                key = at1.next();
                value = at2.next();
                tr = new TableRelation();
                params = tr.getRelationParams();
                tr.setFieldName(key);
                tr.setPrimaryKey(true);
                params.addParam("=" + ExpressionTransfer.transfer(value, cs, ctx), (byte)0);
                trs.addRelation(tr);
            }
            at1 = new ArgumentTokenizer(updateCol, ',');
            at2 = new ArgumentTokenizer(updateValue, ',');
            while (at1.hasNext()) {
                key = at1.next();
                value = at2.next();
                int count = trs.getRelationCount();
                int i = 0;
                while (i < count) {
                    TableRelation t = trs.getRelation(i);
                    if (key == null || key.equalsIgnoreCase(t.getFieldName())) break;
                    ++i;
                }
                if (i != count) continue;
                tr = new TableRelation();
                params = tr.getRelationParams();
                tr.setFieldName(key);
                tr.setPrimaryKey(false);
                params.addParam("=" + ExpressionTransfer.transfer(value, cs, ctx), (byte)0);
                trs.addRelation(tr);
            }
            list.add(up);
        }
        return list;
    }

    private static String getValidityExpression(CellSet cs, Context ctx, String str) {
        int len;
        if (str != null && (len = (str = str.trim()).length()) > 3) {
            int start = 0;
            int idx = 0;
            String result = "";
            while (idx < len) {
                int tmp;
                char ch = str.charAt(idx);
                if (ch == '\'' || ch == '\"') {
                    tmp = Sentence.scanQuotation((String)str, (int)idx);
                    if (tmp > 0) {
                        idx = tmp + 1;
                        continue;
                    }
                    return null;
                }
                if (ch == '$' && idx < len && str.charAt(idx + 1) == '{' && (tmp = Sentence.scanBrace((String)str, (int)(idx + 1))) > 0) {
                    if (start < idx) {
                        result = result + str.substring(start, idx);
                    }
                    result = result + "${" + ExpressionTransfer.transfer(str.substring(idx + 2, tmp), cs, ctx) + "}";
                    idx = tmp;
                    start = idx + 1;
                }
                ++idx;
            }
            if (start < len) {
                result = result + str.substring(start);
            }
            return result;
        }
        return null;
    }

    private static ArrayList getValidityList(String validity, CellSet cs, Context ctx) {
        ArrayList<Validity> list = new ArrayList<Validity>();
        ArgumentTokenizer at = new ArgumentTokenizer(validity, '\u0001');
        while (at.hasNext()) {
            String term;
            Validity vl = new Validity();
            ArgumentTokenizer at1 = new ArgumentTokenizer(at.next(), '\u0000');
            vl.setExp("=" + InputTransfer.getValidityExpression(cs, ctx, at1.next()));
            if (at1.hasNext()) {
                vl.setPrompt(at1.next());
            }
            if (at1.hasNext() && (term = at1.next()) != null) {
                term = term.trim();
                vl.setCheckNoDelay(term.equals("1"));
            }
            list.add(vl);
        }
        return list;
    }

    private static CheckBox toCheckBox(String s) {
        CheckBox cb = new CheckBox();
        Segment segs = new Segment(s);
        String cbText = segs.get("text");
        cb.setLabel(cbText);
        String cbLocation = segs.get("align").trim();
        if (cbLocation.equals("0")) {
            cb.setLabelLocation((byte)1);
        } else {
            cb.setLabelLocation((byte)2);
        }
        String cbOn = segs.get("on").trim();
        String cbOff = segs.get("off").trim();
        cb.setOnValue(cbOn);
        cb.setOffValue(cbOff);
        return cb;
    }

    private static DDCalendar toDDCalendar(String s) {
        DDCalendar ddc = new DDCalendar();
        Segment seg_6 = new Segment(s);
        String sepa = seg_6.get("separator");
        byte bsepa = 1;
        if (sepa.equals("\u65e0")) {
            bsepa = 4;
        } else if (sepa.equals("-")) {
            bsepa = 1;
        } else if (sepa.equals(".")) {
            bsepa = 2;
        } else if (sepa.equals("/")) {
            bsepa = 3;
        }
        String vType = seg_6.get("valueType");
        byte type = 11;
        type = vType.equals("\u5e74\u6708\u65e5") ? (byte)11 : (vType.equals("\u5e74\u6708") ? (byte)12 : 13);
        ddc.setSeparator(bsepa);
        ddc.setType(type);
        return ddc;
    }

    private static DDDataWindow toDDDW(String s, IReport report, CellSet cs, Context ctx) {
        String multi;
        String filterExp;
        DataSetMetaData dsmd;
        DDDataWindow dddw = new DDDataWindow();
        Segment segs = new Segment(s);
        String tbl = segs.get("tbl");
        String code = segs.get("code");
        code = code.toUpperCase();
        String disp = segs.get("disp");
        if (disp == null || disp.trim().length() == 0) {
            disp = code;
        }
        disp = disp.toUpperCase();
        String where = segs.get("where");
        String ds = segs.get("ds");
        String filter_cells = segs.get("filter_cells");
        String attach_fields = segs.get("attach_fields");
        SQLDataSetConfig dsc = new SQLDataSetConfig();
        dsc.setDataSourceName(ds);
        String dsName = "";
        int i = 1;
        while (i < 1000) {
            dsName = "dddw" + i;
            if (!InputTransfer.findDsName(report, dsName)) {
                dsc.setName(dsName);
                break;
            }
            ++i;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(code).append(", ").append(disp);
        if (attach_fields != null && attach_fields.trim().length() > 0) {
            sql.append(", ").append(attach_fields.toUpperCase());
        }
        sql.append(" from ").append(tbl);
        if (where != null && where.trim().length() > 0) {
            sql.append(" where ").append(where);
        }
        dsc.setSQL(sql.toString());
        if (where != null && where.trim().length() > 0) {
            String exps = segs.get("where_para_names");
            String types = segs.get("where_para_types");
            String[] exps_array = new Section(exps, true).toStringArray();
            int i2 = 0;
            while (i2 < exps_array.length) {
                exps_array[i2] = "=" + ExpressionTransfer.transfer(exps_array[i2], cs, ctx);
                dsc.setParamExp(i2, exps_array[i2]);
                ++i2;
            }
            int[] types_array = InputTransfer.getIntArray(new Section(types, true).toStringArray());
            int i3 = 0;
            while (i3 < types_array.length) {
                byte type = ReportInfoTransfer.getParamType(types_array[i3]);
                dsc.setParamType(i3, type);
                ++i3;
            }
        }
        if ((dsmd = report.getDataSetMetaData()) == null) {
            dsmd = new DataSetMetaData();
            report.setDataSetMetaData(dsmd);
        }
        dsmd.addDataSetConfig(dsc);
        dddw.setCodeColName(code);
        dddw.setDispColName(disp);
        dddw.setDsName(dsName);
        if (filter_cells != null && filter_cells.trim().length() > 0) {
            dddw.setFilterCellName(filter_cells.trim().toUpperCase());
        }
        if ((filterExp = segs.get("filter_exp")) != null && filterExp.trim().length() > 0) {
            dddw.setFilterExp(filterExp.trim());
        }
        if ((multi = segs.get("multiselect")) != null && multi.equals("1")) {
            dddw.setMultiSelect(true);
        }
        return dddw;
    }

    private static DDTree toDDTree(String s, IReport report) {
        DDTree tree = new DDTree();
        Segment seg = new Segment(s);
        String treeName = seg.get("name");
        tree.setRootTitle(treeName);
        tree.setHeight(Short.parseShort(seg.get("h")));
        tree.setWidth(Short.parseShort(seg.get("w")));
        tree.setLoopLastNode("1".equals(seg.get("loop")));
        tree.setOnlySelectLeaf("1".equals(seg.get("leafonly")));
        ArrayList<DDTreeNode> al = new ArrayList<DDTreeNode>();
        int count = Integer.parseInt(seg.get("count"));
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < count) {
            String ds = seg.get("ds" + i);
            String tbl = seg.get("table" + i).toUpperCase();
            String code = seg.get("code" + i).toUpperCase();
            String disp = seg.get("disp" + i).toUpperCase();
            String mapKey = ds + tbl + code + disp;
            String dsName = (String)map.get(mapKey);
            if (dsName == null) {
                SQLDataSetConfig dsc = new SQLDataSetConfig();
                dsc.setDataSourceName(ds);
                int k = 1;
                while (k < 1000) {
                    dsName = "tree" + k;
                    if (!InputTransfer.findDsName(report, dsName)) {
                        dsc.setName(dsName);
                        break;
                    }
                    ++k;
                }
                StringBuffer sql = new StringBuffer();
                sql.append("select ").append(code).append(", ").append(disp);
                sql.append(" from ").append(tbl);
                dsc.setSQL(sql.toString());
                DataSetMetaData dsmd = report.getDataSetMetaData();
                if (dsmd == null) {
                    dsmd = new DataSetMetaData();
                    report.setDataSetMetaData(dsmd);
                }
                dsmd.addDataSetConfig(dsc);
                map.put(mapKey, dsName);
            }
            String where = seg.get("where" + i);
            DDTreeNode node = new DDTreeNode();
            node.setCodeColName(code);
            node.setDispColName(disp);
            node.setDsName(dsName);
            node.setWhere(where);
            al.add(node);
            ++i;
        }
        tree.setNodes(al);
        return tree;
    }

    private static DDListBox toListBox(String s) {
        DDListBox ddlb = new DDListBox();
        Segment seg = new Segment(s);
        String tmpCfg = seg.get("list");
        if (tmpCfg != null && tmpCfg.trim().length() > 0) {
            ArgumentTokenizer at = new ArgumentTokenizer(tmpCfg, ';');
            while (at.hasMoreTokens()) {
                ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), ',');
                String code = at1.nextToken();
                if (code == null || code.trim().length() == 0) continue;
                code = code.trim();
                String disp = at1.nextToken();
                ddlb.setItem(code, disp);
            }
        }
        return ddlb;
    }

    private static UploadFile toUploadFile(String s) {
        UploadFile uf = new UploadFile();
        ArrayList<String> al = new ArrayList<String>();
        if (s == null || s.trim().length() == 0) {
            al.add("*.*");
        } else {
            ArgumentTokenizer at = new ArgumentTokenizer(s, ',');
            while (at.hasMoreTokens()) {
                al.add(at.nextToken().trim());
            }
        }
        uf.setExtNames(al);
        return uf;
    }

    static InputProperty transfer(ShortMap exps, IReport report, CellSet cs, Context ctx, boolean newInput) {
        Object update = exps.get((short)4801);
        Object validity = exps.get((short)4803);
        Object writable = exps.get((short)4804);
        Object editStyle = exps.get((short)4805);
        Object editConfig = exps.get((short)4806);
        Object autoCalc = exps.get((short)4807);
        Object dataType = exps.get((short)4810);
        InputProperty ip = new InputProperty();
        boolean prop = false;
        if (autoCalc != null) {
            ip.setAutoCalc("=" + InputTransfer.getValidityExpression(cs, ctx, (String)autoCalc));
            prop = true;
        }
        if (writable == null || writable instanceof Boolean && ((Boolean)writable).booleanValue()) {
            ip.setWritable(true);
            prop = true;
        }
        if (update != null) {
            ip.setUpdateList(InputTransfer.getUpdateList((String)update, cs, ctx));
            prop = true;
        }
        if (validity != null) {
            ip.setValidityList(InputTransfer.getValidityList((String)validity, cs, ctx));
            prop = true;
        }
        if (editStyle != null) {
            byte type = InputTransfer.getEditStyle((Integer)editStyle);
            if (editConfig != null) {
                ip.setEditConfig(InputTransfer.getEditConfig((String)editConfig, type, report, cs, ctx));
            }
            ip.setEditStyle(type);
            prop = true;
        }
        if (dataType != null) {
            ip.setInputType(InputTransfer.getInputDataType((Integer)dataType));
        }
        if (prop) {
            return ip;
        }
        return null;
    }
}

