/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.util.ShortMap;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Escape;
import com.runqian.base4.util.Sentence;
import com.runqian.report.cellset.Cell;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.model.Pager;
import com.runqian.report4.transfer.BarcodeTransfer;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.transfer.GraphTransfer;
import com.runqian.report4.transfer.InputTransfer;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.SubRptProperty;
import java.util.ArrayList;

class NormalCellTransfer {
    NormalCellTransfer() {
    }

    private static byte getAdjustMode(Integer mode) {
        if (CellPropertyDefine.CAS_EXTEND.equals(mode)) {
            return 48;
        }
        if (CellPropertyDefine.CAS_FIXED.equals(mode)) {
            return 49;
        }
        if (CellPropertyDefine.CAS_FILL.equals(mode)) {
            return 50;
        }
        if (CellPropertyDefine.CAS_SHRINK.equals(mode)) {
            return 51;
        }
        return 49;
    }

    private static byte getDatatype(Integer type) {
        if (CellPropertyDefine.CDT_TEXT.equals(type)) {
            return -64;
        }
        if (CellPropertyDefine.CDT_PIC_FILE.equals(type)) {
            return -63;
        }
        if (CellPropertyDefine.CDT_PIC_DB.equals(type)) {
            return -62;
        }
        if (CellPropertyDefine.CDT_GRAPH.equals(type)) {
            return -61;
        }
        if (CellPropertyDefine.CDT_SUBREPORT.equals(type)) {
            return -60;
        }
        if (CellPropertyDefine.CDT_BLANK.equals(type)) {
            return -59;
        }
        if (CellPropertyDefine.CDT_HTML.equals(type)) {
            return -58;
        }
        if (CellPropertyDefine.CDT_BARCODE.equals(type)) {
            return -57;
        }
        return -64;
    }

    private static Area getExtendArea(String area) {
        if (area != null && area.toString().trim().length() > 6) {
            int m = area.indexOf(45);
            int n = area.indexOf(44);
            int startRow = Integer.parseInt(area.substring(0, n));
            int startCol = Integer.parseInt(area.substring(n + 1, m));
            n = area.indexOf(44, m + 1);
            int endRow = Integer.parseInt(area.substring(m + 1, n));
            int endCol = Integer.parseInt(area.substring(n + 1));
            if (startRow > 0 && startCol > 0 && endRow >= startRow && endCol >= startCol) {
                return new Area(startRow, (short)startCol, endRow, (short)endCol);
            }
        }
        return null;
    }

    private static byte getExtendMode(Integer mode) {
        if (CellPropertyDefine.CEX_NONE.equals(mode)) {
            return 17;
        }
        if (CellPropertyDefine.CEX_VERTICAL.equals(mode)) {
            return 18;
        }
        if (CellPropertyDefine.CEX_HORIZONTAL.equals(mode)) {
            return 19;
        }
        if (CellPropertyDefine.CEX_DEFAULT.equals(mode)) {
            return 16;
        }
        return 16;
    }

    private static byte getHAlign(Integer value) {
        if (CellPropertyDefine.CA_LEFT.equals(value)) {
            return -48;
        }
        if (CellPropertyDefine.CA_CENTER.equals(value)) {
            return -47;
        }
        if (CellPropertyDefine.CA_RIGHT.equals(value)) {
            return -46;
        }
        return -48;
    }

    private static byte getLineStyle(Integer style) {
        if (CellPropertyDefine.CBS_NONE.equals(style)) {
            return 80;
        }
        if (CellPropertyDefine.CBS_DOTTED.equals(style)) {
            return 81;
        }
        if (CellPropertyDefine.CBS_DASHED.equals(style)) {
            return 82;
        }
        if (CellPropertyDefine.CBS_SOLID.equals(style)) {
            return 83;
        }
        if (CellPropertyDefine.CBS_DOUBLE.equals(style)) {
            return 84;
        }
        return 80;
    }

    private static float getLineWidth(Integer width) {
        if (CellPropertyDefine.CLL_075_LINE.equals(width)) {
            return 0.75f;
        }
        if (CellPropertyDefine.CLL_100_LINE.equals(width)) {
            return 1.0f;
        }
        if (CellPropertyDefine.CLL_150_LINE.equals(width)) {
            return 1.5f;
        }
        if (CellPropertyDefine.CLL_200_LINE.equals(width)) {
            return 2.0f;
        }
        if (CellPropertyDefine.CLL_300_LINE.equals(width)) {
            return 3.0f;
        }
        return 10000.0f;
    }

    private static SubRptProperty getSubRptProperty(String param, CellSet cs, Context ctx) {
        String tp;
        String paramValue;
        int i;
        int count;
        ArrayList<String> list;
        ArgumentTokenizer atm;
        String value;
        String fun;
        int match;
        int pos;
        String paramName;
        SubRptProperty srp = new SubRptProperty();
        ArgumentTokenizer at = new ArgumentTokenizer(param, ',');
        int type = 1;
        if (at.hasNext()) {
            srp.setName(at.next().trim());
        }
        if (at.hasNext() && (paramName = at.next()) != null && (pos = paramName.indexOf(40)) > 0 && (match = Sentence.scanParenthesis(paramName, pos)) > 0) {
            fun = paramName.substring(0, pos).trim();
            value = paramName.substring(pos + 1, match);
            if ("list".equalsIgnoreCase(fun)) {
                atm = new ArgumentTokenizer(value, ',');
                list = new ArrayList<String>();
                while (atm.hasNext()) {
                    list.add(Escape.removeEscAndQuote(atm.next()));
                }
                count = list.size();
                String[] names = new String[count];
                i = 0;
                while (i < count) {
                    names[i] = (String)list.get(i);
                    ++i;
                }
                srp.setArgNames(names);
            }
        }
        if (at.hasNext() && (paramValue = at.next()) != null && (pos = paramValue.indexOf(40)) > 0 && (match = Sentence.scanParenthesis(paramValue, pos)) > 0) {
            fun = paramValue.substring(0, pos).trim();
            value = paramValue.substring(pos + 1, match);
            if ("list".equalsIgnoreCase(fun)) {
                atm = new ArgumentTokenizer(value, ',');
                list = new ArrayList();
                while (atm.hasNext()) {
                    list.add("=" + ExpressionTransfer.transfer(atm.next(), cs, ctx));
                }
                count = list.size();
                String[] values = new String[count];
                i = 0;
                while (i < count) {
                    values[i] = (String)list.get(i);
                    ++i;
                }
                srp.setArgExps(values);
            }
        }
        if (at.hasNext() && Integer.parseInt(tp = at.next()) != 0) {
            type = 2;
        }
        srp.setType((byte)type);
        return srp;
    }

    private static byte getVAlign(Integer value) {
        if (CellPropertyDefine.CVA_TOP.equals(value)) {
            return -32;
        }
        if (CellPropertyDefine.CVA_MIDDLE.equals(value)) {
            return -31;
        }
        if (CellPropertyDefine.CVA_BOTTOM.equals(value)) {
            return -30;
        }
        return -32;
    }

    private static void parserOther(INormalCell cell, byte cellType, ByteMap expMap, String value, CellSet cs, Context ctx) {
        int match;
        int pos;
        if (cellType == -61) {
            int match2;
            int pos2 = value.indexOf(40);
            if (pos2 > 0 && (match2 = Sentence.scanParenthesis(value, pos2)) > 0) {
                String fun = value.substring(0, pos2).trim();
                String param = value.substring(pos2 + 1, match2);
                if ("graph".equalsIgnoreCase(fun)) {
                    cell.setGraphProperty(GraphTransfer.transfer(param, cs, ctx));
                    expMap.add((byte)40, "graph()");
                }
            }
        } else if (cellType == -57) {
            int match3;
            int pos3 = value.indexOf(40);
            if (pos3 > 0 && (match3 = Sentence.scanParenthesis(value, pos3)) > 0) {
                String fun = value.substring(0, pos3).trim();
                String param = value.substring(pos3 + 1, match3);
                if ("barcode".equalsIgnoreCase(fun)) {
                    cell.setBarcodeProperty(BarcodeTransfer.transfer(param, cs, ctx));
                    expMap.add((byte)40, "barcode()");
                }
            }
        } else if (cellType == -60 && (pos = value.indexOf(40)) > 0 && (match = Sentence.scanParenthesis(value, pos)) > 0) {
            String fun = value.substring(0, pos).trim();
            String param = value.substring(pos + 1, match);
            if ("subrpt".equalsIgnoreCase(fun)) {
                cell.setSubRptProperty(NormalCellTransfer.getSubRptProperty(param, cs, ctx));
                expMap.add((byte)40, "subReport()");
            }
        }
    }

    private static void setExpressions(INormalCell cell, ShortMap exps, byte cellType, CellSet cs, Context ctx) {
        int count = exps.size();
        ByteMap expMap = new ByteMap((short)count);
        Object value = exps.get((short)4102);
        if (value != null) {
            if (cellType == -64) {
                expMap.add((byte)40, ExpressionTransfer.transfer((String)value, cs, ctx));
            } else {
                NormalCellTransfer.parserOther(cell, cellType, expMap, (String)value, cs, ctx);
            }
        }
        int i = 0;
        while (i < count) {
            short key = exps.getKey(i);
            value = exps.getValue(i);
            byte newKey = -1;
            switch (key) {
                case 4201: {
                    newKey = 22;
                    break;
                }
                case 4108: {
                    newKey = 35;
                    break;
                }
                case 4413: {
                    newKey = 53;
                    break;
                }
                case 4412: {
                    newKey = 71;
                    break;
                }
                case 4410: {
                    newKey = 63;
                    break;
                }
                case 4411: {
                    newKey = 67;
                    break;
                }
                case 4101: {
                    newKey = 20;
                    break;
                }
                case 4104: {
                    newKey = 49;
                    break;
                }
                case 4105: {
                    newKey = 41;
                    break;
                }
                case 4701: {
                    newKey = 54;
                    break;
                }
                case 4703: {
                    newKey = 55;
                    break;
                }
                case 4203: {
                    newKey = 42;
                    break;
                }
                case 4403: {
                    newKey = 68;
                    break;
                }
                case 4401: {
                    newKey = 60;
                    break;
                }
                case 4402: {
                    newKey = 64;
                    break;
                }
                case 4406: {
                    newKey = 69;
                    break;
                }
                case 4404: {
                    newKey = 61;
                    break;
                }
                case 4405: {
                    newKey = 65;
                    break;
                }
                case 4304: {
                    newKey = 45;
                    break;
                }
                case 4303: {
                    newKey = 52;
                    break;
                }
                case 4301: {
                    newKey = 43;
                    break;
                }
                case 4305: {
                    newKey = 46;
                    break;
                }
                case 4302: {
                    newKey = 44;
                    break;
                }
                case 4306: {
                    newKey = 47;
                    break;
                }
                case 4409: {
                    newKey = 70;
                    break;
                }
                case 4407: {
                    newKey = 62;
                    break;
                }
                case 4408: {
                    newKey = 66;
                    break;
                }
                case 4202: {
                    newKey = 23;
                    break;
                }
                case 4106: {
                    newKey = 48;
                    break;
                }
                case 4111: {
                    newKey = 50;
                    break;
                }
                case 4112: {
                    newKey = 51;
                    break;
                }
                case 4107: {
                    newKey = 27;
                    break;
                }
                case 4109: {
                    newKey = 37;
                    break;
                }
                case 3102: {
                    newKey = 33;
                    break;
                }
                case 2103: {
                    newKey = 34;
                    break;
                }
                case 4501: {
                    newKey = 28;
                    break;
                }
                case 4103: {
                    newKey = 21;
                    break;
                }
                case 4706: {
                    newKey = 81;
                    break;
                }
                case 4705: {
                    newKey = 57;
                    break;
                }
                case 4414: {
                    newKey = 24;
                    break;
                }
                case 4415: {
                    newKey = 25;
                    break;
                }
                case 4502: {
                    newKey = 30;
                    break;
                }
                case 4503: {
                    newKey = 31;
                    break;
                }
                case 4602: {
                    newKey = 32;
                    break;
                }
                case 4804: {
                    newKey = 80;
                    break;
                }
                case 4702: {
                    newKey = 56;
                }
            }
            if (newKey != -1 && value != null) {
                expMap.add(newKey, ExpressionTransfer.transfer((String)value, cs, ctx));
            }
            ++i;
        }
        cell.setExpMap(expMap);
    }

    private static void setValues(INormalCell cell, ShortMap values, byte unit, IReport report, CellSet cs, Context ctx, byte input, boolean newInput) {
        int count = values.size();
        float width = 0.0f;
        if (input == 1) {
            cell.setInputProperty(InputTransfer.transfer(values, report, cs, ctx, newInput));
        }
        int i = 0;
        while (i < count) {
            short key = values.getKey(i);
            Object value = values.getValue(i);
            switch (key) {
                case 4201: {
                    cell.setHAlign(NormalCellTransfer.getHAlign((Integer)value));
                    break;
                }
                case 4108: {
                    cell.setStretchWhenPaged((Boolean)value);
                    break;
                }
                case 4413: {
                    cell.setBackColor(((Number)value).intValue());
                    break;
                }
                case 4412: {
                    cell.setBBColor(((Number)value).intValue());
                    break;
                }
                case 4410: {
                    cell.setBBStyle(NormalCellTransfer.getLineStyle((Integer)value));
                    break;
                }
                case 4411: {
                    cell.setBBWidth(((Number)value).floatValue());
                    break;
                }
                case 4101: {
                    cell.setCellType(NormalCellTransfer.getDatatype((Integer)value));
                    break;
                }
                case 4102: {
                    cell.setValue(value);
                    break;
                }
                case 4104: {
                    cell.setFormat((String)value);
                    break;
                }
                case 4105: {
                    cell.setDispValue((String)value);
                    break;
                }
                case 4701: {
                    cell.setHyperlink((String)value);
                    break;
                }
                case 4703: {
                    cell.setHyperlinkWindow((String)value);
                    break;
                }
                case 4203: {
                    cell.setIndent(Pager.unUnitTransfer(((Number)value).intValue(), unit));
                    break;
                }
                case 4403: {
                    cell.setLBColor(((Number)value).intValue());
                    break;
                }
                case 4401: {
                    cell.setLBStyle(NormalCellTransfer.getLineStyle((Integer)value));
                    break;
                }
                case 4402: {
                    cell.setLBWidth(((Number)value).floatValue());
                    break;
                }
                case 4406: {
                    cell.setRBColor(((Number)value).intValue());
                    break;
                }
                case 4404: {
                    cell.setRBStyle(NormalCellTransfer.getLineStyle((Integer)value));
                    break;
                }
                case 4405: {
                    cell.setRBWidth(((Number)value).floatValue());
                    break;
                }
                case 4304: {
                    cell.setBold((Boolean)value);
                    break;
                }
                case 4303: {
                    cell.setForeColor(((Number)value).intValue());
                    break;
                }
                case 4301: {
                    cell.setFontName((String)value);
                    break;
                }
                case 4305: {
                    cell.setItalic((Boolean)value);
                    break;
                }
                case 4302: {
                    cell.setFontSize(((Number)value).shortValue());
                    break;
                }
                case 4306: {
                    cell.setUnderline((Boolean)value);
                    break;
                }
                case 4409: {
                    cell.setTBColor(((Number)value).intValue());
                    break;
                }
                case 4407: {
                    cell.setTBStyle(NormalCellTransfer.getLineStyle((Integer)value));
                    break;
                }
                case 4408: {
                    cell.setTBWidth(((Number)value).floatValue());
                    break;
                }
                case 4202: {
                    cell.setVAlign(NormalCellTransfer.getVAlign((Integer)value));
                    break;
                }
                case 4106: {
                    cell.setVisible((Boolean)value);
                    break;
                }
                case 4111: {
                    cell.setRowHidden((Boolean)value);
                    break;
                }
                case 4112: {
                    cell.setColHidden((Boolean)value);
                    break;
                }
                case 4107: {
                    cell.setTextWrap((Boolean)value);
                    break;
                }
                case 4109: {
                    cell.setAdjustSizeMode(NormalCellTransfer.getAdjustMode((Integer)value));
                    break;
                }
                case 3102: {
                    cell.setBreakPageAfterRow((Boolean)value);
                    break;
                }
                case 2103: {
                    cell.setBreakPageAfterCol((Boolean)value);
                    break;
                }
                case 4501: {
                    cell.setExtendMode(NormalCellTransfer.getExtendMode((Integer)value));
                    break;
                }
                case 4103: {
                    cell.setMergedArea(NormalCellTransfer.getExtendArea((String)value));
                    break;
                }
                case 4706: {
                    cell.setNotes((String)value);
                    break;
                }
                case 4705: {
                    cell.setTip((String)value);
                    break;
                }
                case 4414: {
                    width = NormalCellTransfer.getLineWidth((Integer)value);
                    if (width > 100.0f) {
                        cell.setDiagonalStyle((byte)80);
                        cell.setDiagonalWidth(0.0f);
                        break;
                    }
                    cell.setDiagonalStyle((byte)83);
                    cell.setDiagonalWidth(width);
                    break;
                }
                case 4415: {
                    cell.setDiagonalColor(((Number)value).intValue());
                    break;
                }
                case 4502: {
                    cell.setLeftHead(((String)value).toUpperCase());
                    break;
                }
                case 4503: {
                    cell.setTopHead(((String)value).toUpperCase());
                    break;
                }
                case 4602: {
                    cell.setSplitted((Boolean)value);
                    break;
                }
                case 4804: {
                    cell.setModified((Boolean)value);
                    break;
                }
                case 4702: {
                    cell.setVarName((String)value);
                }
            }
            ++i;
        }
    }

    static void transfer(INormalCell cell, Cell cl, IReport report, CellSet cs, Context ctx, byte unit, byte input, boolean newInput) {
        ShortMap values = cl.getValuesMap();
        if (values != null) {
            NormalCellTransfer.setValues(cell, values, unit, report, cs, ctx, input, newInput);
        }
        byte type = cell.getCellType();
        ShortMap exps = cl.getExpressionsMap();
        if (exps != null) {
            NormalCellTransfer.setExpressions(cell, exps, type, cs, ctx);
        }
    }
}

