/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.util.ShortMap;
import com.runqian.report.cellset.Cell;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.model.Pager;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IRowCell;

class RowCellTransfer {
    RowCellTransfer() {
    }

    private static byte getRowType(Integer type) {
        if (CellPropertyDefine.CRT_TITLE.equals(type)) {
            return -96;
        }
        if (CellPropertyDefine.CRT_TABLE_HEADER.equals(type)) {
            return -95;
        }
        if (CellPropertyDefine.CRT_TABLE_FOOTER.equals(type)) {
            return -89;
        }
        if (CellPropertyDefine.CRT_PAGE_HEADER.equals(type)) {
            return -93;
        }
        if (CellPropertyDefine.CRT_PAGE_FOOTER.equals(type)) {
            return -92;
        }
        if (CellPropertyDefine.CRT_NORMAL.equals(type)) {
            return -91;
        }
        return -91;
    }

    private static void setExpressions(IRowCell cell, ShortMap exps, CellSet cs, Context ctx) {
        int count = exps.size();
        ByteMap expMap = new ByteMap(4);
        int i = 0;
        while (i < count) {
            short key = exps.getKey(i);
            Object value = exps.getValue(i);
            byte newKey = -1;
            switch (key) {
                case 3103: {
                    newKey = 0;
                    break;
                }
                case 3101: {
                    newKey = 1;
                    break;
                }
                case 4106: {
                    newKey = 2;
                    break;
                }
                case 3102: {
                    newKey = 3;
                    break;
                }
                case 4706: {
                    newKey = 4;
                }
            }
            if (newKey != -1) {
                String newValue = ExpressionTransfer.transfer((String)value, cs, ctx);
                expMap.put(newKey, newValue);
            }
            ++i;
        }
        if (count > 0) {
            cell.setExpMap(expMap);
        }
    }

    private static void setValues(IRowCell cell, ShortMap values, byte unit) {
        int count = values.size();
        int i = 0;
        while (i < count) {
            short key = values.getKey(i);
            Object value = values.getValue(i);
            switch (key) {
                case 3103: {
                    cell.setRowType(RowCellTransfer.getRowType((Integer)value));
                    break;
                }
                case 3101: {
                    cell.setRowHeight(Pager.unUnitTransfer(((Number)value).floatValue(), unit));
                    break;
                }
                case 4106: {
                    cell.setRowVisible((Boolean)value);
                    break;
                }
                case 3102: {
                    cell.setBreakPage((Boolean)value);
                    break;
                }
                case 4706: {
                    cell.setNotes((String)value);
                }
            }
            ++i;
        }
    }

    static void transfer(IRowCell cell, Cell cl, CellSet cs, Context ctx, byte unit) {
        ShortMap exps;
        ShortMap values = cl.getValuesMap();
        if (values != null) {
            RowCellTransfer.setValues(cell, values, unit);
        }
        if ((exps = cl.getExpressionsMap()) != null) {
            RowCellTransfer.setExpressions(cell, exps, cs, ctx);
        }
    }
}

