/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.usermodel;

import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.ICloneable;
import com.runqian.report4.usermodel.IRecord;
import com.runqian.report4.util.ByteArrayInputRecord;
import com.runqian.report4.util.ByteArrayOutputRecord;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ByteMap
implements IByteMap,
ICloneable,
Externalizable,
IRecord {
    private static final long serialVersionUID = 1L;
    private transient byte[] _$1;
    private transient Object[] _$2;
    private transient short _$3;

    public ByteMap() {
        this(11);
    }

    public ByteMap(short s) {
        if (s < 0) {
            throw new IllegalArgumentException();
        }
        this._$1 = new byte[s];
        this._$2 = new Object[s];
    }

    public void add(byte by, Object object) {
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        if (this._$3 >= byArray.length) {
            int n = (int)((double)this._$3 * 1.1) + 1;
            this._$1 = new byte[n];
            this._$2 = new Object[n];
            System.arraycopy(byArray, 0, this._$1, 0, this._$3);
            System.arraycopy(objectArray, 0, this._$2, 0, this._$3);
        }
        this._$1[this._$3] = by;
        this._$2[this._$3] = object;
        this._$3 = (short)(this._$3 + 1);
    }

    public void addAll(IByteMap iByteMap) {
        this.ensureCapacity(this._$3 + iByteMap.size());
        int n = 0;
        while (n < iByteMap.size()) {
            this.add(iByteMap.getKey(n), iByteMap.getValue(n));
            ++n;
        }
    }

    public void clear() {
        this._$3 = 0;
        int n = 0;
        while (n < this._$2.length) {
            this._$2[n] = null;
            ++n;
        }
    }

    public boolean contains(Object object) {
        Object[] objectArray = this._$2;
        if (object != null) {
            int n = 0;
            while (n < this._$3) {
                if (object.equals(objectArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean containsKey(byte by) {
        byte[] byArray = this._$1;
        int n = 0;
        while (n < this._$3) {
            if (byArray[n] == by) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object deepClone() {
        short s = this._$3;
        ByteMap byteMap = new ByteMap(s);
        new ByteMap(s)._$3 = s;
        System.arraycopy(this._$1, 0, byteMap._$1, 0, s);
        Object[] objectArray = this._$2;
        Object[] objectArray2 = byteMap._$2;
        short s2 = 0;
        while (s2 < s) {
            Object object = objectArray[s2];
            objectArray2[s2] = object instanceof ICloneable ? ((ICloneable)object).deepClone() : object;
            s2 = (short)(s2 + 1);
        }
        return byteMap;
    }

    public void ensureCapacity(int n) {
        if (n > this._$1.length) {
            byte[] byArray = this._$1;
            Object[] objectArray = this._$2;
            this._$1 = new byte[n];
            this._$2 = new Object[n];
            System.arraycopy(byArray, 0, this._$1, 0, this._$3);
            System.arraycopy(objectArray, 0, this._$2, 0, this._$3);
        }
    }

    public void fillRecord(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord byteArrayInputRecord = new ByteArrayInputRecord(byArray);
        this._$3 = byteArrayInputRecord.readShort();
        byte[] byArray2 = new byte[this._$3];
        Object[] objectArray = new Object[this._$3];
        int n = 0;
        while (n < this._$3) {
            byArray2[n] = byteArrayInputRecord.readByte();
            objectArray[n] = byteArrayInputRecord.readObject(true);
            ++n;
        }
        this._$1 = byArray2;
        this._$2 = objectArray;
    }

    public Object get(byte by) {
        byte[] byArray = this._$1;
        int n = this._$3 - 1;
        while (n >= 0) {
            if (byArray[n] == by) {
                return this._$2[n];
            }
            --n;
        }
        return null;
    }

    public int getIndex(byte by) {
        byte[] byArray = this._$1;
        int n = this._$3 - 1;
        while (n >= 0) {
            if (byArray[n] == by) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public byte getKey(int n) {
        return this._$1[n];
    }

    public Object getValue(int n) {
        return this._$2[n];
    }

    public boolean isEmpty() {
        return this._$3 == 0;
    }

    public static void main(String[] stringArray) throws Exception {
        ByteMap byteMap = new ByteMap();
        byteMap.add((byte)1, "abc");
        byteMap.add((byte)2, null);
        byteMap.add((byte)3, "dfdf");
        byteMap.add((byte)1, null);
        byteMap.add((byte)2, "a bc");
        byteMap.add((byte)3, "ad");
        byteMap.purgeNullValues();
        System.out.println(byteMap);
    }

    public void purgeDupKeys() {
        int n;
        short s;
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        short s2 = s = this._$3;
        int n2 = n = s - 2;
        while (n2 >= 0) {
            int n3 = s - 1;
            while (n3 > n) {
                if (byArray[n2] == byArray[n3]) {
                    s2 = (short)(s2 - 1);
                    break;
                }
                --n3;
            }
            if (n3 == n) {
                byArray[n] = byArray[n2];
                objectArray[n] = objectArray[n2];
                --n;
            }
            --n2;
        }
        n = s - s2;
        if (n != 0) {
            System.arraycopy(byArray, n, byArray, 0, s2);
            System.arraycopy(objectArray, n, objectArray, 0, s2);
        }
        this._$3 = s2;
    }

    public void purgeNullValues() {
        int n;
        short s;
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        short s2 = s = this._$3;
        int n2 = n = s - 1;
        while (n2 >= 0) {
            if (objectArray[n2] == null) {
                s2 = (short)(s2 - 1);
            } else {
                if (n != n2) {
                    byArray[n] = byArray[n2];
                    objectArray[n] = objectArray[n2];
                }
                --n;
            }
            --n2;
        }
        n = s - s2;
        if (n != 0) {
            System.arraycopy(byArray, n, byArray, 0, s2);
            System.arraycopy(objectArray, n, objectArray, 0, s2);
        }
        this._$3 = s2;
    }

    public Object put(byte by, Object object) {
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        int n = 0;
        while (n < this._$3) {
            if (byArray[n] == by) {
                Object object2 = objectArray[n];
                objectArray[n] = object;
                return object2;
            }
            ++n;
        }
        if (this._$3 >= byArray.length) {
            int n2 = (int)((double)this._$3 * 1.1) + 1;
            this._$1 = new byte[n2];
            this._$2 = new Object[n2];
            System.arraycopy(byArray, 0, this._$1, 0, this._$3);
            System.arraycopy(objectArray, 0, this._$2, 0, this._$3);
        }
        this._$1[this._$3] = by;
        this._$2[this._$3] = object;
        this._$3 = (short)(this._$3 + 1);
        return null;
    }

    public void putAll(IByteMap iByteMap) {
        this.ensureCapacity(this._$3 + iByteMap.size());
        int n = 0;
        while (n < iByteMap.size()) {
            this.put(iByteMap.getKey(n), iByteMap.getValue(n));
            ++n;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._$3 = objectInput.readShort();
        byte[] byArray = new byte[this._$3];
        Object[] objectArray = new Object[this._$3];
        int n = 0;
        while (n < this._$3) {
            byArray[n] = objectInput.readByte();
            objectArray[n] = objectInput.readObject();
            ++n;
        }
        this._$1 = byArray;
        this._$2 = objectArray;
    }

    public Object remove(byte by) {
        byte[] byArray = this._$1;
        int n = 0;
        while (n < this._$3) {
            if (byArray[n] == by) {
                return this.removeEntry(n);
            }
            ++n;
        }
        return null;
    }

    public Object removeEntry(int n) {
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        Object object = this._$2[n];
        System.arraycopy(byArray, n + 1, byArray, n, this._$3 - n - 1);
        System.arraycopy(objectArray, n + 1, objectArray, n, this._$3 - n - 1);
        this._$3 = (short)(this._$3 - 1);
        objectArray[this._$3] = null;
        return object;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord byteArrayOutputRecord = new ByteArrayOutputRecord();
        byteArrayOutputRecord.writeShort(this._$3);
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        int n = 0;
        while (n < this._$3) {
            byteArrayOutputRecord.writeByte(byArray[n]);
            byteArrayOutputRecord.writeObject(objectArray[n], true);
            ++n;
        }
        return byteArrayOutputRecord.toByteArray();
    }

    public void setValue(int n, Object object) {
        this._$2[n] = object;
    }

    public short size() {
        return this._$3;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        int n2 = 0;
        while (n2 < this._$3) {
            stringBuffer.append(byArray[n2]).append('=').append(objectArray[n2]);
            if (n2 < this._$3 - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void trimToSize() {
        if (this._$3 < this._$1.length) {
            byte[] byArray = this._$1;
            Object[] objectArray = this._$2;
            this._$1 = new byte[this._$3];
            this._$2 = new Object[this._$3];
            System.arraycopy(byArray, 0, this._$1, 0, this._$3);
            System.arraycopy(objectArray, 0, this._$2, 0, this._$3);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this._$3);
        byte[] byArray = this._$1;
        Object[] objectArray = this._$2;
        int n = 0;
        while (n < this._$3) {
            objectOutput.writeByte(byArray[n]);
            objectOutput.writeObject(objectArray[n]);
            ++n;
        }
    }
}

