/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.util;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellStyleUtils {
    public static byte getBorderStyleByte(String string) {
        if ("solid".equalsIgnoreCase(string)) {
            return 83;
        }
        if ("dashed".equalsIgnoreCase(string)) {
            return 82;
        }
        if ("dotted".equalsIgnoreCase(string)) {
            return 81;
        }
        if ("double".equalsIgnoreCase(string)) {
            return 84;
        }
        if ("none".equalsIgnoreCase(string)) {
            return 80;
        }
        return 83;
    }

    public static String getBorderStyleStr(byte by) {
        if (by == 83) {
            return "solid";
        }
        if (by == 80) {
            return "none";
        }
        if (by == 84) {
            return "double";
        }
        if (by == 81) {
            return "dotted";
        }
        if (by == 82) {
            return "dashed";
        }
        return "solid";
    }

    public static String getHTextAlignStr(byte by) {
        if (by == -48) {
            return "left";
        }
        if (by == -47) {
            return "center";
        }
        if (by == -46) {
            return "right";
        }
        return "left";
    }

    public static String getHexValue(int n) {
        Color color = new Color(n, true);
        if (color.getAlpha() == 0) {
            return "transparent";
        }
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        String string4 = "#" + string + string2 + string3;
        return string4.toUpperCase();
    }

    public static int getRGBColor(String string, int n) {
        if (string != null && !"".equals(string)) {
            if (string.startsWith("#")) {
                String string2 = string.substring(1);
                return new Color(CellStyleUtils.isHexColorAndApply(string2, n)).getRGB();
            }
            if (string.startsWith("rgb")) {
                return CellStyleUtils.isRgbColorAndApply(string, n);
            }
            if ("red".equalsIgnoreCase(string)) {
                return new Color(0xFF0000).getRGB();
            }
            if ("Transparent".equalsIgnoreCase(string)) {
                return 0xFFFFFF;
            }
            if ("blue".equalsIgnoreCase(string)) {
                return new Color(255).getRGB();
            }
            if ("yellow".equalsIgnoreCase(string)) {
                return new Color(0xFFFF00).getRGB();
            }
            if ("Black".equalsIgnoreCase(string)) {
                return new Color(0).getRGB();
            }
            if ("White".equalsIgnoreCase(string)) {
                return new Color(0xFFFFFF).getRGB();
            }
            if ("Lime".equalsIgnoreCase(string)) {
                return new Color(65280).getRGB();
            }
            if ("Aqua".equalsIgnoreCase(string)) {
                return new Color(65535).getRGB();
            }
            if ("Fuchsia".equalsIgnoreCase(string)) {
                return new Color(0xFF00FF).getRGB();
            }
            if ("Gray".equalsIgnoreCase(string)) {
                return new Color(0x808080).getRGB();
            }
            if ("Silver".equalsIgnoreCase(string)) {
                return new Color(0xC0C0C0).getRGB();
            }
            if ("Maroon".equalsIgnoreCase(string)) {
                return new Color(0x800000).getRGB();
            }
            if ("Olive".equalsIgnoreCase(string)) {
                return new Color(0x808000).getRGB();
            }
            if ("Green".equalsIgnoreCase(string)) {
                return new Color(32768).getRGB();
            }
            if ("Teal".equalsIgnoreCase(string)) {
                return new Color(32896).getRGB();
            }
            if ("Navy".equalsIgnoreCase(string)) {
                return new Color(128).getRGB();
            }
            if ("Purple".equalsIgnoreCase(string)) {
                return new Color(0x800080).getRGB();
            }
            if ("skyblue".equalsIgnoreCase(string)) {
                return new Color(8900331).getRGB();
            }
            if ("powderblue".equalsIgnoreCase(string)) {
                return new Color(11591910).getRGB();
            }
        }
        return n;
    }

    public static byte getTextAlignByte(String string) {
        if ("left".equalsIgnoreCase(string)) {
            return -48;
        }
        if ("center".equalsIgnoreCase(string)) {
            return -47;
        }
        if ("right".equalsIgnoreCase(string)) {
            return -46;
        }
        return 83;
    }

    public static String getVTextAlignStr(byte by) {
        if (by == -32) {
            return "top";
        }
        if (by == -31) {
            return "middle";
        }
        if (by == -30) {
            return "bottom";
        }
        return "middle";
    }

    public static byte getValignByte(String string) {
        if ("top".equalsIgnoreCase(string)) {
            return -32;
        }
        if ("bottom".equalsIgnoreCase(string)) {
            return -30;
        }
        if ("middle".equalsIgnoreCase(string)) {
            return -31;
        }
        return -31;
    }

    public static boolean getVisibilityStatus(String string) {
        if ("hidden".equalsIgnoreCase(string)) {
            return false;
        }
        if ("visible".equalsIgnoreCase(string)) {
            return true;
        }
        return true;
    }

    public static boolean isDigPX(String string) {
        if (string.length() > 6) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9px]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isHexColor(String string) {
        if (string.length() > 6) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9a-fA-F]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static int isHexColorAndApply(String string, int n) {
        if (!CellStyleUtils.isHexColor(string)) {
            return n;
        }
        char[] cArray = string.toLowerCase().toCharArray();
        double d = 0.0;
        int n2 = cArray.length - 1;
        while (n2 < cArray.length && n2 >= 0) {
            switch (cArray[n2]) {
                case 'a': {
                    d += 10.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                case 'b': {
                    d += 11.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                case 'c': {
                    d += 12.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                case 'd': {
                    d += 13.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                case 'e': {
                    d += 14.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                case 'f': {
                    d += 15.0 * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
                default: {
                    d += (double)Character.getNumericValue(cArray[n2]) * Math.pow(16.0, cArray.length - 1 - n2);
                    break;
                }
            }
            --n2;
        }
        n = new Double(d).intValue();
        return n;
    }

    public static boolean isNumeric(String string) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static int isRgbColorAndApply(String string, int n) {
        if (string.length() > 16) {
            return n;
        }
        if ((string = string.toLowerCase()).startsWith("rgb") && (string = string.substring(3, string.length()).trim()).startsWith("(") && string.endsWith(")")) {
            String[] stringArray;
            string = string.substring(1, string.length() - 1);
            Pattern pattern = Pattern.compile("[0-9,]*");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches() && (stringArray = string.split(",")).length == 3 && Integer.parseInt(stringArray[0]) <= 255 && Integer.parseInt(stringArray[1]) <= 255 && Integer.parseInt(stringArray[2]) <= 255) {
                n = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), 0).getRGB();
            }
        }
        return new Color(n).getRGB();
    }

    public static boolean isSimpleFloatPX(String string) {
        Pattern pattern = Pattern.compile("[0-9]*.[0-9]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isXXX(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static void main(String[] stringArray) {
        String string = "89";
        String string2 = "<report:html name=\"q.raq\" width=\"333\" />sdfsdf<report:html name=\"s.raq\" width=\"ddddd\" />";
        Pattern pattern = Pattern.compile("[0-9]*.[0-9]*");
        Pattern pattern2 = Pattern.compile("(?<=<report:html.*/>)");
        Matcher matcher = pattern2.matcher(string2);
    }
}

