/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.util;

import com.runqian.base4.util.PwdUtils;
import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.model.ReportDefine;
import com.runqian.report4.model.ReportDefine2;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.ReportGroup;
import com.runqian.report4.view.ParamsPool;
import com.runqian.report4.view.excel.ExcelReport;
import com.runqian.report4.view.html.HtmlReport;
import com.runqian.report4.view.pdf.PdfReport;
import com.runqian.report4.view.text.TextFile;
import com.runqian.report4.view.text.TextReport;
import com.runqian.report4.view.word.WordReport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class ReportUtils {
    public static void exportToDOC(OutputStream outputStream, IReport iReport) throws Throwable {
        WordReport wordReport = new WordReport();
        wordReport.export(new PageBuilder(iReport));
        wordReport.saveTo(outputStream);
        outputStream.flush();
    }

    public static void exportToDOC(String string, IReport iReport) throws Throwable {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            ReportUtils.exportToDOC(fileOutputStream, iReport);
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (fileOutputStream == null) break block3;
                fileOutputStream.close();
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void exportToExcel(OutputStream outputStream, IReport iReport, boolean bl) throws Throwable {
        ReportUtils.exportToExcel(outputStream, iReport, bl, 75);
    }

    public static void exportToExcel(OutputStream outputStream, IReport iReport, boolean bl, int n) throws Throwable {
        ExcelReport excelReport = new ExcelReport();
        if (bl) {
            ExportConfig exportConfig = iReport.getExportConfig();
            if (exportConfig != null) {
                excelReport.setFilePassword(PwdUtils.decrypt(exportConfig.getExcelFilePassword()));
                excelReport.setHiddenColExported(exportConfig.getExcelHiddenColExported());
                excelReport.setHiddenRowExported(exportConfig.getExcelHiddenRowExported());
            }
            excelReport.export(new PageBuilder(iReport));
        } else {
            excelReport.export(iReport);
        }
        excelReport.setDispRatio(n);
        excelReport.saveTo(outputStream);
        outputStream.flush();
    }

    public static void exportToExcel(String string, IReport iReport, boolean bl) throws Throwable {
        ReportUtils.exportToExcel(string, iReport, bl, 75);
    }

    public static void exportToExcel(String string, IReport iReport, boolean bl, int n) throws Throwable {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            ReportUtils.exportToExcel(fileOutputStream, iReport, bl, n);
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (fileOutputStream == null) break block3;
                fileOutputStream.close();
            }
            throw throwable;
        }
        Object var6_5 = null;
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void exportToHTML(String string, IReport iReport) throws Throwable {
        ReportUtils.exportToHTML(string, iReport, "GBK", 1.0f);
    }

    public static void exportToHTML(String string, IReport iReport, float f) throws Throwable {
        ReportUtils.exportToHTML(string, iReport, "GBK", f);
    }

    public static void exportToHTML(String string, IReport iReport, String string2, float f) throws Throwable {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            PageBuilder pageBuilder = new PageBuilder(iReport, 1.0E9f, 1.0E9f);
            HtmlReport htmlReport = new HtmlReport(pageBuilder.getPage(1), string, "", null);
            htmlReport.setScale(f);
            outputStreamWriter.write(htmlReport.generateHtml());
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_9 = null;
                if (fileOutputStream == null) break block3;
                ((OutputStream)fileOutputStream).close();
            }
            throw throwable;
        }
        Object var6_8 = null;
        if (fileOutputStream != null) {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void exportToPDF(OutputStream outputStream, IReport iReport) throws Throwable {
        ReportUtils.exportToPDF(outputStream, iReport, false, true);
    }

    public static void exportToPDF(OutputStream outputStream, IReport iReport, boolean bl, boolean bl2) throws Throwable {
        PdfReport pdfReport = new PdfReport(outputStream);
        pdfReport.setAnamorphic(bl2 ^ true);
        if (bl) {
            pdfReport.export(new PageBuilder(iReport));
        } else {
            pdfReport.export(iReport);
        }
        pdfReport.save();
        outputStream.flush();
    }

    public static void exportToPDF(String string, IReport iReport) throws Throwable {
        ReportUtils.exportToPDF(string, iReport, false, true);
    }

    public static void exportToPDF(String string, IReport iReport, boolean bl, boolean bl2) throws Throwable {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            ReportUtils.exportToPDF(fileOutputStream, iReport, bl, bl2);
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (fileOutputStream == null) break block3;
                fileOutputStream.close();
            }
            throw throwable;
        }
        Object var6_5 = null;
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void exportToText(OutputStream outputStream, IReport iReport) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "GBK");
        TextReport textReport = new TextReport(iReport);
        textReport.out(outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void exportToText(OutputStream outputStream, IReport iReport, String string, boolean bl) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "GBK");
        outputStreamWriter.write(ReportUtils.toText(iReport, string, bl));
        outputStreamWriter.flush();
    }

    public static IReport getReport(String string) throws Exception {
        return CacheManager.getInstance().getReportEntry(string).getReportDefine();
    }

    public static String getReportParamValue(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter("reportParamsId");
        if (string2 == null) {
            return null;
        }
        Hashtable hashtable = ParamsPool.get(string2);
        if (hashtable == null) {
            return null;
        }
        return (String)hashtable.get(string);
    }

    public static IReport mergeReport(IReport iReport, Area area) throws Exception {
        int n = area.getBeginRow();
        short s = area.getBeginCol();
        INormalCell iNormalCell = iReport.getCell(n, s);
        iNormalCell.setMergedArea(area);
        int n2 = area.getBeginRow();
        while (n2 <= area.getEndRow()) {
            short s2 = area.getBeginCol();
            while (s2 <= area.getEndCol()) {
                iReport.setCell(n2, s2, iNormalCell);
                s2 = (short)(s2 + 1);
            }
            ++n2;
        }
        iReport.setLBStyle(n, s, iNormalCell.getLBStyle());
        iReport.setLBWidth(n, s, iNormalCell.getLBWidth());
        iReport.setLBColor(n, s, iNormalCell.getLBColor());
        iReport.setTBStyle(n, s, iNormalCell.getTBStyle());
        iReport.setTBWidth(n, s, iNormalCell.getTBWidth());
        iReport.setTBColor(n, s, iNormalCell.getTBColor());
        iReport.setRBStyle(n, s, iNormalCell.getRBStyle());
        iReport.setRBWidth(n, s, iNormalCell.getRBWidth());
        iReport.setRBColor(n, s, iNormalCell.getRBColor());
        iReport.setBBStyle(n, s, iNormalCell.getBBStyle());
        iReport.setBBWidth(n, s, iNormalCell.getBBWidth());
        iReport.setBBColor(n, s, iNormalCell.getBBColor());
        return iReport;
    }

    public static IReport read(InputStream inputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(0);
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        int n4 = bufferedInputStream.read();
        if (n == 82 && n2 == 81 && n3 == 81 && n4 == 82) {
            int n5;
            int n6;
            int n7;
            int n8 = bufferedInputStream.read();
            if ((n8 | (n7 = bufferedInputStream.read()) | (n6 = bufferedInputStream.read()) | (n5 = bufferedInputStream.read())) < 0) {
                throw new EOFException();
            }
            int n9 = (n8 << 24) + (n7 << 16) + (n6 << 8) + n5;
            byte[] byArray = new byte[n9];
            ReportUtils.readBytes(bufferedInputStream, byArray);
            ReportDefine2 reportDefine2 = new ReportDefine2();
            reportDefine2.fillRecord(byArray);
            if (bufferedInputStream.available() > 0 && reportDefine2 instanceof ReportDefine) {
                byte[] byArray2 = new byte[152];
                bufferedInputStream.read(byArray2);
                System.arraycopy(byArray2, 24, reportDefine2.getCipherHash(), 0, 128);
            }
            return reportDefine2;
        }
        bufferedInputStream.reset();
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        IReport iReport = (IReport)objectInputStream.readObject();
        if (bufferedInputStream.available() > 0 && iReport instanceof ReportDefine) {
            byte[] byArray = new byte[152];
            bufferedInputStream.read(byArray);
            System.arraycopy(byArray, 24, iReport.getCipherHash(), 0, 128);
        }
        return iReport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IReport read(String string) throws Exception {
        IReport iReport;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            iReport = ReportUtils.read(fileInputStream);
            Object var4_3 = null;
            if (fileInputStream == null) return iReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return iReport;
    }

    public static void readBytes(InputStream inputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 += n3;
        }
    }

    public static ReportGroup readReportGroup(InputStream inputStream) throws Exception {
        return ReportGroup.read(inputStream);
    }

    public static void readReportGroup(OutputStream outputStream, ReportGroup reportGroup) throws Exception {
        ReportGroup.write(outputStream, reportGroup);
    }

    public static ReportGroup readReportGroup(String string) throws Exception {
        return ReportGroup.read(string);
    }

    public static void readReportGroup(String string, ReportGroup reportGroup) throws Exception {
        ReportGroup.write(string, reportGroup);
    }

    public static String toHTMLString(IReport iReport, String string, HttpServletRequest httpServletRequest) throws Throwable {
        return ReportUtils.toHTMLString(iReport, string, httpServletRequest, 1.0f);
    }

    public static String toHTMLString(IReport iReport, String string, HttpServletRequest httpServletRequest, float f) throws Throwable {
        PageBuilder pageBuilder = new PageBuilder(iReport, 1.0E9f, 1.0E9f);
        HtmlReport htmlReport = new HtmlReport(pageBuilder.getPage(1), string, httpServletRequest.getContextPath(), httpServletRequest);
        htmlReport.setScale(f);
        return htmlReport.generateHtml();
    }

    public static String toText(IReport iReport) throws Exception {
        return new TextReport(iReport).toString();
    }

    public static String toText(IReport iReport, String string, boolean bl) throws Exception {
        TextFile textFile = new TextFile(iReport, string);
        textFile.setSaveDispValue(bl);
        return textFile.toString();
    }

    public static void write(OutputStream outputStream, IReport iReport) throws Exception {
        if (iReport instanceof ReportDefine) {
            outputStream.write(82);
            outputStream.write(81);
            outputStream.write(81);
            outputStream.write(82);
            byte[] byArray = iReport.serialize();
            int n = byArray.length;
            outputStream.write(n >>> 24 & 0xFF);
            outputStream.write(n >>> 16 & 0xFF);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.write(byArray);
            outputStream.write(82);
            outputStream.write(81);
            outputStream.write(81);
            outputStream.write(82);
            outputStream.write(82);
            outputStream.write(81);
            outputStream.write(81);
            outputStream.write(82);
            outputStream.write(iReport.getHash());
            outputStream.write(iReport.getCipherHash());
            return;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream, 8192));
        objectOutputStream.writeObject(iReport);
        objectOutputStream.flush();
    }

    public static void write(String string, IReport iReport) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            ReportUtils.write(fileOutputStream, iReport);
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (fileOutputStream == null) break block3;
                fileOutputStream.close();
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }
}

