/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.applet;

import com.runqian.report4.control.PrintPage;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.ReportUtils;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import javax.print.PrintService;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AReport {
    private byte align = 1;
    public String appRoot;
    public boolean bSetPageSize = false;
    public String cachedId;
    private boolean canSetAlign = true;
    private int columns = 1;
    public String dataServlet;
    public String fileName;
    private JPanel hideContainer;
    public PrinterJob job;
    public PageFormat outerPf;
    private int pageCounts;
    public String paramString;
    private PageBuilder pb;
    private PageFormat pf;
    private Book printBook;
    private IReport report;
    public String reportParamsId;
    public boolean savePrintSetup = false;
    private byte savedAlign = (byte)-1;
    private String savedPrinterName;
    private byte shrink = 1;
    private double shrinkScale = 1.0;
    public String srcType;
    private PageFormat truePf;
    private byte vAlign = 0;

    public void create() {
        String dataServer = this.appRoot + this.dataServlet + "&fileName=" + this.fileName + "&srcType=" + this.srcType;
        if (this.reportParamsId != null) {
            dataServer = dataServer + "&reportParamsId=" + this.reportParamsId;
        }
        if (this.cachedId != null) {
            dataServer = dataServer + "&cachedId=" + this.cachedId;
        }
        if (this.paramString != null) {
            try {
                dataServer = dataServer + "&paramString=" + URLEncoder.encode(this.paramString, "GBK");
            }
            catch (Exception e) {
                dataServer = dataServer + "&paramString=" + URLEncoder.encode(this.paramString);
            }
        }
        try {
            short layoutCol;
            URL url = new URL(dataServer);
            InputStream is = url.openStream();
            this.report = ReportUtils.read(is);
            is.close();
            PrintSetup ps = this.report.getPrintSetup();
            byte pagerStyle = ps.getPagerStyle();
            if (pagerStyle == 1 && (layoutCol = ps.getLayoutColNum()) > 1) {
                this.canSetAlign = false;
            }
            if (this.bSetPageSize) {
                this.outerPf = this.job.pageDialog(ps.getPageFormat());
            }
            if (this.outerPf == null) {
                PageFormat savedPf = null;
                if (this.savePrintSetup) {
                    try {
                        InetAddress ia = InetAddress.getLocalHost();
                        String savePrintSetupKey = ia.getHostName() + ia.getHostAddress() + this.fileName + System.getProperty("user.name");
                        String savePrintSetupUrl = this.appRoot + "/servlet/PrintSetupServlet";
                        String surl = savePrintSetupUrl + "?action=read&key=" + URLEncoder.encode(savePrintSetupKey);
                        URL aurl = new URL(surl);
                        Properties p = new Properties();
                        p.load(aurl.openStream());
                        String hasSetup = p.getProperty("setup");
                        if (hasSetup == null || hasSetup.equalsIgnoreCase("no")) {
                            String otherKey = ia.getHostName() + ia.getHostAddress() + this.fileName;
                            surl = savePrintSetupUrl + "?action=read&key=" + URLEncoder.encode(otherKey);
                            aurl = new URL(surl);
                            p = new Properties();
                            p.load(aurl.openStream());
                            hasSetup = p.getProperty("setup");
                        }
                        if (hasSetup != null && hasSetup.equalsIgnoreCase("yes")) {
                            String sa;
                            savedPf = new PageFormat();
                            savedPf.setOrientation(Integer.parseInt(p.getProperty("orientation")));
                            Paper paper = new Paper();
                            double width = Double.parseDouble(p.getProperty("width"));
                            double height = Double.parseDouble(p.getProperty("height"));
                            paper.setSize(width, height);
                            double x = Double.parseDouble(p.getProperty("x"));
                            double y = Double.parseDouble(p.getProperty("y"));
                            double w = Double.parseDouble(p.getProperty("w"));
                            double h = Double.parseDouble(p.getProperty("h"));
                            paper.setImageableArea(x, y, w, h);
                            savedPf.setPaper(paper);
                            this.savedPrinterName = p.getProperty("printerName");
                            if (this.savedPrinterName != null) {
                                this.savedPrinterName = new String(this.savedPrinterName.getBytes("iso8859-1"), "GBK");
                            }
                            if ((sa = p.getProperty("a")) != null) {
                                try {
                                    this.savedAlign = Byte.parseByte(sa);
                                }
                                catch (Exception esa) {
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        savedPf = null;
                        e.printStackTrace();
                    }
                }
                this.pf = savedPf != null ? savedPf : ps.getPageFormat();
            } else {
                this.pf = this.outerPf;
            }
            this.shrink = ps.getZoomMode();
            this.align = ps.getHAlign();
            this.vAlign = ps.getVAlign();
            if (this.savedAlign != -1) {
                this.align = this.savedAlign;
            }
            this.columns = ps.getTableColumnNum();
            this.createPageBuilder();
            this.initPrintWindow();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createPageBuilder() throws Throwable {
        if (this.shrink == 1) {
            this.truePf = this.pf;
            this.shrinkScale = 1.0;
        } else {
            ReportParser csp = new ReportParser(this.report);
            if (this.shrink == 2) {
                int w = csp.getReportWidth() + 2;
                this.shrinkScale = this.pf.getImageableWidth() / (double)w;
            } else if (this.shrink == 3) {
                int h = csp.getReportHeight() + 2;
                this.shrinkScale = this.pf.getImageableHeight() / (double)h;
            }
            this.truePf = this.getTruePageFormat(1.0 / this.shrinkScale);
        }
        this.pb = new PageBuilder(this.report, this.truePf, this.columns);
    }

    private PageFormat getTruePageFormat(double scale) {
        PageFormat pageformat = new PageFormat();
        Paper paper = new Paper();
        Paper p = this.pf.getPaper();
        paper.setSize(p.getWidth() * scale, p.getHeight() * scale);
        double x = p.getImageableX() * scale;
        double y = p.getImageableY() * scale;
        double w = p.getImageableWidth() * scale;
        double h = p.getImageableHeight() * scale;
        paper.setImageableArea(x, y, w, h);
        pageformat.setPaper(paper);
        pageformat.setOrientation(this.pf.getOrientation());
        return pageformat;
    }

    private void initPrintWindow() {
        this.printBook = new Book();
        this.pageCounts = 0;
        int pageNo = 1;
        while (true) {
            PrintPage page;
            block3: {
                page = new PrintPage(this.report, this.pb, this.truePf, pageNo);
                try {
                    page.create();
                    if (!this.canSetAlign) break block3;
                    page.setAlign(this.align);
                    page.setVAlign(this.vAlign);
                }
                catch (Exception e) {
                    break;
                }
            }
            this.hideContainer.add(page);
            this.printBook.append(page, this.pf);
            ++pageNo;
            ++this.pageCounts;
        }
    }

    public PageFormat print() {
        JFrame jf = new JFrame();
        jf.setSize(60, 40);
        jf.setLocation(-150, -50);
        this.hideContainer = new JPanel();
        jf.getContentPane().add(this.hideContainer);
        this.create();
        jf.show();
        Thread.currentThread().setContextClassLoader(new ClassLoader(){});
        AReport aReport = this;
        PrintService[] pss = aReport.job.lookupPrintServices();
        if (pss.length == 0) {
            JOptionPane.showMessageDialog(null, "\u6ca1\u6709\u627e\u5230\u6253\u5370\u673a");
            return null;
        }
        if (this.savePrintSetup && this.savedPrinterName != null) {
            int i = 0;
            while (i < pss.length) {
                if (pss[i].getName().equals(this.savedPrinterName)) {
                    try {
                        this.job.setPrintService(pss[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
        }
        PrintPage.setScale(this.shrinkScale);
        this.job.setPageable(this.printBook);
        try {
            this.job.print();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        jf.hide();
        jf.dispose();
        return this.outerPf;
    }
}

