/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.applet;

import com.runqian.base4.resources.MessageManager;
import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupPrintDialog
extends JDialog
implements ActionListener {
    private JButton allBtn;
    private String appRoot;
    private JButton closeBtn;
    private String dataServlet;
    private String fileName;
    private Font font;
    private JList list;
    private MessageManager mm = MessageManager.getManager("com.runqian.base4.resources.print");
    private boolean needSelectPrinter = true;
    private JButton noBtn;
    private Frame owner;
    private JButton previewBtn;
    private JButton printBtn;
    private String prompt;
    private String reportParamsId;
    private String[] reportTitles;
    private IReport[] reports;

    public GroupPrintDialog(Frame owner, String prompt) {
        super(owner);
        this.font = new Font("Dialog", 0, 12);
        this.setModal(true);
        this.owner = owner;
        this.prompt = prompt;
        this.setTitle(this.mm.getMessage("group.title") + "  " + prompt);
        this.setSize(300, 240);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            JComponent source = (JComponent)e.getSource();
            if (source.equals(this.allBtn)) {
                this.selectAll();
            } else if (source.equals(this.noBtn)) {
                this.list.clearSelection();
            } else if (source.equals(this.previewBtn)) {
                int index = this.list.getSelectedIndex();
                if (index < 0) {
                    throw new Exception(this.mm.getMessage("group.noReport"));
                }
                IReport report = this.getReport(index);
                PrintFrame pf = new PrintFrame(report, this.prompt, this.appRoot, "", false, this.owner);
                pf.show();
            } else if (source.equals(this.printBtn)) {
                int[] indexes = this.list.getSelectedIndices();
                if (indexes.length == 0) {
                    throw new Exception(this.mm.getMessage("group.noReport"));
                }
                PrinterJob job = PrinterJob.getPrinterJob();
                if (this.needSelectPrinter) {
                    job.printDialog();
                }
                int i = 0;
                while (i < indexes.length) {
                    IReport report = this.getReport(indexes[i]);
                    PrintFrame pf = new PrintFrame(report, this.prompt, this.appRoot, "", false, this.owner);
                    pf.setModal(false);
                    pf.setLocation(-1000, -1000);
                    pf.setPrinterJob(job);
                    pf.show();
                    pf.directPrint(false);
                    ++i;
                }
            } else if (source.equals(this.closeBtn)) {
                this.hide();
                this.dispose();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private JButton createButton(String text) {
        JButton button = new JButton();
        button.setText(text);
        button.setFont(this.font);
        button.setMargin(new Insets(1, 5, 1, 5));
        button.addActionListener(this);
        return button;
    }

    private IReport getReport(int index) throws Exception {
        if (this.reports[index] != null) {
            return this.reports[index];
        }
        String dataServer = this.appRoot + this.dataServlet + "&fileName=" + this.fileName + "&isGroup=1&index=" + index;
        if (this.reportParamsId != null) {
            dataServer = dataServer + "&reportParamsId=" + this.reportParamsId;
        }
        dataServer = dataServer + "&time=" + new Date().getTime();
        URL url = new URL(dataServer);
        InputStream is = url.openStream();
        IReport report = ReportUtils.read(is);
        is.close();
        this.reports[index] = report;
        return report;
    }

    public static void main(String[] args) {
        GroupPrintDialog gpd = new GroupPrintDialog(null, "");
        gpd.setReportTitles(new String[]{"\u62a5\u8868\u4e00", "\u62a5\u8868\u4e8c", "\u62a5\u8868\u4e09", "\u62a5\u8868\u56db"});
        gpd.showDialog();
    }

    private void selectAll() {
        int[] indexes = new int[this.reportTitles.length];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = i;
            ++i;
        }
        this.list.setSelectedIndices(indexes);
    }

    public void setAppRoot(String root) {
        this.appRoot = root;
    }

    public void setDataServlet(String servlet) {
        this.dataServlet = servlet;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setNeedSelectPrinter(boolean b) {
        this.needSelectPrinter = b;
    }

    public void setReportParamsId(String id) {
        this.reportParamsId = id;
    }

    public void setReportTitles(String[] titles) {
        this.reportTitles = titles;
        this.reports = new IReport[titles.length];
    }

    public void showDialog() {
        Dimension size1 = this.getSize();
        Dimension screenSize1 = Toolkit.getDefaultToolkit().getScreenSize();
        int newX1 = (screenSize1.width - size1.width) / 2;
        int newY1 = (screenSize1.height - size1.height) / 2;
        this.setLocation(newX1, newY1);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.list = new JList<String>(this.reportTitles);
        this.list.setFont(this.font);
        this.list.setSelectionMode(2);
        JScrollPane jsp = new JScrollPane(this.list, 20, 30);
        pane.add((Component)jsp, "Center");
        JPanel panel = new JPanel(new FlowLayout());
        this.previewBtn = this.createButton(this.mm.getMessage("group.preview"));
        this.printBtn = this.createButton(this.mm.getMessage("group.print"));
        this.allBtn = this.createButton(this.mm.getMessage("group.all"));
        this.noBtn = this.createButton(this.mm.getMessage("group.no"));
        this.closeBtn = this.createButton(this.mm.getMessage("group.close"));
        panel.add(this.allBtn);
        panel.add(this.noBtn);
        panel.add(this.previewBtn);
        panel.add(this.printBtn);
        panel.add(this.closeBtn);
        pane.add((Component)panel, "South");
        this.selectAll();
        this.show();
    }
}

