/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.applet;

import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.util.ReportUtils;
import com.runqian.report4.view.applet.GroupPrintDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class HtmlPrintApplet
extends JApplet {
    private String appRoot;
    private String cachedId;
    private String dataServlet;
    private String fileName;
    private String isGroup;
    private MessageManager mm = MessageManager.getManager("com.runqian.base4.resources.print");
    private String needSelectPrinter;
    private PageBuilder pb;
    private String reportParamsId;
    private String reportTitles;
    private String savePrintSetup;
    private String srcType;
    private String userUnitName;

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    public Frame getParentWindow(Component compOnApplet) {
        Container c = compOnApplet.getParent();
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void init() {
        try {
            this.initParameters();
            if (this.appRoot.equals("")) {
                throw new Exception(this.mm.getMessage("applet.noAppRoot"));
            }
            if (this.fileName.equals("")) {
                throw new Exception(this.mm.getMessage("applet.nofile"));
            }
            this.print();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            e.printStackTrace();
        }
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        if (!this.appRoot.toLowerCase().startsWith("http")) {
            URL urlBase = this.getCodeBase();
            this.appRoot = urlBase.getProtocol() + "://" + urlBase.getHost() + ":" + urlBase.getPort() + this.appRoot;
        }
        this.dataServlet = this.getParameter("dataServlet", "");
        this.fileName = this.getParameter("fileName", "");
        this.srcType = this.getParameter("srcType", "file");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.cachedId = this.getParameter("cachedId", null);
        this.userUnitName = this.getParameter("unitName", "");
        this.savePrintSetup = this.getParameter("savePrintSetup", "no");
        this.isGroup = this.getParameter("isGroup", "0");
        this.reportTitles = this.getParameter("reportTitles", null);
        this.needSelectPrinter = this.getParameter("needSelectPrinter", "yes");
    }

    public void print() throws Throwable {
        if ("1".equals(this.isGroup)) {
            GroupPrintDialog gpd = new GroupPrintDialog(this.getParentWindow(this), this.userUnitName);
            gpd.setFileName(this.fileName);
            gpd.setAppRoot(this.appRoot);
            gpd.setDataServlet(this.dataServlet);
            gpd.setReportParamsId(this.reportParamsId);
            ArgumentTokenizer at = new ArgumentTokenizer(this.reportTitles, ',');
            String[] tmp = new String[at.countTokens()];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = at.nextToken();
                ++i;
            }
            gpd.setReportTitles(tmp);
            gpd.setNeedSelectPrinter("yes".equalsIgnoreCase(this.needSelectPrinter));
            gpd.showDialog();
        } else {
            JFrame frame = new JFrame(this.mm.getMessage("applet.flashWinTitle"));
            frame.setSize(300, 100);
            frame.setLocation(250, 250);
            frame.setVisible(true);
            frame.getContentPane().setLayout(new BorderLayout());
            JLabel label = new JLabel(this.mm.getMessage("applet.flashText"));
            label.setForeground(Color.red);
            label.setHorizontalAlignment(0);
            label.setFont(new Font("Dialog", 0, 12));
            frame.getContentPane().add(label);
            frame.show();
            String dataServer = this.appRoot + this.dataServlet + "&fileName=" + this.fileName + "&srcType=" + this.srcType;
            if (this.reportParamsId != null) {
                dataServer = dataServer + "&reportParamsId=" + this.reportParamsId;
            }
            if (this.cachedId != null) {
                dataServer = dataServer + "&cachedId=" + this.cachedId;
            }
            dataServer = dataServer + "&time=" + new Date().getTime();
            URL url = new URL(dataServer);
            InputStream is = url.openStream();
            IReport report = ReportUtils.read(is);
            is.close();
            PrintFrame f = new PrintFrame(report, this.userUnitName, this.appRoot, this.fileName, this.savePrintSetup.equalsIgnoreCase("yes"), this.getParentWindow(this), this);
            frame.hide();
            frame.dispose();
            f.show();
        }
    }
}

