/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.pdf;

import com.lowagie2.text.Document;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PdfAction;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfWriter;
import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.tool.GM;
import com.runqian.base4.util.PwdUtils;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.view.pdf.PdfCell;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;

public class PdfReport {
    public static int MAX_SIZE = 14400;
    private int _$1;
    private int _$2;
    private int _$3;
    private int _$4;
    private int _$5;
    private int _$6;
    private OutputStream _$7;
    private String _$8 = "";
    private String _$9;
    private String _$10;
    private int _$11 = 0;
    private boolean _$12 = false;
    private Document _$13;
    private PdfWriter _$14;
    private PdfContentByte _$15;
    private boolean _$16 = true;
    private boolean _$17 = true;

    public PdfReport(OutputStream outputStream) throws Exception {
        this._$7 = outputStream;
        ExtCellSet extCellSet = ExtCellSet.get();
        MessageManager messageManager = EngineMessage.get();
        if (extCellSet == null || !extCellSet.checkExpiration() || !extCellSet.getExportEnabled()) {
            throw new Exception(messageManager.getMessage("pdfreport.licenseError"));
        }
        String string = System.getProperty("forceExport");
        if (!(string != null && string.equalsIgnoreCase("true") || extCellSet.getType() != 0 || ExtCellSet.checkDog())) {
            throw new Exception(messageManager.getMessage("pdfreport.nodog"));
        }
        if (extCellSet.getType() == 1 && (extCellSet.getVersion() == 20 || extCellSet.getVersion() == 21)) {
            this._$8 = extCellSet.getPrompt();
            if (!GM.isValidString(this._$8)) {
                if (extCellSet.getVersion() == 20) {
                    this._$8 = messageManager.getMessage("pdfreport.demo1");
                    return;
                }
                this._$8 = messageManager.getMessage("pdfreport.demo2");
            }
        }
    }

    private void _$1(IReport iReport) throws Exception {
        Graphics2D graphics2D = this._$15.createGraphicsShapes((float)this._$1, (float)this._$2);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._$1(graphics2D, iReport, this._$3, this._$5, this._$4, this._$6, this._$2);
        graphics2D.dispose();
    }

    private void _$1(PageBuilder pageBuilder) throws Exception {
        this._$13.setPageSize(new Rectangle(0.0f, 0.0f, (float)this._$1, (float)this._$2));
        this._$13.setMargins((float)this._$3, (float)this._$4, (float)this._$5, (float)this._$6);
        int n = 1;
        while (n <= pageBuilder.getPageCount()) {
            this._$13.newPage();
            this._$1(pageBuilder.getPage(n));
            ++n;
        }
    }

    private void _$1(Graphics2D graphics2D, IReport iReport, int n, int n2, int n3, int n4, int n5) {
        byte[] byArray;
        if (this._$8.length() > 0) {
            if (n2 < 50) {
                n2 = 50;
            }
            graphics2D.setColor(Color.red);
            graphics2D.setFont(new Font("Dialog", 0, 20));
            graphics2D.drawString(this._$8, 100, 25);
        }
        ReportParser reportParser = new ReportParser(iReport);
        BackGraphConfig backGraphConfig = iReport.getBackGraphConfig();
        if (backGraphConfig != null && (byArray = backGraphConfig.getImageBytes()) != null) {
            Image image = new ImageIcon(byArray).getImage();
            graphics2D.drawImage(image, n, n2, image.getWidth(null), image.getHeight(null), null);
        }
        try {
            int n6;
            int n7;
            int n8;
            int n9;
            short s = iReport.getColCount();
            int n10 = iReport.getRowCount();
            int[] nArray = new int[s];
            nArray[0] = n9 = n;
            short s2 = 1;
            while (s2 < s) {
                float f = reportParser.getColWidth(s2);
                if (!reportParser.isColVisible(s2)) {
                    f = 0.0f;
                }
                nArray[s2] = n9 = (int)((float)n9 + f);
                s2 = (short)(s2 + 1);
            }
            int[] nArray2 = new int[n10];
            int n11 = n2;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            Area area = reportParser.getPageHeader();
            if (area != null) {
                n12 = area.getBeginRow();
                n13 = area.getEndRow();
                n8 = 0;
                while (n8 < n13) {
                    nArray2[n8] = n11;
                    n7 = reportParser.getRowHeight(n8 + 1);
                    if (!reportParser.isRowVisible(n8 + 1)) {
                        n7 = 0;
                    }
                    n11 += n7;
                    ++n8;
                }
            }
            n8 = n13;
            while (n8 < n10) {
                nArray2[n8] = n11;
                n7 = reportParser.getRowHeight(n8 + 1);
                if (!reportParser.isRowVisible(n8 + 1)) {
                    n7 = 0;
                }
                n11 += n7;
                ++n8;
            }
            Area area2 = reportParser.getPageFooter();
            n11 = n5 - n4;
            if (area2 != null) {
                n14 = area2.getBeginRow();
                int n16 = n15 = area2.getEndRow();
                while (n16 >= n14) {
                    n6 = reportParser.getRowHeight(n16);
                    if (!reportParser.isRowVisible(n16)) {
                        n6 = 0;
                    }
                    nArray2[n16 - 1] = n11 -= n6;
                    --n16;
                }
            }
            float f = this._$13.getPageSize().height();
            n6 = 1;
            while (n6 <= n10) {
                if (reportParser.isRowVisible(n6)) {
                    short s3 = 1;
                    while (s3 <= s) {
                        if (reportParser.isColVisible(s3)) {
                            PdfCell pdfCell = this._$17 ? new PdfCell(reportParser, n6, s3, graphics2D, this._$15) : new PdfCell(reportParser, n6, s3, graphics2D, null);
                            INormalCell iNormalCell = reportParser.getCell(n6, s3);
                            if (iNormalCell.getHyperlink() != null && iNormalCell.getHyperlink().length() > 0) {
                                int n17 = reportParser.getRowHeight(n6);
                                int n18 = reportParser.getColWidth(s3);
                                int n19 = nArray[s3 - 1];
                                int n20 = nArray2[n6 - 1] + n17;
                                int n21 = nArray[s3 - 1] + n18;
                                int n22 = nArray2[n6 - 1];
                                this._$15.setAction(new PdfAction(iNormalCell.getHyperlink()), (float)n19, f - (float)n20, (float)n21, f - (float)n22);
                            }
                            pdfCell.drawCell(nArray, nArray2);
                        }
                        s3 = (short)(s3 + 1);
                    }
                }
                ++n6;
            }
            return;
        }
        catch (Exception exception) {
            throw new ReportError(exception.getMessage(), exception);
        }
    }

    private void _$1(PageFormat pageFormat) {
        this._$1 = (int)pageFormat.getWidth();
        this._$2 = (int)pageFormat.getHeight();
        try {
            this._$3 = (int)pageFormat.getImageableX();
        }
        catch (Exception exception) {
            this._$3 = 5;
        }
        try {
            this._$4 = (int)(pageFormat.getWidth() - pageFormat.getImageableWidth()) - this._$3;
        }
        catch (Exception exception) {
            this._$4 = 5;
        }
        try {
            this._$5 = (int)pageFormat.getImageableY();
        }
        catch (Exception exception) {
            this._$5 = 5;
        }
        try {
            this._$6 = (int)(pageFormat.getHeight() - pageFormat.getImageableHeight()) - this._$5;
            return;
        }
        catch (Exception exception) {
            this._$6 = 5;
            return;
        }
    }

    public void export(IReport iReport) throws Throwable {
        ReportParser reportParser = new ReportParser(iReport);
        PrintSetup printSetup = iReport.getPrintSetup();
        PagerInfo pagerInfo = new PagerInfo(printSetup);
        pagerInfo.setOrientation((byte)1);
        short s = printSetup.getTableColumnNum();
        PageFormat pageFormat = printSetup.getPageFormat();
        this._$1(pageFormat);
        this._$1 = reportParser.getReportWidth() + this._$3 + this._$4;
        this._$2 = reportParser.getReportHeight() + this._$5 + this._$6;
        if (this._$1 > MAX_SIZE || this._$2 > MAX_SIZE) {
            if (this._$1 > MAX_SIZE) {
                this._$1 = MAX_SIZE;
            }
            if (this._$2 > MAX_SIZE) {
                this._$2 = MAX_SIZE;
            }
            System.out.println("Report is too large to draw on one PDF page.");
        }
        pagerInfo.setPaperSize(this._$1, this._$2);
        try {
            if (this._$16) {
                ExportConfig exportConfig;
                this._$16 = false;
                this._$13 = new Document(new Rectangle(0.0f, 0.0f, (float)this._$1, (float)this._$2), (float)this._$3, (float)this._$4, (float)this._$5, (float)this._$6);
                this._$14 = PdfWriter.getInstance((Document)this._$13, (OutputStream)this._$7);
                if (!this._$12 && (exportConfig = iReport.getExportConfig()) != null) {
                    this.setUserPassword(PwdUtils.decrypt(exportConfig.getPDFUserPassword()));
                    this.setOwnerPassword(PwdUtils.decrypt(exportConfig.getPDFOwnerPassword()));
                    this.setPrivilege(exportConfig.getPDFPrivilege());
                }
                if (this._$12) {
                    this._$14.setEncryption(true, this._$9, this._$10, this._$11);
                }
                this._$13.open();
                this._$15 = this._$14.getDirectContent();
            }
            this._$1(new PageBuilder(iReport, pagerInfo));
            return;
        }
        catch (Throwable throwable) {
            throw new ReportError(throwable.getMessage(), throwable);
        }
    }

    public void export(PageBuilder pageBuilder) throws Exception {
        PagerInfo pagerInfo = pageBuilder.getPagerInfo();
        this._$1(pagerInfo.getPageFormat());
        if (this._$16) {
            this._$16 = false;
            this._$13 = new Document(new Rectangle(0.0f, 0.0f, (float)this._$1, (float)this._$2), (float)this._$3, (float)this._$4, (float)this._$5, (float)this._$6);
            this._$14 = PdfWriter.getInstance((Document)this._$13, (OutputStream)this._$7);
            if (this._$12) {
                this._$14.setEncryption(true, this._$9, this._$10, this._$11);
            }
            this._$13.open();
            this._$15 = this._$14.getDirectContent();
        }
        this._$1(pageBuilder);
    }

    public String getOwnerPassword() {
        return this._$10;
    }

    public int getPrivilege() {
        return this._$11;
    }

    public String getUserPassword() {
        return this._$9;
    }

    public static void main(String[] stringArray) {
        FileOutputStream fileOutputStream = null;
        Document document = new Document(new Rectangle(0.0f, 0.0f, 595.0f, 842.0f), 5.0f, 5.0f, 5.0f, 5.0f);
        try {
            try {
                fileOutputStream = new FileOutputStream("d:\\b.pdf");
                PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
                document.open();
                document.newPage();
                Phrase phrase = new Phrase("123");
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace(System.out);
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            document.close();
            throw throwable;
        }
        document.close();
    }

    public void resetExport() {
        this._$12 = false;
        this._$9 = "";
        this._$10 = "";
        this._$11 = 0;
    }

    public void save() {
        if (this._$13.isOpen()) {
            this._$13.close();
        }
    }

    public void setAnamorphic(boolean bl) {
        this._$17 = bl;
    }

    public void setOwnerPassword(String string) {
        this._$12 = true;
        this._$10 = string;
    }

    public void setPrivilege(int n) {
        this._$12 = true;
        this._$11 = n;
    }

    public void setUserPassword(String string) {
        this._$12 = true;
        this._$9 = string;
    }
}

