/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class StartReportEditor
extends ClassLoader {
    File[] classDirs = null;
    JarFile[] jars = null;
    ClassLoader loader = null;
    static /* synthetic */ Class class$0;

    private static File checkDir(File dir) {
        if (dir == null) {
            System.out.println(dir + "\u4e3a\u7a7a");
            return null;
        }
        if (!(dir.isDirectory() && dir.exists() && dir.canRead())) {
            return null;
        }
        return dir;
    }

    private byte[] getFileBytes(File f) {
        try {
            int len = (int)f.length();
            byte[] data = new byte[len];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            int i = 0;
            int offset = 0;
            while (i >= 0 && offset < len) {
                i = bis.read(data, offset, len - offset);
                offset += i;
            }
            bis.close();
            return data;
        }
        catch (IOException e) {
            System.out.println("\u8bfb\u4ee5\u4e0b\u6587\u4ef6\u65f6\u51fa\u9519\uff1a" + f);
            return null;
        }
    }

    private static byte[] getFileBytes(JarFile jar, String name) {
        try {
            JarEntry entry = jar.getJarEntry(name);
            if (entry == null) {
                return null;
            }
            int len = (int)entry.getSize();
            byte[] data = new byte[len];
            BufferedInputStream bis = new BufferedInputStream(jar.getInputStream(entry));
            int i = 0;
            int offset = 0;
            while (i >= 0 && offset < len) {
                i = bis.read(data, offset, len - offset);
                offset += i;
            }
            bis.close();
            return data;
        }
        catch (IOException e) {
            System.out.println("\u8bfb\u4ee5\u4e0b\u6587\u4ef6\u65f6\u51fa\u9519\uff1a" + jar);
            return null;
        }
    }

    public StartReportEditor(ClassLoader parent, String classDir, String libDir) {
        this(parent, new String[]{classDir}, new String[]{libDir});
    }

    public StartReportEditor(ClassLoader parent, String[] classDirs, String[] libDirs) {
        super(parent);
        this.loader = parent == null ? ClassLoader.getSystemClassLoader() : parent;
        File[] cds = null;
        if (classDirs != null) {
            cds = new File[classDirs.length];
            int i = 0;
            while (i < classDirs.length) {
                cds[i] = classDirs[i] == null ? null : new File(classDirs[i]);
                ++i;
            }
        }
        File[] lds = null;
        if (libDirs != null) {
            lds = new File[libDirs.length];
            int i = 0;
            while (i < libDirs.length) {
                lds[i] = libDirs[i] == null ? null : new File(libDirs[i]);
                ++i;
            }
        }
        this.addDirs(cds, lds);
    }

    public StartReportEditor(ClassLoader parent, File classDir, File libDir) {
        this(parent, new File[]{classDir}, new File[]{libDir});
    }

    public StartReportEditor(ClassLoader parent, File[] classDirs, File[] libDirs) {
        super(parent);
        this.loader = parent == null ? ClassLoader.getSystemClassLoader() : parent;
        this.addDirs(classDirs, libDirs);
    }

    private void addDirs(File[] classDirs, File[] libDirs) {
        int i;
        ArrayList<Object> al = new ArrayList<Object>();
        if (classDirs != null) {
            i = 0;
            while (i < classDirs.length) {
                File f = StartReportEditor.checkDir(classDirs[i]);
                if (f != null) {
                    al.add(f);
                }
                ++i;
            }
            this.classDirs = al.toArray(new File[al.size()]);
        }
        al.clear();
        if (libDirs != null) {
            i = 0;
            while (i < libDirs.length) {
                File one = StartReportEditor.checkDir(libDirs[i]);
                if (one != null) {
                    File[] files = one.listFiles();
                    int j = 0;
                    while (j < files.length) {
                        String name = files[j].getName();
                        if (!files[j].isDirectory() && files[j].canRead() && name.endsWith(".jar")) {
                            try {
                                al.add(new JarFile(files[j]));
                            }
                            catch (IOException e) {
                                System.out.println("\u4e0d\u80fd\u52a0\u8f7djar\u6587\u4ef6" + name);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.jars = al.toArray(new JarFile[al.size()]);
        }
    }

    public InputStream getResourceAsStream(String name) {
        byte[] buf;
        InputStream stream = this.loader.getResourceAsStream(name);
        if (stream == null && (buf = this.loadBytes(name, false)) != null) {
            stream = new ByteArrayInputStream(buf);
        }
        return stream;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.loader.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                byte[] bb = this.loadBytes(name, true);
                if (bb != null) {
                    clazz = this.findClassEx(name, bb);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve && clazz != null) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class findClassEx(String name, byte[] bb) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (bb == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bb, 0, bb.length);
    }

    private byte[] loadBytes(String name, boolean isClass) {
        byte[] bb = this.loadFromClassDirs(name, isClass);
        if (bb != null) {
            return bb;
        }
        return this.loadFromJars(name, isClass);
    }

    private byte[] loadFromClassDirs(String name, boolean isClass) {
        if (this.classDirs == null) {
            return null;
        }
        if (isClass) {
            name = String.valueOf(name.replace('.', File.separatorChar)) + ".class";
        }
        int i = 0;
        while (i < this.classDirs.length) {
            byte[] bb;
            File f = new File(this.classDirs[i], name);
            if ((f.isFile() || f.exists() || f.canRead()) && (bb = this.getFileBytes(f)) != null) {
                return bb;
            }
            ++i;
        }
        return null;
    }

    private byte[] loadFromJars(String name, boolean isClass) {
        if (this.jars == null) {
            return null;
        }
        if (isClass) {
            name = String.valueOf(name.replace('.', '/')) + ".class";
        }
        int i = 0;
        while (i < this.jars.length) {
            byte[] bb = StartReportEditor.getFileBytes(this.jars[i], name);
            if (bb != null) {
                return bb;
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String[] classDir = new String[]{"classes"};
            String[] libDir = new String[]{"lib", "web/WEB-INF/lib"};
            StartReportEditor scl = new StartReportEditor(ClassLoader.getSystemClassLoader(), classDir, libDir);
            Thread.currentThread().setContextClassLoader(scl);
            Class<?> clas = scl.loadClass(args[0]);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] mainArgType = classArray;
            Method main = clas.getMethod("main", mainArgType);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

