/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class Draw2Y2Line
implements DrawBase {
    GraphParam gp;

    public Draw2Y2Line(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        this.gp.coorWidth = 0;
        this.gp.initGraphInset();
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        if (this.gp.coorWidth < 0 || this.gp.coorWidth > 10000) {
            this.gp.coorWidth = 0;
        }
        double seriesWidth = (double)this.gp.graphRect.width / ((double)(this.gp.category.size() + 1) * this.gp.categorySpan / 100.0 + (double)this.gp.coorWidth / 200.0 + (double)(this.gp.category.size() * this.gp.series.size()));
        double coorWidth = seriesWidth * ((double)this.gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (this.gp.categorySpan / 100.0);
        int tmpInt = (int)((double)(this.gp.category.size() + 1) * categorySpan + coorWidth + (double)(this.gp.category.size() * this.gp.series.size()) * seriesWidth);
        this.gp.graphRect.x += (this.gp.graphRect.width - tmpInt) / 2;
        this.gp.graphRect.width = tmpInt;
        double dely = ((double)this.gp.graphRect.height - coorWidth) / (double)this.gp.tickNum;
        tmpInt = (int)(dely * (double)this.gp.tickNum + coorWidth);
        this.gp.graphRect.y += (this.gp.graphRect.height - tmpInt) / 2;
        this.gp.graphRect.height = tmpInt;
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        StatisticGraph.drawGraphRect(this.gp);
        this.gp.g.setStroke(new BasicStroke(1.0E-5f));
        int i = 0;
        while (i <= this.gp.tickNum) {
            int tmpi = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely);
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x, tmpi, this.gp.gRect1.x + this.gp.tickLen, tmpi);
            if (i != this.gp.tickNum || this.gp.gRect1.height != 10 * (this.gp.gRect1.height / 10)) {
                this.gp.g.setColor(this.gp.gridColor);
                this.gp.g.drawLine(this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                if (i != 0) {
                    float[] dashes = new float[]{2.0f};
                    this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                }
                this.gp.g.drawLine(this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely), this.gp.gRect2.x + this.gp.gRect2.width - 1, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            }
            Number coory = (Number)this.gp.coorValue.get(i);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x = this.gp.gRect1.x - Draw2Y2Line.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely + (double)(Draw2Y2Line.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() == this.gp.baseValue + this.gp.minValue) {
                this.gp.valueBaseLine = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely);
            }
            ++i;
        }
        StatisticGraph.drawWarnLine(this.gp);
        Point[] prePoints1 = new Point[this.gp.series.size()];
        Point[] prePoints2 = new Point[this.gp.series.size()];
        i = 0;
        while (i < this.gp.category.size()) {
            int delx = (int)((double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)this.gp.series.size() + seriesWidth * (double)this.gp.series.size() / 2.0);
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen);
            String value = this.gp.category.get(i).toString().trim();
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(value));
            x = this.gp.gRect1.x + delx - Draw2Y2Line.TR.width / 2;
            y = this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen + Draw2Y2Line.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, value);
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
            int j = 0;
            while (j < this.gp.series.size()) {
                int len = 0;
                Object ser = this.gp.series.get(j);
                Object val = "";
                if (ser == null) {
                    len = 0;
                } else {
                    val = ht.get(ser);
                    if (!GraphParam.isValid(val)) {
                        val = new Double(0.0);
                        len = 0;
                    } else {
                        Number d = (Number)val;
                        double tmp = d.doubleValue() - this.gp.baseValue;
                        len = (int)(dely * (double)this.gp.tickNum * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                    }
                }
                double lb = (double)this.gp.gRect1.x + (double)(i + 1) * categorySpan + (double)((2 * i + 1) * this.gp.series.size()) * seriesWidth / 2.0;
                Point pt1 = new Point((int)lb, this.gp.valueBaseLine - len);
                Point pt2 = new Point((int)(lb + coorWidth), (int)((double)(this.gp.valueBaseLine - len) - coorWidth));
                if (this.gp.dispValueOntop) {
                    if (GraphParam.isValid(val)) {
                        val = this.gp.getFormattedValue(val);
                        TR.setBounds(this.gp.GFV_VALUE.getTextSize(val.toString()));
                        x = pt1.x;
                        y = pt1.y;
                        this.gp.GFV_VALUE.outText(x, y - 3, val.toString());
                    }
                }
                if (this.gp.coorWidth == 0) {
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.fillRect(pt1.x - 3, pt1.y - 3, 6, 6);
                    this.gp.g.fillRect(pt2.x - 3, pt2.y - 3, 6, 6);
                    this.gp.g.setColor(this.gp.coorColor);
                    this.gp.g.drawRect(pt1.x - 3, pt1.y - 3, 6, 6);
                    this.gp.g.drawRect(pt2.x - 3, pt2.y - 3, 6, 6);
                }
                if (i > 0) {
                    int[] ptx1 = new int[]{prePoints1[j].x, prePoints2[j].x, pt2.x, pt1.x};
                    int[] pty1 = new int[]{prePoints1[j].y, prePoints2[j].y, pt2.y, pt1.y};
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    if (this.gp.coorWidth != 0) {
                        this.gp.g.setColor(this.gp.coorColor);
                    } else {
                        this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    }
                    this.gp.g.drawPolygon(ptx1, pty1, 4);
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
                ++j;
            }
            ++i;
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.valueBaseLine, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine);
        Draw2Y2Line.drawY2Line(this.gp, this.gp.series.size());
    }

    public static void drawY2Line(GraphParam gp, int series1Count) {
        int y;
        int x;
        gp.graphRect = new Rectangle(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10 || gp.graphRect.height < 10) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = (double)gp.graphRect.width / ((double)(gp.category.size() + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.category.size() * gp.series.size()));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        int tmpInt = (int)((double)(gp.category.size() + 1) * categorySpan + coorWidth + (double)(gp.category.size() * gp.series.size()) * seriesWidth);
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2;
        gp.graphRect.width = tmpInt;
        double dely = ((double)gp.graphRect.height - coorWidth) / (double)gp.tickNum2;
        tmpInt = (int)(dely * (double)gp.tickNum2 + coorWidth);
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = new Rectangle(gp.graphRect);
        gp.gRect2 = new Rectangle(gp.graphRect);
        int i = 0;
        while (i <= gp.tickNum2) {
            int tmpi = (int)((double)(gp.gRect1.y + gp.gRect1.height) - (double)i * dely);
            gp.g.setColor(gp.coorColor);
            gp.g.drawLine(gp.gRect1.x + gp.gRect1.width - gp.tickLen, tmpi, gp.gRect1.x + gp.gRect1.width, tmpi);
            Number coory = (Number)gp.coorValue2.get(i);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (gp.dataMarkFormat != null && gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(gp.GFV_YLABEL.getTextSize(scoory));
            x = gp.gRect1.x + gp.gRect1.width + gp.tickLen;
            y = (int)((double)(gp.gRect1.y + gp.gRect1.height) - (double)i * dely + (double)(Draw2Y2Line.TR.height / 2));
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() == gp.baseValue2 + gp.minValue2) {
                gp.valueBaseLine = (int)((double)(gp.gRect1.y + gp.gRect1.height) - (double)i * dely);
            }
            ++i;
        }
        gp.g.setStroke(new BasicStroke(1.0E-5f));
        Point[] prePoints1 = new Point[gp.series2.size()];
        Point[] prePoints2 = new Point[gp.series2.size()];
        i = 0;
        while (i < gp.category.size()) {
            GraphDataSource ht = (GraphDataSource)gp.graphData.get(gp.category.get(i));
            int j = 0;
            while (j < gp.series2.size()) {
                int len = 0;
                Object ser = gp.series2.get(j);
                Object val = "";
                if (ser == null) {
                    len = 0;
                } else {
                    val = ht.get(ser);
                    if (!GraphParam.isValid(val)) {
                        len = 0;
                    } else {
                        Number d = (Number)val;
                        double tmp = d.doubleValue() - gp.baseValue2;
                        len = (int)(dely * (double)gp.tickNum2 * (tmp - gp.minValue2) / (gp.maxValue2 * gp.coorScale2));
                    }
                }
                double lb = (double)gp.gRect1.x + (double)(i + 1) * categorySpan + (double)((2 * i + 1) * gp.series.size()) * seriesWidth / 2.0;
                Point pt1 = new Point((int)lb, gp.valueBaseLine - len);
                Point pt2 = new Point((int)(lb + coorWidth), (int)((double)(gp.valueBaseLine - len) - coorWidth));
                if (gp.dispValueOntop && GraphParam.isValid(val)) {
                    val = gp.getFormattedValue(val);
                    TR.setBounds(gp.GFV_VALUE.getTextSize(val.toString()));
                    x = pt1.x;
                    y = pt1.y;
                    gp.GFV_VALUE.outText(x, y - 3, val.toString());
                }
                if (gp.coorWidth == 0) {
                    gp.g.setColor(gp.seriesColor[(series1Count + j) % gp.seriesColor.length]);
                    gp.g.fillOval(pt1.x - 3, pt1.y - 3, 6, 6);
                    gp.g.setColor(gp.coorColor);
                    gp.g.setStroke(new BasicStroke(1.0E-5f));
                    gp.g.drawOval(pt1.x - 3, pt1.y - 3, 6, 6);
                }
                if (i > 0) {
                    int[] ptx1 = new int[]{prePoints1[j].x, prePoints2[j].x, pt2.x, pt1.x};
                    int[] pty1 = new int[]{prePoints1[j].y, prePoints2[j].y, pt2.y, pt1.y};
                    gp.g.setColor(gp.seriesColor[(series1Count + j) % gp.seriesColor.length]);
                    if (gp.coorWidth != 0) {
                        gp.g.setColor(gp.coorColor);
                    } else {
                        gp.g.setColor(gp.seriesColor[(series1Count + j) % gp.seriesColor.length]);
                    }
                    gp.g.drawPolygon(ptx1, pty1, 4);
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
                ++j;
            }
            ++i;
        }
    }
}

