/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class DrawArea3D
implements DrawBase {
    GraphParam gp;

    public DrawArea3D(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        this.gp.initGraphInset();
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        if (this.gp.coorWidth < 0 || this.gp.coorWidth > 10000) {
            this.gp.coorWidth = 0;
        }
        double seriesWidth = (double)this.gp.graphRect.width / ((double)(this.gp.category.size() + 1) * this.gp.categorySpan / 100.0 + (double)this.gp.coorWidth / 200.0 + (double)(this.gp.category.size() * this.gp.series.size()));
        double coorWidth = seriesWidth * ((double)this.gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (this.gp.categorySpan / 100.0);
        int tmpInt = (int)((double)(this.gp.category.size() + 1) * categorySpan + coorWidth + (double)(this.gp.category.size() * this.gp.series.size()) * seriesWidth);
        this.gp.graphRect.x += (this.gp.graphRect.width - tmpInt) / 2;
        this.gp.graphRect.width = tmpInt;
        double dely = ((double)this.gp.graphRect.height - coorWidth) / (double)this.gp.tickNum;
        tmpInt = (int)(dely * (double)this.gp.tickNum + coorWidth);
        this.gp.graphRect.y += (this.gp.graphRect.height - tmpInt) / 2;
        this.gp.graphRect.height = tmpInt;
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        this.gp.gRect1.y = (int)((double)this.gp.gRect1.y + coorWidth);
        this.gp.gRect1.width = (int)((double)this.gp.gRect1.width - coorWidth);
        this.gp.gRect1.height = (int)((double)this.gp.gRect1.height - coorWidth);
        this.gp.gRect2.x = (int)((double)this.gp.gRect2.x + coorWidth);
        this.gp.gRect2.width = (int)((double)this.gp.gRect2.width - coorWidth);
        this.gp.gRect2.height = (int)((double)this.gp.gRect2.height - coorWidth);
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawRect(this.gp.gRect2.x, this.gp.gRect2.y, this.gp.gRect2.width, this.gp.gRect2.height);
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect2.x, this.gp.gRect2.y);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y + this.gp.gRect2.height);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i <= this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x - this.gp.tickLen, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely));
            if (i != this.gp.tickNum || this.gp.gRect1.height != 10 * (this.gp.gRect1.height / 10)) {
                this.gp.g.setColor(this.gp.gridColor);
                this.gp.g.drawLine(this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                if (i != 0) {
                    float[] dashes = new float[]{2.0f};
                    this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                }
                this.gp.g.drawLine(this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely), this.gp.gRect2.x + this.gp.gRect2.width - 1, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            }
            if (i == 0) {
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            Number coory = (Number)this.gp.coorValue.get(i);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x = this.gp.gRect1.x - DrawArea3D.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely + (double)(DrawArea3D.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() == this.gp.baseValue + this.gp.minValue) {
                this.gp.valueBaseLine = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely);
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            ++i;
        }
        StatisticGraph.drawWarnLine(this.gp);
        Point[] prePoints1 = new Point[this.gp.series.size()];
        Point[] prePoints2 = new Point[this.gp.series.size()];
        i = 0;
        while (i < this.gp.category.size()) {
            int delx = (int)((double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)this.gp.series.size() + seriesWidth * (double)this.gp.series.size() / 2.0);
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen);
            String value = this.gp.category.get(i).toString().trim();
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(value));
            x = this.gp.gRect1.x + delx - DrawArea3D.TR.width / 2;
            y = this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen + DrawArea3D.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, value);
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
            int j = 0;
            while (j < this.gp.series.size()) {
                int[] pty1;
                int[] ptx1;
                int len = 0;
                Object ser = this.gp.series.get(j);
                if (ser == null) {
                    len = 0;
                } else {
                    Object val = ht.get(ser);
                    if (val == null || val.toString().trim().length() == 0) {
                        len = 0;
                    } else {
                        Number d = (Number)val;
                        double tmp = d.doubleValue() - this.gp.baseValue;
                        len = (int)(dely * (double)this.gp.tickNum * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                    }
                }
                double lb = (double)this.gp.gRect1.x + (double)(i + 1) * categorySpan + (double)((2 * i + 1) * this.gp.series.size()) * seriesWidth / 2.0;
                Point pt1 = new Point((int)lb, this.gp.valueBaseLine - len);
                Point pt2 = new Point((int)(lb + coorWidth), (int)((double)(this.gp.valueBaseLine - len) - coorWidth));
                if (this.gp.coorWidth == 0) {
                    if (this.gp.series.size() == 1) {
                        this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                    } else {
                        this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    }
                    this.gp.g.fillRect(pt1.x - 2, pt1.y - 2, 4, 4);
                    this.gp.g.fillRect(pt2.x - 2, pt2.y - 2, 4, 4);
                    if (seriesWidth > 3.0) {
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawRect(pt1.x - 2, pt1.y - 2, 4, 4);
                        this.gp.g.drawRect(pt2.x - 2, pt2.y - 2, 4, 4);
                    }
                }
                if (i > 0) {
                    ptx1 = new int[]{prePoints1[j].x, prePoints2[j].x, pt2.x, pt1.x};
                    pty1 = new int[]{prePoints1[j].y, prePoints2[j].y, pt2.y, pt1.y};
                    this.gp.g.setColor(Color.gray);
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    if (this.gp.coorWidth != 0) {
                        this.gp.g.setColor(this.gp.coorColor);
                    } else {
                        this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    }
                    if (seriesWidth > 3.0) {
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    }
                    int[] ptx2 = new int[]{prePoints1[j].x, prePoints1[j].x, pt1.x, pt1.x};
                    int[] pty2 = new int[]{prePoints1[j].y, this.gp.valueBaseLine, this.gp.valueBaseLine, pt1.y};
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.fillPolygon(ptx2, pty2, 4);
                    if (this.gp.coorWidth != 0) {
                        this.gp.g.setColor(this.gp.coorColor);
                    } else {
                        this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    }
                    if (seriesWidth > 3.0) {
                        this.gp.g.drawPolygon(ptx2, pty2, 4);
                    }
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
                if (len >= 0 && i == this.gp.category.size() - 1) {
                    ptx1 = new int[]{prePoints1[j].x, prePoints1[j].x, prePoints2[j].x, prePoints2[j].x};
                    pty1 = new int[]{prePoints1[j].y, this.gp.valueBaseLine, (int)((double)this.gp.valueBaseLine - coorWidth), prePoints2[j].y};
                    this.gp.g.setColor(Color.gray);
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    if (this.gp.coorWidth != 0) {
                        this.gp.g.setColor(this.gp.coorColor);
                    } else {
                        this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    }
                    if (seriesWidth > 3.0) {
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.valueBaseLine, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine, (int)((double)(this.gp.gRect1.x + this.gp.gRect1.width) + coorWidth), (int)((double)this.gp.valueBaseLine - coorWidth));
    }
}

