/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class DrawBar3DObj
implements DrawBase {
    GraphParam gp;

    public DrawBar3DObj(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        this.gp.initGraphInset();
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        if (this.gp.coorWidth < 0 || this.gp.coorWidth > 10000) {
            this.gp.coorWidth = 0;
        }
        double seriesWidth = (double)this.gp.graphRect.height / ((double)(this.gp.category.size() + 1) * this.gp.categorySpan / 100.0 + (double)this.gp.coorWidth / 200.0 + (double)(this.gp.category.size() * this.gp.series.size()));
        double coorWidth = seriesWidth * ((double)this.gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (this.gp.categorySpan / 100.0);
        int tmpInt = (int)((double)(this.gp.category.size() + 1) * categorySpan + coorWidth + (double)(this.gp.category.size() * this.gp.series.size()) * seriesWidth);
        this.gp.graphRect.y += (this.gp.graphRect.height - tmpInt) / 2;
        this.gp.graphRect.height = tmpInt;
        double delx = ((double)this.gp.graphRect.width - coorWidth) / (double)this.gp.tickNum;
        tmpInt = (int)(delx * (double)this.gp.tickNum + coorWidth);
        this.gp.graphRect.x += (this.gp.graphRect.width - tmpInt) / 2;
        this.gp.graphRect.width = tmpInt;
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        this.gp.gRect1.y = (int)((double)this.gp.gRect1.y + coorWidth);
        this.gp.gRect1.width = (int)((double)this.gp.gRect1.width - coorWidth);
        this.gp.gRect1.height = (int)((double)this.gp.gRect1.height - coorWidth);
        this.gp.gRect2.x = (int)((double)this.gp.gRect2.x + coorWidth);
        this.gp.gRect2.width = (int)((double)this.gp.gRect2.width - coorWidth);
        this.gp.gRect2.height = (int)((double)this.gp.gRect2.height - coorWidth);
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawRect(this.gp.gRect2.x, this.gp.gRect2.y, this.gp.gRect2.width, this.gp.gRect2.height);
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect2.x, this.gp.gRect2.y);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y + this.gp.gRect2.height);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i <= this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine((int)((double)this.gp.gRect1.x + (double)i * delx), this.gp.gRect1.y + this.gp.gRect1.height, (int)((double)this.gp.gRect1.x + (double)i * delx), this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen);
            if (i != this.gp.tickNum || this.gp.gRect1.width != 10 * (this.gp.gRect1.width / 10)) {
                this.gp.g.setColor(this.gp.gridColor);
                this.gp.g.drawLine((int)((double)this.gp.gRect1.x + (double)i * delx), this.gp.gRect1.y + this.gp.gRect1.height, (int)((double)this.gp.gRect2.x + (double)i * delx), this.gp.gRect2.y + this.gp.gRect2.height);
                if (i != 0) {
                    float[] dashes = new float[]{2.0f};
                    this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                }
                this.gp.g.drawLine((int)((double)this.gp.gRect2.x + (double)i * delx), this.gp.gRect2.y + this.gp.gRect2.height, (int)((double)this.gp.gRect2.x + (double)i * delx), this.gp.gRect2.y + 1);
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            }
            if (i == 0) {
                int[] ptx1 = new int[]{this.gp.gRect1.x, this.gp.gRect2.x, this.gp.gRect2.x, this.gp.gRect1.x};
                int[] pty1 = new int[]{this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.y + this.gp.gRect2.height, this.gp.gRect2.y, this.gp.gRect1.y};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            Number coorx = (Number)this.gp.coorValue.get(i);
            String scoorx = coorx.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoorx = df.format(coorx.doubleValue());
            }
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(scoorx));
            x = (int)((double)this.gp.gRect1.x + (double)i * delx - (double)(DrawBar3DObj.TR.width / 2));
            y = this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen + DrawBar3DObj.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, scoorx);
            if (coorx.doubleValue() == this.gp.baseValue + this.gp.minValue) {
                this.gp.valueBaseLine = (int)((double)this.gp.gRect1.x + (double)i * delx);
                int[] ptx1 = new int[]{(int)((double)this.gp.gRect1.x + (double)i * delx), (int)((double)this.gp.gRect2.x + (double)i * delx), (int)((double)this.gp.gRect2.x + (double)i * delx), (int)((double)this.gp.gRect1.x + (double)i * delx)};
                int[] pty1 = new int[]{this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.y + this.gp.gRect2.height, this.gp.gRect2.y, this.gp.gRect1.y};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            ++i;
        }
        i = 0;
        while (i < this.gp.category.size()) {
            int dely = (int)((double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)this.gp.series.size() + seriesWidth * (double)this.gp.series.size() / 2.0);
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height - dely, this.gp.gRect1.x - this.gp.tickLen, this.gp.gRect1.y + this.gp.gRect1.height - dely);
            String value = this.gp.category.get(i).toString();
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(value));
            x = this.gp.gRect1.x - DrawBar3DObj.TR.width - this.gp.tickLen;
            y = this.gp.gRect1.y + dely + DrawBar3DObj.TR.height / 2;
            this.gp.GFV_YLABEL.outText(x, y, value);
            if (this.gp.graphTransparent) {
                this.gp.g.setComposite(AlphaComposite.getInstance(3, 0.6f));
            }
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
            int j = 0;
            while (j < this.gp.series.size()) {
                int[] pty1;
                int[] ptx1;
                int len = 0;
                Object ser = this.gp.series.get(j);
                if (ser == null) {
                    len = 0;
                } else {
                    Object val = ht.get(ser);
                    if (val == null || val.toString().trim().length() == 0) {
                        len = 0;
                    } else {
                        Number d = (Number)val;
                        double tmp = d.doubleValue() - this.gp.baseValue;
                        len = (int)(delx * (double)this.gp.tickNum * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                    }
                }
                int lb = (int)((double)this.gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * this.gp.series.size() + j + 1) * seriesWidth);
                if (this.gp.series.size() == 1) {
                    this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                } else {
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                }
                if (len >= 0) {
                    this.gp.g.fillRect(this.gp.valueBaseLine, (int)((double)lb - seriesWidth), len, (int)seriesWidth);
                    if (seriesWidth > 3.0) {
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawRect(this.gp.valueBaseLine, (int)((double)lb - seriesWidth), len, (int)seriesWidth);
                    }
                } else {
                    this.gp.g.fillRect(this.gp.valueBaseLine + len, (int)((double)lb - seriesWidth), Math.abs(len), (int)seriesWidth);
                    if (seriesWidth > 3.0) {
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawRect(this.gp.valueBaseLine + len, (int)((double)lb - seriesWidth), Math.abs(len), (int)seriesWidth);
                    }
                }
                if (this.gp.series.size() == 1) {
                    this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                } else {
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                }
                if (len >= 0) {
                    ptx1 = new int[]{this.gp.valueBaseLine, (int)((double)this.gp.valueBaseLine + coorWidth), (int)((double)(this.gp.valueBaseLine + len) + coorWidth), this.gp.valueBaseLine + len};
                    pty1 = new int[]{(int)((double)lb - seriesWidth), (int)((double)lb - seriesWidth - coorWidth), (int)((double)lb - seriesWidth - coorWidth), (int)((double)lb - seriesWidth)};
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    if (seriesWidth > 3.0) {
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    }
                } else {
                    ptx1 = new int[]{this.gp.valueBaseLine + len, (int)((double)(this.gp.valueBaseLine + len) + coorWidth), (int)((double)this.gp.valueBaseLine + coorWidth), this.gp.valueBaseLine};
                    pty1 = new int[]{(int)((double)lb - seriesWidth), (int)((double)lb - seriesWidth - coorWidth), (int)((double)lb - seriesWidth - coorWidth), (int)((double)lb - seriesWidth)};
                    this.gp.g.fillPolygon(ptx1, pty1, 4);
                    if (seriesWidth > 3.0) {
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    }
                }
                Color clr = null;
                clr = this.gp.series.size() == 1 ? this.gp.seriesColor[i % this.gp.seriesColor.length] : this.gp.seriesColor[j % this.gp.seriesColor.length];
                if (len < 0) {
                    len = 0;
                }
                int[] ptx2 = new int[]{this.gp.valueBaseLine + len, (int)((double)(this.gp.valueBaseLine + len) + coorWidth), (int)((double)(this.gp.valueBaseLine + len) + coorWidth), this.gp.valueBaseLine + len};
                int[] pty2 = new int[]{(int)((double)lb - seriesWidth), (int)((double)lb - seriesWidth - coorWidth), (int)((double)lb - coorWidth), lb};
                clr = new Color(clr.getRed() > 64 ? clr.getRed() - 64 : clr.getRed(), clr.getGreen() > 64 ? clr.getGreen() - 64 : clr.getGreen(), clr.getBlue() > 64 ? clr.getBlue() - 64 : clr.getBlue());
                this.gp.g.setColor(clr);
                this.gp.g.fillPolygon(ptx2, pty2, 4);
                if (seriesWidth > 3.0) {
                    this.gp.g.setColor(this.gp.coorColor);
                    this.gp.g.drawPolygon(ptx2, pty2, 4);
                }
                ++j;
            }
            if (this.gp.graphTransparent) {
                this.gp.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
            ++i;
        }
    }
}

