/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class DrawCol3D
implements DrawBase {
    GraphParam gp;

    public DrawCol3D(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        double dely = 0.0;
        this.gp.initGraphInset();
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        double coorWidth = Math.min(this.gp.graphRect.width, this.gp.graphRect.height) / 2;
        this.gp.gRect1.y = (int)((double)this.gp.gRect1.y + coorWidth);
        this.gp.gRect1.width = (int)((double)this.gp.gRect1.width - coorWidth);
        this.gp.gRect1.height = (int)((double)this.gp.gRect1.height - coorWidth);
        dely = this.gp.gRect1.height / this.gp.tickNum;
        this.gp.gRect1.y = (int)((double)this.gp.gRect1.y + ((double)this.gp.gRect1.height - dely * (double)this.gp.tickNum) / 2.0);
        this.gp.gRect1.height = (int)(dely * (double)this.gp.tickNum);
        double seriesDeep = coorWidth / ((double)((this.gp.series.size() + 1) * this.gp.seriesSpan) / 100.0 + (double)this.gp.series.size());
        double seriesSpan = seriesDeep * ((double)this.gp.seriesSpan / 100.0);
        int tmpInt = (int)((double)(this.gp.series.size() + 1) * seriesSpan + (double)this.gp.series.size() * seriesDeep);
        tmpInt = (int)((coorWidth - (double)tmpInt) / 2.0);
        this.gp.gRect1.y += tmpInt;
        coorWidth = (double)(this.gp.series.size() + 1) * seriesSpan + (double)this.gp.series.size() * seriesDeep;
        double seriesWidth = (double)this.gp.gRect1.width / ((double)(this.gp.category.size() + 1) * this.gp.categorySpan / 100.0 + (double)this.gp.coorWidth / 200.0 + (double)(this.gp.category.size() * this.gp.series.size()));
        double categorySpan = (double)this.gp.gRect1.width / ((double)this.gp.category.size() * 1.5);
        if (seriesWidth > seriesDeep * 2.0) {
            categorySpan += (seriesWidth - seriesDeep * 2.0) / 2.0;
            seriesWidth = seriesDeep * 2.0;
        } else {
            seriesSpan += (seriesDeep - seriesWidth / 2.0) / 2.0;
            seriesDeep = seriesWidth / 2.0;
        }
        this.gp.gRect2.x = (int)((double)this.gp.gRect1.x + coorWidth);
        this.gp.gRect2.width = this.gp.gRect1.width;
        this.gp.gRect2.y = (int)((double)this.gp.gRect1.y - coorWidth);
        this.gp.gRect2.height = this.gp.gRect1.height;
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height);
        this.gp.g.drawRect(this.gp.gRect2.x, this.gp.gRect2.y, this.gp.gRect2.width, this.gp.gRect2.height);
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect2.x, this.gp.gRect2.y);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y + this.gp.gRect2.height);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i <= this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x - this.gp.tickLen, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely));
            if (i != this.gp.tickNum || this.gp.gRect1.height != 10 * (this.gp.gRect1.height / 10)) {
                this.gp.g.setColor(this.gp.gridColor);
                this.gp.g.drawLine(this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                if (i != 0) {
                    float[] dashes = new float[]{2.0f};
                    this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                }
                this.gp.g.drawLine(this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely), this.gp.gRect2.x + this.gp.gRect2.width - 1, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            }
            if (i == 0) {
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            Number coory = (Number)this.gp.coorValue.get(i);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x = this.gp.gRect1.x - DrawCol3D.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely + (double)(DrawCol3D.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() == this.gp.baseValue + this.gp.minValue) {
                this.gp.valueBaseLine = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely);
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            ++i;
        }
        StatisticGraph.drawWarnLine(this.gp);
        if (this.gp.graphTransparent) {
            this.gp.g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        i = 0;
        while (i < this.gp.category.size()) {
            int delx = (int)((double)(i + 1) * categorySpan + (double)i * seriesWidth + seriesWidth / 2.0);
            this.gp.g.setColor(this.gp.gridColor);
            float[] dashes = new float[]{2.0f};
            this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
            this.gp.g.drawLine(this.gp.gRect1.x + delx, this.gp.valueBaseLine, (int)((double)(this.gp.gRect1.x + delx) + coorWidth), (int)((double)this.gp.valueBaseLine - coorWidth));
            this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen);
            String value = this.gp.category.get(i).toString().trim();
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(value));
            x = this.gp.gRect1.x + delx - DrawCol3D.TR.width / 2;
            y = this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen + DrawCol3D.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, value);
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
            if (ht != null) {
                int j = this.gp.series.size() - 1;
                while (j >= 0) {
                    int[] pty1;
                    int[] ptx1;
                    int delz = (int)((double)(i + 1) * seriesSpan + (double)i * seriesDeep + seriesWidth / 2.0);
                    int len = 0;
                    Object ser = this.gp.series.get(j);
                    Object val = null;
                    if (ser == null) {
                        len = 0;
                    } else {
                        val = ht.get(ser);
                        if (!GraphParam.isValid(val)) {
                            val = new Double(0.0);
                            len = 0;
                        } else {
                            Number d = (Number)val;
                            double tmp = d.doubleValue() - this.gp.baseValue;
                            len = (int)(dely * (double)this.gp.tickNum * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                        }
                    }
                    int lb = (int)((double)this.gp.gRect1.x + (double)(i + 1) * categorySpan + (double)i * seriesWidth);
                    int br = (int)((double)(j + 1) * seriesSpan + (double)j * seriesDeep);
                    if (len >= 0) {
                        if (this.gp.series.size() == 1) {
                            this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                        } else {
                            this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                        }
                        this.gp.g.fillRect(lb + br, this.gp.valueBaseLine - len - br, (int)seriesWidth, len);
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawRect(lb + br, this.gp.valueBaseLine - len - br, (int)seriesWidth, len);
                    } else {
                        if (this.gp.series.size() == 1) {
                            this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                        } else {
                            this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                        }
                        this.gp.g.fillRect(lb + br, this.gp.valueBaseLine - br, (int)seriesWidth, Math.abs(len));
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawRect(lb + br, this.gp.valueBaseLine - br, (int)seriesWidth, Math.abs(len));
                    }
                    if (val == null) {
                        val = "";
                    }
                    if (len >= 0) {
                        ptx1 = new int[]{lb + br, (int)((double)(lb + br) + seriesDeep), (int)((double)(lb + br) + seriesDeep + seriesWidth), (int)((double)(lb + br) + seriesWidth)};
                        pty1 = new int[]{this.gp.valueBaseLine - len - br, (int)((double)(this.gp.valueBaseLine - len) - seriesDeep - (double)br), (int)((double)(this.gp.valueBaseLine - len) - seriesDeep - (double)br), this.gp.valueBaseLine - len - br};
                        if (this.gp.series.size() == 1) {
                            this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                        } else {
                            this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                        }
                        this.gp.g.fillPolygon(ptx1, pty1, 4);
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    } else {
                        ptx1 = new int[]{lb + br, (int)((double)(lb + br) + seriesDeep), (int)((double)(lb + br) + seriesDeep + seriesWidth), (int)((double)(lb + br) + seriesWidth)};
                        pty1 = new int[]{this.gp.valueBaseLine - br, (int)((double)this.gp.valueBaseLine - seriesDeep - (double)br), (int)((double)this.gp.valueBaseLine - seriesDeep - (double)br), this.gp.valueBaseLine - br};
                        if (this.gp.series.size() == 1) {
                            this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                        } else {
                            this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                        }
                        this.gp.g.fillPolygon(ptx1, pty1, 4);
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawPolygon(ptx1, pty1, 4);
                    }
                    int[] ptx2 = new int[]{(int)((double)(lb + br) + seriesWidth), (int)((double)(lb + br) + seriesWidth), (int)((double)(lb + br) + seriesWidth + seriesDeep), (int)((double)(lb + br) + seriesWidth + seriesDeep)};
                    int[] pty2 = new int[]{this.gp.valueBaseLine - br, this.gp.valueBaseLine - len - br, (int)((double)(this.gp.valueBaseLine - len) - seriesDeep - (double)br), (int)((double)this.gp.valueBaseLine - seriesDeep - (double)br)};
                    Color clr = null;
                    clr = this.gp.series.size() == 1 ? this.gp.seriesColor[i % this.gp.seriesColor.length] : this.gp.seriesColor[j % this.gp.seriesColor.length];
                    clr = new Color(clr.getRed() > 64 ? clr.getRed() - 64 : clr.getRed(), clr.getGreen() > 64 ? clr.getGreen() - 64 : clr.getGreen(), clr.getBlue() > 64 ? clr.getBlue() - 64 : clr.getBlue());
                    this.gp.g.setColor(clr);
                    this.gp.g.fillPolygon(ptx2, pty2, 4);
                    this.gp.g.setColor(this.gp.coorColor);
                    this.gp.g.drawPolygon(ptx2, pty2, 4);
                    if (this.gp.dispValueOntop) {
                        if (GraphParam.isValid(val)) {
                            val = this.gp.getFormattedValue(val);
                            TR.setBounds(this.gp.GFV_VALUE.getTextSize(val.toString()));
                            x = ptx1[1];
                            y = pty1[0];
                            if (len < 0) {
                                y -= DrawCol3D.TR.height;
                            }
                            this.gp.GFV_VALUE.outText(x, y, val.toString());
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
        if (this.gp.graphTransparent) {
            this.gp.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.valueBaseLine, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine, (int)((double)(this.gp.gRect1.x + this.gp.gRect1.width) + coorWidth), (int)((double)this.gp.valueBaseLine - coorWidth));
    }
}

