/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class DrawGantt
implements DrawBase {
    GraphParam gp;

    public DrawGantt(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        String value;
        this.gp.coorWidth = 0;
        this.gp.baseValue = 0.0;
        this.gp.initGraphInset();
        DrawGantt.createCoorValue(this.gp);
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        double seriesWidth = this.gp.graphRect.height / (this.gp.series.size() + 1);
        double coorWidth = this.gp.graphRect.width / this.gp.coorValue.size();
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i < this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine((int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height, (int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height + this.gp.tickLen);
            if (i != 0) {
                float[] dashes = new float[]{2.0f};
                this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
            }
            this.gp.g.drawLine((int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height, (int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + 1);
            this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            value = this.gp.coorValue.get(i).toString();
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(value));
            x = (int)((double)this.gp.graphRect.x + (double)i * coorWidth - (double)(DrawGantt.TR.width / 2));
            y = this.gp.graphRect.y + this.gp.graphRect.height + this.gp.tickLen + DrawGantt.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, value);
            this.gp.g.drawLine(this.gp.graphRect.x, this.gp.graphRect.y + this.gp.graphRect.height, this.gp.graphRect.x + this.gp.graphRect.width, this.gp.graphRect.y + this.gp.graphRect.height);
            ++i;
        }
        i = 1;
        while (i <= this.gp.series.size()) {
            value = this.gp.series.get(i - 1).toString();
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(value));
            x = this.gp.graphRect.x - DrawGantt.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth + (double)(DrawGantt.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, value);
            this.gp.g.drawLine(this.gp.graphRect.x - this.gp.tickLen, (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth), this.gp.graphRect.x, (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth));
            Vector[] data = (Vector[])this.gp.graphData.get(value);
            int j = 0;
            while (j < data[0].size()) {
                Object oState = data[0].get(j);
                Object oStart = data[1].get(j);
                Object oEnd = data[2].get(j);
                int x1 = StatisticGraph.calcDateX(this.gp, oStart.toString(), coorWidth);
                int x2 = StatisticGraph.calcDateX(this.gp, oEnd.toString(), coorWidth);
                int[] px = new int[]{x1, x1, x2, x2};
                int y2 = (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth);
                int y1 = y2 - this.gp.stateH / 2;
                int y3 = y2 + this.gp.stateH / 2;
                int[] pySchedule = new int[]{y2 - 1, y1, y1, y2 - 1};
                int[] pyImplement = new int[]{y3, y2 + 1, y2 + 1, y3};
                String strState = oState.toString().toLowerCase();
                this.gp.g.setColor(this.getStateColor(oState));
                if (strState.indexOf("\u8ba1\u5212") >= 0 || strState.indexOf("schedule") >= 0) {
                    this.gp.g.fillPolygon(px, pySchedule, 4);
                    this.gp.g.setColor(this.gp.lineColor);
                    this.gp.g.drawPolygon(px, pySchedule, 4);
                } else {
                    this.gp.g.fillPolygon(px, pyImplement, 4);
                    this.gp.g.setColor(this.gp.lineColor);
                    this.gp.g.drawPolygon(px, pyImplement, 4);
                }
                ++j;
            }
            ++i;
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.graphRect.x, this.gp.graphRect.y, this.gp.graphRect.x, this.gp.graphRect.y + this.gp.graphRect.height);
    }

    public static void createCoorValue(GraphParam gp) {
        gp.coorValue = new Vector();
        GregorianCalendar g1 = new GregorianCalendar();
        GregorianCalendar g2 = new GregorianCalendar();
        g1.setTime(new Date(gp.startTime.getTime()));
        g2.setTime(new Date(gp.endTime.getTime()));
        int j = 0;
        switch (gp.timeScale) {
            case 1: {
                g2.add(1, 1);
                while (g1.before(g2)) {
                    int Y1 = g1.get(1);
                    gp.coorValue.add(j, String.valueOf(String.valueOf(Y1)) + "\u5e74");
                    g1.add(1, 1);
                    ++j;
                }
                break;
            }
            case 2: {
                while (g1.before(g2)) {
                    int Y1 = g1.get(1);
                    int M1 = g1.get(2);
                    gp.coorValue.add(j, String.valueOf(String.valueOf(Y1)) + "\u5e74" + String.valueOf(M1 + 1) + "\u6708");
                    g1.add(2, 1);
                    ++j;
                }
                break;
            }
            case 3: {
                while (g1.before(g2)) {
                    int Y1 = g1.get(1);
                    int M1 = g1.get(2);
                    int D1 = g1.get(5);
                    gp.coorValue.add(j, String.valueOf(String.valueOf(Y1)) + "\u5e74" + String.valueOf(M1 + 1) + "\u6708" + String.valueOf(D1) + "\u65e5");
                    g1.add(5, 1);
                    ++j;
                }
                break;
            }
            case 4: {
                while (g1.before(g2)) {
                    int Y1 = g1.get(1);
                    int M1 = g1.get(2);
                    int D1 = g1.get(5);
                    int T1 = g1.get(11);
                    if (T1 == 0) {
                        gp.coorValue.add(j, String.valueOf(String.valueOf(D1)) + "\u65e5" + String.valueOf(T1) + "\u65f6");
                    } else {
                        gp.coorValue.add(j, String.valueOf(String.valueOf(T1)) + "\u65f6");
                    }
                    g1.add(11, 1);
                    ++j;
                }
                break;
            }
            case 5: {
                while (g1.before(g2)) {
                    int H = g1.get(11);
                    int Mi = g1.get(12);
                    gp.coorValue.add(j, String.valueOf(String.valueOf(H)) + "\u65f6" + String.valueOf(Mi) + "\u5206");
                    g1.add(12, 1);
                    ++j;
                }
                break;
            }
            case 6: {
                while (g1.before(g2)) {
                    int H = g1.get(11);
                    int Mi = g1.get(12);
                    int S = g1.get(13);
                    gp.coorValue.add(j, String.valueOf(String.valueOf(H)) + "\u65f6" + String.valueOf(Mi) + "\u5206" + String.valueOf(S) + "\u79d2");
                    g1.add(13, 1);
                    ++j;
                }
                break;
            }
        }
        gp.tickNum = j;
    }

    private Color getStateColor(Object oState) {
        int i = 0;
        i = 0;
        while (i < this.gp.category.size()) {
            Object tmp = this.gp.category.get(i);
            if (tmp.equals(oState)) break;
            ++i;
        }
        return this.gp.getColor(i);
    }
}

