/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.text.DecimalFormat;

public class DrawPie
implements DrawBase {
    GraphParam gp;

    public DrawPie(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int radiusx = 0;
        int radiusy = 0;
        this.gp.coorWidth = 0;
        this.gp.pieHeight = 0;
        this.gp.pieRotation = 100;
        this.gp.initGraphInset();
        if (this.gp.minValue < 0.0) {
            this.gp.g.setColor(Color.black);
            this.gp.g.setFont(this.gp.GFV_TITLE.font);
            this.gp.g.drawString("\u753b\u997c\u5f62\u56fe\u4e0d\u80fd\u6709\u8d1f\u6570\u503c\u3002", 50, 50);
            return;
        }
        if (this.gp.pieHeight > 100) {
            this.gp.pieHeight = 100;
        }
        if (this.gp.pieHeight < 0) {
            this.gp.pieHeight = 0;
        }
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        radiusx = this.gp.series.size() == 0 ? this.gp.graphRect.width / 2 : this.gp.graphRect.width / (2 * this.gp.series.size());
        radiusy = (int)((double)this.gp.graphRect.height / ((double)(2 * this.gp.series.size()) + (double)this.gp.pieHeight / 100.0));
        if (this.gp.pieRotation < 10) {
            this.gp.pieRotation = 10;
        }
        if (this.gp.pieRotation > 100) {
            this.gp.pieRotation = 100;
        }
        if ((double)radiusx * ((double)this.gp.pieRotation / 100.0) > (double)radiusy) {
            radiusx = (int)((double)radiusy / ((double)this.gp.pieRotation / 100.0));
        } else {
            radiusy = (int)((double)(radiusx * this.gp.pieRotation) / 100.0);
        }
        int dely = (int)((double)radiusy * ((double)this.gp.pieHeight / 100.0));
        int tmpInt1 = radiusx * (2 * this.gp.series.size());
        int tmpInt2 = radiusy * (2 * this.gp.series.size()) + (int)((double)radiusy * ((double)this.gp.pieHeight / 100.0));
        this.gp.graphRect = new Rectangle(this.gp.graphRect.x + (this.gp.graphRect.width - tmpInt1) / 2, this.gp.graphRect.y + (this.gp.graphRect.height - tmpInt2) / 2, tmpInt1, tmpInt2);
        int orgx = this.gp.graphRect.x + this.gp.graphRect.width / 2;
        int orgy = this.gp.graphRect.y + dely + (this.gp.graphRect.height - dely) / 2;
        boolean cut = this.gp.series.size() == 1;
        int j = 0;
        while (j < this.gp.series.size()) {
            double amount;
            GraphDataSource ht;
            double totAmount = 0.0;
            double totAngle = 0.0;
            int radx = 0;
            int rady = 0;
            radx = (this.gp.series.size() - j) * radiusx;
            rady = (this.gp.series.size() - j) * radiusy;
            double max = 0.0;
            int maxi = -1;
            int movex = 0;
            int movey = 0;
            int i = 0;
            while (i < this.gp.category.size()) {
                ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                amount = 0.0;
                Object ser = this.gp.series.get(j);
                if (ser == null) {
                    amount = 0.0;
                } else {
                    Object val = ht.get(ser);
                    if (!GraphParam.isValid(val)) {
                        amount = 0.0;
                    } else {
                        Number d = (Number)val;
                        amount = d.doubleValue();
                        if (amount > max) {
                            max = amount;
                            maxi = i;
                        }
                    }
                }
                totAmount += amount;
                ++i;
            }
            if (totAmount != 0.0) {
                totAngle = 0.0;
                i = 0;
                while (i < this.gp.category.size()) {
                    ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                    amount = 0.0;
                    double angle = 0.0;
                    Object ser = this.gp.series.get(j);
                    if (ser == null) {
                        amount = 0.0;
                        System.out.println("ser is null");
                    } else {
                        Object val = ht.get(ser);
                        if (!GraphParam.isValid(val)) {
                            amount = 0.0;
                            System.out.println("val is null");
                        } else {
                            Number d = (Number)val;
                            amount = d.doubleValue();
                            System.out.println("normal:amount=" + amount);
                        }
                    }
                    angle = 360.0 * amount / totAmount;
                    if (i == this.gp.category.size() - 1) {
                        angle = 360.0 - totAngle;
                    }
                    if (cut && maxi == i) {
                        movex = (int)(20.0 * Math.cos(Math.toRadians(-totAngle - angle / 2.0)));
                        movey = (int)(-20.0 * Math.sin(Math.toRadians(-totAngle - angle / 2.0)));
                    } else {
                        movex = 0;
                        movey = 0;
                    }
                    this.gp.g.setColor(this.gp.seriesColor[i % this.gp.seriesColor.length]);
                    Arc2D.Double ddd = null;
                    ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2 * radx, 2 * rady, -totAngle, -angle, 2);
                    this.gp.g.fill(ddd);
                    this.gp.g.setColor(this.gp.lineColor);
                    this.gp.g.draw(ddd);
                    if (this.gp.series.size() == 1) {
                        int x1 = orgx + (int)Math.round((double)(radx / 2) * Math.cos(Math.toRadians(-totAngle - angle / 2.0))) + movex;
                        int y1 = orgy - (int)Math.round((double)(rady / 2) * Math.sin(Math.toRadians(-totAngle - angle / 2.0))) + movey;
                        int x2 = orgx + (int)Math.round((double)(radx + 5) * Math.cos(Math.toRadians(-totAngle - angle / 2.0))) + movex;
                        int y2 = orgy - (int)Math.round((double)(rady + 5) * Math.sin(Math.toRadians(-totAngle - angle / 2.0))) + movey;
                        this.gp.g.setColor(this.gp.coorColor);
                        this.gp.g.drawLine(x1, y1, x2, y2);
                        FontMetrics fm = this.gp.g.getFontMetrics(this.gp.GFV_XLABEL.font);
                        String fmt = GraphParam.isValid(this.gp.dataMarkFormat) ? this.gp.dataMarkFormat : "0.00%";
                        DecimalFormat df = new DecimalFormat(fmt, GraphParam.dfs);
                        String text = df.format(amount / totAmount);
                        double tmpAngle = 360.0 - (totAngle + angle / 2.0);
                        int w = this.gp.GFV_VALUE.getTextSize((String)text).width;
                        int h = this.gp.GFV_VALUE.getTextSize((String)text).height;
                        if (tmpAngle > 90.0 && tmpAngle < 270.0) {
                            x2 -= w;
                        }
                        if (tmpAngle > 180.0 && tmpAngle < 360.0) {
                            y2 += h;
                        }
                        this.gp.GFV_VALUE.outText(x2, y2, text);
                    }
                    totAngle += angle;
                    ++i;
                }
                if (this.gp.series.size() > 1) {
                    int angle = Math.round(360 / this.gp.series.size()) * j;
                    this.gp.g.setColor(this.gp.coorColor);
                    int x1 = orgx + (int)Math.round((double)(radx - radiusx / 2) * Math.cos(Math.toRadians(angle)));
                    int y1 = orgy - (int)Math.round((double)(rady - radiusy / 2) * Math.sin(Math.toRadians(angle)));
                    int x2 = orgx + (int)Math.round((double)(radiusx * this.gp.series.size() + 5) * Math.cos(Math.toRadians(angle)));
                    int y2 = orgy - (int)Math.round((double)(radiusy * this.gp.series.size() + 5) * Math.sin(Math.toRadians(angle)));
                    this.gp.g.drawLine(x1, y1, x2, y2);
                    FontMetrics fm = this.gp.g.getFontMetrics(this.gp.GFV_XLABEL.font);
                    if (angle > 90 && angle < 270) {
                        StatisticGraph.drawString(this.gp.series.get(j).toString(), x2 + (int)((double)fm.stringWidth(this.gp.series.get(j).toString()) * Math.cos(Math.toRadians(angle))), y2 - (int)((double)fm.stringWidth(this.gp.series.get(j).toString()) * Math.sin(Math.toRadians(angle))), angle - 180, false, this.gp.GFV_XLABEL.font, this.gp);
                    } else {
                        StatisticGraph.drawString(this.gp.series.get(j).toString(), x2, y2, angle, false, this.gp.GFV_XLABEL.font, this.gp);
                    }
                }
                orgy -= dely;
            }
            ++j;
        }
    }
}

