/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.text.DecimalFormat;

public class DrawPie3DObj
implements DrawBase {
    GraphParam gp;

    public DrawPie3DObj(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int radiusx = 0;
        int radiusy = 0;
        this.gp.coorWidth = 0;
        this.gp.initGraphInset();
        if (this.gp.minValue < 0.0) {
            this.gp.g.setColor(Color.black);
            this.gp.g.setFont(this.gp.GFV_TITLE.font);
            this.gp.g.drawString("\u753b\u997c\u5f62\u56fe\u4e0d\u80fd\u6709\u8d1f\u6570\u503c\u3002", 50, 50);
            return;
        }
        if (this.gp.pieHeight > 100) {
            this.gp.pieHeight = 100;
        }
        if (this.gp.pieHeight < 0) {
            this.gp.pieHeight = 0;
        }
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        radiusx = this.gp.series.size() == 0 ? this.gp.graphRect.width / 2 : this.gp.graphRect.width / (2 * this.gp.series.size());
        radiusy = (int)((double)this.gp.graphRect.height / ((double)(2 * this.gp.series.size()) + (double)this.gp.pieHeight / 100.0));
        if (this.gp.pieRotation < 10) {
            this.gp.pieRotation = 10;
        }
        if (this.gp.pieRotation > 100) {
            this.gp.pieRotation = 100;
        }
        if ((double)radiusx * ((double)this.gp.pieRotation / 100.0) > (double)radiusy) {
            radiusx = (int)((double)radiusy / ((double)this.gp.pieRotation / 100.0));
        } else {
            radiusy = (int)((double)(radiusx * this.gp.pieRotation) / 100.0);
        }
        int dely = (int)((double)radiusy * ((double)this.gp.pieHeight / 100.0));
        int tmpInt1 = radiusx * (2 * this.gp.series.size());
        int tmpInt2 = radiusy * (2 * this.gp.series.size()) + (int)((double)radiusy * ((double)this.gp.pieHeight / 100.0));
        this.gp.graphRect = new Rectangle(this.gp.graphRect.x + (this.gp.graphRect.width - tmpInt1) / 2, this.gp.graphRect.y + (this.gp.graphRect.height - tmpInt2) / 2, tmpInt1, tmpInt2);
        int orgx = this.gp.graphRect.x + this.gp.graphRect.width / 2;
        int orgy = this.gp.graphRect.y + dely + (this.gp.graphRect.height - dely) / 2;
        boolean cut = this.gp.series.size() == 1 && this.gp.category.size() > 1;
        int z = 0;
        while (z < this.gp.series.size()) {
            double amount;
            GraphDataSource ht;
            if (this.gp.graphTransparent) {
                this.gp.g.setComposite(AlphaComposite.getInstance(3, 0.6f));
            }
            double totAmount = 0.0;
            int totAngle = 0;
            int radx = 0;
            int rady = 0;
            radx = (this.gp.series.size() - z) * radiusx;
            rady = (this.gp.series.size() - z) * radiusy;
            double max = 0.0;
            int maxi = -1;
            int movex = 0;
            int movey = 0;
            int i = 0;
            while (i < this.gp.category.size()) {
                ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                amount = 0.0;
                Object ser = this.gp.series.get(z);
                if (ser == null) {
                    amount = 0.0;
                } else {
                    Object val = ht.get(ser);
                    if (!GraphParam.isValid(val)) {
                        amount = 0.0;
                    } else {
                        Number d = (Number)val;
                        amount = d.doubleValue();
                        if (amount > max) {
                            max = amount;
                            maxi = i;
                        }
                    }
                }
                totAmount += amount;
                ++i;
            }
            if (totAmount != 0.0) {
                Number d;
                Object ser;
                totAngle = 0;
                i = 0;
                while (i < this.gp.category.size()) {
                    ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                    amount = 0.0;
                    int angle = 0;
                    ser = this.gp.series.get(z);
                    if (ser == null) {
                        amount = 0.0;
                    } else {
                        Object val = ht.get(ser);
                        if (!GraphParam.isValid(val)) {
                            amount = 0.0;
                        } else {
                            d = (Number)val;
                            amount = d.doubleValue();
                        }
                    }
                    angle = (int)(360.0 * amount / totAmount);
                    if (angle != 0) {
                        if (i == this.gp.category.size() - 1) {
                            angle = 360 - totAngle;
                        }
                        if (cut && maxi == i) {
                            movex = (int)Math.round((double)(dely * 2 / 3) * Math.cos(Math.toRadians(totAngle + angle / 2)));
                            movey = (int)Math.round((double)(-dely * 2 / 3) * Math.sin(Math.toRadians(totAngle + angle / 2)));
                        } else {
                            movex = 0;
                            movey = 0;
                        }
                        this.gp.g.setColor(Color.gray);
                        this.gp.g.fillArc(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle, angle);
                        this.gp.g.setColor(this.gp.getColor(i));
                        this.gp.g.fillArc(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle, angle);
                        this.gp.g.setColor(this.gp.lineColor);
                        this.gp.g.drawArc(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle, angle);
                        if (totAngle < 180) {
                            this.drawBackBaffle(totAngle, orgx, radx, movex, orgy, rady, movey, dely, angle, i);
                        }
                        totAngle += angle;
                    }
                    ++i;
                }
                this.gp.g.setColor(this.gp.lineColor);
                this.gp.g.drawLine(orgx + radx, orgy - dely, orgx + radx, orgy);
                totAngle = 0;
                i = 0;
                while (i < this.gp.category.size()) {
                    ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                    amount = 0.0;
                    int angle = 0;
                    ser = this.gp.series.get(z);
                    if (ser == null) {
                        amount = 0.0;
                    } else {
                        Object val = ht.get(ser);
                        if (!GraphParam.isValid(val)) {
                            amount = 0.0;
                        } else {
                            d = (Number)val;
                            amount = d.doubleValue();
                        }
                    }
                    angle = (int)(360.0 * amount / totAmount);
                    if (i == this.gp.category.size() - 1) {
                        angle = 360 - totAngle;
                    }
                    if (angle != 0 || totAngle < 90) {
                        if (cut && maxi == i) {
                            movex = (int)Math.round((double)(dely * 2 / 3) * Math.cos(Math.toRadians(totAngle + angle / 2)));
                            movey = (int)Math.round((double)(-dely * 2 / 3) * Math.sin(Math.toRadians(totAngle + angle / 2)));
                        } else {
                            movex = 0;
                            movey = 0;
                        }
                        totAngle += angle;
                        int a = 0;
                        int a1 = 0;
                        int b = 0;
                        int b1 = 0;
                        Arc2D.Double ddd = null;
                        ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle - angle, angle, 2);
                        a = (int)ddd.getEndPoint().getX();
                        a1 = (int)ddd.getStartPoint().getX();
                        b = (int)ddd.getEndPoint().getY();
                        b1 = (int)ddd.getStartPoint().getY();
                        if (cut && maxi == i) {
                            if (a1 > orgx + movex && a >= orgx + movex && b >= orgy + movey && b1 <= orgy + movey) {
                                this.drawCut2(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut1(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                            } else if (a1 > orgx + movex && a >= orgx + movex) {
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut2(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut1(a1, b1, orgx, orgy, movex, movey, dely, i);
                            } else if (a1 < orgx + movex && a <= orgx + movex) {
                                this.drawCut1(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut2(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                            } else if (a > orgx + movex && a1 < orgx + movex) {
                                this.drawCut1(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut2(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                            } else if (a < orgx + movex && a1 > orgx + movex) {
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut2(a1, b1, orgx, orgy, movex, movey, dely, i);
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut1(a1, b1, orgx, orgy, movex, movey, dely, i);
                            }
                        } else if (this.gp.graphTransparent && this.gp.category.size() > 1 && (!cut || i != maxi - 1 && (i != this.gp.category.size() - 1 || maxi != 0))) {
                            if (a > orgx + movex) {
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                            } else {
                                this.drawCut3(a, b, orgx, orgy, movex, movey, dely, i);
                                this.drawCut4(a, b, orgx, orgy, movex, movey, dely, i);
                            }
                        }
                    }
                    ++i;
                }
                totAngle = 0;
                i = 0;
                while (i < this.gp.category.size()) {
                    ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i));
                    amount = 0.0;
                    int angle = 0;
                    ser = this.gp.series.get(z);
                    if (ser == null) {
                        amount = 0.0;
                    } else {
                        Object val = ht.get(ser);
                        if (!GraphParam.isValid(val)) {
                            amount = 0.0;
                        } else {
                            d = (Number)val;
                            amount = d.doubleValue();
                        }
                    }
                    angle = (int)(360.0 * amount / totAmount);
                    if (i == this.gp.category.size() - 1) {
                        angle = 360 - totAngle;
                    }
                    if (angle != 0 || totAngle < 90) {
                        if (cut && maxi == i) {
                            movex = (int)Math.round((double)(dely * 2 / 3) * Math.cos(Math.toRadians(totAngle + angle / 2)));
                            movey = (int)Math.round((double)(-dely * 2 / 3) * Math.sin(Math.toRadians(totAngle + angle / 2)));
                        } else {
                            movex = 0;
                            movey = 0;
                        }
                        if (totAngle + angle > 180) {
                            this.drawFrontBaffle(totAngle, orgx, radx, movex, orgy, rady, movey, dely, angle, i);
                        }
                        this.gp.g.setColor(this.gp.getColor(i));
                        this.gp.g.fillArc(orgx - radx + movex, orgy - rady - dely + movey, 2 * radx, 2 * rady, totAngle, angle);
                        Arc2D.Double ddd1 = new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2 * radx, 2 * rady, totAngle, angle, 2);
                        this.gp.g.setColor(this.gp.lineColor);
                        if (this.gp.category.size() > 1) {
                            this.gp.g.drawLine(orgx + movex, orgy - dely + movey, (int)ddd1.getStartPoint().getX(), (int)ddd1.getStartPoint().getY());
                        }
                        this.gp.g.drawArc(orgx - radx + movex, orgy - rady - dely + movey, 2 * radx, 2 * rady, totAngle, angle);
                        if (this.gp.series.size() == 1) {
                            int x1 = orgx + (int)Math.round((double)(radx / 2) * Math.cos(Math.toRadians(totAngle + angle / 2))) + movex;
                            int y1 = orgy - (int)Math.round((double)(rady / 2) * Math.sin(Math.toRadians(totAngle + angle / 2))) + movey - dely;
                            int x2 = orgx + (int)Math.round((double)(radx + 5) * Math.cos(Math.toRadians(totAngle + angle / 2))) + movex;
                            int y2 = orgy - (int)Math.round((double)(rady + 5) * Math.sin(Math.toRadians(totAngle + angle / 2))) + movey - dely;
                            this.gp.g.setColor(this.gp.coorColor);
                            this.gp.g.drawLine(x1, y1, x2, y2);
                            FontMetrics fm = this.gp.g.getFontMetrics(this.gp.GFV_XLABEL.font);
                            String fmt = GraphParam.isValid(this.gp.dataMarkFormat) ? this.gp.dataMarkFormat : "0.00%";
                            DecimalFormat df = new DecimalFormat(fmt, GraphParam.dfs);
                            String text = df.format(amount / totAmount);
                            double tmpAngle = totAngle + angle / 2;
                            int w = this.gp.GFV_VALUE.getTextSize((String)text).width;
                            int h = this.gp.GFV_VALUE.getTextSize((String)text).height;
                            if (tmpAngle > 90.0 && tmpAngle < 270.0) {
                                x2 -= w;
                            }
                            if (tmpAngle > 180.0 && tmpAngle < 360.0) {
                                y2 += h;
                            }
                            this.gp.GFV_VALUE.outText(x2, y2, text);
                        }
                        totAngle += angle;
                    }
                    ++i;
                }
                if (this.gp.graphTransparent) {
                    this.gp.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
                if (this.gp.series.size() > 1) {
                    int angle = Math.round(360 / this.gp.series.size()) * z;
                    this.gp.g.setColor(Color.black);
                    int x1 = orgx + (int)Math.round((double)(radx - radiusx / 2) * Math.cos(Math.toRadians(angle)));
                    int y1 = orgy - (int)Math.round((double)(rady - radiusy / 2) * Math.sin(Math.toRadians(angle)));
                    int x2 = orgx + (int)Math.round((double)(radiusx * this.gp.series.size() + 5) * Math.cos(Math.toRadians(angle)));
                    int y2 = orgy - (int)Math.round((double)(radiusy * this.gp.series.size() + 5) * Math.sin(Math.toRadians(angle)));
                    this.gp.g.drawLine(x1, y1, x2, y2);
                    this.gp.g.setFont(this.gp.GFV_LEGEND.font);
                    FontMetrics fm = this.gp.g.getFontMetrics(this.gp.GFV_LEGEND.font);
                    if (angle > 90 && angle < 270) {
                        StatisticGraph.drawString(this.gp.series.get(z).toString(), x2 + (int)((double)fm.stringWidth(this.gp.series.get(z).toString()) * Math.cos(Math.toRadians(angle))), y2 - (int)((double)fm.stringWidth(this.gp.series.get(z).toString()) * Math.sin(Math.toRadians(angle))), angle - 180, false, this.gp.GFV_LEGEND.font, this.gp);
                    } else {
                        StatisticGraph.drawString(this.gp.series.get(z).toString(), x2, y2, angle, false, this.gp.GFV_LEGEND.font, this.gp);
                    }
                }
                orgy -= dely;
            }
            ++z;
        }
    }

    private void drawFrontBaffle(int totAngle, int orgx, int radx, int movex, int orgy, int rady, int movey, int dely, int angle, int i) {
        int a = 0;
        int a1 = 0;
        int b = 0;
        int b1 = 0;
        Arc2D.Double ddd = null;
        Arc2D.Double ddd1 = null;
        int totAngle1 = totAngle;
        if (totAngle < 180) {
            totAngle1 = 180;
        }
        ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle1, totAngle + angle - totAngle1, 2);
        Arc2D.Double dddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle1 - 1, totAngle + angle - totAngle1 + 2, 2);
        ddd1 = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey - dely, 2 * radx, 2 * rady, totAngle1, totAngle + angle - totAngle1, 2);
        a = (int)ddd.getEndPoint().getX();
        a1 = (int)ddd.getStartPoint().getX();
        b = (int)ddd.getEndPoint().getY();
        b1 = (int)ddd.getStartPoint().getY();
        int aa = (int)dddd.getEndPoint().getX();
        int aa1 = (int)dddd.getStartPoint().getX();
        int bb = (int)dddd.getEndPoint().getY();
        int bb1 = (int)dddd.getStartPoint().getY();
        int[] ptx1 = new int[]{a1, a1, a, a};
        int[] pty1 = new int[]{-dely + b1, b1, b, -dely + b};
        Polygon pp1 = new Polygon(ptx1, pty1, 4);
        int[] ptx2 = new int[]{orgx + movex, aa1, aa};
        int[] pty2 = new int[]{orgy + movey, bb1, bb};
        Polygon pp2 = new Polygon(ptx2, pty2, 3);
        Area area = new Area(ddd);
        Area area1 = new Area(ddd1);
        Area area2 = new Area(pp1);
        Area area3 = new Area(pp2);
        area.subtract(area3);
        area.add(area1);
        area.add(area2);
        area.subtract(area1);
        this.gp.g.setColor(Color.gray);
        this.gp.g.fill(area);
        this.gp.g.setColor(this.gp.getColor(i));
        this.gp.g.fill(area);
    }

    private void drawBackBaffle(int totAngle, int orgx, int radx, int movex, int orgy, int rady, int movey, int dely, int angle, int i) {
        int a = 0;
        int a1 = 0;
        int b = 0;
        int b1 = 0;
        Arc2D.Double ddd = null;
        Arc2D.Double ddd1 = null;
        int totAngle1 = totAngle + angle;
        if (totAngle + angle > 180) {
            totAngle1 = 180;
        }
        ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2 * radx, 2 * rady, totAngle, totAngle1 - totAngle, 2);
        ddd1 = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey - dely, 2 * radx, 2 * rady, totAngle, totAngle1 - totAngle, 2);
        a = (int)ddd.getEndPoint().getX();
        a1 = (int)ddd.getStartPoint().getX();
        b = (int)ddd.getEndPoint().getY();
        b1 = (int)ddd.getStartPoint().getY();
        int[] ptx1 = new int[]{a1, a1, a, a};
        int[] pty1 = new int[]{-dely + b1, b1, b, -dely + b};
        Polygon pp1 = new Polygon(ptx1, pty1, 4);
        int[] ptx2 = new int[]{orgx + movex, a1, a};
        int[] pty2 = new int[]{orgy + movey - dely, b1 - dely, b - dely};
        Polygon pp2 = new Polygon(ptx2, pty2, 3);
        Area area = new Area(ddd);
        Area area1 = new Area(ddd1);
        Area area2 = new Area(pp1);
        Area area3 = new Area(pp2);
        area1.subtract(area3);
        area1.add(area);
        area1.add(area2);
        area1.subtract(area);
        this.gp.g.setColor(Color.gray);
        this.gp.g.fill(area1);
        this.gp.g.setColor(this.gp.getColor(i));
        this.gp.g.fill(area1);
    }

    private void drawCut1(int a1, int b1, int orgx, int orgy, int movex, int movey, int dely, int i) {
        int[] ptx1 = new int[]{a1 - movex, a1 - movex, orgx, orgx};
        int[] pty1 = new int[]{b1 - movey, -dely + b1 - movey, -dely + orgy, orgy};
        if (i == 0) {
            this.gp.g.setColor(this.gp.getColor(this.gp.category.size() - 1));
        } else {
            this.gp.g.setColor(this.gp.getColor(i - 1));
        }
        this.gp.g.fillPolygon(ptx1, pty1, 4);
        this.gp.g.setColor(this.gp.lineColor);
        this.gp.g.drawPolygon(ptx1, pty1, 4);
    }

    private void drawCut2(int a1, int b1, int orgx, int orgy, int movex, int movey, int dely, int i) {
        int[] ptx1 = new int[]{a1, a1, orgx + movex, orgx + movex};
        int[] pty1 = new int[]{b1, -dely + b1, -dely + orgy + movey, orgy + movey};
        this.gp.g.setColor(this.gp.getColor(i));
        this.gp.g.fillPolygon(ptx1, pty1, 4);
        this.gp.g.setColor(this.gp.lineColor);
        this.gp.g.drawPolygon(ptx1, pty1, 4);
    }

    private void drawCut3(int a, int b, int orgx, int orgy, int movex, int movey, int dely, int i) {
        int[] ptx1 = new int[]{a, a, orgx + movex, orgx + movex};
        int[] pty1 = new int[]{b, -dely + b, -dely + orgy + movey, orgy + movey};
        this.gp.g.setColor(this.gp.getColor(i));
        this.gp.g.fillPolygon(ptx1, pty1, 4);
        this.gp.g.setColor(this.gp.lineColor);
        this.gp.g.drawPolygon(ptx1, pty1, 4);
    }

    private void drawCut4(int a, int b, int orgx, int orgy, int movex, int movey, int dely, int i) {
        int[] ptx1 = new int[]{a - movex, a - movex, orgx, orgx};
        int[] pty1 = new int[]{b - movey, -dely + b - movey, -dely + orgy, orgy};
        if (i + 1 == this.gp.category.size()) {
            this.gp.g.setColor(this.gp.getColor(0));
        } else {
            this.gp.g.setColor(this.gp.getColor(i + 1));
        }
        this.gp.g.fillPolygon(ptx1, pty1, 4);
        this.gp.g.setColor(this.gp.lineColor);
        this.gp.g.drawPolygon(ptx1, pty1, 4);
    }
}

