/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class DrawRadar
implements DrawBase {
    GraphParam gp;

    public DrawRadar(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        int tmpInt;
        this.gp.initGraphInset();
        this.gp.adjustBaseValue(true);
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        int tmpInt1 = this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset;
        int tmpInt2 = this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset;
        if (tmpInt1 < tmpInt2) {
            tmpInt = tmpInt1;
            this.gp.topInset += (tmpInt2 - tmpInt1) / 2;
        } else {
            tmpInt = tmpInt2;
            this.gp.leftInset += (tmpInt1 - tmpInt2) / 2;
        }
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, tmpInt, tmpInt);
        int r = tmpInt / 2;
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        if (this.gp.graphBackColor != null) {
            this.gp.g.setColor(this.gp.graphBackColor);
            this.gp.g.fillOval(this.gp.gRect2.x + 1, this.gp.gRect2.y + 1, this.gp.gRect2.width - 1, this.gp.gRect2.height - 1);
        }
        tmpInt = this.gp.category.size();
        int deltaAngle = 360 / tmpInt;
        int cx = this.gp.leftInset + r;
        int cy = this.gp.topInset + r;
        this.gp.g.setStroke(new BasicStroke(1.0E-5f));
        int i = 0;
        while (i < this.gp.category.size()) {
            String cat = this.gp.category.get(i).toString();
            double angle = deltaAngle * i + 90;
            double rAngle = Math.toRadians(angle);
            int x2 = cx + (int)((double)r * Math.cos(rAngle));
            int y2 = cy - (int)((double)r * Math.sin(rAngle));
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(cx, cy, x2, y2);
            double tmpAngle = angle;
            int w = this.gp.GFV_XLABEL.getTextSize((String)cat).width;
            int h = this.gp.GFV_XLABEL.getTextSize((String)cat).height;
            if (tmpAngle >= 90.0 && tmpAngle < 270.0) {
                x2 -= w;
            }
            if (tmpAngle > 180.0 && tmpAngle < 360.0) {
                y2 += h;
            }
            this.gp.GFV_XLABEL.outText(x2, y2, cat);
            ++i;
        }
        int deltaR = r / this.gp.tickNum;
        float[] dashes = new float[]{2.0f};
        int i2 = 0;
        while (i2 <= this.gp.tickNum) {
            int dr = i2 * deltaR;
            x = cx - dr;
            y = cy - dr;
            if (i2 < this.gp.tickNum) {
                this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                this.gp.g.setColor(this.gp.gridColor);
            } else {
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
                this.gp.g.setColor(this.gp.coorColor);
            }
            this.gp.g.drawOval(x, y, dr * 2, dr * 2);
            Number coory = (Number)this.gp.coorValue.get(i2);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x = cx;
            y = cy - dr;
            this.gp.GFV_YLABEL.outText(x, y, scoory);
            ++i2;
        }
        Point[] prePoints = new Point[this.gp.series.size()];
        Point[] startPoints = new Point[this.gp.series.size()];
        int i3 = 0;
        while (i3 < this.gp.category.size()) {
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(this.gp.category.get(i3));
            int j = 0;
            while (j < this.gp.series.size()) {
                int len = 0;
                Object ser = this.gp.series.get(j);
                Object val = "";
                if (ser == null) {
                    len = 0;
                } else {
                    val = ht.get(ser);
                    if (!GraphParam.isValid(val)) {
                        len = 0;
                    } else {
                        Number d = (Number)val;
                        double tmp = d.doubleValue() - this.gp.baseValue;
                        len = (int)((double)(deltaR * this.gp.tickNum) * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                    }
                }
                double angle = deltaAngle * i3 + 90;
                double rAngle = Math.toRadians(angle);
                r = len;
                x = cx + (int)((double)r * Math.cos(rAngle));
                y = cy - (int)((double)r * Math.sin(rAngle));
                Point pt = new Point(x, y);
                this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                this.gp.g.setStroke(new BasicStroke(1.0f));
                this.gp.g.fillRect(pt.x - 2, pt.y - 2, 4, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawRect(pt.x - 2, pt.y - 2, 4, 4);
                if (i3 == 0) {
                    startPoints[j] = pt;
                } else if (i3 == this.gp.category.size() - 1) {
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.setStroke(new BasicStroke(1.0f));
                    this.gp.g.drawLine(prePoints[j].x, prePoints[j].y, pt.x, pt.y);
                    this.gp.g.drawLine(startPoints[j].x, startPoints[j].y, pt.x, pt.y);
                } else {
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.setStroke(new BasicStroke(1.0f));
                    this.gp.g.drawLine(prePoints[j].x, prePoints[j].y, pt.x, pt.y);
                }
                prePoints[j] = pt;
                ++j;
            }
            ++i3;
        }
    }
}

