/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import java.util.ArrayList;

public class GraphDataSource {
    private ArrayList keys = null;
    private ArrayList values = null;

    public GraphDataSource() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public GraphDataSource(int initCapacity) {
        this.keys = new ArrayList(initCapacity);
        this.values = new ArrayList(initCapacity);
    }

    public GraphDataSource(GraphDataSource gds) {
        this.keys = gds.keyList();
        this.values = gds.valueList();
    }

    public void add(int index, Object key, Object value) {
        this.keys.add(index, key);
        this.values.add(index, value);
    }

    public boolean add(Object key, Object value) {
        return this.keys.add(key) && this.values.add(value);
    }

    public boolean addAll(GraphDataSource gds) {
        return this.keys.addAll(gds.keyList()) && this.values.addAll(gds.valueList());
    }

    public boolean addAll(int index, GraphDataSource gds) {
        return this.keys.addAll(index, gds.keyList()) && this.values.addAll(gds.valueList());
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    public void ensureCapacity(int minCapacity) {
        this.keys.ensureCapacity(minCapacity);
        this.values.ensureCapacity(minCapacity);
    }

    public Object getKey(int index) {
        return this.keys.get(index);
    }

    public Object getValue(int index) {
        return this.values.get(index);
    }

    public Object get(Object key) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i).equals(key)) {
                return this.values.get(i);
            }
            ++i;
        }
        return null;
    }

    public void remove(int index) {
        this.keys.remove(index);
        this.values.remove(index);
    }

    public void remove(Object key) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i).equals(key)) {
                this.keys.remove(i);
                this.values.remove(i);
                return;
            }
            ++i;
        }
    }

    public int indexOf(Object key) {
        return this.keys.indexOf(key);
    }

    public void set(int index, Object key, Object value) {
        this.keys.set(index, key);
        this.values.set(index, value);
    }

    public int size() {
        return this.keys.size();
    }

    public void trimToSize() {
        this.keys.trimToSize();
        this.values.trimToSize();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public ArrayList keyList() {
        return this.keys;
    }

    public ArrayList valueList() {
        return this.values;
    }

    public Object[] keyArray() {
        return this.keys.toArray();
    }

    public Object[] valueArray() {
        return this.values.toArray();
    }
}

