/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.GraphParam;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public class GraphFontView {
    public String text = "";
    public String text2 = "";
    Font font;
    Color color;
    boolean vertical = false;
    int angle;
    private GraphParam gp;
    Rectangle PA = null;

    public GraphFontView(GraphParam gp) {
        this.gp = gp;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        if (this.gp.is2YGraph()) {
            int pos = -1;
            pos = text.indexOf(44);
            if (pos < 0) {
                pos = text.indexOf(59);
            }
            if (pos < 0) {
                this.text = text;
            } else {
                this.text = text.substring(0, pos);
                this.text2 = text.substring(pos + 1);
            }
        } else {
            this.text = text;
        }
    }

    public void outText(int x, int y) {
        this.outText(x, y, this.text);
    }

    public void outText(int x, int y, String text) {
        Rectangle TA;
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (this.font.getSize() == 0) {
            return;
        }
        if (this.vertical || this.angle == 0) {
            TA = this.getTextSize(text);
            TA.x = x;
            TA.y = y;
            if (this.PA != null && TA.intersects(this.PA)) {
                return;
            }
            this.PA = TA;
        } else {
            this.vertical = true;
            TA = this.getTextSize(text);
            this.vertical = false;
            TA.x = x;
            TA.y = y;
            if (this.PA != null && TA.intersects(this.PA)) {
                return;
            }
            this.PA = TA;
        }
        this.gp.g.setColor(this.color);
        this.gp.g.setFont(this.font);
        Object o = this.gp.g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Composite com = this.gp.g.getComposite();
        this.gp.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.gp.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        FontMetrics fm = this.gp.g.getFontMetrics(this.font);
        if (this.vertical) {
            int textTotalHeight = (text.length() - 1) * fm.getAscent();
            y -= textTotalHeight;
            int i = 0;
            while (i < text.length()) {
                this.gp.g.drawString(text.substring(i, i + 1), x, y + i * fm.getAscent());
                ++i;
            }
        } else if (this.angle == 0) {
            this.gp.g.drawString(text, x, y);
        } else {
            AffineTransform at = this.gp.g.getTransform();
            AffineTransform at1 = AffineTransform.getRotateInstance(Math.toRadians(-this.angle), x, y);
            this.gp.g.transform(at1);
            this.gp.g.setStroke(new BasicStroke(1.0f));
            this.gp.g.drawString(text, x, y);
            this.gp.g.setTransform(at);
        }
        this.gp.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, o);
        this.gp.g.setComposite(com);
        this.gp.g.setStroke(new BasicStroke(1.0E-5f));
    }

    public Rectangle getTextSize() {
        return this.getTextSize(this.text);
    }

    public Rectangle getTextSize(String text) {
        if (text == null) {
            return new Rectangle();
        }
        if (this.vertical) {
            return this.getVerticalArea(text);
        }
        if (this.angle == 0) {
            return this.getHorizonArea(text);
        }
        return this.getRotationArea(text);
    }

    private Rectangle getVerticalArea(String text) {
        Rectangle area = new Rectangle();
        FontMetrics fm = this.gp.g.getFontMetrics(this.font);
        int hh = fm.getAscent();
        area.width = fm.stringWidth("\u5b57");
        area.height = hh * text.length();
        return area;
    }

    private Rectangle getHorizonArea(String text) {
        Rectangle area = new Rectangle();
        FontMetrics fm = this.gp.g.getFontMetrics(this.font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent();
        area.width = hw;
        area.height = hh;
        return area;
    }

    private Rectangle getRotationArea(String text) {
        Rectangle area = new Rectangle();
        FontMetrics fm = this.gp.g.getFontMetrics(this.font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent();
        int aw = (int)((double)hw * Math.cos(Math.toRadians(this.angle)));
        int ah = (int)((double)hw * Math.sin(Math.toRadians(this.angle)));
        if (aw == 0) {
            aw = fm.stringWidth("\u5b57");
        }
        if (ah == 0) {
            ah = hh;
        }
        area.width = aw;
        area.height = ah;
        return area;
    }
}

