/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphFont;
import com.runqian.base.graph.GraphFontView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphParam {
    public static DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.CHINESE);
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public Graphics2D g;
    public double baseValue = 0.0;
    public StringBuffer sb_link = new StringBuffer(1000);
    public GraphDataSource graphData;
    public Vector category = new Vector();
    public Vector series = new Vector();
    public Vector coorValue = new Vector();
    public Vector sampling = new Vector();
    public double coorScale = 1.0;
    public String scaleMark = "1";
    public int graphMargin = 5;
    public double maxValue = 0.0;
    public double minValue = 0.0;
    public double interval = 0.0;
    public Vector positive;
    public double maxPositive = 0.0;
    public double minNegative = 0.0;
    public int topInset = 0;
    public int bottomInset = 0;
    public int leftInset = 0;
    public int rightInset = 0;
    public boolean hasSeries = false;
    public boolean drawTitle = true;
    public boolean drawLabel = true;
    public boolean drawLegend = true;
    public boolean drawPanelBorder = true;
    public int graphType = 7;
    public int legendPosition = 2;
    public int valueBaseLine = 0;
    public int graphWidth = 640;
    public int graphHeight = 480;
    public int leftMargin = 10;
    public int rightMargin = 10;
    public int topMargin = 10;
    public int bottomMargin = 10;
    public int legendBoxWidth = 0;
    public int legendBoxHeight = 0;
    public int tickLen = 4;
    public int tickNum = 10;
    public int maxTicknum = 0;
    public int minTicknum = 3;
    public GraphFontView GFV_TITLE;
    public GraphFontView GFV_VALUE;
    public GraphFontView GFV_LEGEND;
    public GraphFontView GFV_XTITLE;
    public GraphFontView GFV_XLABEL;
    public GraphFontView GFV_YTITLE;
    public GraphFontView GFV_YLABEL;
    public int coorWidth = 100;
    public double categorySpan = 190.0;
    public int seriesSpan = 100;
    public int pieRotation = 50;
    public int pieHeight = 70;
    public Rectangle graphRect;
    public Rectangle gRect1;
    public Rectangle gRect2;
    public Color lineColor = Color.lightGray;
    public Color panelBackColor = new Color(255, 255, 255);
    public Color panelBorderColor = new Color(255, 210, 210);
    public Color graphBackColor = new Color(255, 255, 255);
    public Color coorColor = new Color(0, 0, 0);
    public Color coor3DColor = new Color(239, 239, 239);
    public Color gridColor = new Color(0, 0, 0);
    public boolean graphTransparent = false;
    public Timestamp startTime = Timestamp.valueOf("2999-01-01 00:00:00");
    public Timestamp endTime = Timestamp.valueOf("1900-01-01 00:00:00");
    public int timeScale = 4;
    public int stateH = 4;
    public String dataMarkFormat = "";
    public boolean dispValueOntop = false;
    public Vector[] warnLine = null;
    public Vector[] timeRange = null;
    public boolean valueRangeAuto = true;
    public String colorScheme = "color";
    public Color[] seriesColor = new Color[]{new Color(128, 128, 0), new Color(255, 128, 0), new Color(192, 255, 0), new Color(0, 0, 128), new Color(128, 0, 128), new Color(255, 0, 128), new Color(0, 128, 128), new Color(128, 128, 128), new Color(0, 255, 255), new Color(192, 192, 192), new Color(255, 128, 128), new Color(0, 255, 128), new Color(192, 255, 128), new Color(255, 255, 0), new Color(255, 255, 128), new Color(128, 0, 255), new Color(255, 0, 255), new Color(0, 128, 255), new Color(128, 128, 255), new Color(255, 128, 255), new Color(192, 255, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(0, 128, 0), new Color(255, 255, 255)};
    public Vector series2 = new Vector();
    public Vector coorValue2 = new Vector();
    public int maxTicknum2 = 0;
    public int minTicknum2 = 0;
    public int tickNum2 = 10;
    public double interval2 = 0.0;
    public double maxValue2 = 0.0;
    public double minValue2 = 0.0;
    public double baseValue2 = 0.0;
    public double coorScale2 = 1.0;
    public boolean valueRangeAuto2 = true;
    private Rectangle TR = new Rectangle();

    public void setScaleMark(String scale) {
        this.scaleMark = scale;
    }

    public void setColorScheme(String colorScheme) {
        if (colorScheme == null || colorScheme.trim().length() == 0) {
            return;
        }
        this.colorScheme = colorScheme;
    }

    public static boolean isValid(Object str) {
        if (str == null) {
            return false;
        }
        if (!(str instanceof String)) {
            return str.toString().trim().length() > 0;
        }
        String s = (String)str;
        return s.trim().length() != 0;
    }

    public void readColor() throws Exception {
        Properties config = new Properties();
        try {
            config.load(this.getClass().getResourceAsStream("/color.properties"));
            String color = config.getProperty(this.colorScheme);
            if (color == null || color.trim().length() == 0) {
                throw new Exception();
            }
            StringTokenizer st = new StringTokenizer(color, ";");
            int count = st.countTokens();
            this.seriesColor = new Color[count];
            int i = 0;
            while (i < count) {
                StringTokenizer st1 = new StringTokenizer(st.nextToken(), ",");
                this.seriesColor[i] = new Color(Integer.parseInt(st1.nextToken().trim()), Integer.parseInt(st1.nextToken().trim()), Integer.parseInt(st1.nextToken().trim()));
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u914d\u8272\u65b9\u6848\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }

    public Color getColor(int number) {
        return this.seriesColor[number % this.seriesColor.length];
    }

    public void initGraphInset() {
        this.leftInset = this.leftMargin;
        this.topInset = this.topMargin;
        this.rightInset = this.rightMargin;
        this.bottomInset = this.bottomMargin;
    }

    public void createCoorValue() {
        if (this.is2YGraph()) {
            if (!this.valueRangeAuto2) {
                return;
            }
            this.createCoorValue2();
        }
        if (!this.valueRangeAuto) {
            return;
        }
        double doubleTmp = 0.0;
        this.coorScale = 1.0;
        if (this.minValue >= 0.0) {
            if (this.maxValue == 0.0) {
                this.maxValue = 1.0;
            }
            while (this.maxValue > 100.0) {
                this.coorScale *= 10.0;
                this.maxValue *= 0.1;
            }
            while (this.maxValue < 1.0) {
                this.coorScale *= 0.1;
                this.maxValue *= 10.0;
            }
            if (this.interval == 0.0) {
                this.interval = this.maxValue > 50.0 ? 10.0 * this.coorScale : 5.0 * this.coorScale;
            }
            if (this.maxValue % (this.interval / this.coorScale) != 0.0) {
                this.maxValue = this.maxValue - this.maxValue % (this.interval / this.coorScale) + this.interval / this.coorScale;
            }
            this.tickNum = (int)(this.maxValue / (this.interval / this.coorScale));
            if (this.minTicknum > 0 && this.tickNum < this.minTicknum) {
                this.tickNum = this.minTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            if (this.maxTicknum > 0 && this.tickNum > this.maxTicknum) {
                this.tickNum = this.maxTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            if (this.maxValue == 0.0) {
                this.maxValue = 1.0;
            }
            int i = 0;
            while (i <= this.tickNum) {
                doubleTmp = this.scaleMark.equals("2") ? (double)i * this.maxValue / (double)this.tickNum : (this.scaleMark.equals("1") ? (double)i * this.maxValue * this.coorScale / (double)this.tickNum : (double)i * this.maxValue * (this.coorScale / Double.parseDouble(this.scaleMark)) / (double)this.tickNum);
                this.coorValue.add(i, new Double(doubleTmp + this.baseValue));
                ++i;
            }
        } else if (this.maxValue <= 0.0) {
            doubleTmp = this.maxValue;
            this.maxValue = Math.abs(this.minValue);
            this.minValue = Math.abs(doubleTmp);
            if (this.maxValue == 0.0) {
                this.maxValue = 1.0;
            }
            while (this.maxValue > 100.0) {
                this.coorScale *= 10.0;
                this.maxValue *= 0.1;
            }
            while (this.maxValue < 1.0) {
                this.coorScale *= 0.1;
                this.maxValue *= 10.0;
            }
            if (this.interval == 0.0) {
                this.interval = this.maxValue > 50.0 ? 10.0 * this.coorScale : 5.0 * this.coorScale;
            }
            if (this.maxValue % (this.interval / this.coorScale) != 0.0) {
                this.maxValue = this.maxValue - this.maxValue % (this.interval / this.coorScale) + this.interval / this.coorScale;
            }
            this.tickNum = (int)(this.maxValue / (this.interval / this.coorScale));
            if (this.minTicknum > 0 && this.tickNum < this.minTicknum) {
                this.tickNum = this.minTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            if (this.maxTicknum > 0 && this.tickNum > this.maxTicknum) {
                this.tickNum = this.maxTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            if (this.maxValue == 0.0) {
                this.maxValue = 1.0;
            }
            int i = 0;
            while (i <= this.tickNum) {
                doubleTmp = this.scaleMark.equals("2") ? (double)(-(this.tickNum - i)) * this.maxValue / (double)this.tickNum : (this.scaleMark.equals("1") ? (double)(-(this.tickNum - i)) * this.maxValue * this.coorScale / (double)this.tickNum : (double)(-(this.tickNum - i)) * this.maxValue * (this.coorScale / Double.parseDouble(this.scaleMark)) / (double)this.tickNum);
                this.coorValue.add(i, new Double(doubleTmp + this.baseValue));
                ++i;
            }
        } else {
            if (this.maxValue < Math.abs(this.minValue)) {
                this.maxValue = Math.abs(this.minValue);
            }
            if (this.maxValue == 0.0) {
                this.maxValue = 1.0;
            }
            while (this.maxValue > 100.0) {
                this.coorScale *= 10.0;
                this.maxValue *= 0.1;
            }
            while (this.maxValue < 1.0) {
                this.coorScale *= 0.1;
                this.maxValue *= 10.0;
            }
            if (this.interval == 0.0) {
                this.interval = this.maxValue > 50.0 ? 10.0 * this.coorScale : 5.0 * this.coorScale;
            }
            if (this.maxValue % (this.interval / this.coorScale) != 0.0) {
                this.maxValue = this.maxValue - this.maxValue % (this.interval / this.coorScale) + this.interval / this.coorScale;
            }
            this.tickNum = (int)(this.maxValue / (this.interval / this.coorScale));
            if (this.minTicknum > 0 && this.tickNum < this.minTicknum) {
                this.tickNum = this.minTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            if (this.maxTicknum > 0 && this.tickNum > this.maxTicknum) {
                this.tickNum = this.maxTicknum;
                if (this.maxValue % (double)this.tickNum > 0.0) {
                    this.maxValue = this.maxValue - this.maxValue % (double)this.tickNum + (double)this.tickNum;
                }
            }
            int intTmp = this.tickNum;
            this.tickNum *= 2;
            int i = -intTmp;
            while (i <= intTmp) {
                doubleTmp = this.scaleMark.equals("2") ? (double)i * this.maxValue / (double)intTmp : (this.scaleMark.equals("1") ? (double)i * this.maxValue * this.coorScale / (double)intTmp : (double)i * this.maxValue * (this.coorScale / Double.parseDouble(this.scaleMark)) / (double)intTmp);
                this.coorValue.add(this.coorValue.size(), new Double(doubleTmp + this.baseValue));
                ++i;
            }
            this.maxValue *= 2.0;
        }
        this.minValue = 0.0;
        if (this.scaleMark.equals("2") && this.coorScale != 1.0) {
            this.GFV_YTITLE.text = this.coorScale > 1000.0 ? String.valueOf(this.GFV_YTITLE.text) + "(" + GraphParam.xToChinese(this.coorScale) + ")" : String.valueOf(this.GFV_YTITLE.text) + "(\u6bd4\u4f8b\uff1a1:" + this.coorScale + ")";
        } else if (!this.scaleMark.equals("1")) {
            if (this.scaleMark.equals("1000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343)";
            } else if (this.scaleMark.equals("10000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4e07)";
            } else if (this.scaleMark.equals("1000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u4e07)";
            } else if (this.scaleMark.equals("10000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343\u4e07)";
            } else if (this.scaleMark.equals("100000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4ebf)";
            } else if (this.scaleMark.equals("1000000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5341\u4ebf)";
            } else if (this.scaleMark.equals("0.01")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.0001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4e07\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.000001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u4e07\u5206\u4e4b\u4e00)";
            }
        }
    }

    public void createCoorValue2() {
        double doubleTmp = 0.0;
        this.coorScale2 = 1.0;
        if (this.minValue2 >= 0.0) {
            if (this.maxValue2 == 0.0) {
                this.maxValue2 = 1.0;
            }
            while (this.maxValue2 > 100.0) {
                this.coorScale2 *= 10.0;
                this.maxValue2 *= 0.1;
            }
            while (this.maxValue2 < 1.0) {
                this.coorScale2 *= 0.1;
                this.maxValue2 *= 10.0;
            }
            if (this.interval2 == 0.0) {
                this.interval2 = this.maxValue2 > 50.0 ? 10.0 * this.coorScale2 : 5.0 * this.coorScale2;
            }
            if (this.maxValue2 % (this.interval2 / this.coorScale2) != 0.0) {
                this.maxValue2 = this.maxValue2 - this.maxValue2 % (this.interval2 / this.coorScale2) + this.interval2 / this.coorScale2;
            }
            this.tickNum2 = (int)(this.maxValue2 / (this.interval2 / this.coorScale2));
            if (this.minTicknum2 > 0 && this.tickNum2 < this.minTicknum2) {
                this.tickNum2 = this.minTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            if (this.maxTicknum2 > 0 && this.tickNum2 > this.maxTicknum2) {
                this.tickNum2 = this.maxTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            if (this.maxValue2 == 0.0) {
                this.maxValue2 = 1.0;
            }
            int i = 0;
            while (i <= this.tickNum2) {
                doubleTmp = this.scaleMark.equals("2") ? (double)i * this.maxValue2 / (double)this.tickNum2 : (this.scaleMark.equals("1") ? (double)i * this.maxValue2 * this.coorScale2 / (double)this.tickNum2 : (double)i * this.maxValue2 * (this.coorScale2 / Double.parseDouble(this.scaleMark)) / (double)this.tickNum2);
                this.coorValue2.add(i, new Double(doubleTmp + this.baseValue2));
                ++i;
            }
        } else if (this.maxValue2 <= 0.0) {
            doubleTmp = this.maxValue2;
            this.maxValue2 = Math.abs(this.minValue2);
            this.minValue2 = Math.abs(doubleTmp);
            if (this.maxValue2 == 0.0) {
                this.maxValue2 = 1.0;
            }
            while (this.maxValue2 > 100.0) {
                this.coorScale2 *= 10.0;
                this.maxValue2 *= 0.1;
            }
            while (this.maxValue2 < 1.0) {
                this.coorScale2 *= 0.1;
                this.maxValue2 *= 10.0;
            }
            if (this.interval2 == 0.0) {
                this.interval2 = this.maxValue2 > 50.0 ? 10.0 * this.coorScale2 : 5.0 * this.coorScale2;
            }
            if (this.maxValue2 % (this.interval2 / this.coorScale2) != 0.0) {
                this.maxValue2 = this.maxValue2 - this.maxValue2 % (this.interval2 / this.coorScale2) + this.interval2 / this.coorScale2;
            }
            this.tickNum2 = (int)(this.maxValue2 / (this.interval2 / this.coorScale2));
            if (this.minTicknum2 > 0 && this.tickNum2 < this.minTicknum2) {
                this.tickNum2 = this.minTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            if (this.maxTicknum2 > 0 && this.tickNum2 > this.maxTicknum2) {
                this.tickNum2 = this.maxTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            if (this.maxValue2 == 0.0) {
                this.maxValue2 = 1.0;
            }
            int i = 0;
            while (i <= this.tickNum2) {
                doubleTmp = this.scaleMark.equals("2") ? (double)(-(this.tickNum2 - i)) * this.maxValue2 / (double)this.tickNum2 : (this.scaleMark.equals("1") ? (double)(-(this.tickNum2 - i)) * this.maxValue2 * this.coorScale2 / (double)this.tickNum2 : (double)(-(this.tickNum2 - i)) * this.maxValue2 * (this.coorScale2 / Double.parseDouble(this.scaleMark)) / (double)this.tickNum2);
                this.coorValue2.add(i, new Double(doubleTmp));
                ++i;
            }
        } else {
            if (this.maxValue2 < Math.abs(this.minValue2)) {
                this.maxValue2 = Math.abs(this.minValue2);
            }
            if (this.maxValue2 == 0.0) {
                this.maxValue2 = 1.0;
            }
            while (this.maxValue2 > 100.0) {
                this.coorScale2 *= 10.0;
                this.maxValue2 *= 0.1;
            }
            while (this.maxValue2 < 1.0) {
                this.coorScale2 *= 0.1;
                this.maxValue2 *= 10.0;
            }
            if (this.interval2 == 0.0) {
                this.interval2 = this.maxValue2 > 50.0 ? 10.0 * this.coorScale2 : 5.0 * this.coorScale2;
            }
            if (this.maxValue2 % (this.interval2 / this.coorScale2) != 0.0) {
                this.maxValue2 = this.maxValue2 - this.maxValue2 % (this.interval2 / this.coorScale2) + this.interval2 / this.coorScale2;
            }
            this.tickNum2 = (int)(this.maxValue2 / (this.interval2 / this.coorScale2));
            if (this.minTicknum2 > 0 && this.tickNum2 < this.minTicknum2) {
                this.tickNum2 = this.minTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            if (this.maxTicknum2 > 0 && this.tickNum2 > this.maxTicknum2) {
                this.tickNum2 = this.maxTicknum2;
                if (this.maxValue2 % (double)this.tickNum2 > 0.0) {
                    this.maxValue2 = this.maxValue2 - this.maxValue2 % (double)this.tickNum2 + (double)this.tickNum2;
                }
            }
            int intTmp = this.tickNum2;
            this.tickNum2 *= 2;
            int i = -intTmp;
            while (i <= intTmp) {
                doubleTmp = this.scaleMark.equals("2") ? (double)i * this.maxValue2 / (double)intTmp : (this.scaleMark.equals("1") ? (double)i * this.maxValue2 * this.coorScale2 / (double)intTmp : (double)i * this.maxValue2 * (this.coorScale2 / Double.parseDouble(this.scaleMark)) / (double)intTmp);
                this.coorValue2.add(this.coorValue2.size(), new Double(doubleTmp));
                ++i;
            }
            this.maxValue2 *= 2.0;
        }
        this.minValue2 = 0.0;
        if (this.scaleMark.equals("2") && this.coorScale2 != 1.0) {
            this.GFV_YTITLE.text = this.coorScale2 > 1000.0 ? String.valueOf(this.GFV_YTITLE.text) + "(" + GraphParam.xToChinese(this.coorScale2) + ")" : String.valueOf(this.GFV_YTITLE.text) + "(\u6bd4\u4f8b\uff1a1:" + this.coorScale2 + ")";
        } else if (!this.scaleMark.equals("1")) {
            if (this.scaleMark.equals("1000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343)";
            } else if (this.scaleMark.equals("10000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4e07)";
            } else if (this.scaleMark.equals("1000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u4e07)";
            } else if (this.scaleMark.equals("10000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343\u4e07)";
            } else if (this.scaleMark.equals("100000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4ebf)";
            } else if (this.scaleMark.equals("1000000000")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5341\u4ebf)";
            } else if (this.scaleMark.equals("0.01")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u5343\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.0001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u4e07\u5206\u4e4b\u4e00)";
            } else if (this.scaleMark.equals("0.000001")) {
                this.GFV_YTITLE.text = String.valueOf(this.GFV_YTITLE.text) + "(\u767e\u4e07\u5206\u4e4b\u4e00)";
            }
        }
    }

    public void adjustCoorInset() {
        DecimalFormat df;
        String scoory;
        Object coory;
        int maxValW = 0;
        int maxValH = 0;
        int maxCatW = 0;
        int maxCatH = 0;
        int intTmp = 0;
        int i = 0;
        while (i < this.tickNum) {
            coory = this.coorValue.get(i);
            scoory = coory.toString();
            df = null;
            if (this.dataMarkFormat != null && this.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.dataMarkFormat, dfs);
                scoory = df.format(((Number)coory).doubleValue());
            }
            this.TR = this.GFV_YLABEL.getTextSize(scoory);
            intTmp = this.TR.width;
            if (maxValW < intTmp) {
                maxValW = intTmp;
            }
            if (maxValH < (intTmp = this.TR.height)) {
                maxValH = intTmp;
            }
            ++i;
        }
        int j = 0;
        while (j < this.category.size()) {
            Object o = this.category.get(j);
            this.TR = this.GFV_XLABEL.getTextSize(o.toString());
            intTmp = this.TR.width;
            if (maxCatW < intTmp) {
                maxCatW = intTmp;
            }
            if (maxCatH < (intTmp = this.TR.height)) {
                maxCatH = intTmp;
            }
            ++j;
        }
        if (this.isBarGraph()) {
            this.leftInset += maxCatW + 4;
            this.bottomInset += maxValH + 4;
        } else {
            this.leftInset += maxValW + 4;
            this.bottomInset += maxCatH + 4;
            if (this.is2YGraph()) {
                i = 0;
                while (i < this.tickNum2) {
                    coory = this.coorValue2.get(i);
                    scoory = coory.toString();
                    df = null;
                    if (this.dataMarkFormat != null && this.dataMarkFormat.trim().length() > 0) {
                        df = new DecimalFormat(this.dataMarkFormat, dfs);
                        scoory = df.format(((Number)coory).doubleValue());
                    }
                    this.TR = this.GFV_YLABEL.getTextSize(scoory);
                    intTmp = this.TR.width;
                    if (maxValW < intTmp) {
                        maxValW = intTmp;
                    }
                    if (maxValH < (intTmp = this.TR.height)) {
                        maxValH = intTmp;
                    }
                    ++i;
                }
                this.rightInset += maxValW + 4;
            }
        }
    }

    public void setDataMarkFormat(String format) {
        this.dataMarkFormat = format;
    }

    public void setLegendPosition(String pos) {
        if (pos == null || pos.trim().length() < 1) {
            return;
        }
        switch (pos.charAt(0)) {
            case '1': {
                this.legendPosition = 1;
                break;
            }
            case '2': {
                this.legendPosition = 2;
                break;
            }
            case '3': {
                this.legendPosition = 3;
                break;
            }
            case '4': {
                this.legendPosition = 4;
                break;
            }
            case '5': {
                this.legendPosition = 0;
                this.drawLegend = false;
            }
        }
    }

    public void printGraphData() {
        System.out.println("--------------graphData-start--------------");
        int i = 0;
        while (i < this.category.size()) {
            Object obj = this.graphData.get(this.category.get(i));
            if (obj != null) {
                System.out.println("\nCategory " + this.category.get(i).toString() + "'s series:");
                GraphDataSource ht = (GraphDataSource)obj;
                int j = 0;
                while (j < this.series.size()) {
                    Number d = (Number)ht.get(this.series.get(j));
                    if (d == null) {
                        System.out.println(String.valueOf(this.series.get(j).toString()) + "\t->\t0");
                    } else {
                        System.out.println(String.valueOf(this.series.get(j).toString()) + "\t->\t" + d.doubleValue());
                    }
                    ++j;
                }
                System.out.print("\n");
            }
            ++i;
        }
        System.out.println("--------------graphData---end--------------");
    }

    public void setGraphTransparent(boolean graphTransparent) {
        this.graphTransparent = graphTransparent;
    }

    public GraphFontView getGraphFontView(GraphFont gf, String text, int fontType) {
        GraphFontView gfv = new GraphFontView(this);
        gfv.setAngle(gf.getAngle());
        gfv.setVertical(gf.isVerticalText());
        gfv.setColor(new Color(gf.getColor()));
        Font font = this.getFont(gf.getFamily(), gf.getSize(), fontType, gf.isAutoResize(), gf.isBold(), false, text);
        gfv.setFont(font);
        gfv.setText(text);
        return gfv;
    }

    public String getFormattedValue(Object val) {
        Number d = (Number)val;
        double tmp = d.doubleValue();
        if (this.scaleMark.equals("2")) {
            tmp /= this.coorScale;
        } else if (!this.scaleMark.equals("1")) {
            tmp /= Double.parseDouble(this.scaleMark);
        }
        if (this.dataMarkFormat != null && this.dataMarkFormat.trim().length() > 0) {
            DecimalFormat df = new DecimalFormat(this.dataMarkFormat, dfs);
            val = df.format(tmp);
        }
        return val.toString();
    }

    public Font getFont(String face, int size, int fontType, boolean autoSize, boolean isBold, boolean isItalic, String text) {
        int style = 0;
        if (isBold) {
            ++style;
        }
        if (isItalic) {
            style += 2;
        }
        if (!autoSize) {
            return new Font(face, style, size);
        }
        int len = 0;
        len = this.category.size() == 0 ? 4 : this.category.get(0).toString().length();
        switch (fontType) {
            case 0: {
                size = Math.round((this.graphWidth < this.graphHeight ? this.graphWidth : this.graphHeight) / 15);
                size = size > 17 ? 17 : size;
                break;
            }
            case 5: {
                size = Math.round((this.graphWidth - this.leftInset) / (this.series.size() == 0 ? 1 : this.series.size()) / (len == 0 ? 1 : len));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 3: {
                int tmp = (int)((double)len * Math.cos(Math.toRadians(this.GFV_XLABEL.angle)));
                if (tmp < 1) {
                    tmp = 1;
                }
                size = Math.round((this.graphWidth - this.leftInset) / (this.category.size() == 0 ? 1 : this.category.size()) / tmp);
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 1: {
                size = Math.round((this.graphWidth - this.leftInset - this.rightInset) / (text == null || text.trim().length() == 0 ? 1 : text.length()));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 4: {
                size = Math.round((this.graphHeight - this.topInset - this.bottomInset) / (this.tickNum == 0 ? 1 : this.tickNum));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 2: {
                size = Math.round((this.graphHeight - this.topInset - this.bottomInset) / (text == null || text.trim().length() == 0 ? 1 : text.length()));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
        }
        return new Font(face, style, size);
    }

    public void setDispValueOntop(boolean dispValueOntop) {
        this.dispValueOntop = dispValueOntop;
    }

    public void setWarnLine(String warnLine) {
        if (warnLine == null) {
            return;
        }
        this.warnLine = new Vector[3];
        StringTokenizer sb = new StringTokenizer(warnLine, "&");
        int count = sb.countTokens();
        int i = 0;
        while (i < 3) {
            this.warnLine[i] = new Vector(count);
            ++i;
        }
        i = 0;
        while (i < count) {
            String value = sb.nextToken();
            String lineType = null;
            String lineColor = null;
            int pos = value.indexOf("=");
            if (pos > 0 && (pos = (value = value.substring(pos + 1)).indexOf(",")) > 0) {
                lineType = value.substring(pos + 1);
                value = value.substring(0, pos);
                pos = lineType.indexOf(",");
                if (pos > 0) {
                    lineColor = lineType.substring(pos + 1);
                    lineType = lineType.substring(0, pos);
                }
            }
            this.warnLine[0].add(i, value);
            this.warnLine[1].add(i, lineType);
            this.warnLine[2].add(i, lineColor);
            ++i;
        }
    }

    public void setValueRange(String startValue, String endValue, String interval) {
        String i1;
        String e1;
        String s1;
        String s2 = null;
        String e2 = null;
        String i2 = null;
        int pos = -1;
        if (!(GraphParam.isValid(startValue) && GraphParam.isValid(endValue) && GraphParam.isValid(interval))) {
            return;
        }
        pos = startValue.indexOf(44);
        if (pos < 0) {
            s1 = startValue;
        } else {
            s1 = startValue.substring(0, pos);
            s2 = startValue.substring(pos + 1);
        }
        pos = endValue.indexOf(44);
        if (pos < 0) {
            e1 = endValue;
        } else {
            e1 = endValue.substring(0, pos);
            e2 = endValue.substring(pos + 1);
        }
        pos = interval.indexOf(44);
        if (pos < 0) {
            i1 = interval;
        } else {
            i1 = interval.substring(0, pos);
            i2 = interval.substring(pos + 1);
        }
        this.setValueRange1(s1, e1, i1);
        this.setValueRange2(s2, e2, i2);
    }

    public void setValueRange1(String startValue, String endValue, String interval) {
        if (interval == null || interval.trim().length() == 0 || this.isStackedGraph() || this.graphType == 22) {
            return;
        }
        this.interval = Double.parseDouble(interval);
        if (startValue != null && startValue.trim().length() > 0 && endValue != null && endValue.trim().length() > 0) {
            this.minValue = Double.parseDouble(startValue);
            this.maxValue = Double.parseDouble(endValue);
            this.baseValue = this.minValue;
            this.minValue -= this.baseValue;
            this.maxValue -= this.baseValue;
            if ((this.maxValue - this.minValue) % this.interval != 0.0) {
                this.tickNum = (int)((this.maxValue - this.minValue) / this.interval) + 1;
                this.maxValue = this.minValue + (double)this.tickNum * this.interval;
            } else {
                this.tickNum = (int)((this.maxValue - this.minValue) / this.interval);
            }
            int i = 0;
            while (i <= this.tickNum) {
                double doubleTmp = (double)i * this.interval + this.minValue;
                this.coorValue.add(i, new Double(doubleTmp + this.baseValue));
                ++i;
            }
            this.maxValue -= this.minValue;
            this.valueRangeAuto = false;
        }
    }

    public void setValueRange2(String startValue, String endValue, String interval) {
        if (interval == null || interval.trim().length() == 0 || this.isStackedGraph() || this.graphType == 22) {
            return;
        }
        this.interval2 = Double.parseDouble(interval);
        if (startValue != null && startValue.trim().length() > 0 && endValue != null && endValue.trim().length() > 0) {
            this.minValue2 = Double.parseDouble(startValue);
            this.maxValue2 = Double.parseDouble(endValue);
            this.baseValue2 = this.minValue2;
            this.minValue2 -= this.baseValue2;
            this.maxValue2 -= this.baseValue2;
            if ((this.maxValue2 - this.minValue2) % this.interval2 != 0.0) {
                this.tickNum2 = (int)((this.maxValue2 - this.minValue2) / this.interval2) + 1;
                this.maxValue2 = this.minValue2 + (double)this.tickNum2 * this.interval2;
            } else {
                this.tickNum2 = (int)((this.maxValue2 - this.minValue2) / this.interval2);
            }
            int i = 0;
            while (i <= this.tickNum2) {
                double doubleTmp = (double)i * this.interval2 + this.minValue2;
                this.coorValue2.add(i, new Double(doubleTmp + this.baseValue2));
                ++i;
            }
            this.maxValue2 -= this.minValue2;
            this.valueRangeAuto2 = false;
        }
    }

    public void setMinTicknum(int minTicknum) {
        this.minTicknum = minTicknum;
    }

    public void setMaxTicknum(int maxTicknum) {
        this.maxTicknum = maxTicknum;
    }

    public void setTimeRange(String timeRange) {
        if (timeRange == null) {
            return;
        }
        this.timeRange = new Vector[4];
        StringTokenizer sb = new StringTokenizer(timeRange, "/");
        int count = sb.countTokens();
        int i = 0;
        while (i < 4) {
            this.timeRange[i] = new Vector(count);
            ++i;
        }
        i = 0;
        while (i < count) {
            String start = sb.nextToken();
            String end = null;
            String sampling = null;
            String labeling = null;
            int pos = start.indexOf("\t");
            if (pos > 0) {
                end = start.substring(pos + 1);
                start = start.substring(0, pos);
                pos = end.indexOf("\t");
                if (pos > 0) {
                    sampling = end.substring(pos + 1);
                    end = end.substring(0, pos);
                    pos = sampling.indexOf("\t");
                    if (pos > 0) {
                        labeling = sampling.substring(pos + 1);
                        sampling = sampling.substring(0, pos);
                    }
                }
            }
            this.timeRange[0].add(i, start);
            this.timeRange[1].add(i, end);
            this.timeRange[2].add(i, sampling);
            this.timeRange[3].add(i, labeling);
            ++i;
        }
    }

    public void setGraphType(int gt) {
        this.graphType = gt;
    }

    public void setGraphExtent(int gw, int gh) {
        if (gw > 0) {
            this.graphWidth = gw;
        }
        if (gh > 0) {
            this.graphHeight = gh;
        }
    }

    public void setPanelBackColor(int rgb, String transparent) {
        this.panelBackColor = transparent != null && transparent.equals("1") ? null : new Color(rgb);
    }

    public void setGraphBackColor(int rgb, String transparent) {
        this.graphBackColor = transparent != null && transparent.equals("1") ? null : new Color(rgb);
    }

    public void setCoorColor(Color color) {
        if (color != null) {
            this.coorColor = color;
        }
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.gridColor = color;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setDataSource(GraphDataSource dataSource, int firstNum) {
        try {
            this.graphData = dataSource;
            it = dataSource.keyArray();
            firstSer = new Vector<Object>(firstNum + 1);
            firstVal = new Vector<Number>(firstNum + 1);
            other = 0.0;
            totalSum = 0.0;
            totPositive = new Vector<Double>();
            totNegative = new Vector<Double>();
            i = 0;
            while (i < it.length) {
                cat = it[i];
                totPositive.add(i, new Double(0.0));
                totNegative.add(i, new Double(0.0));
                try {
                    tempData = (GraphDataSource)dataSource.getValue(i);
                }
                catch (Exception e) {
                    tempData = new GraphDataSource();
                }
                if (!this.hasSeries) {
                    this.hasSeries = tempData.size() > 1;
                }
                it1 = tempData.keyArray();
                btmp = true;
                j = 0;
                while (j < it1.length) {
                    block39: {
                        block40: {
                            block38: {
                                block37: {
                                    ser = it1[j];
                                    try {
                                        d = (Number)tempData.getValue(j);
                                    }
                                    catch (Exception e) {
                                        d = new Double(0.0);
                                    }
                                    dd = 0.0;
                                    if (firstVal.size() >= 1) {
                                        try {
                                            dd = ((Number)firstVal.get(firstVal.size() - 1)).doubleValue();
                                        }
                                        catch (Exception e) {
                                            dd = 0.0;
                                        }
                                    }
                                    if (j != 0) break block37;
                                    totalSum += d.doubleValue();
                                    break block38;
                                }
                                if (firstNum > 0 && i >= firstNum && !firstSer.contains(cat)) break block39;
                            }
                            if (j != 0 || firstNum <= 0) ** GOTO lbl-1000
                            k = 0;
                            while (k < firstVal.size()) {
                                dd = 0.0;
                                try {
                                    dd = ((Number)firstVal.get(k)).doubleValue();
                                }
                                catch (Exception e) {
                                    dd = 0.0;
                                }
                                if (d.doubleValue() > dd) {
                                    if (k == 0) {
                                        firstVal.add(0, d);
                                        firstSer.add(0, cat);
                                    } else {
                                        firstVal.insertElementAt(d, k);
                                        firstSer.insertElementAt(cat, k);
                                    }
                                    if (firstSer.size() <= firstNum) break;
                                    tmp = firstSer.get(firstSer.size() - 1);
                                    firstSer.remove(firstSer.size() - 1);
                                    firstVal.remove(firstVal.size() - 1);
                                    this.removeCategory(tmp);
                                    break;
                                }
                                ++k;
                            }
                            if (k < firstVal.size() || firstVal.size() >= firstNum || firstNum <= 0) break block40;
                            firstVal.add(d);
                            firstSer.add(cat);
                            ** GOTO lbl-1000
                        }
                        if (k >= firstVal.size() && firstNum > 0) {
                            other += d.doubleValue();
                        } else lbl-1000:
                        // 3 sources

                        {
                            if (i == 0 && j == 0) {
                                this.maxValue = d.doubleValue();
                                this.minValue = d.doubleValue();
                            } else {
                                if (d.doubleValue() > this.maxValue) {
                                    this.maxValue = d.doubleValue();
                                }
                                if (d.doubleValue() < this.minValue) {
                                    this.minValue = d.doubleValue();
                                }
                            }
                            this.maxPositive = this.maxValue;
                            this.minNegative = this.minValue;
                            tmp = 0.0;
                            if (d.doubleValue() >= 0.0) {
                                tmp = (Double)totPositive.get(i);
                                totPositive.set(i, new Double(tmp + d.doubleValue()));
                            } else {
                                tmp = (Double)totNegative.get(i);
                                totNegative.set(i, new Double(tmp + d.doubleValue()));
                            }
                            this.addSeries(ser);
                        }
                    }
                    ++j;
                }
                if (btmp && tempData != null && firstNum <= 0) {
                    this.addCategory(cat);
                }
                ++i;
            }
            if (firstNum > 0) {
                this.category.addAll(firstSer);
                other = 0.0;
                i = 0;
                while (i < this.category.size()) {
                    key = this.category.get(i);
                    tmpData = (GraphDataSource)this.graphData.get(key);
                    it1 = tmpData.keyArray();
                    ser = it1[0];
                    try {
                        d = (Number)tmpData.getValue(0);
                    }
                    catch (Exception e) {
                        d = new Double(0.0);
                    }
                    other += d.doubleValue();
                    ++i;
                }
                tmph = new GraphDataSource();
                if ((other = totalSum - other) > this.maxValue) {
                    this.maxPositive = this.maxValue = other;
                }
                if (other < this.minValue) {
                    this.minValue = other;
                    this.minNegative = this.maxValue;
                }
                tmph.add(this.series.get(0), new Double(other));
                this.category.add("\u5176\u5b83");
                this.graphData.add("\u5176\u5b83", tmph);
            }
            this.maxPositive = 0.0;
            this.minNegative = 0.0;
            k = 0;
            while (k < totPositive.size()) {
                tmp = 0.0;
                tmp = (Double)totPositive.get(k);
                if (this.maxPositive < tmp) {
                    this.maxPositive = tmp;
                }
                if (this.minNegative > (tmp = ((Double)totNegative.get(k)).doubleValue())) {
                    this.minNegative = tmp;
                }
                ++k;
            }
            this.positive = totPositive;
            if (this.is2YGraph()) {
                this.set2YEnv();
            }
            this.adjustBaseValue(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void adjustBaseValue(boolean minValueAsBase) {
    }

    public boolean is2YGraph() {
        return this.graphType == 20 || this.graphType == 21;
    }

    public boolean isStackedGraph() {
        return this.graphType == 5 || this.graphType == 6 || this.graphType == 10 || this.graphType == 11;
    }

    public boolean isBarGraph() {
        return this.graphType == 2 || this.graphType == 3 || this.graphType == 4 || this.graphType == 5 || this.graphType == 6;
    }

    private void set2YEnv() {
        int totalSeries = this.series.size();
        Vector tmpSeries = new Vector();
        int s1 = (totalSeries + 1) / 2;
        int i = 0;
        while (i < this.series.size()) {
            if (i >= s1) {
                this.series2.add(this.series.get(i));
            } else {
                tmpSeries.add(this.series.get(i));
            }
            ++i;
        }
        this.series = tmpSeries;
        this.maxValue = 0.0;
        this.minValue = 0.0;
        i = 0;
        while (i < this.category.size()) {
            Object obj = this.graphData.get(this.category.get(i));
            if (obj != null) {
                double tmpValue;
                Number d;
                GraphDataSource ht = (GraphDataSource)obj;
                int j = 0;
                while (j < this.series.size()) {
                    d = (Number)ht.get(this.series.get(j));
                    tmpValue = d == null ? 0.0 : d.doubleValue();
                    if (i == 0 && j == 0) {
                        this.maxValue = tmpValue;
                        this.minValue = tmpValue;
                    }
                    if (tmpValue > this.maxValue) {
                        this.maxValue = tmpValue;
                    }
                    if (tmpValue < this.minValue) {
                        this.minValue = tmpValue;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.series2.size()) {
                    d = (Number)ht.get(this.series2.get(j));
                    tmpValue = d == null ? 0.0 : d.doubleValue();
                    if (i == 0 && j == 0) {
                        this.maxValue2 = tmpValue;
                        this.minValue2 = tmpValue;
                    } else {
                        if (tmpValue > this.maxValue2) {
                            this.maxValue2 = tmpValue;
                        }
                        if (tmpValue < this.minValue2) {
                            this.minValue2 = tmpValue;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setStateDataSource(GraphDataSource dataSource) {
        try {
            this.graphData = dataSource;
            this.series = new Vector();
            this.category = new Vector();
            Object[] it = dataSource.keyArray();
            int j = 0;
            while (j < it.length) {
                Vector[] tempData;
                Object ser = it[j];
                try {
                    tempData = (Vector[])dataSource.getValue(j);
                }
                catch (Exception e) {
                    tempData = new Vector[]{new Vector(), new Vector(), new Vector()};
                }
                int i = 0;
                while (i < tempData[0].size()) {
                    Object oStart = tempData[1].get(i);
                    Object oEnd = tempData[2].get(i);
                    Object oState = tempData[0].get(i);
                    String tmp = oStart.toString();
                    Timestamp start = null;
                    try {
                        start = Timestamp.valueOf(tmp);
                    }
                    catch (Exception e) {
                        try {
                            Time.valueOf(tmp);
                            tmp = "1900-01-01 " + tmp;
                            start = Timestamp.valueOf(tmp);
                        }
                        catch (Exception ee) {
                            Date.valueOf(tmp);
                            tmp = String.valueOf(tmp) + " 00:00:00";
                            start = Timestamp.valueOf(tmp);
                        }
                    }
                    if (this.startTime.after(start)) {
                        this.startTime = start;
                    }
                    tmp = oEnd.toString();
                    Timestamp end = null;
                    try {
                        end = Timestamp.valueOf(tmp);
                    }
                    catch (Exception e) {
                        try {
                            Time.valueOf(tmp);
                            tmp = "1900-01-01 " + tmp;
                            end = Timestamp.valueOf(tmp);
                        }
                        catch (Exception ee) {
                            Date.valueOf(tmp);
                            tmp = String.valueOf(tmp) + " 00:00:00";
                            end = Timestamp.valueOf(tmp);
                        }
                    }
                    if (this.endTime.before(end)) {
                        this.endTime = end;
                    }
                    this.addCategory(oState);
                    ++i;
                }
                this.addSeries(ser);
                ++j;
            }
            this.hasSeries = this.series.size() > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTrendDataSource(GraphDataSource dataSource) {
        if (this.timeRange == null) {
            this.setDataSource(dataSource, 0);
            return;
        }
        try {
            this.graphData = dataSource;
            int i = 0;
            while (i < this.timeRange[0].size()) {
                System.out.println("start=" + this.timeRange[0].get(i).toString() + " end=" + this.timeRange[1].get(i).toString());
                Timestamp start = null;
                try {
                    start = Timestamp.valueOf(this.timeRange[0].get(i).toString());
                }
                catch (Exception e) {
                    start = Timestamp.valueOf(String.valueOf(this.timeRange[0].get(i).toString()) + " 00:00:00");
                }
                Timestamp end = null;
                try {
                    end = Timestamp.valueOf(this.timeRange[1].get(i).toString());
                }
                catch (Exception e) {
                    end = Timestamp.valueOf(String.valueOf(this.timeRange[1].get(i).toString()) + " 00:00:00");
                }
                int labeling = Integer.parseInt(this.timeRange[3].get(i).toString());
                int sampling = Integer.parseInt(this.timeRange[2].get(i).toString());
                this.createCategory(start, end, labeling, this.category);
                this.createCategory(start, end, sampling, this.sampling);
                if (!this.sampling.contains(sdf.format(end))) {
                    this.sampling.add(sdf.format(end));
                }
                if (!this.category.contains(sdf.format(end))) {
                    this.category.add(sdf.format(end));
                }
                ++i;
            }
            Object[] it = dataSource.keyArray();
            Vector<Double> totPositive = new Vector<Double>();
            Vector<Double> totNegative = new Vector<Double>();
            this.hasSeries = false;
            int i2 = 0;
            while (i2 < it.length) {
                GraphDataSource tempData;
                Object cat = it[i2];
                totPositive.add(i2, new Double(0.0));
                totNegative.add(i2, new Double(0.0));
                try {
                    tempData = (GraphDataSource)dataSource.getValue(i2);
                }
                catch (Exception e) {
                    tempData = new GraphDataSource();
                }
                Object[] it1 = tempData.keyArray();
                boolean btmp = true;
                int j = 0;
                while (j < it1.length) {
                    Number d;
                    Object ser = it1[j];
                    try {
                        d = (Number)tempData.getValue(j);
                    }
                    catch (Exception e) {
                        d = new Double(0.0);
                    }
                    if (d.doubleValue() > this.maxValue) {
                        this.maxValue = d.doubleValue();
                    }
                    if (d.doubleValue() < this.minValue) {
                        this.minValue = d.doubleValue();
                    }
                    this.maxPositive = this.maxValue;
                    this.minNegative = this.minValue;
                    if (d.doubleValue() > this.maxValue) {
                        this.maxValue = d.doubleValue();
                    }
                    if (d.doubleValue() < this.minValue) {
                        this.minValue = d.doubleValue();
                    }
                    double tmp = 0.0;
                    if (d.doubleValue() >= 0.0) {
                        tmp = (Double)totPositive.get(i2);
                        totPositive.set(i2, new Double(tmp + d.doubleValue()));
                    } else {
                        tmp = (Double)totNegative.get(i2);
                        totNegative.set(i2, new Double(tmp + d.doubleValue()));
                    }
                    this.addSeries(ser);
                    ++j;
                }
                if (!btmp || tempData == null) {
                    // empty if block
                }
                ++i2;
            }
            this.hasSeries = this.series.size() > 1;
            this.maxPositive = 0.0;
            this.minNegative = 0.0;
            int k = 0;
            while (k < totPositive.size()) {
                double tmp = 0.0;
                tmp = (Double)totPositive.get(k);
                if (this.maxPositive < tmp) {
                    this.maxPositive = tmp;
                }
                if (this.minNegative > (tmp = ((Double)totNegative.get(k)).doubleValue())) {
                    this.minNegative = tmp;
                }
                ++k;
            }
            this.positive = totPositive;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createCategory(Timestamp start, Timestamp end, int timeScale, Vector Cat) {
        GregorianCalendar gc = new GregorianCalendar();
        switch (timeScale) {
            case 1: {
                gc.setTime(end);
                int endY = gc.get(1);
                gc.setTime(start);
                int startY = gc.get(1);
                while (startY <= endY) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(1, 1);
                    startY = gc.get(1);
                }
                break;
            }
            case 2: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                while (startY < endY || startY == endY && startM <= endM) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(2, 1);
                    startY = gc.get(1);
                    startM = gc.get(2);
                }
                break;
            }
            case 3: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && startD <= endD)) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(5, 1);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                }
                break;
            }
            case 7: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && startD <= endD)) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(5, 5);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                }
                break;
            }
            case 4: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH <= endH))) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(11, 1);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startH = gc.get(11);
                }
                break;
            }
            case 5: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                int endMM = gc.get(12);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                int startMM = gc.get(12);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH < endH || startH == endH && startMM <= endMM))) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(12, 1);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startMM = gc.get(12);
                    startH = gc.get(11);
                }
                break;
            }
            case 6: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                int endMM = gc.get(12);
                int endS = gc.get(13);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                int startMM = gc.get(12);
                int startS = gc.get(13);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH < endH || startH == endH && (startMM < endMM || startMM == endMM && startS <= endS)))) {
                    Cat.add(sdf.format(gc.getTime()));
                    gc.add(13, 1);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startMM = gc.get(12);
                    startH = gc.get(11);
                    startS = gc.get(13);
                }
                break;
            }
        }
    }

    public void setTimeScale(int timeScale) {
        this.timeScale = timeScale;
    }

    public void setStateBarH(int h) {
        this.stateH = h;
    }

    private void removeCategory(Object obj) {
        int i = 0;
        while (i < this.category.size()) {
            Object tmp = this.category.get(i);
            if (obj.equals(tmp)) {
                this.category.remove(i);
                return;
            }
            ++i;
        }
    }

    private void addCategory(Object obj) {
        int i = 0;
        while (i < this.category.size()) {
            Object tmp = this.category.get(i);
            if (obj.toString().compareTo(tmp.toString()) == 0) {
                return;
            }
            ++i;
        }
        this.category.add(obj);
    }

    private void addSeries(Object obj) {
        int i = 0;
        while (i < this.series.size()) {
            Object tmp = this.series.get(i);
            if (obj.toString().compareTo(tmp.toString()) == 0) {
                return;
            }
            ++i;
        }
        this.series.add(obj);
    }

    private static boolean isValidString(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().length() != 0;
    }

    static String xToChinese(double dd) {
        String s = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        String s1 = "\u62fe\u4f70\u4edf\u4e07\u62fe\u4f70\u4edf\u4ebf\u62fe\u4f70\u4edf\u4e07";
        StringBuffer k = new StringBuffer();
        String m = String.valueOf(Math.round(dd));
        int j = m.length();
        while (j >= 1) {
            char n = s.charAt(Integer.parseInt(m.substring(m.length() - j, m.length() - j + 1)));
            if (n != '\u96f6' || k.charAt(k.length() - 1) != '\u96f6') {
                k.append(n);
                if (n != '\u96f6') {
                    int u = j - 2;
                    if (u >= 0) {
                        k.append(s1.charAt(u));
                    }
                    if (u > 3 && u < 7) {
                        k.append('\u4e07');
                    }
                    if (u > 7) {
                        k.append('\u4ebf');
                    }
                }
            }
            --j;
        }
        if (k.length() > 0 && k.charAt(k.length() - 1) == '\u96f6') {
            k.deleteCharAt(k.length() - 1);
        }
        if (k.length() > 0 && k.charAt(0) == '\u58f9') {
            k.deleteCharAt(0);
        }
        return k.toString();
    }
}

