/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.Draw2Y2Line;
import com.runqian.base.graph.Draw2YColLine;
import com.runqian.base.graph.DrawArea;
import com.runqian.base.graph.DrawArea3D;
import com.runqian.base.graph.DrawBar;
import com.runqian.base.graph.DrawBar3DObj;
import com.runqian.base.graph.DrawBarStacked;
import com.runqian.base.graph.DrawBarStacked3DObj;
import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.DrawCol;
import com.runqian.base.graph.DrawCol3D;
import com.runqian.base.graph.DrawCol3DObj;
import com.runqian.base.graph.DrawColStacked;
import com.runqian.base.graph.DrawColStacked3DObj;
import com.runqian.base.graph.DrawDot;
import com.runqian.base.graph.DrawGantt;
import com.runqian.base.graph.DrawLine;
import com.runqian.base.graph.DrawLine3DObj;
import com.runqian.base.graph.DrawPie;
import com.runqian.base.graph.DrawPie3DObj;
import com.runqian.base.graph.DrawRadar;
import com.runqian.base.graph.GraphFont;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.TimeState;
import com.runqian.base.graph.TimeTrend;
import com.runqian.base.util.GifEncoder;
import com.runqian.base.util.Sentence;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import javax.media.jai.JAI;

public class StatisticGraph {
    private GraphParam gp;
    private static Rectangle TR;

    public StatisticGraph(GraphParam gp) {
        this.gp = gp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage drawImage(String bmpType, StringBuffer sb, String link, String target) throws Exception {
        BufferedImage bi = null;
        try {
            try {
                bi = bmpType.equalsIgnoreCase("gif") || bmpType.equalsIgnoreCase("png") ? new BufferedImage(this.gp.graphWidth, this.gp.graphHeight, 2) : new BufferedImage(this.gp.graphWidth, this.gp.graphHeight, 1);
                this.gp.g = (Graphics2D)bi.getGraphics();
                if (this.gp.panelBackColor != null) {
                    this.gp.g.setBackground(this.gp.panelBackColor);
                    this.gp.g.clearRect(0, 0, this.gp.graphWidth, this.gp.graphHeight);
                }
                this.gp.g.setStroke(new BasicStroke(1.0f, 1, 1, 0.1f));
                this.gp.readColor();
                if (!bmpType.equalsIgnoreCase("gif")) {
                    this.gp.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.paint(sb, link, target);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.gp.g.dispose();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.gp.g.dispose();
        return bi;
    }

    public static int calcDateX(GraphParam gp, String valDate, double coorWidth) {
        long scaleTime;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(gp.startTime.getTime()));
        long starTime = 0L;
        int Y = gc.get(1);
        int M = gc.get(2);
        int D = gc.get(5);
        int H = gc.get(11);
        int Mi = gc.get(12);
        switch (gp.timeScale) {
            case 1: {
                gc.set(Y, 1, 1);
                scaleTime = 31536000000L;
                break;
            }
            case 2: {
                gc.set(Y, M, 1);
                scaleTime = 2592000000L;
                break;
            }
            case 3: {
                gc.set(Y, M, D, 0, 0);
                scaleTime = 86400000L;
                break;
            }
            case 4: {
                gc.set(Y, M, D, H, 0);
                scaleTime = 3600000L;
                break;
            }
            case 5: {
                gc.set(Y, M, D, H, Mi, 0);
                scaleTime = 60000L;
                break;
            }
            default: {
                scaleTime = 1000L;
            }
        }
        starTime = gc.getTime().getTime();
        long currenTime = Timestamp.valueOf(valDate).getTime();
        long deltaTime = currenTime - starTime;
        double deltaLength = (double)((float)deltaTime * 1.0f / (float)scaleTime) * coorWidth;
        return (int)deltaLength + gp.graphRect.x;
    }

    public static void drawGraph(OutputStream out, String bmpType, BufferedImage bi) throws Exception {
        try {
            if (bmpType.equalsIgnoreCase("jpg")) {
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam jp = encoder.getDefaultJPEGEncodeParam(bi);
                jp.setDensityUnit(1);
                jp.setQuality(1.0f, true);
                encoder.encode(bi, jp);
            } else if (bmpType.equalsIgnoreCase("gif")) {
                GifEncoder encoder = new GifEncoder(bi, out);
                encoder.encode();
            } else {
                JAI.create((String)"encode", (RenderedImage)bi, (Object)out, (Object)"PNG", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void paint(StringBuffer sb, String link, String target) {
        DrawBase graph = null;
        switch (this.gp.graphType) {
            case 2: {
                graph = new DrawBar(this.gp);
                break;
            }
            case 3: 
            case 4: {
                graph = new DrawBar3DObj(this.gp);
                break;
            }
            case 5: {
                graph = new DrawBarStacked(this.gp);
                break;
            }
            case 6: {
                graph = new DrawBarStacked3DObj(this.gp);
                break;
            }
            case 7: {
                graph = new DrawCol(this.gp);
                break;
            }
            case 8: {
                graph = new DrawCol3D(this.gp);
                break;
            }
            case 9: {
                graph = new DrawCol3DObj(this.gp);
                break;
            }
            case 10: {
                graph = new DrawColStacked(this.gp);
                break;
            }
            case 11: {
                graph = new DrawColStacked3DObj(this.gp);
                break;
            }
            case 12: {
                graph = new DrawLine(this.gp);
                break;
            }
            case 16: {
                graph = new DrawLine3DObj(this.gp);
                break;
            }
            case 13: {
                graph = new DrawPie(this.gp);
                break;
            }
            case 17: {
                graph = new DrawPie3DObj(this.gp);
                break;
            }
            case 18: {
                graph = new TimeState(this.gp);
                break;
            }
            case 19: {
                graph = new TimeTrend(this.gp);
                break;
            }
            case 1: {
                graph = new DrawArea(this.gp);
                break;
            }
            case 15: {
                graph = new DrawArea3D(this.gp);
                break;
            }
            case 14: {
                graph = new DrawDot(this.gp);
                break;
            }
            case 21: {
                graph = new Draw2YColLine(this.gp);
                break;
            }
            case 20: {
                graph = new Draw2Y2Line(this.gp);
                break;
            }
            case 22: {
                graph = new DrawRadar(this.gp);
                break;
            }
            case 23: {
                graph = new DrawGantt(this.gp);
                break;
            }
            default: {
                graph = new DrawCol(this.gp);
            }
        }
        graph.drawGraph(sb, link, target);
    }

    public static void drawString(String value, int x, int y, int angle, boolean isVertical, Font font, GraphParam gp) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (font.getSize() == 0) {
            return;
        }
        gp.g.setFont(font);
        Object o = gp.g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Composite com = gp.g.getComposite();
        gp.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        gp.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        FontMetrics fm = gp.g.getFontMetrics(font);
        if (isVertical) {
            int i = 0;
            while (i < value.length()) {
                gp.g.drawString(value.substring(i, i + 1), x, y + i * fm.getAscent());
                ++i;
            }
        } else {
            AffineTransform at = gp.g.getTransform();
            double dx = 0.0;
            double dy = 0.0;
            if (angle != 0 && gp.graphType != 13 && gp.graphType != 17) {
                dx = (double)fm.stringWidth(value) * Math.cos(Math.toRadians(angle));
                dy = (double)fm.stringWidth(value) * (1.0 - Math.sin(Math.toRadians(angle)));
            }
            AffineTransform at1 = AffineTransform.getRotateInstance(Math.toRadians(-angle), (double)x - dx, (double)y - dy);
            gp.g.transform(at1);
            TextLayout textlayout = new TextLayout(value, font, gp.g.getFontRenderContext());
            textlayout.draw(gp.g, (int)((double)x - dx), (int)((double)y - dy));
            gp.g.setTransform(at);
        }
        gp.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, o);
        gp.g.setComposite(com);
    }

    public static void drawText(String text, int x, int y, GraphFont gf, GraphParam gp) {
        if (!StatisticGraph.isValidString(text)) {
            return;
        }
        gp.g.setColor(new Color(gf.getColor()));
    }

    public static void keepGraphSpace(GraphParam gp) {
        int space = gp.graphMargin;
        gp.leftInset += space;
        gp.rightInset += space;
        gp.topInset += space;
        gp.bottomInset += space;
    }

    public static void drawTitle(GraphParam gp) {
        int x = 0;
        int y = 0;
        if (!gp.drawTitle) {
            return;
        }
        TR = gp.GFV_TITLE.getTextSize();
        x = gp.leftMargin + (gp.graphWidth - gp.leftMargin - gp.rightMargin - StatisticGraph.TR.width) / 2;
        y = gp.topInset + StatisticGraph.TR.height;
        if (gp.legendPosition == 1) {
            x += gp.legendBoxWidth / 2;
        } else if (gp.legendPosition == 2) {
            x -= gp.legendBoxWidth / 2;
        }
        gp.GFV_TITLE.outText(x, y);
        gp.topInset += StatisticGraph.TR.height + 4;
    }

    public static void drawGraphRect(GraphParam gp) {
        gp.g.setColor(gp.coorColor);
        gp.g.setStroke(new BasicStroke(1.0f));
        gp.g.drawRect(gp.gRect2.x, gp.gRect2.y, gp.gRect2.width, gp.gRect2.height);
        if (gp.graphBackColor != null) {
            gp.g.setColor(gp.graphBackColor);
            gp.g.fillRect(gp.gRect2.x + 1, gp.gRect2.y + 1, gp.gRect2.width - 1, gp.gRect2.height - 1);
        }
    }

    public static void drawLabel(GraphParam gp) {
        int x = 0;
        int y = 0;
        String label = "";
        StringBuffer sb = new StringBuffer("");
        if (!gp.drawLabel) {
            return;
        }
        label = gp.isBarGraph() ? gp.GFV_YTITLE.text : gp.GFV_XTITLE.text;
        TR = gp.GFV_XTITLE.getTextSize(label);
        x = gp.leftMargin + (gp.graphWidth - gp.leftMargin - gp.rightMargin - StatisticGraph.TR.width) / 2;
        y = gp.graphHeight - gp.bottomMargin;
        if (gp.legendPosition == 1) {
            x += gp.legendBoxWidth / 2;
        } else if (gp.legendPosition == 2) {
            x -= gp.legendBoxWidth / 2;
        }
        if (gp.legendPosition == 4) {
            y -= gp.legendBoxHeight + 10;
        }
        gp.GFV_XTITLE.outText(x, y, label);
        gp.bottomInset += StatisticGraph.TR.height + 4;
        label = gp.isBarGraph() ? gp.GFV_XTITLE.text : gp.GFV_YTITLE.text;
        TR = gp.GFV_YTITLE.getTextSize(label);
        x = gp.leftInset;
        y = gp.topMargin + (gp.graphHeight - gp.topMargin - gp.bottomMargin) / 2;
        if (gp.legendPosition == 3) {
            y += gp.legendBoxHeight / 2;
        } else if (gp.legendPosition == 4) {
            y -= gp.legendBoxHeight / 2;
        }
        gp.GFV_YTITLE.outText(x, y, label);
        gp.leftInset += StatisticGraph.TR.width + 4;
        if (gp.is2YGraph()) {
            TR = gp.GFV_YTITLE.getTextSize(gp.GFV_YTITLE.text2);
            x = gp.graphWidth - gp.rightInset - StatisticGraph.TR.width;
            y = gp.topMargin + (gp.graphHeight - gp.topMargin - gp.bottomMargin) / 2;
            if (gp.legendPosition == 3) {
                y += gp.legendBoxHeight / 2;
            } else if (gp.legendPosition == 4) {
                y -= gp.legendBoxHeight / 2;
            }
            gp.GFV_YTITLE.outText(x, y, gp.GFV_YTITLE.text2);
            gp.rightInset += StatisticGraph.TR.width + 4;
        }
    }

    public static void drawLegend(StringBuffer sb, String link, String target, GraphParam gp) {
        Object o;
        int i;
        int fontHeight = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int legendWidth = 0;
        int legendHeight = 0;
        int intTmp = 0;
        int totalWidth = 0;
        int totalHeight = 0;
        if (!gp.drawLegend) {
            return;
        }
        if (!StatisticGraph.isValidString(target)) {
            target = "_blank";
        }
        if (gp.graphType == 13 || gp.graphType == 17 || gp.graphType == 18 || gp.graphType == 23 || !gp.hasSeries) {
            i = 0;
            while (i < gp.category.size()) {
                o = gp.category.get(i);
                TR = gp.GFV_LEGEND.getTextSize(o.toString());
                intTmp = StatisticGraph.TR.width;
                if (maxWidth < intTmp) {
                    maxWidth = intTmp;
                    maxHeight = StatisticGraph.TR.height;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < gp.series.size()) {
                o = gp.series.get(i);
                TR = gp.GFV_LEGEND.getTextSize(o.toString());
                intTmp = StatisticGraph.TR.width;
                if (maxWidth < intTmp) {
                    maxWidth = intTmp;
                    maxHeight = StatisticGraph.TR.height;
                }
                ++i;
            }
            if (gp.is2YGraph()) {
                i = 0;
                while (i < gp.series2.size()) {
                    o = gp.series2.get(i);
                    TR = gp.GFV_LEGEND.getTextSize(o.toString());
                    intTmp = StatisticGraph.TR.width;
                    if (maxWidth < intTmp) {
                        maxWidth = intTmp;
                        maxHeight = StatisticGraph.TR.height;
                    }
                    ++i;
                }
            }
        }
        int size = 0;
        size = gp.graphType == 13 || gp.graphType == 17 || gp.graphType == 18 || gp.graphType == 23 || !gp.hasSeries ? gp.category.size() : (gp.is2YGraph() ? gp.series.size() + gp.series2.size() : gp.series.size());
        int series1Count = gp.series.size();
        fontHeight = maxHeight;
        if (gp.legendPosition == 3 || gp.legendPosition == 4) {
            int borderwidth;
            int borderx;
            int row;
            totalWidth = gp.graphWidth - gp.leftMargin - gp.rightMargin;
            legendWidth = fontHeight + 12 + maxWidth;
            int col = totalWidth / legendWidth;
            if (col < 1) {
                col = 1;
            }
            if ((row = size / col) * col < size) {
                ++row;
            }
            int tmp = gp.graphHeight - gp.bottomInset - ((row + 1) * 4 + row * fontHeight);
            if (row > 1) {
                borderx = gp.leftMargin + (totalWidth - legendWidth * col) / 2;
                borderwidth = legendWidth * col;
            } else {
                borderx = gp.leftMargin + (totalWidth - legendWidth * size) / 2;
                borderwidth = legendWidth * size;
            }
            int bordery = gp.legendPosition == 3 ? gp.topInset : tmp;
            int borderheight = fontHeight * row + (row + 1) * 4;
            gp.g.setColor(Color.black);
            gp.g.drawRect(borderx, bordery, borderwidth, borderheight);
            gp.legendBoxWidth = borderwidth;
            gp.legendBoxHeight = borderheight;
            int i2 = 0;
            while (i2 < row) {
                int x = row > 1 ? gp.leftMargin + (totalWidth - legendWidth * col) / 2 : gp.leftMargin + (totalWidth - legendWidth * size) / 2;
                int j = 0;
                while (j < col) {
                    if (i2 * col + j >= size) break;
                    int y = gp.legendPosition == 3 ? gp.topInset + (i2 + 1) * (4 + fontHeight) : tmp + (i2 + 1) * (4 + fontHeight);
                    Object o2 = null;
                    int seriesNo = i2 * col + j;
                    o2 = gp.graphType == 13 || gp.graphType == 17 || gp.graphType == 18 || gp.graphType == 23 || !gp.hasSeries ? (Object)gp.category.get(seriesNo) : (seriesNo >= series1Count ? (Object)gp.series2.get(seriesNo - series1Count) : (Object)gp.series.get(seriesNo));
                    x += 4;
                    if (gp.is2YGraph() && gp.hasSeries && seriesNo >= series1Count) {
                        gp.g.setStroke(new BasicStroke(1.0E-5f));
                        gp.g.setColor(gp.getColor(seriesNo));
                        gp.g.fillOval(x, y - fontHeight, fontHeight, fontHeight);
                        gp.g.setColor(Color.black);
                        gp.g.drawOval(x, y - fontHeight, fontHeight, fontHeight);
                    } else {
                        gp.g.setColor(gp.getColor(seriesNo));
                        gp.g.fillRect(x, y - fontHeight, fontHeight, fontHeight);
                        gp.g.setColor(Color.black);
                        gp.g.drawRect(x, y - fontHeight, fontHeight, fontHeight);
                    }
                    String coordx = String.valueOf(x) + "," + (y - fontHeight) + ",";
                    gp.GFV_LEGEND.outText(x += fontHeight + 4, y, o2.toString());
                    TR = gp.GFV_LEGEND.getTextSize(o2.toString());
                    coordx = String.valueOf(coordx) + (x + StatisticGraph.TR.width) + "," + y;
                    if (sb != null && StatisticGraph.isValidString(link) && StatisticGraph.isValidString(target)) {
                        sb.append(StatisticGraph.getStgLinkHtml(link, "rect", coordx, target, o2.toString()));
                    }
                    x += maxWidth + 4;
                    ++j;
                }
                ++i2;
            }
            if (gp.legendPosition == 3) {
                gp.topInset += (row + 1) * 4 + row * fontHeight + 4;
            } else {
                gp.bottomInset += (row + 1) * 4 + row * fontHeight + 4;
            }
        } else {
            int borderheight;
            int bordery;
            int col;
            legendWidth = fontHeight + 12 + maxWidth;
            totalHeight = gp.graphHeight - gp.topMargin - gp.bottomMargin;
            legendHeight = fontHeight + 8;
            int row = totalHeight / legendHeight;
            if (row < 1) {
                row = 1;
            }
            if (row * (col = size / row) < size) {
                ++col;
            }
            int tmp = gp.graphWidth - gp.rightInset - ((col + 1) * 4 + col * legendWidth);
            if (col > 1) {
                bordery = gp.topMargin + (totalHeight - legendHeight * row) / 2;
                borderheight = legendHeight * row;
            } else {
                bordery = gp.topMargin + (totalHeight - legendHeight * size) / 2;
                borderheight = legendHeight * size;
            }
            int borderx = gp.legendPosition == 1 ? gp.leftInset : tmp;
            int borderwidth = legendWidth * col;
            gp.g.setColor(Color.black);
            gp.g.drawRect(borderx, bordery, borderwidth, borderheight);
            gp.legendBoxWidth = borderwidth;
            gp.legendBoxHeight = borderheight;
            int j = 0;
            while (j < col) {
                int y = col > 1 ? gp.topMargin + (totalHeight - legendHeight * row) / 2 + fontHeight + 4 : gp.topMargin + (totalHeight - legendHeight * size) / 2 + fontHeight + 4;
                int i3 = 0;
                while (i3 < row) {
                    if (j * row + i3 >= size) break;
                    int x = gp.legendPosition == 1 ? gp.leftInset + j * legendWidth : tmp + j * legendWidth;
                    Object o3 = null;
                    int seriesNo = j * row + i3;
                    o3 = gp.graphType == 13 || gp.graphType == 17 || gp.graphType == 18 || gp.graphType == 23 || !gp.hasSeries ? (Object)gp.category.get(seriesNo) : (seriesNo >= series1Count ? (Object)gp.series2.get(seriesNo - series1Count) : (Object)gp.series.get(seriesNo));
                    x += 4;
                    if (gp.is2YGraph() && gp.hasSeries && i3 >= series1Count) {
                        gp.g.setStroke(new BasicStroke(1.0E-5f));
                        gp.g.setColor(gp.getColor(seriesNo));
                        gp.g.fillOval(x, y - fontHeight, fontHeight, fontHeight);
                        gp.g.setColor(Color.black);
                        gp.g.drawOval(x, y - fontHeight, fontHeight, fontHeight);
                    } else {
                        gp.g.setColor(gp.getColor(seriesNo));
                        gp.g.fillRect(x, y - fontHeight, fontHeight, fontHeight);
                        gp.g.setColor(Color.black);
                        gp.g.drawRect(x, y - fontHeight, fontHeight, fontHeight);
                    }
                    String coordx = String.valueOf(x) + "," + (y - fontHeight) + ",";
                    gp.GFV_LEGEND.outText(x += fontHeight + 4, y, o3.toString());
                    TR = gp.GFV_LEGEND.getTextSize(o3.toString());
                    coordx = String.valueOf(coordx) + (x + StatisticGraph.TR.width) + "," + y;
                    if (sb != null && StatisticGraph.isValidString(link) && StatisticGraph.isValidString(target)) {
                        sb.append(StatisticGraph.getStgLinkHtml(link, "rect", coordx, target, o3.toString()));
                    }
                    y += legendHeight;
                    ++i3;
                }
                ++j;
            }
            if (gp.legendPosition == 1) {
                gp.leftInset += (col + 1) * 4 + col * legendWidth + 4;
            } else {
                gp.rightInset += (col + 1) * 4 + col * legendWidth + 4;
            }
        }
    }

    public static void drawWarnLine(GraphParam gp) {
        if (gp.warnLine == null) {
            return;
        }
        Stroke s = gp.g.getStroke();
        int i = 0;
        while (i < gp.warnLine[0].size()) {
            double value = new Double(gp.warnLine[0].get(i).toString()) - gp.baseValue - gp.minValue;
            String lineType = gp.warnLine[1].get(i).toString();
            int lineColor = Integer.parseInt(gp.warnLine[2].get(i).toString());
            gp.g.setColor(new Color(lineColor));
            float[] dashes = lineType.equals("5") ? new float[]{3.0f, 6.0f, 8.0f, 6.0f} : (lineType.equals("6") ? new float[]{3.0f, 4.0f, 8.0f, 4.0f, 3.0f, 4.0f} : (lineType.equals("3") ? new float[]{18.0f, 6.0f} : (lineType.equals("4") ? new float[]{4.0f, 3.0f} : new float[]{1.0f})));
            gp.g.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, dashes, 0.0f));
            if (gp.minNegative >= 0.0) {
                gp.g.drawLine(gp.gRect2.x, (int)((double)gp.gRect2.y + (1.0 - value / (gp.maxValue * gp.coorScale)) * (double)gp.gRect2.height), gp.gRect2.x + gp.gRect2.width, (int)((double)gp.gRect2.y + (1.0 - value / (gp.maxValue * gp.coorScale)) * (double)gp.gRect2.height));
            } else if (gp.maxPositive <= 0.0) {
                gp.g.drawLine(gp.gRect2.x, (int)((double)gp.gRect2.y - value / (gp.maxValue * gp.coorScale) * (double)gp.gRect2.height), gp.gRect2.x + gp.gRect2.width, (int)((double)gp.gRect2.y - value / (gp.maxValue * gp.coorScale) * (double)gp.gRect2.height));
            } else if (value > 0.0) {
                gp.g.drawLine(gp.gRect2.x, (int)((double)gp.gRect2.y + (1.0 - value * 2.0 / (gp.maxValue * gp.coorScale)) * (double)gp.gRect2.height / 2.0), gp.gRect2.x + gp.gRect2.width, (int)((double)gp.gRect2.y + (1.0 - value * 2.0 / (gp.maxValue * gp.coorScale)) * (double)gp.gRect2.height / 2.0));
            } else {
                gp.g.drawLine(gp.gRect2.x, (int)((double)(gp.gRect2.y + gp.gRect2.height / 2) - value * 2.0 / (gp.maxValue * gp.coorScale) * (double)gp.gRect2.height / 2.0), gp.gRect2.x + gp.gRect2.width, (int)((double)(gp.gRect2.y + gp.gRect2.height / 2) - value * 2.0 / (gp.maxValue * gp.coorScale) * (double)gp.gRect2.height / 2.0));
            }
            ++i;
        }
        gp.g.setStroke(s);
    }

    public static String getStgLinkHtml(String link, String shape, String coords, String target, String legendValue) {
        link = Sentence.replace(link, 0, "@legend", URLEncoder.encode(legendValue), 27);
        StringBuffer sb = new StringBuffer(100);
        sb.append("<area shape=\"").append(shape).append("\" coords=\"");
        sb.append(coords).append("\" href=\"").append(link).append("\" target=\"").append(target);
        sb.append("\">\n");
        return sb.toString();
    }

    public static boolean isValidString(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().length() != 0;
    }

    public static void main(String[] args) {
        Vector<String> category = new Vector<String>();
        HashMap graphData = new HashMap();
        category.add("\u5f20\u4e09");
        category.add("\u674e\u56db");
        category.add("\u738b\u4e8c");
        category.add("\u5218\u8001\u5927");
        int i = 0;
        while (i < category.size()) {
            HashMap<String, String> stuData = new HashMap<String, String>();
            stuData.put("\u8bed\u6587", "80");
            stuData.put("\u6570\u5b66", "67");
            stuData.put("\u82f1\u8bed", "78");
            stuData.put("\u5c0f\u8bf4", "23");
            graphData.put(category.elementAt(i), stuData);
            ++i;
        }
        GraphParam gp = new GraphParam();
        StatisticGraph sg = new StatisticGraph(gp);
        try {
            FileOutputStream out = new FileOutputStream(new File("d:\\test.jpg"));
            BufferedImage img = sg.drawImage("jpg", null, "", "");
            StatisticGraph.drawGraph(out, "jpg", img);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

